/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi;

import com.oracle.truffle.nfi.Lexer;
import com.oracle.truffle.nfi.NativeSource;
import com.oracle.truffle.nfi.SignatureRootNode;
import com.oracle.truffle.nfi.SignatureRootNodeFactory;
import com.oracle.truffle.nfi.backend.spi.types.NativeLibraryDescriptor;
import com.oracle.truffle.nfi.backend.spi.types.NativeSimpleType;
import com.oracle.truffle.nfi.backend.spi.types.TypeFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

final class Parser
extends TypeFactory {
    private final Lexer lexer;

    static NativeSource parseNFISource(CharSequence source) {
        Parser parser = new Parser(source);
        NativeSource ret = parser.parseNFISource();
        parser.expect(Lexer.Token.EOF);
        return ret;
    }

    private Parser(CharSequence source) {
        this.lexer = new Lexer(source);
    }

    private void expect(Lexer.Token token) {
        if (this.lexer.next() != token) {
            throw this.lexer.fail("unexpected token: expected '%s', but got '%s'", token.getName(), this.lexer.currentValue());
        }
    }

    private NativeSource parseNFISource() {
        String nfiId = null;
        if (this.lexer.peek() == Lexer.Token.IDENTIFIER && this.lexer.peekValue().equalsIgnoreCase("with")) {
            this.lexer.next();
            if (this.lexer.next() != Lexer.Token.IDENTIFIER) {
                throw this.lexer.fail("Expecting NFI backend identifier");
            }
            nfiId = this.lexer.currentValue();
        }
        NativeSource.Content c = this.parseNFISourceContent();
        return new NativeSource(nfiId, c);
    }

    private NativeSource.Content parseNFISourceContent() {
        switch (this.lexer.peek()) {
            case IDENTIFIER: {
                NativeLibraryDescriptor descriptor = this.parseLibraryDescriptor();
                NativeSource.ParsedLibrary ret = new NativeSource.ParsedLibrary(descriptor);
                if (this.lexer.next() == Lexer.Token.OPENBRACE) {
                    Lexer.Token closeOrId;
                    while ((closeOrId = this.lexer.next()) != Lexer.Token.CLOSEBRACE) {
                        if (closeOrId != Lexer.Token.IDENTIFIER) {
                            throw this.lexer.fail("Expecting identifier in library body");
                        }
                        String ident = this.lexer.currentValue();
                        this.lexer.mark();
                        this.parseSignature();
                        ret.register(ident, this.lexer.markedValue());
                        if (this.lexer.next() == Lexer.Token.SEMICOLON) continue;
                        throw this.lexer.fail("Expecting semicolon");
                    }
                }
                return ret;
            }
            case OPENPAREN: {
                SignatureRootNode.BuildSignatureNode buildSig = this.parseSignature();
                return new NativeSource.ParsedSignature(buildSig);
            }
        }
        this.lexer.next();
        throw this.lexer.fail("Expecting identifier or '('");
    }

    private NativeLibraryDescriptor parseLibraryDescriptor() {
        Lexer.Token token = this.lexer.next();
        String keyword = this.lexer.currentValue();
        if (token == Lexer.Token.IDENTIFIER) {
            switch (keyword) {
                case "load": {
                    return this.parseLoadLibrary();
                }
                case "default": {
                    return Parser.createDefaultLibrary();
                }
            }
        }
        throw this.lexer.fail("expected 'load' or 'default', but got '%s'", keyword);
    }

    private String parseIdentOrString() {
        if (this.lexer.peek() == Lexer.Token.IDENTIFIER) {
            this.lexer.next();
        } else {
            this.expect(Lexer.Token.STRING);
        }
        return this.lexer.currentValue();
    }

    private NativeLibraryDescriptor parseLoadLibrary() {
        List<String> flags = null;
        if (this.lexer.peek() == Lexer.Token.OPENPAREN) {
            flags = this.parseFlags();
        }
        String filename = this.parseIdentOrString();
        return Parser.createLibraryDescriptor(filename, flags);
    }

    private List<String> parseFlags() {
        Lexer.Token nextToken;
        this.expect(Lexer.Token.OPENPAREN);
        ArrayList<String> flags = new ArrayList<String>();
        do {
            this.expect(Lexer.Token.IDENTIFIER);
            flags.add(this.lexer.currentValue());
        } while ((nextToken = this.lexer.next()) == Lexer.Token.OR);
        if (nextToken != Lexer.Token.CLOSEPAREN) {
            throw this.lexer.fail("unexpected token: expected '|' or ')', but got '%s'", this.lexer.currentValue());
        }
        return flags;
    }

    private SignatureRootNode.GetTypeNode parseType() {
        switch (this.lexer.peek()) {
            case OPENPAREN: {
                SignatureRootNode.BuildSignatureNode signature = this.parseSignature();
                return SignatureRootNodeFactory.GetSignatureTypeNodeGen.create(signature);
            }
            case OPENBRACKET: {
                return this.parseArrayType();
            }
            case IDENTIFIER: {
                return this.parseSimpleType(true);
            }
        }
        this.lexer.next();
        throw this.lexer.fail("expected type, but got '%s'", this.lexer.currentValue());
    }

    private SignatureRootNode.BuildSignatureNode parseSignature() {
        this.expect(Lexer.Token.OPENPAREN);
        ArrayList<SignatureRootNode.ArgumentBuilderNode> args = new ArrayList<SignatureRootNode.ArgumentBuilderNode>();
        Lexer.Token nextToken = this.lexer.peek();
        if (nextToken == Lexer.Token.CLOSEPAREN) {
            this.lexer.next();
        } else {
            do {
                if (this.lexer.peek() == Lexer.Token.ELLIPSIS) {
                    this.lexer.next();
                    args.add(SignatureRootNodeFactory.MakeVarargsNodeGen.create());
                }
                SignatureRootNode.GetTypeNode type = this.parseType();
                args.add(SignatureRootNodeFactory.AddArgumentNodeGen.create(type));
            } while ((nextToken = this.lexer.next()) == Lexer.Token.COMMA);
        }
        if (nextToken != Lexer.Token.CLOSEPAREN) {
            throw this.lexer.fail("unexpected token: expected ',' or ')', but got '%s'", this.lexer.currentValue());
        }
        this.expect(Lexer.Token.COLON);
        SignatureRootNode.GetTypeNode retType = this.parseType();
        args.add(SignatureRootNodeFactory.SetRetTypeNodeGen.create(retType));
        return SignatureRootNodeFactory.BuildSignatureNodeGen.create(args.toArray(SignatureRootNode.ArgumentBuilderNode.EMPTY));
    }

    private SignatureRootNode.GetTypeNode parseArrayType() {
        this.expect(Lexer.Token.OPENBRACKET);
        this.expect(Lexer.Token.IDENTIFIER);
        NativeSimpleType type = this.getSimpleType(this.lexer.currentValue());
        this.expect(Lexer.Token.CLOSEBRACKET);
        return SignatureRootNodeFactory.GetArrayTypeNodeGen.create(type);
    }

    private SignatureRootNode.GetTypeNode parseSimpleType(boolean envAllowed) {
        this.expect(Lexer.Token.IDENTIFIER);
        String identifier = this.lexer.currentValue();
        if (envAllowed && "env".equalsIgnoreCase(identifier)) {
            return SignatureRootNodeFactory.GetEnvTypeNodeGen.create();
        }
        return SignatureRootNodeFactory.GetSimpleTypeNodeGen.create(this.getSimpleType(identifier));
    }

    private NativeSimpleType getSimpleType(String identifier) {
        try {
            return NativeSimpleType.valueOf(identifier.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw this.lexer.fail("unknown simple type '%s'", identifier);
        }
    }
}

