/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.memory.MemoryFence;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.nfi.CallSignatureNode;
import com.oracle.truffle.nfi.CallSignatureNodeFactory;
import com.oracle.truffle.nfi.NFIClosure;
import com.oracle.truffle.nfi.NFILanguage;
import com.oracle.truffle.nfi.NFISignature;
import com.oracle.truffle.nfi.NFISymbol;
import com.oracle.truffle.nfi.api.SignatureLibrary;
import com.oracle.truffle.nfi.backend.spi.NFIBackendSignatureLibrary;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=NFISignature.class)
final class NFISignatureGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<NFIBackendSignatureLibrary> N_F_I_BACKEND_SIGNATURE_LIBRARY_ = LibraryFactory.resolve(NFIBackendSignatureLibrary.class);

    private NFISignatureGen() {
    }

    static {
        LibraryExport.register(NFISignature.class, (LibraryExport[])new LibraryExport[]{new SignatureLibraryExports()});
    }

    @GeneratedBy(value=NFISignature.class)
    private static final class SignatureLibraryExports
    extends LibraryExport<SignatureLibrary> {
        private SignatureLibraryExports() {
            super(SignatureLibrary.class, NFISignature.class, false, false, 0);
        }

        protected SignatureLibrary createUncached(Object receiver) {
            assert (receiver instanceof NFISignature);
            Uncached uncached = new Uncached();
            return uncached;
        }

        protected SignatureLibrary createCached(Object receiver) {
            assert (receiver instanceof NFISignature);
            return new Cached(receiver);
        }

        @GeneratedBy(value=NFISignature.class)
        private static final class Uncached
        extends SignatureLibrary {
            protected Uncached() {
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof NFISignature) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof NFISignature;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object bind(Object arg0Value_, Object arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                NFISignature arg0Value = (NFISignature)arg0Value_;
                if (arg1Value instanceof NFISymbol) {
                    NFISymbol arg1Value_ = (NFISymbol)arg1Value;
                    return NFISignature.Bind.doSymbol(arg0Value, arg1Value_);
                }
                return NFISignature.Bind.doOther(arg0Value, arg1Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object createClosure(Object arg0Value_, Object arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                NFISignature arg0Value = (NFISignature)arg0Value_;
                return NFISignature.CreateClosure.doCreate(arg0Value, arg1Value, (NFIBackendSignatureLibrary)N_F_I_BACKEND_SIGNATURE_LIBRARY_.getUncached(arg0Value.nativeSignature));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object call(Object arg0Value_, Object arg1Value, Object ... arg2Value) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                NFISignature arg0Value = (NFISignature)arg0Value_;
                return arg0Value.call(arg1Value, arg2Value, CallSignatureNodeFactory.CachedCallSignatureNodeGen.getUncached());
            }
        }

        @GeneratedBy(value=NFISignature.class)
        private static final class Cached
        extends SignatureLibrary {
            @Node.Child
            private NFIBackendSignatureLibrary receiverNativeSignatureNFIBackendSignatureLibrary_;
            @CompilerDirectives.CompilationFinal
            private volatile int state_0_;
            @CompilerDirectives.CompilationFinal
            private volatile int exclude_;
            @Node.Child
            private CreateClosureCachedData createClosure_cached_cache;
            @Node.Child
            private CallSignatureNode.CachedCallSignatureNode callNode__call_call_;

            protected Cached(Object receiver) {
                NFISignature castReceiver = (NFISignature)receiver;
                this.receiverNativeSignatureNFIBackendSignatureLibrary_ = (NFIBackendSignatureLibrary)super.insert((Node)N_F_I_BACKEND_SIGNATURE_LIBRARY_.create(castReceiver.nativeSignature));
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof NFISignature) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                if (!(receiver instanceof NFISignature)) {
                    return false;
                }
                return this.receiverNativeSignatureNFIBackendSignatureLibrary_.accepts(((NFISignature)receiver).nativeSignature);
            }

            @Override
            public Object bind(Object arg0Value_, Object arg1Value) {
                assert (arg0Value_ instanceof NFISignature) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                NFISignature arg0Value = (NFISignature)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 3) != 0) {
                    if ((state_0 & 1) != 0 && arg1Value instanceof NFISymbol) {
                        NFISymbol arg1Value_ = (NFISymbol)arg1Value;
                        return NFISignature.Bind.doSymbol(arg0Value, arg1Value_);
                    }
                    if ((state_0 & 2) != 0 && Cached.bindFallbackGuard_(state_0, arg0Value, arg1Value)) {
                        return NFISignature.Bind.doOther(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.bindAndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object bindAndSpecialize(NFISignature arg0Value, Object arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                try {
                    int state_0 = this.state_0_;
                    if (arg1Value instanceof NFISymbol) {
                        NFISymbol arg1Value_ = (NFISymbol)arg1Value;
                        this.state_0_ = state_0 |= 1;
                        lock.unlock();
                        hasLock = false;
                        Object object = NFISignature.Bind.doSymbol(arg0Value, arg1Value_);
                        return object;
                    }
                    this.state_0_ = state_0 |= 2;
                    lock.unlock();
                    hasLock = false;
                    Object object = NFISignature.Bind.doOther(arg0Value, arg1Value);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 3) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & 3 & (state_0 & 3) - 1) == 0) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            @Override
            @ExplodeLoop
            public Object createClosure(Object arg0Value_, Object arg1Value) {
                assert (arg0Value_ instanceof NFISignature) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                NFISignature arg0Value = (NFISignature)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0xC) != 0) {
                    if ((state_0 & 4) != 0) {
                        CreateClosureCachedData s0_ = this.createClosure_cached_cache;
                        while (s0_ != null) {
                            if (!Assumption.isValidAssumption((Assumption)s0_.assumption0_)) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                this.removeCached_((Object)s0_);
                                return this.createClosureAndSpecialize(arg0Value, arg1Value);
                            }
                            assert (s0_.lib_.accepts(s0_.cachedClosure_.signature.nativeSignature));
                            if (arg1Value == s0_.cachedClosure_.executable && arg0Value == s0_.cachedClosure_.signature) {
                                return NFISignature.CreateClosure.doCached(arg0Value, arg1Value, s0_.cachedClosure_, s0_.lib_, s0_.cachedRet_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 8) != 0) {
                        NFIBackendSignatureLibrary createClosure_create_lib__ = this.receiverNativeSignatureNFIBackendSignatureLibrary_;
                        return NFISignature.CreateClosure.doCreate(arg0Value, arg1Value, createClosure_create_lib__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.createClosureAndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object createClosureAndSpecialize(NFISignature arg0Value, Object arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                try {
                    int state_0 = this.state_0_;
                    int exclude = this.exclude_;
                    if (exclude == 0) {
                        int count0_ = 0;
                        CreateClosureCachedData s0_ = this.createClosure_cached_cache;
                        if ((state_0 & 4) != 0) {
                            while (s0_ != null) {
                                assert (s0_.lib_.accepts(s0_.cachedClosure_.signature.nativeSignature));
                                if (arg1Value == s0_.cachedClosure_.executable && arg0Value == s0_.cachedClosure_.signature && (s0_.assumption0_ == null || Assumption.isValidAssumption((Assumption)s0_.assumption0_))) break;
                                s0_ = s0_.next_;
                                ++count0_;
                            }
                        }
                        if (s0_ == null) {
                            Assumption assumption0;
                            NFIClosure cachedClosure__ = NFISignature.CreateClosure.createClosure(arg1Value, arg0Value);
                            if (arg1Value == cachedClosure__.executable && arg0Value == cachedClosure__.signature && Assumption.isValidAssumption((Assumption)(assumption0 = NFILanguage.getSingleContextAssumption())) && count0_ < 3) {
                                s0_ = (CreateClosureCachedData)super.insert((Node)new CreateClosureCachedData(this.createClosure_cached_cache));
                                s0_.cachedClosure_ = cachedClosure__;
                                s0_.lib_ = (NFIBackendSignatureLibrary)s0_.insertAccessor(N_F_I_BACKEND_SIGNATURE_LIBRARY_.create(cachedClosure__.signature.nativeSignature));
                                s0_.cachedRet_ = s0_.lib_.createClosure(cachedClosure__.signature.nativeSignature, cachedClosure__);
                                s0_.assumption0_ = assumption0;
                                MemoryFence.storeStore();
                                this.createClosure_cached_cache = s0_;
                                this.state_0_ = state_0 |= 4;
                            }
                        }
                        if (s0_ != null) {
                            lock.unlock();
                            hasLock = false;
                            Object object = NFISignature.CreateClosure.doCached(arg0Value, arg1Value, s0_.cachedClosure_, s0_.lib_, s0_.cachedRet_);
                            return object;
                        }
                    }
                    NFIBackendSignatureLibrary createClosure_create_lib__ = null;
                    createClosure_create_lib__ = this.receiverNativeSignatureNFIBackendSignatureLibrary_;
                    this.exclude_ = exclude |= 1;
                    this.createClosure_cached_cache = null;
                    state_0 &= 0xFFFFFFFB;
                    this.state_0_ = state_0 |= 8;
                    lock.unlock();
                    hasLock = false;
                    Object object = NFISignature.CreateClosure.doCreate(arg0Value, arg1Value, createClosure_create_lib__);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void removeCached_(Object s0_) {
                Lock lock = this.getLock();
                lock.lock();
                try {
                    CreateClosureCachedData prev = null;
                    CreateClosureCachedData cur = this.createClosure_cached_cache;
                    while (cur != null) {
                        if (cur == s0_) {
                            if (prev == null) {
                                this.createClosure_cached_cache = cur.next_;
                                this.adoptChildren();
                                break;
                            }
                            prev.next_ = cur.next_;
                            prev.adoptChildren();
                            break;
                        }
                        prev = cur;
                        cur = cur.next_;
                    }
                    if (this.createClosure_cached_cache == null) {
                        this.state_0_ &= 0xFFFFFFFB;
                    }
                }
                finally {
                    lock.unlock();
                }
            }

            @Override
            public Object call(Object arg0Value_, Object arg1Value, Object ... arg2Value) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
                assert (arg0Value_ instanceof NFISignature) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                NFISignature arg0Value = (NFISignature)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x10) != 0) {
                    return arg0Value.call(arg1Value, arg2Value, this.callNode__call_call_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.callNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object callNode_AndSpecialize(NFISignature arg0Value, Object arg1Value, Object[] arg2Value) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                try {
                    int state_0 = this.state_0_;
                    this.callNode__call_call_ = (CallSignatureNode.CachedCallSignatureNode)super.insert((Node)CallSignatureNodeFactory.CachedCallSignatureNodeGen.create());
                    this.state_0_ = state_0 |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    Object object = arg0Value.call(arg1Value, arg2Value, this.callNode__call_call_);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            private static boolean bindFallbackGuard_(int state_0, NFISignature arg0Value, Object arg1Value) {
                return (state_0 & 1) != 0 || !(arg1Value instanceof NFISymbol);
            }

            @GeneratedBy(value=NFISignature.class)
            private static final class CreateClosureCachedData
            extends Node {
                @Node.Child
                CreateClosureCachedData next_;
                @CompilerDirectives.CompilationFinal
                NFIClosure cachedClosure_;
                @Node.Child
                NFIBackendSignatureLibrary lib_;
                @CompilerDirectives.CompilationFinal
                Object cachedRet_;
                @CompilerDirectives.CompilationFinal
                Assumption assumption0_;

                CreateClosureCachedData(CreateClosureCachedData next_) {
                    this.next_ = next_;
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                <T extends Node> T insertAccessor(T node) {
                    return (T)super.insert(node);
                }
            }
        }
    }
}

