/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.nfi.CallSignatureNode;
import com.oracle.truffle.nfi.NFIClosure;
import com.oracle.truffle.nfi.NFILanguage;
import com.oracle.truffle.nfi.NFISymbol;
import com.oracle.truffle.nfi.NFIType;
import com.oracle.truffle.nfi.api.SignatureLibrary;
import com.oracle.truffle.nfi.backend.spi.NFIBackendSignatureBuilderLibrary;
import com.oracle.truffle.nfi.backend.spi.NFIBackendSignatureLibrary;
import com.oracle.truffle.nfi.backend.spi.util.ProfiledArrayBuilder;

@ExportLibrary(value=SignatureLibrary.class)
final class NFISignature
implements TruffleObject {
    final String backendId;
    final SignatureCachedState cachedState;
    final Object nativeSignature;
    final NFIType retType;
    final NFIType[] argTypes;
    final int nativeArgCount;
    final int managedArgCount;
    static final NFISignature NO_SIGNATURE = new NFISignature();

    private NFISignature() {
        this.backendId = null;
        this.cachedState = null;
        this.nativeSignature = null;
        this.retType = null;
        this.argTypes = null;
        this.nativeArgCount = -1;
        this.managedArgCount = -1;
    }

    NFISignature(String backendId, SignatureCachedState cachedState, Object nativeSignature, NFIType retType, NFIType[] argTypes, int nativeArgCount, int managedArgCount) {
        this.backendId = backendId;
        this.cachedState = cachedState;
        this.nativeSignature = nativeSignature;
        this.retType = retType;
        this.argTypes = argTypes;
        this.nativeArgCount = nativeArgCount;
        this.managedArgCount = managedArgCount;
    }

    @ExportMessage
    Object call(Object function, Object[] args, @Cached CallSignatureNode.CachedCallSignatureNode call) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
        return call.execute(this, function, args);
    }

    @ExportLibrary(value=NFIBackendSignatureBuilderLibrary.class)
    static final class SignatureBuilder {
        final String backendId;
        final Object backendBuilder;
        NFIType retType;
        ProfiledArrayBuilder<NFIType> argTypes;
        NFIType.TypeCachedState retTypeState;
        ArgsCachedState argsState;

        SignatureBuilder(String backendId, Object backendBuilder, ProfiledArrayBuilder<NFIType> argTypes) {
            this.backendId = backendId;
            this.backendBuilder = backendBuilder;
            this.argsState = ArgsCachedState.NO_ARGS;
            this.argTypes = argTypes;
        }

        @ExportMessage
        void makeVarargs(@CachedLibrary(value="this.backendBuilder") NFIBackendSignatureBuilderLibrary backendLibrary) {
            backendLibrary.makeVarargs(this.backendBuilder);
        }

        @ExportMessage
        static class Build {
            Build() {
            }

            @Specialization(guards={"builder.argsState == cachedState.args", "builder.retTypeState == cachedState.retType"})
            static NFISignature doCached(SignatureBuilder builder, @Cached(value="create(builder)") SignatureCachedState cachedState, @CachedLibrary(value="builder.backendBuilder") NFIBackendSignatureBuilderLibrary backendLibrary) {
                Object nativeSignature = backendLibrary.build(builder.backendBuilder);
                return new NFISignature(builder.backendId, cachedState, nativeSignature, builder.retType, builder.argTypes.getFinalArray(), cachedState.args.nativeArgCount, cachedState.args.managedArgCount);
            }

            @Specialization(replaces={"doCached"})
            static NFISignature doGeneric(SignatureBuilder builder, @CachedLibrary(value="builder.backendBuilder") NFIBackendSignatureBuilderLibrary backendLibrary) {
                Object nativeSignature = backendLibrary.build(builder.backendBuilder);
                return new NFISignature(builder.backendId, null, nativeSignature, builder.retType, builder.argTypes.getFinalArray(), builder.argsState.nativeArgCount, builder.argsState.managedArgCount);
            }
        }

        @ExportMessage
        static class SetReturnType {
            SetReturnType() {
            }

            @Specialization
            static void doSet(SignatureBuilder builder, NFIType type, @CachedLibrary(value="builder.backendBuilder") NFIBackendSignatureBuilderLibrary backendLibrary) {
                builder.retType = type;
                builder.retTypeState = type.cachedState;
                backendLibrary.setReturnType(builder.backendBuilder, type.backendType);
            }
        }

        @ExportMessage
        static class AddArgument {
            AddArgument() {
            }

            @Specialization(guards={"builder.argsState == prevArgsState", "type.cachedState == argState"})
            static void doCached(SignatureBuilder builder, NFIType type, @Cached(value="builder.argsState") ArgsCachedState prevArgsState, @Cached(value="type.cachedState") NFIType.TypeCachedState argState, @Cached(value="prevArgsState.addArg(argState)") ArgsCachedState newArgsState, @CachedLibrary(value="builder.backendBuilder") NFIBackendSignatureBuilderLibrary backendLibrary) {
                assert (builder.argsState == prevArgsState && type.cachedState == argState);
                builder.argsState = newArgsState;
                backendLibrary.addArgument(builder.backendBuilder, type.backendType);
                builder.argTypes.add(type);
            }

            @Specialization(replaces={"doCached"})
            static void doGeneric(SignatureBuilder builder, NFIType type, @CachedLibrary(value="builder.backendBuilder") NFIBackendSignatureBuilderLibrary backendLibrary) {
                builder.argsState = builder.argsState.addArg(type.cachedState);
                backendLibrary.addArgument(builder.backendBuilder, type.backendType);
                builder.argTypes.add(type);
            }
        }
    }

    static final class SignatureCachedState {
        final NFIType.TypeCachedState retType;
        final ArgsCachedState args;
        private CallTarget polymorphicSignatureCall;
        private CallTarget polymorphicClosureCall;

        private SignatureCachedState(NFIType.TypeCachedState retType, ArgsCachedState args) {
            this.retType = retType;
            this.args = args;
        }

        static SignatureCachedState create(SignatureBuilder builder) {
            return new SignatureCachedState(builder.retTypeState, builder.argsState);
        }

        CallSignatureNode createOptimizedSignatureCall() {
            CompilerAsserts.neverPartOfCompilation((String)"createOptimizedSignatureCall");
            return CallSignatureNode.createOptimizedCall(this.retType, this.args);
        }

        CallSignatureNode createOptimizedClosureCall() {
            CompilerAsserts.neverPartOfCompilation((String)"createOptimizedClosureCall");
            return CallSignatureNode.createOptimizedClosure(this.retType, this.args);
        }

        @CompilerDirectives.TruffleBoundary
        private synchronized void initPolymorphicSignatureCall() {
            if (this.polymorphicSignatureCall == null) {
                CallSignatureNode call = this.createOptimizedSignatureCall();
                CallSignatureNode.CallSignatureRootNode rootNode = new CallSignatureNode.CallSignatureRootNode(NFILanguage.get(null), call);
                this.polymorphicSignatureCall = Truffle.getRuntime().createCallTarget((RootNode)rootNode);
            }
        }

        CallTarget getPolymorphicSignatureCall() {
            if (this.polymorphicSignatureCall == null) {
                this.initPolymorphicSignatureCall();
            }
            assert (this.polymorphicSignatureCall != null);
            return this.polymorphicSignatureCall;
        }

        @CompilerDirectives.TruffleBoundary
        private synchronized void initPolymorphicClosureCall() {
            if (this.polymorphicClosureCall == null) {
                CallSignatureNode call = this.createOptimizedClosureCall();
                CallSignatureNode.CallSignatureRootNode rootNode = new CallSignatureNode.CallSignatureRootNode(NFILanguage.get(null), call);
                this.polymorphicClosureCall = Truffle.getRuntime().createCallTarget((RootNode)rootNode);
            }
        }

        CallTarget getPolymorphicClosureCall() {
            if (this.polymorphicClosureCall == null) {
                this.initPolymorphicClosureCall();
            }
            assert (this.polymorphicClosureCall != null);
            return this.polymorphicClosureCall;
        }
    }

    static final class ArgsCachedState {
        static final ArgsCachedState NO_ARGS = new ArgsCachedState();
        final int nativeArgCount;
        final int managedArgCount;
        final NFIType.TypeCachedState argType;
        final ArgsCachedState prev;

        private ArgsCachedState() {
            this(0, 0, null, null);
        }

        private ArgsCachedState(int nativeArgCount, int managedArgCount, NFIType.TypeCachedState argType, ArgsCachedState prev) {
            this.nativeArgCount = nativeArgCount;
            this.managedArgCount = managedArgCount;
            this.argType = argType;
            this.prev = prev;
        }

        ArgsCachedState addArg(NFIType.TypeCachedState type) {
            return new ArgsCachedState(this.nativeArgCount + 1, this.managedArgCount + type.managedArgCount, type, this);
        }
    }

    @ExportMessage
    @ImportStatic(value={NFILanguage.class})
    static class CreateClosure {
        CreateClosure() {
        }

        static NFIClosure createClosure(Object executable, NFISignature signature) {
            return new NFIClosure(executable, signature);
        }

        @Specialization(guards={"executable == cachedClosure.executable", "signature == cachedClosure.signature"}, assumptions={"getSingleContextAssumption()"})
        static Object doCached(NFISignature signature, Object executable, @Cached(value="createClosure(executable, signature)") NFIClosure cachedClosure, @CachedLibrary(value="cachedClosure.signature.nativeSignature") NFIBackendSignatureLibrary lib, @Cached(value="lib.createClosure(cachedClosure.signature.nativeSignature, cachedClosure)") Object cachedRet) {
            return cachedRet;
        }

        @Specialization(replaces={"doCached"})
        static Object doCreate(NFISignature signature, Object executable, @CachedLibrary(value="signature.nativeSignature") NFIBackendSignatureLibrary lib) {
            NFIClosure closure = new NFIClosure(executable, signature);
            return lib.createClosure(signature.nativeSignature, closure);
        }
    }

    @ExportMessage
    static class Bind {
        Bind() {
        }

        @Specialization
        static Object doSymbol(NFISignature signature, NFISymbol function) {
            return NFISymbol.createBound(signature.backendId, function.nativeSymbol, signature);
        }

        @Fallback
        static Object doOther(NFISignature signature, Object function) {
            return NFISymbol.createBound(signature.backendId, function, signature);
        }
    }
}

