/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.nfi.NFIContext;
import com.oracle.truffle.nfi.NFILanguage;
import com.oracle.truffle.nfi.NFISignature;
import com.oracle.truffle.nfi.NFISymbol;

@GenerateUncached
@ImportStatic(value={NFILanguage.class})
abstract class BindSignatureNode
extends Node {
    BindSignatureNode() {
    }

    abstract Object execute(NFISymbol var1, Object var2) throws UnsupportedMessageException, UnsupportedTypeException;

    static String asString(InteropLibrary interop, Object signature) throws UnsupportedTypeException {
        try {
            return interop.asString(signature);
        }
        catch (UnsupportedMessageException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw UnsupportedTypeException.create((Object[])new Object[]{signature});
        }
    }

    @CompilerDirectives.TruffleBoundary
    static Source createSignatureSource(String backend, Object signature) throws UnsupportedTypeException {
        String sigString = BindSignatureNode.asString(InteropLibrary.getUncached(), signature);
        return Source.newBuilder((String)"nfi", (CharSequence)String.format("with %s %s", backend, sigString), (String)"bind").build();
    }

    @CompilerDirectives.TruffleBoundary
    static NFISignature parseSignature(String backend, Object signature) throws UnsupportedTypeException {
        Source source = BindSignatureNode.createSignatureSource(backend, signature);
        CallTarget ct = NFIContext.get(null).env.parseInternal(source, new String[0]);
        return (NFISignature)ct.call(new Object[0]);
    }

    @Specialization(limit="5", guards={"symbol.backend == cachedBackend", "signature == cachedSignature"}, assumptions={"getSingleContextAssumption()"})
    static Object doCachedSignature(NFISymbol symbol, Object signature, @Cached(value="symbol.backend") String cachedBackend, @Cached(value="signature") Object cachedSignature, @Cached(value="parseSignature(cachedBackend, cachedSignature)") NFISignature parsedSignature) {
        return NFISymbol.createBound(symbol.backend, symbol.nativeSymbol, parsedSignature);
    }

    @Specialization(limit="5", guards={"cachedSignature.equals(asString(interop, signature))"}, replaces={"doCachedSignature"})
    Object doCachedSignatureString(NFISymbol symbol, Object signature, @CachedLibrary(value="signature") InteropLibrary interop, @Cached(value="asString(interop, signature)") String cachedSignature, @Cached(value="createSignatureSource(symbol.backend, cachedSignature)") Source signatureSource, @Cached IndirectCallNode call) {
        CallTarget parsedSignature = NFIContext.get((Node)this).env.parseInternal(signatureSource, new String[0]);
        return NFISymbol.createBound(symbol.backend, symbol.nativeSymbol, (NFISignature)call.call(parsedSignature, new Object[0]));
    }

    @Specialization(replaces={"doCachedSignature", "doCachedSignatureString"})
    static Object doGeneric(NFISymbol symbol, Object signature) throws UnsupportedTypeException {
        return NFISymbol.createBound(symbol.backend, symbol.nativeSymbol, BindSignatureNode.parseSignature(symbol.backend, signature));
    }
}

