/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.memory.MemoryFence;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.nfi.CallSignatureNode;
import com.oracle.truffle.nfi.ConvertTypeNode;
import com.oracle.truffle.nfi.ConvertTypeNodeFactory;
import com.oracle.truffle.nfi.NFISignature;
import com.oracle.truffle.nfi.NFIType;
import com.oracle.truffle.nfi.backend.spi.NFIBackendSignatureLibrary;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(value=CallSignatureNode.class)
final class CallSignatureNodeFactory {
    private static final LibraryFactory<NFIBackendSignatureLibrary> N_F_I_BACKEND_SIGNATURE_LIBRARY_ = LibraryFactory.resolve(NFIBackendSignatureLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    CallSignatureNodeFactory() {
    }

    @GeneratedBy(value=CallSignatureNode.OptimizedCallClosureNode.class)
    static final class OptimizedCallClosureNodeGen
    extends CallSignatureNode.OptimizedCallClosureNode
    implements GenerateAOT.Provider {
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @CompilerDirectives.CompilationFinal
        private volatile int exclude_;
        @CompilerDirectives.CompilationFinal
        private BranchProfile call0_exception_;
        @Node.Child
        private InteropLibrary call0_interop_;
        @CompilerDirectives.CompilationFinal
        private BranchProfile call1_exception_;

        private OptimizedCallClosureNodeGen(NFIType.TypeCachedState retType, NFISignature.ArgsCachedState argsState) {
            super(retType, argsState);
        }

        @Override
        Object execute(NFISignature arg0Value, Object arg1Value, Object[] arg2Value) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
            }
            if ((state_0 & 6) != 0) {
                if ((state_0 & 2) != 0 && this.call0_interop_.accepts(arg1Value)) {
                    return this.doCall(arg0Value, arg1Value, arg2Value, this.call0_exception_, this.call0_interop_);
                }
                if ((state_0 & 4) != 0) {
                    return this.call1Boundary(state_0, arg0Value, arg1Value, arg2Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object call1Boundary(int state_0, NFISignature arg0Value, Object arg1Value, Object[] arg2Value) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                InteropLibrary call1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value);
                Object object = this.doCall(arg0Value, arg1Value, arg2Value, this.call1_exception_, call1_interop__);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object executeAndSpecialize(NFISignature arg0Value, Object arg1Value, Object[] arg2Value) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                Object object;
                if ((this.state_0_ & 1) != 0) {
                    this.resetAOT_();
                }
                int state_0 = this.state_0_;
                int exclude = this.exclude_;
                if (exclude == 0) {
                    boolean Call0_duplicateFound_ = false;
                    if ((state_0 & 2) != 0 && this.call0_interop_.accepts(arg1Value)) {
                        Call0_duplicateFound_ = true;
                    }
                    if (!Call0_duplicateFound_ && (state_0 & 2) == 0) {
                        this.call0_exception_ = BranchProfile.create();
                        this.call0_interop_ = (InteropLibrary)super.insert((Node)INTEROP_LIBRARY_.create(arg1Value));
                        this.state_0_ = state_0 |= 2;
                        Call0_duplicateFound_ = true;
                    }
                    if (Call0_duplicateFound_) {
                        lock.unlock();
                        hasLock = false;
                        Object object2 = this.doCall(arg0Value, arg1Value, arg2Value, this.call0_exception_, this.call0_interop_);
                        return object2;
                    }
                }
                InteropLibrary call1_interop__ = null;
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set((Node)this);
                try {
                    this.call1_exception_ = BranchProfile.create();
                    call1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value);
                    this.exclude_ = exclude |= 1;
                    state_0 &= 0xFFFFFFFD;
                    this.state_0_ = state_0 |= 4;
                    lock.unlock();
                    hasLock = false;
                    object = this.doCall(arg0Value, arg1Value, arg2Value, this.call1_exception_, call1_interop__);
                }
                catch (Throwable throwable) {
                    encapsulating_.set(prev_);
                    throw throwable;
                }
                encapsulating_.set(prev_);
                return object;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 6) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 6 & (state_0 & 6) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                return;
            }
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
            this.exclude_ = 0;
        }

        public static CallSignatureNode.OptimizedCallClosureNode create(NFIType.TypeCachedState retType, NFISignature.ArgsCachedState argsState) {
            return new OptimizedCallClosureNodeGen(retType, argsState);
        }
    }

    @GeneratedBy(value=CallSignatureNode.OptimizedCallSignatureNode.class)
    static final class OptimizedCallSignatureNodeGen
    extends CallSignatureNode.OptimizedCallSignatureNode
    implements GenerateAOT.Provider {
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @CompilerDirectives.CompilationFinal
        private BranchProfile exception_;
        @Node.Child
        private NFIBackendSignatureLibrary backendLibrary_;

        private OptimizedCallSignatureNodeGen(NFIType.TypeCachedState retType, NFISignature.ArgsCachedState argsState) {
            super(retType, argsState);
        }

        @Override
        Object execute(NFISignature arg0Value, Object arg1Value, Object[] arg2Value) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
            }
            if ((state_0 & 2) != 0) {
                return this.doCall(arg0Value, arg1Value, arg2Value, this.exception_, this.backendLibrary_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object executeAndSpecialize(NFISignature arg0Value, Object arg1Value, Object[] arg2Value) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                if ((this.state_0_ & 1) != 0) {
                    this.resetAOT_();
                }
                int state_0 = this.state_0_;
                this.exception_ = BranchProfile.create();
                this.backendLibrary_ = (NFIBackendSignatureLibrary)super.insert((Node)N_F_I_BACKEND_SIGNATURE_LIBRARY_.createDispatched(1));
                this.state_0_ = state_0 |= 2;
                lock.unlock();
                hasLock = false;
                Object object = this.doCall(arg0Value, arg1Value, arg2Value, this.exception_, this.backendLibrary_);
                return object;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 2) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                return;
            }
            this.exception_ = BranchProfile.create();
            this.backendLibrary_ = (NFIBackendSignatureLibrary)super.insert((Node)N_F_I_BACKEND_SIGNATURE_LIBRARY_.createDispatched(1));
            this.exception_.disable();
            if (this.backendLibrary_ instanceof GenerateAOT.Provider) {
                assert (NodeUtil.assertRecursion((Node)this.backendLibrary_, (int)1));
                ((GenerateAOT.Provider)this.backendLibrary_).prepareForAOT(language, root);
            }
            this.state_0_ = state_0 |= 3;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            if ((state_0 & 2) != 0) {
                this.exception_.reset();
            }
            this.state_0_ = 0;
            this.backendLibrary_ = null;
        }

        public static CallSignatureNode.OptimizedCallSignatureNode create(NFIType.TypeCachedState retType, NFISignature.ArgsCachedState argsState) {
            return new OptimizedCallSignatureNodeGen(retType, argsState);
        }
    }

    @GeneratedBy(value=CallSignatureNode.CachedCallSignatureNode.class)
    static final class CachedCallSignatureNodeGen
    extends CallSignatureNode.CachedCallSignatureNode
    implements GenerateAOT.Provider {
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @CompilerDirectives.CompilationFinal
        private volatile int exclude_;
        @Node.Child
        private OptimizedDirectData optimizedDirect_cache;
        @Node.Child
        private IndirectCallNode optimizedIndirect_call_;
        @Node.Child
        private SlowPathData slowPath_cache;

        private CachedCallSignatureNodeGen() {
        }

        @Override
        @ExplodeLoop
        Object execute(NFISignature arg0Value, Object arg1Value, Object[] arg2Value) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
            }
            if ((state_0 & 0xE) != 0) {
                SlowPathData s2_;
                if ((state_0 & 2) != 0) {
                    OptimizedDirectData s0_ = this.optimizedDirect_cache;
                    while (s0_ != null) {
                        assert (s0_.cachedState_ != null);
                        if (arg0Value.cachedState == s0_.cachedState_) {
                            return this.doOptimizedDirect(arg0Value, arg1Value, arg2Value, s0_.cachedState_, s0_.call_);
                        }
                        s0_ = s0_.next_;
                    }
                }
                if ((state_0 & 4) != 0 && arg0Value.cachedState != null) {
                    return this.doOptimizedIndirect(arg0Value, arg1Value, arg2Value, this.optimizedIndirect_call_);
                }
                if ((state_0 & 8) != 0 && (s2_ = this.slowPath_cache) != null && arg0Value.cachedState == null) {
                    return this.doSlowPath(arg0Value, arg1Value, arg2Value, s2_.exception_, s2_.convertArg_, s2_.convertRet_, s2_.nativeLibrary_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }

        private Object executeAndSpecialize(NFISignature arg0Value, Object arg1Value, Object[] arg2Value) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                if ((this.state_0_ & 1) != 0) {
                    this.resetAOT_();
                }
                int state_0 = this.state_0_;
                int exclude = this.exclude_;
                if (exclude == 0) {
                    NFISignature.SignatureCachedState cachedState__;
                    int count0_ = 0;
                    OptimizedDirectData s0_ = this.optimizedDirect_cache;
                    if ((state_0 & 2) != 0) {
                        while (s0_ != null) {
                            assert (s0_.cachedState_ != null);
                            if (arg0Value.cachedState == s0_.cachedState_) break;
                            s0_ = s0_.next_;
                            ++count0_;
                        }
                    }
                    if (s0_ == null && (cachedState__ = arg0Value.cachedState) != null && count0_ < 3) {
                        s0_ = (OptimizedDirectData)super.insert((Node)new OptimizedDirectData(this.optimizedDirect_cache));
                        s0_.cachedState_ = cachedState__;
                        s0_.call_ = s0_.insertAccessor(cachedState__.createOptimizedSignatureCall());
                        MemoryFence.storeStore();
                        this.optimizedDirect_cache = s0_;
                        this.state_0_ = state_0 |= 2;
                    }
                    if (s0_ != null) {
                        lock.unlock();
                        hasLock = false;
                        Object object = this.doOptimizedDirect(arg0Value, arg1Value, arg2Value, s0_.cachedState_, s0_.call_);
                        return object;
                    }
                }
                if (arg0Value.cachedState != null) {
                    this.optimizedIndirect_call_ = (IndirectCallNode)super.insert((Node)IndirectCallNode.create());
                    this.exclude_ = exclude |= 1;
                    this.optimizedDirect_cache = null;
                    state_0 &= 0xFFFFFFFD;
                    this.state_0_ = state_0 |= 4;
                    lock.unlock();
                    hasLock = false;
                    Object count0_ = this.doOptimizedIndirect(arg0Value, arg1Value, arg2Value, this.optimizedIndirect_call_);
                    return count0_;
                }
                if (arg0Value.cachedState == null) {
                    SlowPathData s2_ = (SlowPathData)super.insert((Node)new SlowPathData());
                    s2_.exception_ = BranchProfile.create();
                    s2_.convertArg_ = s2_.insertAccessor(ConvertTypeNodeFactory.ConvertToNativeNodeGen.create());
                    s2_.convertRet_ = s2_.insertAccessor(ConvertTypeNodeFactory.ConvertFromNativeNodeGen.create());
                    s2_.nativeLibrary_ = (NFIBackendSignatureLibrary)s2_.insertAccessor(N_F_I_BACKEND_SIGNATURE_LIBRARY_.createDispatched(3));
                    MemoryFence.storeStore();
                    this.slowPath_cache = s2_;
                    this.state_0_ = state_0 |= 8;
                    lock.unlock();
                    hasLock = false;
                    Object object = this.doSlowPath(arg0Value, arg1Value, arg2Value, s2_.exception_, s2_.convertArg_, s2_.convertRet_, s2_.nativeLibrary_);
                    return object;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            OptimizedDirectData s0_;
            int state_0 = this.state_0_;
            if ((state_0 & 0xE) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 0xE & (state_0 & 0xE) - 1) == 0 && ((s0_ = this.optimizedDirect_cache) == null || s0_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                return;
            }
            this.optimizedIndirect_call_ = (IndirectCallNode)super.insert((Node)IndirectCallNode.create());
            this.exclude_ |= 1;
            this.optimizedDirect_cache = null;
            state_0 &= 0xFFFFFFFD;
            SlowPathData s2_ = (SlowPathData)super.insert((Node)new SlowPathData());
            s2_.exception_ = BranchProfile.create();
            s2_.convertArg_ = s2_.insertAccessor(ConvertTypeNodeFactory.ConvertToNativeNodeGen.create());
            s2_.convertRet_ = s2_.insertAccessor(ConvertTypeNodeFactory.ConvertFromNativeNodeGen.create());
            s2_.nativeLibrary_ = (NFIBackendSignatureLibrary)s2_.insertAccessor(N_F_I_BACKEND_SIGNATURE_LIBRARY_.createDispatched(3));
            s2_.exception_.disable();
            MemoryFence.storeStore();
            this.slowPath_cache = s2_;
            assert (NodeUtil.assertRecursion((Node)s2_.convertArg_, (int)1));
            ((GenerateAOT.Provider)s2_.convertArg_).prepareForAOT(language, root);
            assert (NodeUtil.assertRecursion((Node)s2_.convertRet_, (int)1));
            ((GenerateAOT.Provider)s2_.convertRet_).prepareForAOT(language, root);
            if (s2_.nativeLibrary_ instanceof GenerateAOT.Provider) {
                assert (NodeUtil.assertRecursion((Node)s2_.nativeLibrary_, (int)1));
                ((GenerateAOT.Provider)s2_.nativeLibrary_).prepareForAOT(language, root);
            }
            this.state_0_ = state_0 |= 0xD;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            if ((state_0 & 8) != 0) {
                this.slowPath_cache.exception_.reset();
            }
            this.state_0_ = 0;
            this.exclude_ = 0;
            this.slowPath_cache = null;
        }

        public static CallSignatureNode.CachedCallSignatureNode create() {
            return new CachedCallSignatureNodeGen();
        }

        public static CallSignatureNode.CachedCallSignatureNode getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=CallSignatureNode.CachedCallSignatureNode.class)
        private static final class Uncached
        extends CallSignatureNode.CachedCallSignatureNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            Object execute(NFISignature arg0Value, Object arg1Value, Object[] arg2Value) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
                if (arg0Value.cachedState != null) {
                    return this.doOptimizedIndirect(arg0Value, arg1Value, arg2Value, IndirectCallNode.getUncached());
                }
                if (arg0Value.cachedState == null) {
                    return this.doSlowPath(arg0Value, arg1Value, arg2Value, BranchProfile.getUncached(), ConvertTypeNodeFactory.ConvertToNativeNodeGen.getUncached(), ConvertTypeNodeFactory.ConvertFromNativeNodeGen.getUncached(), (NFIBackendSignatureLibrary)N_F_I_BACKEND_SIGNATURE_LIBRARY_.getUncached());
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            public boolean isAdoptable() {
                return false;
            }
        }

        @GeneratedBy(value=CallSignatureNode.CachedCallSignatureNode.class)
        private static final class SlowPathData
        extends Node {
            @CompilerDirectives.CompilationFinal
            BranchProfile exception_;
            @Node.Child
            ConvertTypeNode.ConvertToNativeNode convertArg_;
            @Node.Child
            ConvertTypeNode.ConvertFromNativeNode convertRet_;
            @Node.Child
            NFIBackendSignatureLibrary nativeLibrary_;

            SlowPathData() {
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }

        @GeneratedBy(value=CallSignatureNode.CachedCallSignatureNode.class)
        private static final class OptimizedDirectData
        extends Node {
            @Node.Child
            OptimizedDirectData next_;
            @CompilerDirectives.CompilationFinal
            NFISignature.SignatureCachedState cachedState_;
            @Node.Child
            CallSignatureNode call_;

            OptimizedDirectData(OptimizedDirectData next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }
}

