/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.backend.spi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.library.Message;
import com.oracle.truffle.api.library.ReflectionLibrary;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.utilities.FinalBitSet;
import com.oracle.truffle.nfi.backend.spi.NFIBackendSignatureLibrary;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(value=NFIBackendSignatureLibrary.class)
final class NFIBackendSignatureLibraryGen
extends LibraryFactory<NFIBackendSignatureLibrary> {
    private static final Class<NFIBackendSignatureLibrary> LIBRARY_CLASS = NFIBackendSignatureLibraryGen.lazyLibraryClass();
    private static final Message CALL = new MessageImpl("call", 0, Object.class, Object.class, Object.class, Object[].class);
    private static final Message CREATE_CLOSURE = new MessageImpl("createClosure", 1, Object.class, Object.class, Object.class);
    private static final NFIBackendSignatureLibraryGen INSTANCE = new NFIBackendSignatureLibraryGen();
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private NFIBackendSignatureLibraryGen() {
        super(LIBRARY_CLASS, Collections.unmodifiableList(Arrays.asList(CALL, CREATE_CLOSURE)));
    }

    protected Class<?> getDefaultClass(Object receiver) {
        return NFIBackendSignatureLibrary.class;
    }

    protected NFIBackendSignatureLibrary createProxy(ReflectionLibrary library) {
        return new Proxy(library);
    }

    protected FinalBitSet createMessageBitSet(Message ... messages) {
        BitSet bitSet = new BitSet(2);
        for (Message message : messages) {
            bitSet.set(((MessageImpl)message).index);
        }
        return FinalBitSet.valueOf((BitSet)bitSet);
    }

    protected NFIBackendSignatureLibrary createDelegate(NFIBackendSignatureLibrary delegateLibrary) {
        return new Delegate(delegateLibrary);
    }

    protected Object genericDispatch(Library originalLib, Object receiver, Message message, Object[] args, int offset) throws Exception {
        NFIBackendSignatureLibrary lib = (NFIBackendSignatureLibrary)originalLib;
        MessageImpl messageImpl = (MessageImpl)message;
        if (messageImpl.getParameterCount() - 1 != args.length - offset) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Invalid number of arguments.");
        }
        switch (messageImpl.index) {
            case 0: {
                return lib.call(receiver, args[offset], (Object[])args[offset + 1]);
            }
            case 1: {
                return lib.createClosure(receiver, args[offset]);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new AbstractMethodError(message.toString());
    }

    protected NFIBackendSignatureLibrary createDispatchImpl(int limit) {
        return new CachedDispatchFirst(null, null, limit);
    }

    protected NFIBackendSignatureLibrary createUncachedDispatch() {
        return new UncachedDispatch();
    }

    private static Class<NFIBackendSignatureLibrary> lazyLibraryClass() {
        try {
            return Class.forName("com.oracle.truffle.nfi.backend.spi.NFIBackendSignatureLibrary", false, NFIBackendSignatureLibraryGen.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }

    static {
        LibraryExport.register(LIBRARY_CLASS, (LibraryExport[])new LibraryExport[]{new Default()});
        LibraryFactory.register(LIBRARY_CLASS, (LibraryFactory)INSTANCE);
    }

    @GeneratedBy(value=NFIBackendSignatureLibrary.class)
    private static abstract class CachedDispatch
    extends NFIBackendSignatureLibrary {
        @Node.Child
        NFIBackendSignatureLibrary library;
        @Node.Child
        CachedDispatch next;

        CachedDispatch(NFIBackendSignatureLibrary library, CachedDispatch next) {
            this.library = library;
            this.next = next;
        }

        abstract int getLimit();

        abstract boolean isAOT();

        abstract void setAOT(boolean var1);

        @Override
        @ExplodeLoop
        public Object call(Object receiver_, Object functionPointer, Object ... args) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
            if (CompilerDirectives.inInterpreter() && this.isAOT()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
            while (true) {
                CachedDispatch current = this;
                do {
                    NFIBackendSignatureLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.call(receiver_, functionPointer, args);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public Object createClosure(Object receiver_, Object executable) {
            if (CompilerDirectives.inInterpreter() && this.isAOT()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
            while (true) {
                CachedDispatch current = this;
                do {
                    NFIBackendSignatureLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.createClosure(receiver_, executable);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        public boolean accepts(Object receiver_) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void specialize(Object receiver_) {
            Lock lock = this.getLock();
            lock.lock();
            try {
                if (this.isAOT()) {
                    this.library = null;
                    this.next = null;
                    this.setAOT(false);
                }
                CachedDispatch current = this;
                NFIBackendSignatureLibrary thisLibrary = current.library;
                if (thisLibrary == null) {
                    this.library = (NFIBackendSignatureLibrary)this.insert((Node)INSTANCE.create(receiver_));
                } else {
                    int count = 0;
                    do {
                        NFIBackendSignatureLibrary currentLibrary;
                        if ((currentLibrary = current.library) != null && currentLibrary.accepts(receiver_)) {
                            return;
                        }
                        ++count;
                    } while ((current = current.next) != null);
                    if (count >= this.getLimit()) {
                        this.library = (NFIBackendSignatureLibrary)this.insert((Node)new CachedToUncachedDispatch());
                        this.next = null;
                    } else {
                        this.next = (CachedDispatch)this.insert((Node)new CachedDispatchNext((NFIBackendSignatureLibrary)INSTANCE.create(receiver_), this.next));
                    }
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    @GeneratedBy(value=NFIBackendSignatureLibrary.class)
    private static final class CachedDispatchFirst
    extends CachedDispatch
    implements GenerateAOT.Provider {
        private final int limit_;
        private volatile boolean aot_;

        CachedDispatchFirst(NFIBackendSignatureLibrary library, CachedDispatch next, int limit_) {
            super(library, next);
            this.limit_ = limit_;
        }

        @Override
        void setAOT(boolean value) {
            this.aot_ = value;
        }

        @Override
        boolean isAOT() {
            return this.aot_;
        }

        @Override
        int getLimit() {
            return this.limit_;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if (this.aot_) {
                return;
            }
            for (LibraryExport export : INSTANCE.getAOTExports()) {
                NFIBackendSignatureLibrary exportLibrary = (NFIBackendSignatureLibrary)INSTANCE.createAOT(export);
                if (this.library == null) {
                    this.library = (NFIBackendSignatureLibrary)this.insert((Node)exportLibrary);
                    continue;
                }
                this.next = (CachedDispatch)this.insert((Node)new CachedDispatchNext(exportLibrary, this.next));
            }
            this.aot_ = true;
        }

        public NodeCost getCost() {
            if (this.library instanceof CachedToUncachedDispatch) {
                return NodeCost.MEGAMORPHIC;
            }
            CachedDispatch current = this;
            int count = 0;
            do {
                if (current.library == null) continue;
                ++count;
            } while ((current = current.next) != null);
            return NodeCost.fromCount((int)count);
        }
    }

    @GeneratedBy(value=NFIBackendSignatureLibrary.class)
    private static final class CachedDispatchNext
    extends CachedDispatch {
        CachedDispatchNext(NFIBackendSignatureLibrary library, CachedDispatch next) {
            super(library, next);
        }

        @Override
        int getLimit() {
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Override
        void setAOT(boolean value) {
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Override
        boolean isAOT() {
            throw CompilerDirectives.shouldNotReachHere();
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }
    }

    @GeneratedBy(value=NFIBackendSignatureLibrary.class)
    private static final class UncachedDispatch
    extends NFIBackendSignatureLibrary {
        private UncachedDispatch() {
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object call(Object receiver_, Object functionPointer, Object ... args) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
            return ((NFIBackendSignatureLibrary)INSTANCE.getUncached(receiver_)).call(receiver_, functionPointer, args);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object createClosure(Object receiver_, Object executable) {
            return ((NFIBackendSignatureLibrary)INSTANCE.getUncached(receiver_)).createClosure(receiver_, executable);
        }

        @CompilerDirectives.TruffleBoundary
        public boolean accepts(Object receiver_) {
            return true;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    @GeneratedBy(value=NFIBackendSignatureLibrary.class)
    private static final class CachedToUncachedDispatch
    extends NFIBackendSignatureLibrary {
        private CachedToUncachedDispatch() {
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public Object call(Object receiver_, Object functionPointer, Object ... args) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
            assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                Object object = ((NFIBackendSignatureLibrary)INSTANCE.getUncached(receiver_)).call(receiver_, functionPointer, args);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public Object createClosure(Object receiver_, Object executable) {
            assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                Object object = ((NFIBackendSignatureLibrary)INSTANCE.getUncached(receiver_)).createClosure(receiver_, executable);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        public boolean accepts(Object receiver_) {
            return true;
        }
    }

    @GeneratedBy(value=NFIBackendSignatureLibrary.class)
    private static final class Delegate
    extends NFIBackendSignatureLibrary {
        @Node.Child
        private NFIBackendSignatureLibrary delegateLibrary;

        Delegate(NFIBackendSignatureLibrary delegateLibrary) {
            this.delegateLibrary = delegateLibrary;
        }

        @Override
        public Object call(Object receiver_, Object functionPointer, Object ... args) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
            if (NFIBackendSignatureLibraryGen.isDelegated((Library)this.delegateLibrary, (int)0)) {
                Object delegate = NFIBackendSignatureLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((NFIBackendSignatureLibrary)NFIBackendSignatureLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).call(delegate, functionPointer, args);
            }
            return this.delegateLibrary.call(receiver_, functionPointer, args);
        }

        @Override
        public Object createClosure(Object receiver_, Object executable) {
            if (NFIBackendSignatureLibraryGen.isDelegated((Library)this.delegateLibrary, (int)1)) {
                Object delegate = NFIBackendSignatureLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((NFIBackendSignatureLibrary)NFIBackendSignatureLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).createClosure(delegate, executable);
            }
            return this.delegateLibrary.createClosure(receiver_, executable);
        }

        public boolean accepts(Object receiver_) {
            return this.delegateLibrary.accepts(receiver_);
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        public boolean isAdoptable() {
            return this.delegateLibrary.isAdoptable();
        }
    }

    @GeneratedBy(value=NFIBackendSignatureLibrary.class)
    private static final class Proxy
    extends NFIBackendSignatureLibrary {
        @Node.Child
        private ReflectionLibrary lib;

        Proxy(ReflectionLibrary lib) {
            this.lib = lib;
        }

        @Override
        public Object call(Object receiver_, Object functionPointer, Object ... args) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
            try {
                return this.lib.send(receiver_, CALL, new Object[]{functionPointer, args});
            }
            catch (ArityException | UnsupportedMessageException | UnsupportedTypeException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public Object createClosure(Object receiver_, Object executable) {
            try {
                return this.lib.send(receiver_, CREATE_CLOSURE, new Object[]{executable});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        public boolean accepts(Object receiver_) {
            return this.lib.accepts(receiver_);
        }
    }

    @GeneratedBy(value=NFIBackendSignatureLibrary.class)
    private static class MessageImpl
    extends Message {
        final int index;

        MessageImpl(String name, int index, Class<?> returnType, Class<?> ... parameters) {
            super(LIBRARY_CLASS, name, returnType, (Class[])parameters);
            this.index = index;
        }
    }

    @GeneratedBy(value=NFIBackendSignatureLibrary.class)
    private static final class Default
    extends LibraryExport<NFIBackendSignatureLibrary> {
        private Default() {
            super(NFIBackendSignatureLibrary.class, Object.class, false, false, 0);
        }

        protected NFIBackendSignatureLibrary createUncached(Object receiver) {
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected NFIBackendSignatureLibrary createCached(Object receiver) {
            return new Cached(receiver);
        }

        @GeneratedBy(value=NFIBackendSignatureLibrary.class)
        private static final class Uncached
        extends NFIBackendSignatureLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Uncached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
                this.dynamicDispatchTarget_ = this.dynamicDispatch_.dispatch(receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == this.dynamicDispatchTarget_;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object call(Object receiver, Object functionPointer, Object ... args) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object createClosure(Object receiver, Object executable) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }
        }

        @GeneratedBy(value=NFIBackendSignatureLibrary.class)
        private static final class Cached
        extends NFIBackendSignatureLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Cached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)this.insert((Node)DYNAMIC_DISPATCH_LIBRARY_.create(receiver));
                this.dynamicDispatchTarget_ = ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver)).dispatch(receiver);
            }

            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == this.dynamicDispatchTarget_;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object call(Object receiver, Object functionPointer, Object ... args) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object createClosure(Object receiver, Object executable) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }
        }
    }
}

