/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.memory.MemoryFence;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.nfi.BindSignatureNode;
import com.oracle.truffle.nfi.NFILanguage;
import com.oracle.truffle.nfi.NFISignature;
import com.oracle.truffle.nfi.NFISymbol;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=BindSignatureNode.class)
final class BindSignatureNodeGen
extends BindSignatureNode {
    private static final Uncached UNCACHED = new Uncached();
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    @CompilerDirectives.CompilationFinal
    private volatile int state_0_;
    @CompilerDirectives.CompilationFinal
    private volatile int exclude_;
    @CompilerDirectives.CompilationFinal
    private CachedSignatureData cachedSignature_cache;
    @Node.Child
    private CachedSignatureStringData cachedSignatureString_cache;

    private BindSignatureNodeGen() {
    }

    @Override
    @ExplodeLoop
    Object execute(NFISymbol arg0Value, Object arg1Value) throws UnsupportedMessageException, UnsupportedTypeException {
        int state_0 = this.state_0_;
        if (state_0 != 0) {
            if ((state_0 & 1) != 0) {
                CachedSignatureData s0_ = this.cachedSignature_cache;
                while (s0_ != null) {
                    if (!Assumption.isValidAssumption((Assumption)s0_.assumption0_)) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        this.removeCachedSignature_(s0_);
                        return this.executeAndSpecialize(arg0Value, arg1Value);
                    }
                    if (arg0Value.backend == s0_.cachedBackend_ && arg1Value == s0_.cachedSignature_) {
                        return BindSignatureNode.doCachedSignature(arg0Value, arg1Value, s0_.cachedBackend_, s0_.cachedSignature_, s0_.parsedSignature_);
                    }
                    s0_ = s0_.next_;
                }
            }
            if ((state_0 & 2) != 0) {
                CachedSignatureStringData s1_ = this.cachedSignatureString_cache;
                while (s1_ != null) {
                    if (s1_.interop_.accepts(arg1Value) && s1_.cachedSignature_.equals(BindSignatureNode.asString(s1_.interop_, arg1Value))) {
                        return this.doCachedSignatureString(arg0Value, arg1Value, s1_.interop_, s1_.cachedSignature_, s1_.signatureSource_, s1_.call_);
                    }
                    s1_ = s1_.next_;
                }
            }
            if ((state_0 & 4) != 0) {
                return BindSignatureNode.doGeneric(arg0Value, arg1Value);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value, arg1Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeAndSpecialize(NFISymbol arg0Value, Object arg1Value) throws UnsupportedTypeException {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        try {
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            if ((exclude & 1) == 0) {
                Object assumption0;
                int count0_ = 0;
                CachedSignatureData s0_ = this.cachedSignature_cache;
                if ((state_0 & 1) != 0) {
                    while (s0_ != null && (arg0Value.backend != s0_.cachedBackend_ || arg1Value != s0_.cachedSignature_ || s0_.assumption0_ != null && !Assumption.isValidAssumption((Assumption)s0_.assumption0_))) {
                        s0_ = s0_.next_;
                        ++count0_;
                    }
                }
                if (s0_ == null && Assumption.isValidAssumption((Assumption)(assumption0 = NFILanguage.getSingleContextAssumption())) && count0_ < 5) {
                    s0_ = new CachedSignatureData(this.cachedSignature_cache);
                    s0_.cachedBackend_ = arg0Value.backend;
                    s0_.cachedSignature_ = arg1Value;
                    s0_.parsedSignature_ = BindSignatureNode.parseSignature(s0_.cachedBackend_, s0_.cachedSignature_);
                    s0_.assumption0_ = assumption0;
                    MemoryFence.storeStore();
                    this.cachedSignature_cache = s0_;
                    this.state_0_ = state_0 |= 1;
                }
                if (s0_ != null) {
                    lock.unlock();
                    hasLock = false;
                    assumption0 = BindSignatureNode.doCachedSignature(arg0Value, arg1Value, s0_.cachedBackend_, s0_.cachedSignature_, s0_.parsedSignature_);
                    return assumption0;
                }
            }
            if ((exclude & 2) == 0) {
                InteropLibrary interop__;
                String cachedSignature__;
                int count1_ = 0;
                CachedSignatureStringData s1_ = this.cachedSignatureString_cache;
                if ((state_0 & 2) != 0) {
                    while (!(s1_ == null || s1_.interop_.accepts(arg1Value) && s1_.cachedSignature_.equals(BindSignatureNode.asString(s1_.interop_, arg1Value)))) {
                        s1_ = s1_.next_;
                        ++count1_;
                    }
                }
                if (s1_ == null && (cachedSignature__ = BindSignatureNode.asString(interop__ = (InteropLibrary)super.insert((Node)INTEROP_LIBRARY_.create(arg1Value)), arg1Value)).equals(BindSignatureNode.asString(interop__, arg1Value)) && count1_ < 5) {
                    s1_ = (CachedSignatureStringData)super.insert((Node)new CachedSignatureStringData(this.cachedSignatureString_cache));
                    s1_.interop_ = s1_.insertAccessor(interop__);
                    s1_.cachedSignature_ = cachedSignature__;
                    s1_.signatureSource_ = BindSignatureNode.createSignatureSource(arg0Value.backend, cachedSignature__);
                    s1_.call_ = s1_.insertAccessor(IndirectCallNode.create());
                    MemoryFence.storeStore();
                    this.cachedSignatureString_cache = s1_;
                    this.exclude_ = exclude |= 1;
                    this.cachedSignature_cache = null;
                    state_0 &= 0xFFFFFFFE;
                    this.state_0_ = state_0 |= 2;
                }
                if (s1_ != null) {
                    lock.unlock();
                    hasLock = false;
                    Object object = this.doCachedSignatureString(arg0Value, arg1Value, s1_.interop_, s1_.cachedSignature_, s1_.signatureSource_, s1_.call_);
                    return object;
                }
            }
            this.exclude_ = exclude |= 3;
            this.cachedSignature_cache = null;
            this.cachedSignatureString_cache = null;
            state_0 &= 0xFFFFFFFC;
            this.state_0_ = state_0 |= 4;
            lock.unlock();
            hasLock = false;
            Object object = BindSignatureNode.doGeneric(arg0Value, arg1Value);
            return object;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if (state_0 == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & state_0 - 1) == 0) {
            CachedSignatureData s0_ = this.cachedSignature_cache;
            CachedSignatureStringData s1_ = this.cachedSignatureString_cache;
            if (!(s0_ != null && s0_.next_ != null || s1_ != null && s1_.next_ != null)) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeCachedSignature_(Object s0_) {
        Lock lock = this.getLock();
        lock.lock();
        try {
            CachedSignatureData prev = null;
            CachedSignatureData cur = this.cachedSignature_cache;
            while (cur != null) {
                if (cur == s0_) {
                    if (prev == null) {
                        this.cachedSignature_cache = cur.next_;
                        break;
                    }
                    prev.next_ = cur.next_;
                    break;
                }
                prev = cur;
                cur = cur.next_;
            }
            if (this.cachedSignature_cache == null) {
                this.state_0_ &= 0xFFFFFFFE;
            }
        }
        finally {
            lock.unlock();
        }
    }

    public static BindSignatureNode create() {
        return new BindSignatureNodeGen();
    }

    public static BindSignatureNode getUncached() {
        return UNCACHED;
    }

    @GeneratedBy(value=BindSignatureNode.class)
    private static final class Uncached
    extends BindSignatureNode {
        private Uncached() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        Object execute(NFISymbol arg0Value, Object arg1Value) throws UnsupportedMessageException, UnsupportedTypeException {
            return BindSignatureNode.doGeneric(arg0Value, arg1Value);
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    @GeneratedBy(value=BindSignatureNode.class)
    private static final class CachedSignatureStringData
    extends Node {
        @Node.Child
        CachedSignatureStringData next_;
        @Node.Child
        InteropLibrary interop_;
        @CompilerDirectives.CompilationFinal
        String cachedSignature_;
        @CompilerDirectives.CompilationFinal
        Source signatureSource_;
        @Node.Child
        IndirectCallNode call_;

        CachedSignatureStringData(CachedSignatureStringData next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }

    @GeneratedBy(value=BindSignatureNode.class)
    private static final class CachedSignatureData {
        @CompilerDirectives.CompilationFinal
        CachedSignatureData next_;
        @CompilerDirectives.CompilationFinal
        String cachedBackend_;
        @CompilerDirectives.CompilationFinal
        Object cachedSignature_;
        @CompilerDirectives.CompilationFinal
        NFISignature parsedSignature_;
        @CompilerDirectives.CompilationFinal
        Assumption assumption0_;

        CachedSignatureData(CachedSignatureData next_) {
            this.next_ = next_;
        }
    }
}

