// CheckStyle: start generated
package com.oracle.truffle.nfi.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.TruffleLanguage.ContextReference;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.nfi.impl.LibFFISignature.ArgsState;
import com.oracle.truffle.nfi.impl.LibFFISignature.CachedSignatureInfo;
import com.oracle.truffle.nfi.impl.LibFFISignature.SignatureBuilder;
import com.oracle.truffle.nfi.impl.LibFFISignature.SignatureBuilder.AddArgument;
import com.oracle.truffle.nfi.impl.LibFFISignature.SignatureBuilder.Build;
import com.oracle.truffle.nfi.impl.LibFFISignature.SignatureBuilder.SetReturnType;
import com.oracle.truffle.nfi.impl.LibFFIType.CachedTypeInfo;
import com.oracle.truffle.nfi.spi.NFIBackendSignatureBuilderLibrary;
import java.util.concurrent.locks.Lock;

@GeneratedBy(SignatureBuilder.class)
final class SignatureBuilderGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    static  {
        LibraryExport.register(SignatureBuilder.class, new NFIBackendSignatureBuilderLibraryExports());
    }

    private SignatureBuilderGen() {
    }

    @GeneratedBy(SignatureBuilder.class)
    private static final class NFIBackendSignatureBuilderLibraryExports extends LibraryExport<NFIBackendSignatureBuilderLibrary> {

        private NFIBackendSignatureBuilderLibraryExports() {
            super(NFIBackendSignatureBuilderLibrary.class, SignatureBuilder.class, false);
        }

        @Override
        protected NFIBackendSignatureBuilderLibrary createUncached(Object receiver) {
            assert receiver instanceof SignatureBuilder;
            NFIBackendSignatureBuilderLibrary uncached = new Uncached();
            return uncached;
        }

        @Override
        protected NFIBackendSignatureBuilderLibrary createCached(Object receiver) {
            assert receiver instanceof SignatureBuilder;
            return new Cached();
        }

        @GeneratedBy(SignatureBuilder.class)
        private static final class Cached extends NFIBackendSignatureBuilderLibrary {

            @CompilationFinal private volatile int state_0_;
            @CompilationFinal private volatile int exclude_;
            @CompilationFinal private ContextReference<NFIContext> nFILanguageImplContextReference_;
            @CompilationFinal private AddArgumentCachedData addArgument_cached_cache;
            @CompilationFinal private BuildCachedData build_cached_cache;

            protected Cached() {
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof SignatureBuilder) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof SignatureBuilder;
            }

            @Override
            public void setReturnType(Object arg0Value_, Object arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                SignatureBuilder arg0Value = ((SignatureBuilder) arg0Value_);
                int state_0 = state_0_;
                if ((state_0 & 0b1) != 0 /* is-state_0 doSet(SignatureBuilder, LibFFIType) */ && arg1Value instanceof LibFFIType) {
                    LibFFIType arg1Value_ = (LibFFIType) arg1Value;
                    SetReturnType.doSet(arg0Value, arg1Value_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                setReturnTypeAndSpecialize(arg0Value, arg1Value);
                return;
            }

            private void setReturnTypeAndSpecialize(SignatureBuilder arg0Value, Object arg1Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = state_0_;
                try {
                    if (arg1Value instanceof LibFFIType) {
                        LibFFIType arg1Value_ = (LibFFIType) arg1Value;
                        this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 doSet(SignatureBuilder, LibFFIType) */;
                        lock.unlock();
                        hasLock = false;
                        SetReturnType.doSet(arg0Value, arg1Value_);
                        return;
                    }
                    throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                int state_0 = state_0_;
                if ((state_0 & 0b1) == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

            @ExplodeLoop
            @Override
            public void addArgument(Object arg0Value_, Object arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                SignatureBuilder arg0Value = ((SignatureBuilder) arg0Value_);
                int state_0 = state_0_;
                if ((state_0 & 0b110) != 0 /* is-state_0 doCached(SignatureBuilder, LibFFIType, ArgsState, CachedTypeInfo, ArgsState) || doGeneric(SignatureBuilder, LibFFIType) */ && arg1Value instanceof LibFFIType) {
                    LibFFIType arg1Value_ = (LibFFIType) arg1Value;
                    if ((state_0 & 0b10) != 0 /* is-state_0 doCached(SignatureBuilder, LibFFIType, ArgsState, CachedTypeInfo, ArgsState) */) {
                        AddArgumentCachedData s1_ = this.addArgument_cached_cache;
                        while (s1_ != null) {
                            if ((arg0Value.state == s1_.oldState_) && (arg1Value_.typeInfo == s1_.cachedTypeInfo_)) {
                                AddArgument.doCached(arg0Value, arg1Value_, s1_.oldState_, s1_.cachedTypeInfo_, s1_.newState_);
                                return;
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is-state_0 doGeneric(SignatureBuilder, LibFFIType) */) {
                        AddArgument.doGeneric(arg0Value, arg1Value_);
                        return;
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                addArgumentAndSpecialize(arg0Value, arg1Value);
                return;
            }

            private void addArgumentAndSpecialize(SignatureBuilder arg0Value, Object arg1Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = state_0_;
                int exclude = exclude_;
                try {
                    if (arg1Value instanceof LibFFIType) {
                        LibFFIType arg1Value_ = (LibFFIType) arg1Value;
                        if (((exclude & 0b1)) == 0 /* is-not-exclude doCached(SignatureBuilder, LibFFIType, ArgsState, CachedTypeInfo, ArgsState) */) {
                            int count1_ = 0;
                            AddArgumentCachedData s1_ = this.addArgument_cached_cache;
                            if ((state_0 & 0b10) != 0 /* is-state_0 doCached(SignatureBuilder, LibFFIType, ArgsState, CachedTypeInfo, ArgsState) */) {
                                while (s1_ != null) {
                                    if ((arg0Value.state == s1_.oldState_) && (arg1Value_.typeInfo == s1_.cachedTypeInfo_)) {
                                        break;
                                    }
                                    s1_ = s1_.next_;
                                    count1_++;
                                }
                            }
                            if (s1_ == null) {
                                // assert (arg0Value.state == s1_.oldState_);
                                // assert (arg1Value_.typeInfo == s1_.cachedTypeInfo_);
                                if (count1_ < (3)) {
                                    s1_ = new AddArgumentCachedData(addArgument_cached_cache);
                                    s1_.oldState_ = (arg0Value.state);
                                    s1_.cachedTypeInfo_ = (arg1Value_.typeInfo);
                                    s1_.newState_ = (s1_.oldState_.addArg(s1_.cachedTypeInfo_));
                                    this.addArgument_cached_cache = s1_;
                                    this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 doCached(SignatureBuilder, LibFFIType, ArgsState, CachedTypeInfo, ArgsState) */;
                                }
                            }
                            if (s1_ != null) {
                                lock.unlock();
                                hasLock = false;
                                AddArgument.doCached(arg0Value, arg1Value_, s1_.oldState_, s1_.cachedTypeInfo_, s1_.newState_);
                                return;
                            }
                        }
                        this.exclude_ = exclude = exclude | 0b1 /* add-exclude doCached(SignatureBuilder, LibFFIType, ArgsState, CachedTypeInfo, ArgsState) */;
                        this.addArgument_cached_cache = null;
                        state_0 = state_0 & 0xfffffffd /* remove-state_0 doCached(SignatureBuilder, LibFFIType, ArgsState, CachedTypeInfo, ArgsState) */;
                        this.state_0_ = state_0 = state_0 | 0b100 /* add-state_0 doGeneric(SignatureBuilder, LibFFIType) */;
                        lock.unlock();
                        hasLock = false;
                        AddArgument.doGeneric(arg0Value, arg1Value_);
                        return;
                    }
                    throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @ExplodeLoop
            @Override
            public Object build(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                SignatureBuilder arg0Value = ((SignatureBuilder) arg0Value_);
                int state_0 = state_0_;
                if ((state_0 & 0b11000) != 0 /* is-state_0 doCached(SignatureBuilder, ArgsState, CachedTypeInfo, NFIContext, CachedSignatureInfo) || doGeneric(SignatureBuilder, NFIContext) */) {
                    if ((state_0 & 0b1000) != 0 /* is-state_0 doCached(SignatureBuilder, ArgsState, CachedTypeInfo, NFIContext, CachedSignatureInfo) */) {
                        BuildCachedData s1_ = this.build_cached_cache;
                        while (s1_ != null) {
                            if ((arg0Value.state == s1_.cachedState_) && (arg0Value.retTypeInfo == s1_.cachedRetType_)) {
                                ContextReference<NFIContext> nFILanguageImplContextReference__ = this.nFILanguageImplContextReference_;
                                NFIContext ctx__ = nFILanguageImplContextReference__.get();
                                return Build.doCached(arg0Value, s1_.cachedState_, s1_.cachedRetType_, ctx__, s1_.cachedSigInfo_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is-state_0 doGeneric(SignatureBuilder, NFIContext) */) {
                        {
                            ContextReference<NFIContext> nFILanguageImplContextReference__1 = this.nFILanguageImplContextReference_;
                            NFIContext build_generic_ctx__ = nFILanguageImplContextReference__1.get();
                            return Build.doGeneric(arg0Value, build_generic_ctx__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return buildAndSpecialize(arg0Value);
            }

            private Object buildAndSpecialize(SignatureBuilder arg0Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = state_0_;
                int exclude = exclude_;
                try {
                    {
                        NFIContext ctx__ = null;
                        if (((exclude & 0b10)) == 0 /* is-not-exclude doCached(SignatureBuilder, ArgsState, CachedTypeInfo, NFIContext, CachedSignatureInfo) */) {
                            int count1_ = 0;
                            BuildCachedData s1_ = this.build_cached_cache;
                            if ((state_0 & 0b1000) != 0 /* is-state_0 doCached(SignatureBuilder, ArgsState, CachedTypeInfo, NFIContext, CachedSignatureInfo) */) {
                                while (s1_ != null) {
                                    if ((arg0Value.state == s1_.cachedState_) && (arg0Value.retTypeInfo == s1_.cachedRetType_)) {
                                        ContextReference<NFIContext> nFILanguageImplContextReference__2 = this.nFILanguageImplContextReference_;
                                        if (nFILanguageImplContextReference__2 == null) {
                                            this.nFILanguageImplContextReference_ = nFILanguageImplContextReference__2 = super.lookupContextReference(NFILanguageImpl.class);
                                        }
                                        ctx__ = nFILanguageImplContextReference__2.get();
                                        break;
                                    }
                                    s1_ = s1_.next_;
                                    count1_++;
                                }
                            }
                            if (s1_ == null) {
                                {
                                    CachedTypeInfo cachedRetType__ = (arg0Value.retType.typeInfo);
                                    // assert (arg0Value.state == s1_.cachedState_);
                                    if ((arg0Value.retTypeInfo == cachedRetType__) && count1_ < (3)) {
                                        s1_ = new BuildCachedData(build_cached_cache);
                                        s1_.cachedState_ = (arg0Value.state);
                                        s1_.cachedRetType_ = cachedRetType__;
                                        ContextReference<NFIContext> nFILanguageImplContextReference__3 = this.nFILanguageImplContextReference_;
                                        if (nFILanguageImplContextReference__3 == null) {
                                            this.nFILanguageImplContextReference_ = nFILanguageImplContextReference__3 = super.lookupContextReference(NFILanguageImpl.class);
                                        }
                                        ctx__ = nFILanguageImplContextReference__3.get();
                                        s1_.cachedSigInfo_ = (LibFFISignature.prepareSignatureInfo(ctx__.language, cachedRetType__, s1_.cachedState_));
                                        this.build_cached_cache = s1_;
                                        this.state_0_ = state_0 = state_0 | 0b1000 /* add-state_0 doCached(SignatureBuilder, ArgsState, CachedTypeInfo, NFIContext, CachedSignatureInfo) */;
                                    }
                                }
                            }
                            if (s1_ != null) {
                                lock.unlock();
                                hasLock = false;
                                return Build.doCached(arg0Value, s1_.cachedState_, s1_.cachedRetType_, ctx__, s1_.cachedSigInfo_);
                            }
                        }
                    }
                    {
                        NFIContext build_generic_ctx__ = null;
                        ContextReference<NFIContext> nFILanguageImplContextReference__4 = this.nFILanguageImplContextReference_;
                        if (nFILanguageImplContextReference__4 == null) {
                            this.nFILanguageImplContextReference_ = nFILanguageImplContextReference__4 = super.lookupContextReference(NFILanguageImpl.class);
                        }
                        build_generic_ctx__ = nFILanguageImplContextReference__4.get();
                        this.exclude_ = exclude = exclude | 0b10 /* add-exclude doCached(SignatureBuilder, ArgsState, CachedTypeInfo, NFIContext, CachedSignatureInfo) */;
                        this.build_cached_cache = null;
                        state_0 = state_0 & 0xfffffff7 /* remove-state_0 doCached(SignatureBuilder, ArgsState, CachedTypeInfo, NFIContext, CachedSignatureInfo) */;
                        this.state_0_ = state_0 = state_0 | 0b10000 /* add-state_0 doGeneric(SignatureBuilder, NFIContext) */;
                        lock.unlock();
                        hasLock = false;
                        return Build.doGeneric(arg0Value, build_generic_ctx__);
                    }
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void makeVarargs(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                (((SignatureBuilder) receiver)).makeVarargs();
                return;
            }

            @GeneratedBy(SignatureBuilder.class)
            private static final class AddArgumentCachedData {

                @CompilationFinal AddArgumentCachedData next_;
                @CompilationFinal ArgsState oldState_;
                @CompilationFinal CachedTypeInfo cachedTypeInfo_;
                @CompilationFinal ArgsState newState_;

                AddArgumentCachedData(AddArgumentCachedData next_) {
                    this.next_ = next_;
                }

            }
            @GeneratedBy(SignatureBuilder.class)
            private static final class BuildCachedData {

                @CompilationFinal BuildCachedData next_;
                @CompilationFinal ArgsState cachedState_;
                @CompilationFinal CachedTypeInfo cachedRetType_;
                @CompilationFinal CachedSignatureInfo cachedSigInfo_;

                BuildCachedData(BuildCachedData next_) {
                    this.next_ = next_;
                }

            }
        }
        @GeneratedBy(SignatureBuilder.class)
        private static final class Uncached extends NFIBackendSignatureBuilderLibrary {

            private final ContextReference<NFIContext> nFILanguageImplContextReference_ = lookupContextReference(NFILanguageImpl.class);

            protected Uncached() {
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof SignatureBuilder) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof SignatureBuilder;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public void setReturnType(Object arg0Value_, Object arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                SignatureBuilder arg0Value = ((SignatureBuilder) arg0Value_);
                if (arg1Value instanceof LibFFIType) {
                    LibFFIType arg1Value_ = (LibFFIType) arg1Value;
                    SetReturnType.doSet(arg0Value, arg1Value_);
                    return;
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            @TruffleBoundary
            @Override
            public void addArgument(Object arg0Value_, Object arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                SignatureBuilder arg0Value = ((SignatureBuilder) arg0Value_);
                if (arg1Value instanceof LibFFIType) {
                    LibFFIType arg1Value_ = (LibFFIType) arg1Value;
                    AddArgument.doGeneric(arg0Value, arg1Value_);
                    return;
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            @TruffleBoundary
            @Override
            public Object build(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                SignatureBuilder arg0Value = ((SignatureBuilder) arg0Value_);
                return Build.doGeneric(arg0Value, this.nFILanguageImplContextReference_.get());
            }

            @TruffleBoundary
            @Override
            public void makeVarargs(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                ((SignatureBuilder) receiver) .makeVarargs();
                return;
            }

        }
    }
}
