// CheckStyle: start generated
package com.oracle.truffle.nfi.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.TruffleLanguage.ContextReference;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.nfi.spi.NFIBackendSignatureLibrary;
import java.util.concurrent.locks.Lock;

@GeneratedBy(LibFFISignature.class)
@SuppressWarnings("unused")
final class LibFFISignatureGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    static  {
        LibraryExport.register(LibFFISignature.class, new NFIBackendSignatureLibraryExports());
    }

    private LibFFISignatureGen() {
    }

    @GeneratedBy(LibFFISignature.class)
    private static final class NFIBackendSignatureLibraryExports extends LibraryExport<NFIBackendSignatureLibrary> {

        private NFIBackendSignatureLibraryExports() {
            super(NFIBackendSignatureLibrary.class, LibFFISignature.class, false);
        }

        @Override
        protected NFIBackendSignatureLibrary createUncached(Object receiver) {
            assert receiver instanceof LibFFISignature;
            NFIBackendSignatureLibrary uncached = new Uncached();
            return uncached;
        }

        @Override
        protected NFIBackendSignatureLibrary createCached(Object receiver) {
            assert receiver instanceof LibFFISignature;
            return new Cached();
        }

        @GeneratedBy(LibFFISignature.class)
        private static final class Cached extends NFIBackendSignatureLibrary {

            @CompilationFinal private volatile int state_0_;
            @CompilationFinal private volatile int exclude_;
            @CompilationFinal private ContextReference<NFIContext> nFILanguageImplContextReference_;
            @Child private CallNode_Call0Data callNode__call0_cache;
            @CompilationFinal private BranchProfile callNode__call1_toNative_;
            @CompilationFinal private BranchProfile callNode__call1_error_;
            @Child private FunctionExecuteNode callNode__call1_functionExecute_;

            protected Cached() {
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof LibFFISignature) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LibFFISignature;
            }

            @ExplodeLoop
            @Override
            public Object call(Object arg0Value_, Object arg1Value, Object... arg2Value) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                LibFFISignature arg0Value = ((LibFFISignature) arg0Value_);
                int state_0 = state_0_;
                if ((state_0 & 0b11) != 0 /* is-state_0 call(LibFFISignature, Object, Object[], InteropLibrary, BranchProfile, BranchProfile, FunctionExecuteNode) || call(LibFFISignature, Object, Object[], InteropLibrary, BranchProfile, BranchProfile, FunctionExecuteNode) */) {
                    if ((state_0 & 0b1) != 0 /* is-state_0 call(LibFFISignature, Object, Object[], InteropLibrary, BranchProfile, BranchProfile, FunctionExecuteNode) */) {
                        CallNode_Call0Data s1_ = this.callNode__call0_cache;
                        while (s1_ != null) {
                            if ((s1_.interop_.accepts(arg1Value))) {
                                return arg0Value.call(arg1Value, arg2Value, s1_.interop_, s1_.toNative_, s1_.error_, s1_.functionExecute_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is-state_0 call(LibFFISignature, Object, Object[], InteropLibrary, BranchProfile, BranchProfile, FunctionExecuteNode) */) {
                        return this.call1Boundary(state_0, arg0Value, arg1Value, arg2Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return callNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            @SuppressWarnings("static-method")
            @TruffleBoundary
            private Object call1Boundary(int state_0, LibFFISignature arg0Value, Object arg1Value, Object[] arg2Value) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set(this);
                try {
                    {
                        InteropLibrary callNode__call1_interop__ = (INTEROP_LIBRARY_.getUncached(arg1Value));
                        return arg0Value.call(arg1Value, arg2Value, callNode__call1_interop__, this.callNode__call1_toNative_, this.callNode__call1_error_, this.callNode__call1_functionExecute_);
                    }
                } finally {
                    encapsulating_.set(prev_);
                }
            }

            private Object callNode_AndSpecialize(LibFFISignature arg0Value, Object arg1Value, Object[] arg2Value) throws ArityException, UnsupportedTypeException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = state_0_;
                int exclude = exclude_;
                try {
                    if ((exclude) == 0 /* is-not-exclude call(LibFFISignature, Object, Object[], InteropLibrary, BranchProfile, BranchProfile, FunctionExecuteNode) */) {
                        int count1_ = 0;
                        CallNode_Call0Data s1_ = this.callNode__call0_cache;
                        if ((state_0 & 0b1) != 0 /* is-state_0 call(LibFFISignature, Object, Object[], InteropLibrary, BranchProfile, BranchProfile, FunctionExecuteNode) */) {
                            while (s1_ != null) {
                                if ((s1_.interop_.accepts(arg1Value))) {
                                    break;
                                }
                                s1_ = s1_.next_;
                                count1_++;
                            }
                        }
                        if (s1_ == null) {
                            // assert (s1_.interop_.accepts(arg1Value));
                            if (count1_ < (3)) {
                                s1_ = super.insert(new CallNode_Call0Data(callNode__call0_cache));
                                s1_.interop_ = s1_.insertAccessor((INTEROP_LIBRARY_.create(arg1Value)));
                                s1_.toNative_ = (BranchProfile.create());
                                s1_.error_ = (BranchProfile.create());
                                s1_.functionExecute_ = s1_.insertAccessor((FunctionExecuteNodeGen.create()));
                                this.callNode__call0_cache = s1_;
                                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 call(LibFFISignature, Object, Object[], InteropLibrary, BranchProfile, BranchProfile, FunctionExecuteNode) */;
                            }
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            return arg0Value.call(arg1Value, arg2Value, s1_.interop_, s1_.toNative_, s1_.error_, s1_.functionExecute_);
                        }
                    }
                    {
                        InteropLibrary callNode__call1_interop__ = null;
                        {
                            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                            Node prev_ = encapsulating_.set(this);
                            try {
                                callNode__call1_interop__ = (INTEROP_LIBRARY_.getUncached(arg1Value));
                                this.callNode__call1_toNative_ = (BranchProfile.create());
                                this.callNode__call1_error_ = (BranchProfile.create());
                                this.callNode__call1_functionExecute_ = super.insert((FunctionExecuteNodeGen.create()));
                                this.exclude_ = exclude = exclude | 0b1 /* add-exclude call(LibFFISignature, Object, Object[], InteropLibrary, BranchProfile, BranchProfile, FunctionExecuteNode) */;
                                this.callNode__call0_cache = null;
                                state_0 = state_0 & 0xfffffffe /* remove-state_0 call(LibFFISignature, Object, Object[], InteropLibrary, BranchProfile, BranchProfile, FunctionExecuteNode) */;
                                this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 call(LibFFISignature, Object, Object[], InteropLibrary, BranchProfile, BranchProfile, FunctionExecuteNode) */;
                                lock.unlock();
                                hasLock = false;
                                return arg0Value.call(arg1Value, arg2Value, callNode__call1_interop__, this.callNode__call1_toNative_, this.callNode__call1_error_, this.callNode__call1_functionExecute_);
                            } finally {
                                encapsulating_.set(prev_);
                            }
                        }
                    }
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                int state_0 = state_0_;
                if ((state_0 & 0b11) == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    if (((state_0 & 0b11) & ((state_0 & 0b11) - 1)) == 0 /* is-single-state_0  */) {
                        CallNode_Call0Data s1_ = this.callNode__call0_cache;
                        if ((s1_ == null || s1_.next_ == null)) {
                            return NodeCost.MONOMORPHIC;
                        }
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

            @Override
            public Object createClosure(Object arg0Value_, Object arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                LibFFISignature arg0Value = ((LibFFISignature) arg0Value_);
                int state_0 = state_0_;
                if ((state_0 & 0b100) != 0 /* is-state_0 createClosure(LibFFISignature, Object, ContextReference<NFIContext>) */) {
                    {
                        ContextReference<NFIContext> nFILanguageImplContextReference__ = this.nFILanguageImplContextReference_;
                        ContextReference<NFIContext> createClosureNode__ctxRef__ = nFILanguageImplContextReference__;
                        return LibFFISignature.createClosure(arg0Value, arg1Value, createClosureNode__ctxRef__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return createClosureNode_AndSpecialize(arg0Value, arg1Value);
            }

            private Object createClosureNode_AndSpecialize(LibFFISignature arg0Value, Object arg1Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = state_0_;
                try {
                    {
                        ContextReference<NFIContext> createClosureNode__ctxRef__ = null;
                        ContextReference<NFIContext> nFILanguageImplContextReference__1 = this.nFILanguageImplContextReference_;
                        if (nFILanguageImplContextReference__1 == null) {
                            this.nFILanguageImplContextReference_ = nFILanguageImplContextReference__1 = super.lookupContextReference(NFILanguageImpl.class);
                        }
                        createClosureNode__ctxRef__ = nFILanguageImplContextReference__1;
                        this.state_0_ = state_0 = state_0 | 0b100 /* add-state_0 createClosure(LibFFISignature, Object, ContextReference<NFIContext>) */;
                        lock.unlock();
                        hasLock = false;
                        return LibFFISignature.createClosure(arg0Value, arg1Value, createClosureNode__ctxRef__);
                    }
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @GeneratedBy(LibFFISignature.class)
            private static final class CallNode_Call0Data extends Node {

                @Child CallNode_Call0Data next_;
                @Child InteropLibrary interop_;
                @CompilationFinal BranchProfile toNative_;
                @CompilationFinal BranchProfile error_;
                @Child FunctionExecuteNode functionExecute_;

                CallNode_Call0Data(CallNode_Call0Data next_) {
                    this.next_ = next_;
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                <T extends Node> T insertAccessor(T node) {
                    return super.insert(node);
                }

            }
        }
        @GeneratedBy(LibFFISignature.class)
        private static final class Uncached extends NFIBackendSignatureLibrary {

            private final ContextReference<NFIContext> nFILanguageImplContextReference_ = lookupContextReference(NFILanguageImpl.class);

            protected Uncached() {
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof LibFFISignature) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LibFFISignature;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public Object call(Object arg0Value_, Object arg1Value, Object... arg2Value) throws ArityException, UnsupportedTypeException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                LibFFISignature arg0Value = ((LibFFISignature) arg0Value_);
                return arg0Value.call(arg1Value, arg2Value, (INTEROP_LIBRARY_.getUncached(arg1Value)), (BranchProfile.getUncached()), (BranchProfile.getUncached()), (FunctionExecuteNodeGen.getUncached()));
            }

            @TruffleBoundary
            @Override
            public Object createClosure(Object arg0Value_, Object arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                LibFFISignature arg0Value = ((LibFFISignature) arg0Value_);
                return LibFFISignature.createClosure(arg0Value, arg1Value, this.nFILanguageImplContextReference_);
            }

        }
    }
}
