// CheckStyle: start generated
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.nfi.NFISignature.ArgsCachedState;
import com.oracle.truffle.nfi.NFISignature.SignatureBuilder;
import com.oracle.truffle.nfi.NFISignature.SignatureCachedState;
import com.oracle.truffle.nfi.NFISignature.SignatureBuilder.AddArgument;
import com.oracle.truffle.nfi.NFISignature.SignatureBuilder.Build;
import com.oracle.truffle.nfi.NFISignature.SignatureBuilder.SetReturnType;
import com.oracle.truffle.nfi.NFIType.TypeCachedState;
import com.oracle.truffle.nfi.spi.NFIBackendSignatureBuilderLibrary;
import java.util.concurrent.locks.Lock;

@GeneratedBy(SignatureBuilder.class)
final class SignatureBuilderGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<NFIBackendSignatureBuilderLibrary> N_F_I_BACKEND_SIGNATURE_BUILDER_LIBRARY_ = LibraryFactory.resolve(NFIBackendSignatureBuilderLibrary.class);

    static  {
        LibraryExport.register(SignatureBuilder.class, new NFIBackendSignatureBuilderLibraryExports());
    }

    private SignatureBuilderGen() {
    }

    @GeneratedBy(SignatureBuilder.class)
    private static final class NFIBackendSignatureBuilderLibraryExports extends LibraryExport<NFIBackendSignatureBuilderLibrary> {

        private NFIBackendSignatureBuilderLibraryExports() {
            super(NFIBackendSignatureBuilderLibrary.class, SignatureBuilder.class, false);
        }

        @Override
        protected NFIBackendSignatureBuilderLibrary createUncached(Object receiver) {
            assert receiver instanceof SignatureBuilder;
            NFIBackendSignatureBuilderLibrary uncached = new Uncached();
            return uncached;
        }

        @Override
        protected NFIBackendSignatureBuilderLibrary createCached(Object receiver) {
            assert receiver instanceof SignatureBuilder;
            return new Cached(receiver);
        }

        @GeneratedBy(SignatureBuilder.class)
        private static final class Cached extends NFIBackendSignatureBuilderLibrary {

            @Child private NFIBackendSignatureBuilderLibrary receiverBackendBuilderNFIBackendSignatureBuilderLibrary_;
            @CompilationFinal private volatile int state_0_;
            @CompilationFinal private volatile int exclude_;
            @Child private AddArgumentCachedData addArgument_cached_cache;
            @Child private BuildCachedData build_cached_cache;

            protected Cached(Object receiver) {
                SignatureBuilder castReceiver = ((SignatureBuilder) receiver) ;
                this.receiverBackendBuilderNFIBackendSignatureBuilderLibrary_ = super.insert(N_F_I_BACKEND_SIGNATURE_BUILDER_LIBRARY_.create((castReceiver.backendBuilder)));
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof SignatureBuilder) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                if (!(receiver instanceof SignatureBuilder)) {
                    return false;
                } else if (!this.receiverBackendBuilderNFIBackendSignatureBuilderLibrary_.accepts((((SignatureBuilder) receiver).backendBuilder))) {
                    return false;
                } else {
                    return true;
                }
            }

            @ExplodeLoop
            @Override
            public void addArgument(Object arg0Value_, Object arg1Value) {
                assert arg0Value_ instanceof SignatureBuilder : "Invalid library usage. Library does not accept given receiver.";
                assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                SignatureBuilder arg0Value = ((SignatureBuilder) arg0Value_);
                int state_0 = state_0_;
                if ((state_0 & 0b11) != 0 /* is-state_0 doCached(SignatureBuilder, NFIType, ArgsCachedState, TypeCachedState, ArgsCachedState, NFIBackendSignatureBuilderLibrary) || doGeneric(SignatureBuilder, NFIType, NFIBackendSignatureBuilderLibrary) */ && arg1Value instanceof NFIType) {
                    NFIType arg1Value_ = (NFIType) arg1Value;
                    if ((state_0 & 0b1) != 0 /* is-state_0 doCached(SignatureBuilder, NFIType, ArgsCachedState, TypeCachedState, ArgsCachedState, NFIBackendSignatureBuilderLibrary) */) {
                        AddArgumentCachedData s1_ = this.addArgument_cached_cache;
                        while (s1_ != null) {
                            if ((arg0Value.argsState == s1_.prevArgsState_) && (arg1Value_.cachedState == s1_.argState_)) {
                                NFIBackendSignatureBuilderLibrary backendLibrary__ = this.receiverBackendBuilderNFIBackendSignatureBuilderLibrary_;
                                AddArgument.doCached(arg0Value, arg1Value_, s1_.prevArgsState_, s1_.argState_, s1_.newArgsState_, backendLibrary__);
                                return;
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is-state_0 doGeneric(SignatureBuilder, NFIType, NFIBackendSignatureBuilderLibrary) */) {
                        {
                            NFIBackendSignatureBuilderLibrary addArgument_generic_backendLibrary__ = this.receiverBackendBuilderNFIBackendSignatureBuilderLibrary_;
                            AddArgument.doGeneric(arg0Value, arg1Value_, addArgument_generic_backendLibrary__);
                            return;
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                addArgumentAndSpecialize(arg0Value, arg1Value);
                return;
            }

            private void addArgumentAndSpecialize(SignatureBuilder arg0Value, Object arg1Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = state_0_;
                int exclude = exclude_;
                try {
                    if (arg1Value instanceof NFIType) {
                        NFIType arg1Value_ = (NFIType) arg1Value;
                        {
                            NFIBackendSignatureBuilderLibrary backendLibrary__ = null;
                            if (((exclude & 0b1)) == 0 /* is-not-exclude doCached(SignatureBuilder, NFIType, ArgsCachedState, TypeCachedState, ArgsCachedState, NFIBackendSignatureBuilderLibrary) */) {
                                int count1_ = 0;
                                AddArgumentCachedData s1_ = this.addArgument_cached_cache;
                                if ((state_0 & 0b1) != 0 /* is-state_0 doCached(SignatureBuilder, NFIType, ArgsCachedState, TypeCachedState, ArgsCachedState, NFIBackendSignatureBuilderLibrary) */) {
                                    while (s1_ != null) {
                                        if ((arg0Value.argsState == s1_.prevArgsState_) && (arg1Value_.cachedState == s1_.argState_)) {
                                            backendLibrary__ = this.receiverBackendBuilderNFIBackendSignatureBuilderLibrary_;
                                            break;
                                        }
                                        s1_ = s1_.next_;
                                        count1_++;
                                    }
                                }
                                if (s1_ == null) {
                                    // assert (arg0Value.argsState == s1_.prevArgsState_);
                                    // assert (arg1Value_.cachedState == s1_.argState_);
                                    if (count1_ < (3)) {
                                        s1_ = super.insert(new AddArgumentCachedData(addArgument_cached_cache));
                                        s1_.prevArgsState_ = (arg0Value.argsState);
                                        s1_.argState_ = (arg1Value_.cachedState);
                                        s1_.newArgsState_ = (s1_.prevArgsState_.addArg(s1_.argState_));
                                        backendLibrary__ = this.receiverBackendBuilderNFIBackendSignatureBuilderLibrary_;
                                        this.addArgument_cached_cache = s1_;
                                        this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 doCached(SignatureBuilder, NFIType, ArgsCachedState, TypeCachedState, ArgsCachedState, NFIBackendSignatureBuilderLibrary) */;
                                    }
                                }
                                if (s1_ != null) {
                                    lock.unlock();
                                    hasLock = false;
                                    AddArgument.doCached(arg0Value, arg1Value_, s1_.prevArgsState_, s1_.argState_, s1_.newArgsState_, backendLibrary__);
                                    return;
                                }
                            }
                        }
                        {
                            NFIBackendSignatureBuilderLibrary addArgument_generic_backendLibrary__ = null;
                            addArgument_generic_backendLibrary__ = this.receiverBackendBuilderNFIBackendSignatureBuilderLibrary_;
                            this.exclude_ = exclude = exclude | 0b1 /* add-exclude doCached(SignatureBuilder, NFIType, ArgsCachedState, TypeCachedState, ArgsCachedState, NFIBackendSignatureBuilderLibrary) */;
                            this.addArgument_cached_cache = null;
                            state_0 = state_0 & 0xfffffffe /* remove-state_0 doCached(SignatureBuilder, NFIType, ArgsCachedState, TypeCachedState, ArgsCachedState, NFIBackendSignatureBuilderLibrary) */;
                            this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 doGeneric(SignatureBuilder, NFIType, NFIBackendSignatureBuilderLibrary) */;
                            lock.unlock();
                            hasLock = false;
                            AddArgument.doGeneric(arg0Value, arg1Value_, addArgument_generic_backendLibrary__);
                            return;
                        }
                    }
                    throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                int state_0 = state_0_;
                if ((state_0 & 0b11) == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    if (((state_0 & 0b11) & ((state_0 & 0b11) - 1)) == 0 /* is-single-state_0  */) {
                        AddArgumentCachedData s1_ = this.addArgument_cached_cache;
                        if ((s1_ == null || s1_.next_ == null)) {
                            return NodeCost.MONOMORPHIC;
                        }
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

            @Override
            public void setReturnType(Object arg0Value_, Object arg1Value) {
                assert arg0Value_ instanceof SignatureBuilder : "Invalid library usage. Library does not accept given receiver.";
                assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                SignatureBuilder arg0Value = ((SignatureBuilder) arg0Value_);
                int state_0 = state_0_;
                if ((state_0 & 0b100) != 0 /* is-state_0 doSet(SignatureBuilder, NFIType, NFIBackendSignatureBuilderLibrary) */ && arg1Value instanceof NFIType) {
                    NFIType arg1Value_ = (NFIType) arg1Value;
                    {
                        NFIBackendSignatureBuilderLibrary setReturnType_backendLibrary__ = this.receiverBackendBuilderNFIBackendSignatureBuilderLibrary_;
                        SetReturnType.doSet(arg0Value, arg1Value_, setReturnType_backendLibrary__);
                        return;
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                setReturnTypeAndSpecialize(arg0Value, arg1Value);
                return;
            }

            private void setReturnTypeAndSpecialize(SignatureBuilder arg0Value, Object arg1Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = state_0_;
                try {
                    {
                        NFIBackendSignatureBuilderLibrary setReturnType_backendLibrary__ = null;
                        if (arg1Value instanceof NFIType) {
                            NFIType arg1Value_ = (NFIType) arg1Value;
                            setReturnType_backendLibrary__ = this.receiverBackendBuilderNFIBackendSignatureBuilderLibrary_;
                            this.state_0_ = state_0 = state_0 | 0b100 /* add-state_0 doSet(SignatureBuilder, NFIType, NFIBackendSignatureBuilderLibrary) */;
                            lock.unlock();
                            hasLock = false;
                            SetReturnType.doSet(arg0Value, arg1Value_, setReturnType_backendLibrary__);
                            return;
                        }
                    }
                    throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @ExplodeLoop
            @Override
            public Object build(Object arg0Value_) {
                assert arg0Value_ instanceof SignatureBuilder : "Invalid library usage. Library does not accept given receiver.";
                assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                SignatureBuilder arg0Value = ((SignatureBuilder) arg0Value_);
                int state_0 = state_0_;
                if ((state_0 & 0b11000) != 0 /* is-state_0 doCached(SignatureBuilder, SignatureCachedState, NFIBackendSignatureBuilderLibrary) || doGeneric(SignatureBuilder, NFIBackendSignatureBuilderLibrary) */) {
                    if ((state_0 & 0b1000) != 0 /* is-state_0 doCached(SignatureBuilder, SignatureCachedState, NFIBackendSignatureBuilderLibrary) */) {
                        BuildCachedData s1_ = this.build_cached_cache;
                        while (s1_ != null) {
                            if ((arg0Value.argsState == s1_.cachedState_.args) && (arg0Value.retTypeState == s1_.cachedState_.retType)) {
                                NFIBackendSignatureBuilderLibrary backendLibrary__ = this.receiverBackendBuilderNFIBackendSignatureBuilderLibrary_;
                                return Build.doCached(arg0Value, s1_.cachedState_, backendLibrary__);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is-state_0 doGeneric(SignatureBuilder, NFIBackendSignatureBuilderLibrary) */) {
                        {
                            NFIBackendSignatureBuilderLibrary build_generic_backendLibrary__ = this.receiverBackendBuilderNFIBackendSignatureBuilderLibrary_;
                            return Build.doGeneric(arg0Value, build_generic_backendLibrary__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return buildAndSpecialize(arg0Value);
            }

            private NFISignature buildAndSpecialize(SignatureBuilder arg0Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = state_0_;
                int exclude = exclude_;
                try {
                    {
                        NFIBackendSignatureBuilderLibrary backendLibrary__ = null;
                        if (((exclude & 0b10)) == 0 /* is-not-exclude doCached(SignatureBuilder, SignatureCachedState, NFIBackendSignatureBuilderLibrary) */) {
                            int count1_ = 0;
                            BuildCachedData s1_ = this.build_cached_cache;
                            if ((state_0 & 0b1000) != 0 /* is-state_0 doCached(SignatureBuilder, SignatureCachedState, NFIBackendSignatureBuilderLibrary) */) {
                                while (s1_ != null) {
                                    if ((arg0Value.argsState == s1_.cachedState_.args) && (arg0Value.retTypeState == s1_.cachedState_.retType)) {
                                        backendLibrary__ = this.receiverBackendBuilderNFIBackendSignatureBuilderLibrary_;
                                        break;
                                    }
                                    s1_ = s1_.next_;
                                    count1_++;
                                }
                            }
                            if (s1_ == null) {
                                {
                                    SignatureCachedState cachedState__ = (SignatureCachedState.create(arg0Value));
                                    if ((arg0Value.argsState == cachedState__.args) && (arg0Value.retTypeState == cachedState__.retType) && count1_ < (3)) {
                                        s1_ = super.insert(new BuildCachedData(build_cached_cache));
                                        s1_.cachedState_ = cachedState__;
                                        backendLibrary__ = this.receiverBackendBuilderNFIBackendSignatureBuilderLibrary_;
                                        this.build_cached_cache = s1_;
                                        this.state_0_ = state_0 = state_0 | 0b1000 /* add-state_0 doCached(SignatureBuilder, SignatureCachedState, NFIBackendSignatureBuilderLibrary) */;
                                    }
                                }
                            }
                            if (s1_ != null) {
                                lock.unlock();
                                hasLock = false;
                                return Build.doCached(arg0Value, s1_.cachedState_, backendLibrary__);
                            }
                        }
                    }
                    {
                        NFIBackendSignatureBuilderLibrary build_generic_backendLibrary__ = null;
                        build_generic_backendLibrary__ = this.receiverBackendBuilderNFIBackendSignatureBuilderLibrary_;
                        this.exclude_ = exclude = exclude | 0b10 /* add-exclude doCached(SignatureBuilder, SignatureCachedState, NFIBackendSignatureBuilderLibrary) */;
                        this.build_cached_cache = null;
                        state_0 = state_0 & 0xfffffff7 /* remove-state_0 doCached(SignatureBuilder, SignatureCachedState, NFIBackendSignatureBuilderLibrary) */;
                        this.state_0_ = state_0 = state_0 | 0b10000 /* add-state_0 doGeneric(SignatureBuilder, NFIBackendSignatureBuilderLibrary) */;
                        lock.unlock();
                        hasLock = false;
                        return Build.doGeneric(arg0Value, build_generic_backendLibrary__);
                    }
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void makeVarargs(Object arg0Value_) {
                assert arg0Value_ instanceof SignatureBuilder : "Invalid library usage. Library does not accept given receiver.";
                assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                SignatureBuilder arg0Value = ((SignatureBuilder) arg0Value_);
                {
                    NFIBackendSignatureBuilderLibrary makeVarargsNode__backendLibrary__ = this.receiverBackendBuilderNFIBackendSignatureBuilderLibrary_;
                    arg0Value.makeVarargs(makeVarargsNode__backendLibrary__);
                    return;
                }
            }

            @GeneratedBy(SignatureBuilder.class)
            private static final class AddArgumentCachedData extends Node {

                @Child AddArgumentCachedData next_;
                @CompilationFinal ArgsCachedState prevArgsState_;
                @CompilationFinal TypeCachedState argState_;
                @CompilationFinal ArgsCachedState newArgsState_;

                AddArgumentCachedData(AddArgumentCachedData next_) {
                    this.next_ = next_;
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

            }
            @GeneratedBy(SignatureBuilder.class)
            private static final class BuildCachedData extends Node {

                @Child BuildCachedData next_;
                @CompilationFinal SignatureCachedState cachedState_;

                BuildCachedData(BuildCachedData next_) {
                    this.next_ = next_;
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

            }
        }
        @GeneratedBy(SignatureBuilder.class)
        private static final class Uncached extends NFIBackendSignatureBuilderLibrary {

            protected Uncached() {
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof SignatureBuilder) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof SignatureBuilder;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public void addArgument(Object arg0Value_, Object arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                SignatureBuilder arg0Value = ((SignatureBuilder) arg0Value_);
                if (arg1Value instanceof NFIType) {
                    NFIType arg1Value_ = (NFIType) arg1Value;
                    AddArgument.doGeneric(arg0Value, arg1Value_, N_F_I_BACKEND_SIGNATURE_BUILDER_LIBRARY_.getUncached((arg0Value.backendBuilder)));
                    return;
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            @TruffleBoundary
            @Override
            public void setReturnType(Object arg0Value_, Object arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                SignatureBuilder arg0Value = ((SignatureBuilder) arg0Value_);
                if (arg1Value instanceof NFIType) {
                    NFIType arg1Value_ = (NFIType) arg1Value;
                    SetReturnType.doSet(arg0Value, arg1Value_, N_F_I_BACKEND_SIGNATURE_BUILDER_LIBRARY_.getUncached((arg0Value.backendBuilder)));
                    return;
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            @TruffleBoundary
            @Override
            public Object build(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                SignatureBuilder arg0Value = ((SignatureBuilder) arg0Value_);
                return Build.doGeneric(arg0Value, N_F_I_BACKEND_SIGNATURE_BUILDER_LIBRARY_.getUncached((arg0Value.backendBuilder)));
            }

            @TruffleBoundary
            @Override
            public void makeVarargs(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                SignatureBuilder arg0Value = ((SignatureBuilder) arg0Value_);
                arg0Value.makeVarargs(N_F_I_BACKEND_SIGNATURE_BUILDER_LIBRARY_.getUncached((arg0Value.backendBuilder)));
                return;
            }

        }
    }
}
