// CheckStyle: start generated
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.library.Message;
import com.oracle.truffle.api.library.ReflectionLibrary;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.utilities.FinalBitSet;
import com.oracle.truffle.nfi.NFIType.TypeCachedState;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.concurrent.locks.Lock;

@GeneratedBy(NFITypeLibrary.class)
final class NFITypeLibraryGen extends LibraryFactory<NFITypeLibrary> {

    private static final Class<NFITypeLibrary> LIBRARY_CLASS = NFITypeLibraryGen.lazyLibraryClass();
    private static final Message CONVERT_TO_NATIVE = new MessageImpl("convertToNative", 0, Object.class, TypeCachedState.class, NFIType.class, Object.class);
    private static final Message CONVERT_FROM_NATIVE = new MessageImpl("convertFromNative", 1, Object.class, TypeCachedState.class, NFIType.class, Object.class);
    private static final NFITypeLibraryGen INSTANCE = new NFITypeLibraryGen();
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    static  {
        LibraryExport.register(NFITypeLibraryGen.LIBRARY_CLASS, new Default());
        LibraryFactory.register(NFITypeLibraryGen.LIBRARY_CLASS, INSTANCE);
    }

    private NFITypeLibraryGen() {
        super(NFITypeLibraryGen.LIBRARY_CLASS, Collections.unmodifiableList(Arrays.asList(NFITypeLibraryGen.CONVERT_TO_NATIVE, NFITypeLibraryGen.CONVERT_FROM_NATIVE)));
    }

    @Override
    protected Class<?> getDefaultClass(Object receiver) {
        return NFITypeLibrary.class;
    }

    @Override
    protected NFITypeLibrary createProxy(ReflectionLibrary library) {
        return new Proxy(library);
    }

    @Override
    protected FinalBitSet createMessageBitSet(Message... messages) {
        BitSet bitSet = new BitSet(2);
        for (Message message : messages) {
            bitSet.set(((MessageImpl) message).index);
        }
        return FinalBitSet.valueOf(bitSet);
    }

    @Override
    protected NFITypeLibrary createDelegate(NFITypeLibrary delegateLibrary) {
        return new Delegate(delegateLibrary);
    }

    @Override
    protected Object genericDispatch(Library originalLib, Object receiver, Message message, Object[] args, int offset) throws Exception {
        NFITypeLibrary lib = (NFITypeLibrary) originalLib;
        MessageImpl messageImpl = (MessageImpl) message;
        if (messageImpl.getParameterCount() - 1 != args.length - offset) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Invalid number of arguments.");
        }
        switch (messageImpl.index) {
            case 0 :
                return lib.convertToNative((TypeCachedState) receiver, (NFIType) args[offset], args[offset + 1]);
            case 1 :
                return lib.convertFromNative((TypeCachedState) receiver, (NFIType) args[offset], args[offset + 1]);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new AbstractMethodError(message.toString());
    }

    @Override
    protected NFITypeLibrary createDispatchImpl(int limit) {
        return new CachedDispatchFirst(null, null, limit);
    }

    @Override
    protected NFITypeLibrary createUncachedDispatch() {
        return new UncachedDispatch();
    }

    @SuppressWarnings("unchecked")
    private static Class<NFITypeLibrary> lazyLibraryClass() {
        try {
            return (Class<NFITypeLibrary>) Class.forName("com.oracle.truffle.nfi.NFITypeLibrary", false, NFITypeLibraryGen.class.getClassLoader());
        } catch (ClassNotFoundException e) {
            throw CompilerDirectives.shouldNotReachHere(e);
        }
    }

    @GeneratedBy(NFITypeLibrary.class)
    private static final class Default extends LibraryExport<NFITypeLibrary> {

        private Default() {
            super(NFITypeLibrary.class, TypeCachedState.class, false);
        }

        @Override
        protected NFITypeLibrary createUncached(Object receiver) {
            assert receiver instanceof TypeCachedState;
            NFITypeLibrary uncached = new Uncached(receiver);
            return uncached;
        }

        @Override
        protected NFITypeLibrary createCached(Object receiver) {
            assert receiver instanceof TypeCachedState;
            return new Cached(receiver);
        }

        @GeneratedBy(NFITypeLibrary.class)
        private static final class Cached extends NFITypeLibrary {

            private final Class<? extends TypeCachedState> receiverClass_;

            protected Cached(Object receiver) {
                TypeCachedState castReceiver = ((TypeCachedState) receiver) ;
                this.receiverClass_ = castReceiver.getClass();
            }

            @Override
            public boolean accepts(Object receiver) {
                assert receiver.getClass() != this.receiverClass_ || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver.getClass() == this.receiverClass_;
            }

            @TruffleBoundary
            @Override
            public Object convertToNative(TypeCachedState receiver, NFIType type, Object value) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @TruffleBoundary
            @Override
            public Object convertFromNative(TypeCachedState receiver, NFIType type, Object value) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

        }
        @GeneratedBy(NFITypeLibrary.class)
        private static final class Uncached extends NFITypeLibrary {

            private final Class<? extends TypeCachedState> receiverClass_;

            protected Uncached(Object receiver) {
                this.receiverClass_ = ((TypeCachedState) receiver).getClass();
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                assert receiver.getClass() != this.receiverClass_ || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver.getClass() == this.receiverClass_;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public Object convertToNative(TypeCachedState receiver, NFIType type, Object value) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @TruffleBoundary
            @Override
            public Object convertFromNative(TypeCachedState receiver, NFIType type, Object value) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

        }
    }
    @GeneratedBy(NFITypeLibrary.class)
    private static class MessageImpl extends Message {

        final int index;

        MessageImpl(String name, int index, Class<?> returnType, Class<?>... parameters) {
            super(NFITypeLibraryGen.LIBRARY_CLASS, name, returnType, parameters);
            this.index = index;
        }

    }
    @GeneratedBy(NFITypeLibrary.class)
    private static final class Proxy extends NFITypeLibrary {

        @Child private ReflectionLibrary lib;

        Proxy(ReflectionLibrary lib) {
            this.lib = lib;
        }

        @Override
        public Object convertToNative(TypeCachedState receiver_, NFIType type, Object value) {
            try {
                return lib.send(receiver_, NFITypeLibraryGen.CONVERT_TO_NATIVE, type, value);
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public Object convertFromNative(TypeCachedState receiver_, NFIType type, Object value) {
            try {
                return lib.send(receiver_, NFITypeLibraryGen.CONVERT_FROM_NATIVE, type, value);
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public boolean accepts(Object receiver_) {
            return lib.accepts(receiver_);
        }

    }
    @GeneratedBy(NFITypeLibrary.class)
    private static final class Delegate extends NFITypeLibrary {

        @Child private NFITypeLibrary delegateLibrary;

        Delegate(NFITypeLibrary delegateLibrary) {
            this.delegateLibrary = delegateLibrary;
        }

        @Override
        public Object convertToNative(TypeCachedState receiver_, NFIType type, Object value) {
            if (LibraryFactory.isDelegated(delegateLibrary, 0)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).convertToNative((TypeCachedState) delegate, type, value);
            } else {
                return this.delegateLibrary.convertToNative(receiver_, type, value);
            }
        }

        @Override
        public Object convertFromNative(TypeCachedState receiver_, NFIType type, Object value) {
            if (LibraryFactory.isDelegated(delegateLibrary, 1)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).convertFromNative((TypeCachedState) delegate, type, value);
            } else {
                return this.delegateLibrary.convertFromNative(receiver_, type, value);
            }
        }

        @Override
        public boolean accepts(Object receiver_) {
            return delegateLibrary.accepts(receiver_);
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        @Override
        public boolean isAdoptable() {
            return this.delegateLibrary.isAdoptable();
        }

    }
    @GeneratedBy(NFITypeLibrary.class)
    private static final class CachedToUncachedDispatch extends NFITypeLibrary {

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @TruffleBoundary
        @Override
        public Object convertToNative(TypeCachedState receiver_, NFIType type, Object value) {
            assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).convertToNative(receiver_, type, value);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public Object convertFromNative(TypeCachedState receiver_, NFIType type, Object value) {
            assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).convertFromNative(receiver_, type, value);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @Override
        public boolean accepts(Object receiver_) {
            return true;
        }

    }
    @GeneratedBy(NFITypeLibrary.class)
    private static final class UncachedDispatch extends NFITypeLibrary {

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @TruffleBoundary
        @Override
        public Object convertToNative(TypeCachedState receiver_, NFIType type, Object value) {
            return INSTANCE.getUncached(receiver_).convertToNative(receiver_, type, value);
        }

        @TruffleBoundary
        @Override
        public Object convertFromNative(TypeCachedState receiver_, NFIType type, Object value) {
            return INSTANCE.getUncached(receiver_).convertFromNative(receiver_, type, value);
        }

        @TruffleBoundary
        @Override
        public boolean accepts(Object receiver_) {
            return true;
        }

        @Override
        public boolean isAdoptable() {
            return false;
        }

    }
    @GeneratedBy(NFITypeLibrary.class)
    private static final class CachedDispatchNext extends CachedDispatch {

        CachedDispatchNext(NFITypeLibrary library, CachedDispatch next) {
            super(library, next);
        }

        @Override
        int getLimit() {
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
    @GeneratedBy(NFITypeLibrary.class)
    private static final class CachedDispatchFirst extends CachedDispatch {

        private final int limit_;

        CachedDispatchFirst(NFITypeLibrary library, CachedDispatch next, int limit_) {
            super(library, next);
            this.limit_ = limit_;
        }

        @Override
        int getLimit() {
            return this.limit_;
        }

        @Override
        public NodeCost getCost() {
            if (this.library instanceof CachedToUncachedDispatch) {
                return NodeCost.MEGAMORPHIC;
            }
            CachedDispatch current = this;
            int count = 0;
            do {
                if (current.library != null) {
                    count++;
                }
                current = current.next;
            } while (current != null);
            return NodeCost.fromCount(count);
        }

    }
    @GeneratedBy(NFITypeLibrary.class)
    private abstract static class CachedDispatch extends NFITypeLibrary {

        @Child NFITypeLibrary library;
        @Child CachedDispatch next;

        CachedDispatch(NFITypeLibrary library, CachedDispatch next) {
            this.library = library;
            this.next = next;
        }

        abstract int getLimit();

        @ExplodeLoop
        @Override
        public Object convertToNative(TypeCachedState receiver_, NFIType type, Object value) {
            do {
                CachedDispatch current = this;
                do {
                    NFITypeLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.convertToNative(receiver_, type, value);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public Object convertFromNative(TypeCachedState receiver_, NFIType type, Object value) {
            do {
                CachedDispatch current = this;
                do {
                    NFITypeLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.convertFromNative(receiver_, type, value);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @Override
        public boolean accepts(Object receiver_) {
            return true;
        }

        private void specialize(TypeCachedState receiver_) {
            CachedDispatch current = this;
            NFITypeLibrary thisLibrary = current.library;
            if (thisLibrary == null) {
                this.library = insert(INSTANCE.create(receiver_));
            } else {
                Lock lock = getLock();
                lock.lock();
                try {
                    int count = 0;
                    do {
                        NFITypeLibrary currentLibrary = current.library;
                        if (currentLibrary != null && currentLibrary.accepts(receiver_)) {
                            return;
                        }
                        count++;
                        current = current.next;
                    } while (current != null);
                    if (count >= getLimit()) {
                        this.library = insert(new CachedToUncachedDispatch());
                        this.next = null;
                    } else {
                        this.next = insert(new CachedDispatchNext(INSTANCE.create(receiver_), next));
                    }
                } finally {
                    lock.unlock();
                }
            }
        }

    }
}
