// CheckStyle: start generated
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.nfi.NFIRootNode.LoadLibraryNode;
import com.oracle.truffle.nfi.NFIRootNode.LookupAndBindNode;
import com.oracle.truffle.nfi.spi.NFIBackend;
import com.oracle.truffle.nfi.spi.types.NativeLibraryDescriptor;
import java.util.concurrent.locks.Lock;

@GeneratedBy(NFIRootNode.class)
@SuppressWarnings("unused")
final class NFIRootNodeFactory {

    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    @GeneratedBy(LookupAndBindNode.class)
    static final class LookupAndBindNodeGen extends LookupAndBindNode {

        @CompilationFinal private volatile int state_0_;
        @CompilationFinal private volatile int exclude_;
        @Child private InteropLibrary symInterop;
        @Child private InteropLibrary lookupAndBind0_libInterop_;

        private LookupAndBindNodeGen(String name, String signature) {
            super(name, signature);
        }

        @Override
        Object execute(Object arg0Value) {
            int state_0 = state_0_;
            if (state_0 != 0 /* is-state_0 doLookupAndBind(Object, InteropLibrary, InteropLibrary) || doLookupAndBind(Object, InteropLibrary, InteropLibrary) */) {
                if ((state_0 & 0b1) != 0 /* is-state_0 doLookupAndBind(Object, InteropLibrary, InteropLibrary) */) {
                    if ((this.lookupAndBind0_libInterop_.accepts(arg0Value))) {
                        return doLookupAndBind(arg0Value, this.lookupAndBind0_libInterop_, this.symInterop);
                    }
                }
                if ((state_0 & 0b10) != 0 /* is-state_0 doLookupAndBind(Object, InteropLibrary, InteropLibrary) */) {
                    return this.lookupAndBind1Boundary(state_0, arg0Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value);
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private Object lookupAndBind1Boundary(int state_0, Object arg0Value) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    InteropLibrary lookupAndBind1_libInterop__ = (INTEROP_LIBRARY_.getUncached(arg0Value));
                    return doLookupAndBind(arg0Value, lookupAndBind1_libInterop__, this.symInterop);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        private Object executeAndSpecialize(Object arg0Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = state_0_;
            int exclude = exclude_;
            try {
                if ((exclude) == 0 /* is-not-exclude doLookupAndBind(Object, InteropLibrary, InteropLibrary) */) {
                    boolean LookupAndBind0_duplicateFound_ = false;
                    if ((state_0 & 0b1) != 0 /* is-state_0 doLookupAndBind(Object, InteropLibrary, InteropLibrary) */) {
                        if ((this.lookupAndBind0_libInterop_.accepts(arg0Value))) {
                            LookupAndBind0_duplicateFound_ = true;
                        }
                    }
                    if (!LookupAndBind0_duplicateFound_) {
                        // assert (this.lookupAndBind0_libInterop_.accepts(arg0Value));
                        if (((state_0 & 0b1)) == 0 /* is-not-state_0 doLookupAndBind(Object, InteropLibrary, InteropLibrary) */) {
                            this.lookupAndBind0_libInterop_ = super.insert((INTEROP_LIBRARY_.create(arg0Value)));
                            if (this.symInterop == null) {
                                this.symInterop = super.insert((INTEROP_LIBRARY_.createDispatched(1)));
                            }
                            this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 doLookupAndBind(Object, InteropLibrary, InteropLibrary) */;
                            LookupAndBind0_duplicateFound_ = true;
                        }
                    }
                    if (LookupAndBind0_duplicateFound_) {
                        lock.unlock();
                        hasLock = false;
                        return doLookupAndBind(arg0Value, this.lookupAndBind0_libInterop_, this.symInterop);
                    }
                }
                {
                    InteropLibrary lookupAndBind1_libInterop__ = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            lookupAndBind1_libInterop__ = (INTEROP_LIBRARY_.getUncached(arg0Value));
                            if (this.symInterop == null) {
                                this.symInterop = super.insert((INTEROP_LIBRARY_.createDispatched(1)));
                            }
                            this.exclude_ = exclude = exclude | 0b1 /* add-exclude doLookupAndBind(Object, InteropLibrary, InteropLibrary) */;
                            state_0 = state_0 & 0xfffffffe /* remove-state_0 doLookupAndBind(Object, InteropLibrary, InteropLibrary) */;
                            this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 doLookupAndBind(Object, InteropLibrary, InteropLibrary) */;
                            lock.unlock();
                            hasLock = false;
                            return doLookupAndBind(arg0Value, lookupAndBind1_libInterop__, this.symInterop);
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LookupAndBindNode create(String name, String signature) {
            return new LookupAndBindNodeGen(name, signature);
        }

    }
    @GeneratedBy(LoadLibraryNode.class)
    static final class LoadLibraryNodeGen extends LoadLibraryNode {

        @CompilationFinal private volatile int state_0_;
        @CompilationFinal private volatile int exclude_;
        @Child private CachedData cached_cache;
        @Child private IndirectCallNode generic_callNode_;

        private LoadLibraryNodeGen(NativeLibraryDescriptor descriptor) {
            super(descriptor);
        }

        @ExplodeLoop
        @Override
        protected Object execute(NFIBackend arg0Value) {
            int state_0 = state_0_;
            if (state_0 != 0 /* is-state_0 doCached(NFIBackend, NFIBackend, DirectCallNode) || doGeneric(NFIBackend, IndirectCallNode) */) {
                if ((state_0 & 0b1) != 0 /* is-state_0 doCached(NFIBackend, NFIBackend, DirectCallNode) */) {
                    CachedData s1_ = this.cached_cache;
                    while (s1_ != null) {
                        if ((arg0Value == s1_.cachedBackend_)) {
                            return doCached(arg0Value, s1_.cachedBackend_, s1_.callNode_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state_0 & 0b10) != 0 /* is-state_0 doGeneric(NFIBackend, IndirectCallNode) */) {
                    return doGeneric(arg0Value, this.generic_callNode_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value);
        }

        private Object executeAndSpecialize(NFIBackend arg0Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = state_0_;
            int exclude = exclude_;
            try {
                if ((exclude) == 0 /* is-not-exclude doCached(NFIBackend, NFIBackend, DirectCallNode) */) {
                    int count1_ = 0;
                    CachedData s1_ = this.cached_cache;
                    if ((state_0 & 0b1) != 0 /* is-state_0 doCached(NFIBackend, NFIBackend, DirectCallNode) */) {
                        while (s1_ != null) {
                            if ((arg0Value == s1_.cachedBackend_)) {
                                break;
                            }
                            s1_ = s1_.next_;
                            count1_++;
                        }
                    }
                    if (s1_ == null) {
                        // assert (arg0Value == s1_.cachedBackend_);
                        if (count1_ < (5)) {
                            s1_ = super.insert(new CachedData(cached_cache));
                            s1_.cachedBackend_ = (arg0Value);
                            s1_.callNode_ = s1_.insertAccessor((DirectCallNode.create(parseLibrary(s1_.cachedBackend_))));
                            this.cached_cache = s1_;
                            this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 doCached(NFIBackend, NFIBackend, DirectCallNode) */;
                        }
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return doCached(arg0Value, s1_.cachedBackend_, s1_.callNode_);
                    }
                }
                this.generic_callNode_ = super.insert((IndirectCallNode.create()));
                this.exclude_ = exclude = exclude | 0b1 /* add-exclude doCached(NFIBackend, NFIBackend, DirectCallNode) */;
                this.cached_cache = null;
                state_0 = state_0 & 0xfffffffe /* remove-state_0 doCached(NFIBackend, NFIBackend, DirectCallNode) */;
                this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 doGeneric(NFIBackend, IndirectCallNode) */;
                lock.unlock();
                hasLock = false;
                return doGeneric(arg0Value, this.generic_callNode_);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    CachedData s1_ = this.cached_cache;
                    if ((s1_ == null || s1_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LoadLibraryNode create(NativeLibraryDescriptor descriptor) {
            return new LoadLibraryNodeGen(descriptor);
        }

        @GeneratedBy(LoadLibraryNode.class)
        private static final class CachedData extends Node {

            @Child CachedData next_;
            @CompilationFinal NFIBackend cachedBackend_;
            @Child DirectCallNode callNode_;

            CachedData(CachedData next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
    }
}
