// CheckStyle: start generated
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.nfi.ConvertTypeNode.ConvertFromNativeNode;
import com.oracle.truffle.nfi.ConvertTypeNode.ConvertToNativeNode;
import com.oracle.truffle.nfi.ConvertTypeNodeFactory.ConvertFromNativeNodeGen;
import com.oracle.truffle.nfi.ConvertTypeNodeFactory.ConvertToNativeNodeGen;
import com.oracle.truffle.nfi.NFIClosure.Execute;
import com.oracle.truffle.nfi.NFISignature.SignatureCachedState;
import java.util.concurrent.locks.Lock;

@GeneratedBy(NFIClosure.class)
final class NFIClosureGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    static  {
        LibraryExport.register(NFIClosure.class, new InteropLibraryExports());
    }

    private NFIClosureGen() {
    }

    @GeneratedBy(NFIClosure.class)
    private static final class InteropLibraryExports extends LibraryExport<InteropLibrary> {

        private InteropLibraryExports() {
            super(InteropLibrary.class, NFIClosure.class, false);
        }

        @Override
        protected InteropLibrary createUncached(Object receiver) {
            assert receiver instanceof NFIClosure;
            InteropLibrary uncached = new Uncached();
            return uncached;
        }

        @Override
        protected InteropLibrary createCached(Object receiver) {
            assert receiver instanceof NFIClosure;
            return new Cached(receiver);
        }

        @GeneratedBy(NFIClosure.class)
        private static final class Cached extends InteropLibrary {

            @Child private InteropLibrary receiverExecutableInteropLibrary_;
            @CompilationFinal private volatile int state_0_;
            @CompilationFinal private volatile int exclude_;
            @Child private ExecuteOptimizedDirectData execute_optimizedDirect_cache;
            @Child private IndirectCallNode execute_optimizedIndirect_call_;
            @CompilationFinal private BranchProfile execute_slowPath_exception_;
            @Child private ConvertFromNativeNode execute_slowPath_convertArg_;
            @Child private ConvertToNativeNode execute_slowPath_convertRet_;

            protected Cached(Object receiver) {
                NFIClosure castReceiver = ((NFIClosure) receiver) ;
                this.receiverExecutableInteropLibrary_ = super.insert(INTEROP_LIBRARY_.create((castReceiver.executable)));
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof NFIClosure) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                if (!(receiver instanceof NFIClosure)) {
                    return false;
                } else if (!this.receiverExecutableInteropLibrary_.accepts((((NFIClosure) receiver).executable))) {
                    return false;
                } else {
                    return true;
                }
            }

            @ExplodeLoop
            @Override
            public Object execute(Object arg0Value_, Object... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert arg0Value_ instanceof NFIClosure : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                NFIClosure arg0Value = ((NFIClosure) arg0Value_);
                int state_0 = state_0_;
                if (state_0 != 0 /* is-state_0 doOptimizedDirect(NFIClosure, Object[], SignatureCachedState, CallSignatureNode) || doOptimizedIndirect(NFIClosure, Object[], IndirectCallNode) || doSlowPath(NFIClosure, Object[], BranchProfile, ConvertFromNativeNode, ConvertToNativeNode, InteropLibrary) */) {
                    if ((state_0 & 0b1) != 0 /* is-state_0 doOptimizedDirect(NFIClosure, Object[], SignatureCachedState, CallSignatureNode) */ && (arg0Value.signature.cachedState != null)) {
                        ExecuteOptimizedDirectData s1_ = this.execute_optimizedDirect_cache;
                        while (s1_ != null) {
                            if ((arg0Value.signature.cachedState == s1_.cachedState_)) {
                                return Execute.doOptimizedDirect(arg0Value, arg1Value, s1_.cachedState_, s1_.call_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is-state_0 doOptimizedIndirect(NFIClosure, Object[], IndirectCallNode) */) {
                        if ((arg0Value.signature.cachedState != null)) {
                            return Execute.doOptimizedIndirect(arg0Value, arg1Value, this.execute_optimizedIndirect_call_);
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is-state_0 doSlowPath(NFIClosure, Object[], BranchProfile, ConvertFromNativeNode, ConvertToNativeNode, InteropLibrary) */) {
                        if ((arg0Value.signature.cachedState == null)) {
                            InteropLibrary execute_slowPath_interop__ = this.receiverExecutableInteropLibrary_;
                            return Execute.doSlowPath(arg0Value, arg1Value, this.execute_slowPath_exception_, this.execute_slowPath_convertArg_, this.execute_slowPath_convertRet_, execute_slowPath_interop__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(NFIClosure arg0Value, Object[] arg1Value) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = state_0_;
                int exclude = exclude_;
                try {
                    if ((exclude) == 0 /* is-not-exclude doOptimizedDirect(NFIClosure, Object[], SignatureCachedState, CallSignatureNode) */ && (arg0Value.signature.cachedState != null)) {
                        int count1_ = 0;
                        ExecuteOptimizedDirectData s1_ = this.execute_optimizedDirect_cache;
                        if ((state_0 & 0b1) != 0 /* is-state_0 doOptimizedDirect(NFIClosure, Object[], SignatureCachedState, CallSignatureNode) */) {
                            while (s1_ != null) {
                                if ((arg0Value.signature.cachedState == s1_.cachedState_)) {
                                    break;
                                }
                                s1_ = s1_.next_;
                                count1_++;
                            }
                        }
                        if (s1_ == null) {
                            // assert (arg0Value.signature.cachedState == s1_.cachedState_);
                            if (count1_ < (3)) {
                                s1_ = super.insert(new ExecuteOptimizedDirectData(execute_optimizedDirect_cache));
                                s1_.cachedState_ = (arg0Value.signature.cachedState);
                                s1_.call_ = s1_.insertAccessor((s1_.cachedState_.createOptimizedClosureCall()));
                                this.execute_optimizedDirect_cache = s1_;
                                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 doOptimizedDirect(NFIClosure, Object[], SignatureCachedState, CallSignatureNode) */;
                            }
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            return Execute.doOptimizedDirect(arg0Value, arg1Value, s1_.cachedState_, s1_.call_);
                        }
                    }
                    if ((arg0Value.signature.cachedState != null)) {
                        this.execute_optimizedIndirect_call_ = super.insert((IndirectCallNode.create()));
                        this.exclude_ = exclude = exclude | 0b1 /* add-exclude doOptimizedDirect(NFIClosure, Object[], SignatureCachedState, CallSignatureNode) */;
                        this.execute_optimizedDirect_cache = null;
                        state_0 = state_0 & 0xfffffffe /* remove-state_0 doOptimizedDirect(NFIClosure, Object[], SignatureCachedState, CallSignatureNode) */;
                        this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 doOptimizedIndirect(NFIClosure, Object[], IndirectCallNode) */;
                        lock.unlock();
                        hasLock = false;
                        return Execute.doOptimizedIndirect(arg0Value, arg1Value, this.execute_optimizedIndirect_call_);
                    }
                    {
                        InteropLibrary execute_slowPath_interop__ = null;
                        if ((arg0Value.signature.cachedState == null)) {
                            this.execute_slowPath_exception_ = (BranchProfile.create());
                            this.execute_slowPath_convertArg_ = super.insert((ConvertFromNativeNodeGen.create()));
                            this.execute_slowPath_convertRet_ = super.insert((ConvertToNativeNodeGen.create()));
                            execute_slowPath_interop__ = this.receiverExecutableInteropLibrary_;
                            this.state_0_ = state_0 = state_0 | 0b100 /* add-state_0 doSlowPath(NFIClosure, Object[], BranchProfile, ConvertFromNativeNode, ConvertToNativeNode, InteropLibrary) */;
                            lock.unlock();
                            hasLock = false;
                            return Execute.doSlowPath(arg0Value, arg1Value, this.execute_slowPath_exception_, this.execute_slowPath_convertArg_, this.execute_slowPath_convertRet_, execute_slowPath_interop__);
                        }
                    }
                    throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                int state_0 = state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                        ExecuteOptimizedDirectData s1_ = this.execute_optimizedDirect_cache;
                        if ((s1_ == null || s1_.next_ == null)) {
                            return NodeCost.MONOMORPHIC;
                        }
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

            @Override
            public boolean isExecutable(Object arg0Value_) {
                assert arg0Value_ instanceof NFIClosure : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                NFIClosure arg0Value = ((NFIClosure) arg0Value_);
                {
                    InteropLibrary isExecutableNode__interop__ = this.receiverExecutableInteropLibrary_;
                    return arg0Value.isExecutable(isExecutableNode__interop__);
                }
            }

            @GeneratedBy(NFIClosure.class)
            private static final class ExecuteOptimizedDirectData extends Node {

                @Child ExecuteOptimizedDirectData next_;
                @CompilationFinal SignatureCachedState cachedState_;
                @Child CallSignatureNode call_;

                ExecuteOptimizedDirectData(ExecuteOptimizedDirectData next_) {
                    this.next_ = next_;
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                <T extends Node> T insertAccessor(T node) {
                    return super.insert(node);
                }

            }
        }
        @GeneratedBy(NFIClosure.class)
        private static final class Uncached extends InteropLibrary {

            protected Uncached() {
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof NFIClosure) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof NFIClosure;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public Object execute(Object arg0Value_, Object... arg1Value) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                NFIClosure arg0Value = ((NFIClosure) arg0Value_);
                if ((arg0Value.signature.cachedState != null)) {
                    return Execute.doOptimizedIndirect(arg0Value, arg1Value, (IndirectCallNode.getUncached()));
                }
                if ((arg0Value.signature.cachedState == null)) {
                    return Execute.doSlowPath(arg0Value, arg1Value, (BranchProfile.getUncached()), (ConvertFromNativeNodeGen.getUncached()), (ConvertToNativeNodeGen.getUncached()), INTEROP_LIBRARY_.getUncached((arg0Value.executable)));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            @TruffleBoundary
            @Override
            public boolean isExecutable(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                NFIClosure arg0Value = ((NFIClosure) arg0Value_);
                return arg0Value.isExecutable(INTEROP_LIBRARY_.getUncached((arg0Value.executable)));
            }

        }
    }
}
