/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.spi.types;

import com.oracle.truffle.nfi.spi.types.NativeTypeMirror;
import java.util.Collections;
import java.util.List;

public final class NativeSignature {
    static final int NOT_VARARGS = -1;
    private final NativeTypeMirror retType;
    private final List<NativeTypeMirror> argTypes;
    private final int fixedArgCount;

    NativeSignature(NativeTypeMirror retType, int fixedArgCount, List<NativeTypeMirror> argTypes) {
        this.retType = retType;
        this.argTypes = argTypes;
        this.fixedArgCount = fixedArgCount;
    }

    public NativeTypeMirror getRetType() {
        return this.retType;
    }

    public List<NativeTypeMirror> getArgTypes() {
        return Collections.unmodifiableList(this.argTypes);
    }

    public boolean isVarargs() {
        return this.fixedArgCount != -1;
    }

    public int getFixedArgCount() {
        return this.isVarargs() ? this.fixedArgCount : this.argTypes.size();
    }
}

