/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.impl;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CachedLanguage;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.nfi.impl.LibFFISignature;
import com.oracle.truffle.nfi.impl.LibFFIType;
import com.oracle.truffle.nfi.impl.NFIContext;
import com.oracle.truffle.nfi.impl.NFILanguageImpl;
import com.oracle.truffle.nfi.impl.NativeArgumentBuffer;
import com.oracle.truffle.nfi.impl.NativeArgumentLibrary;
import com.oracle.truffle.nfi.impl.NativePointer;

@GenerateUncached
@ImportStatic(value={NFILanguageImpl.class})
abstract class FunctionExecuteNode
extends Node {
    static final int ARG_DISPATCH_LIMIT = 5;

    FunctionExecuteNode() {
    }

    public abstract Object execute(NativePointer var1, LibFFISignature var2, Object[] var3) throws ArityException, UnsupportedTypeException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Specialization(guards={"signature == cachedSignature"})
    protected Object cachedSignature(NativePointer receiver, LibFFISignature signature, Object[] args, @Cached(value="signature") LibFFISignature cachedSignature, @Cached(value="createCachedSignatureCall(cachedSignature)") DirectCallNode execute) {
        try {
            Object object = execute.call(new Object[]{receiver.asPointer(), args});
            return object;
        }
        finally {
            assert (FunctionExecuteNode.keepAlive(args));
        }
    }

    protected DirectCallNode createCachedSignatureCall(LibFFISignature signature) {
        RootCallTarget target = Truffle.getRuntime().createCallTarget((RootNode)new SignatureExecuteNode((TruffleLanguage.ContextReference<NFIContext>)this.lookupContextReference(NFILanguageImpl.class), signature));
        DirectCallNode callNode = DirectCallNode.create((CallTarget)target);
        callNode.forceInlining();
        return callNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExplodeLoop
    @Specialization(replaces={"cachedSignature"}, guards={"signature.getArgTypes().length == libs.length"})
    protected Object cachedArgCount(NativePointer receiver, LibFFISignature signature, Object[] args, @Cached(value="getGenericNativeArgumentLibraries(signature.getArgTypes().length)") NativeArgumentLibrary[] libs, @Cached(value="createSlowPathCall()") DirectCallNode slowPathCall, @Cached BranchProfile exception) throws ArityException, UnsupportedTypeException {
        LibFFIType[] argTypes = signature.getArgTypes();
        NativeArgumentBuffer.Array buffer = signature.prepareBuffer();
        int argIdx = 0;
        for (int i = 0; i < libs.length; ++i) {
            if (argIdx >= args.length) {
                FunctionExecuteNode.raiseArityException(argTypes, args.length);
            }
            Object arg = argTypes[i].injectedArgument ? null : args[argIdx++];
            libs[i].serialize(argTypes[i], buffer, arg);
        }
        if (argIdx != args.length) {
            exception.enter();
            throw ArityException.create((int)argIdx, (int)args.length);
        }
        try {
            Object object = slowPathCall.call(new Object[]{receiver, signature, buffer});
            return object;
        }
        finally {
            assert (FunctionExecuteNode.keepAlive(args));
        }
    }

    DirectCallNode createSlowPathCall() {
        NFILanguageImpl language = (NFILanguageImpl)this.lookupLanguageReference(NFILanguageImpl.class).get();
        return DirectCallNode.create((CallTarget)language.getSlowPathCall());
    }

    private static void raiseArityException(LibFFIType[] argTypes, int actualArgCount) throws ArityException {
        CompilerDirectives.transferToInterpreter();
        int expectedArgCount = 0;
        for (LibFFIType argType : argTypes) {
            if (argType.injectedArgument) continue;
            ++expectedArgCount;
        }
        throw ArityException.create((int)expectedArgCount, (int)actualArgCount);
    }

    protected static NativeArgumentLibrary[] getGenericNativeArgumentLibraries(int argCount) {
        NativeArgumentLibrary[] ret = new NativeArgumentLibrary[argCount];
        for (int i = 0; i < argCount; ++i) {
            ret[i] = (NativeArgumentLibrary)NativeArgumentLibrary.getFactory().createDispatched(5);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Specialization(replaces={"cachedArgCount"})
    static Object genericExecute(NativePointer receiver, LibFFISignature signature, Object[] args, @CachedLibrary(limit="ARG_DISPATCH_LIMIT") NativeArgumentLibrary nativeArguments, @CachedLanguage NFILanguageImpl language) throws ArityException, UnsupportedTypeException {
        LibFFIType[] argTypes = signature.getArgTypes();
        NativeArgumentBuffer.Array buffer = signature.prepareBuffer();
        int argIdx = 0;
        for (int i = 0; i < argTypes.length; ++i) {
            Object arg;
            if (argTypes[i].injectedArgument) {
                arg = null;
            } else {
                if (argIdx >= args.length) {
                    FunctionExecuteNode.raiseArityException(argTypes, args.length);
                }
                arg = args[argIdx++];
            }
            nativeArguments.serialize(argTypes[i], buffer, arg);
        }
        if (argIdx != args.length) {
            throw ArityException.create((int)argIdx, (int)args.length);
        }
        try {
            Object object = IndirectCallNode.getUncached().call(language.getSlowPathCall(), new Object[]{receiver, signature, buffer});
            return object;
        }
        finally {
            assert (FunctionExecuteNode.keepAlive(args));
        }
    }

    private static boolean keepAlive(Object args) {
        return true;
    }

    static class SlowPathExecuteNode
    extends RootNode {
        @CompilerDirectives.CompilationFinal
        TruffleLanguage.ContextReference<NFIContext> ctxRef;

        SlowPathExecuteNode(NFILanguageImpl language) {
            super((TruffleLanguage)language);
        }

        public Object execute(VirtualFrame frame) {
            if (this.ctxRef == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.ctxRef = this.lookupContextReference(NFILanguageImpl.class);
            }
            NativePointer receiver = (NativePointer)frame.getArguments()[0];
            LibFFISignature signature = (LibFFISignature)frame.getArguments()[1];
            NativeArgumentBuffer.Array buffer = (NativeArgumentBuffer.Array)frame.getArguments()[2];
            return SlowPathExecuteNode.slowPathExecute((NFIContext)this.ctxRef.get(), signature, receiver.asPointer(), buffer);
        }

        @CompilerDirectives.TruffleBoundary
        static Object slowPathExecute(NFIContext ctx, LibFFISignature signature, long functionPointer, NativeArgumentBuffer.Array buffer) {
            return signature.execute(ctx, functionPointer, buffer);
        }
    }

    static class SignatureExecuteNode
    extends RootNode {
        final LibFFISignature signature;
        @Node.Children
        NativeArgumentLibrary[] argLibs;
        final TruffleLanguage.ContextReference<NFIContext> ctxRef;

        SignatureExecuteNode(TruffleLanguage.ContextReference<NFIContext> ctxRef, LibFFISignature signature) {
            super((TruffleLanguage)((NFIContext)ctxRef.get()).language);
            this.signature = signature;
            this.ctxRef = ctxRef;
            LibFFIType[] argTypes = signature.getArgTypes();
            this.argLibs = new NativeArgumentLibrary[argTypes.length];
            for (int i = 0; i < argTypes.length; ++i) {
                this.argLibs[i] = (NativeArgumentLibrary)NativeArgumentLibrary.getFactory().create((Object)argTypes[i]);
            }
        }

        @ExplodeLoop
        public Object execute(VirtualFrame frame) {
            long address = (Long)frame.getArguments()[0];
            Object[] args = (Object[])frame.getArguments()[1];
            if (args.length != this.signature.getRealArgCount()) {
                throw SignatureExecuteNode.silenceException(RuntimeException.class, (Exception)((Object)ArityException.create((int)this.argLibs.length, (int)args.length)));
            }
            NativeArgumentBuffer.Array buffer = this.signature.prepareBuffer();
            try {
                LibFFIType[] types = this.signature.getArgTypes();
                assert (this.argLibs.length == types.length);
                int argIdx = 0;
                for (int i = 0; i < this.argLibs.length; ++i) {
                    Object arg = argIdx < args.length ? args[argIdx] : null;
                    this.argLibs[i].serialize(types[i], buffer, arg);
                    if (types[i].injectedArgument) continue;
                    ++argIdx;
                }
                assert (argIdx == args.length) : "SerializeArgumentNodes didn't consume all arguments";
            }
            catch (UnsupportedTypeException ex) {
                throw SignatureExecuteNode.silenceException(RuntimeException.class, (Exception)((Object)ex));
            }
            return this.signature.execute((NFIContext)this.ctxRef.get(), address, buffer);
        }

        static <E extends Exception> RuntimeException silenceException(Class<E> type, Exception ex) throws E {
            throw ex;
        }
    }
}

