// CheckStyle: start generated
package com.oracle.truffle.nfi.spi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.library.Message;
import com.oracle.truffle.api.library.ReflectionLibrary;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.utilities.FinalBitSet;
import com.oracle.truffle.nfi.spi.NativeSymbolLibrary;
import com.oracle.truffle.nfi.spi.types.NativeSignature;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.concurrent.locks.Lock;

@GeneratedBy(NativeSymbolLibrary.class)
final class NativeSymbolLibraryGen extends LibraryFactory<NativeSymbolLibrary> {

    private static final Class<NativeSymbolLibrary> LIBRARY_CLASS = NativeSymbolLibraryGen.lazyLibraryClass();
    private static final Message IS_BINDABLE = new MessageImpl("isBindable", 0, boolean.class, Object.class);
    private static final Message PREPARE_SIGNATURE = new MessageImpl("prepareSignature", 1, Object.class, Object.class, NativeSignature.class);
    private static final Message CALL = new MessageImpl("call", 2, Object.class, Object.class, Object.class, Object[].class);
    private static final NativeSymbolLibraryGen INSTANCE = new NativeSymbolLibraryGen();
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    static  {
        LibraryExport.register(NativeSymbolLibraryGen.LIBRARY_CLASS, new Default());
        LibraryFactory.register(NativeSymbolLibraryGen.LIBRARY_CLASS, INSTANCE);
    }

    private NativeSymbolLibraryGen() {
        super(NativeSymbolLibraryGen.LIBRARY_CLASS, Collections.unmodifiableList(Arrays.asList(NativeSymbolLibraryGen.IS_BINDABLE, NativeSymbolLibraryGen.PREPARE_SIGNATURE, NativeSymbolLibraryGen.CALL)));
    }

    @Override
    protected Class<?> getDefaultClass(Object receiver) {
        return NativeSymbolLibrary.class;
    }

    @Override
    protected NativeSymbolLibrary createProxy(ReflectionLibrary library) {
        return new Proxy(library);
    }

    @Override
    protected FinalBitSet createMessageBitSet(Message... messages) {
        BitSet bitSet = new BitSet(2);
        for (Message message : messages) {
            bitSet.set(((MessageImpl) message).index);
        }
        return FinalBitSet.valueOf(bitSet);
    }

    @Override
    protected NativeSymbolLibrary createDelegate(NativeSymbolLibrary delegateLibrary) {
        return new Delegate(delegateLibrary);
    }

    @Override
    protected Object genericDispatch(Library originalLib, Object receiver, Message message, Object[] args, int offset) throws Exception {
        NativeSymbolLibrary lib = (NativeSymbolLibrary) originalLib;
        MessageImpl messageImpl = (MessageImpl) message;
        if (messageImpl.getParameterCount() - 1 != args.length - offset) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Invalid number of arguments.");
        }
        switch (messageImpl.index) {
            case 0 :
                return lib.isBindable(receiver);
            case 1 :
                return lib.prepareSignature(receiver, (NativeSignature) args[offset]);
            case 2 :
                return lib.call(receiver, args[offset], (Object[]) args[offset + 1]);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new AbstractMethodError(message.toString());
    }

    @Override
    protected NativeSymbolLibrary createDispatchImpl(int limit) {
        return new CachedDispatchFirst(null, null, limit);
    }

    @Override
    protected NativeSymbolLibrary createUncachedDispatch() {
        return new UncachedDispatch();
    }

    @SuppressWarnings("unchecked")
    private static Class<NativeSymbolLibrary> lazyLibraryClass() {
        try {
            return (Class<NativeSymbolLibrary>) Class.forName("com.oracle.truffle.nfi.spi.NativeSymbolLibrary", false, NativeSymbolLibraryGen.class.getClassLoader());
        } catch (ClassNotFoundException e) {
            throw CompilerDirectives.shouldNotReachHere(e);
        }
    }

    @GeneratedBy(NativeSymbolLibrary.class)
    private static final class Default extends LibraryExport<NativeSymbolLibrary> {

        private Default() {
            super(NativeSymbolLibrary.class, Object.class, false);
        }

        @Override
        protected NativeSymbolLibrary createUncached(Object receiver) {
            NativeSymbolLibrary uncached = new Uncached(receiver);
            return uncached;
        }

        @Override
        protected NativeSymbolLibrary createCached(Object receiver) {
            return new Cached(receiver);
        }

        @GeneratedBy(NativeSymbolLibrary.class)
        private static final class Cached extends NativeSymbolLibrary {

            @Child private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            Cached(Object receiver) {
                this.dynamicDispatch_ = insert(DYNAMIC_DISPATCH_LIBRARY_.create(receiver));
                this.dynamicDispatchTarget_ = DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver).dispatch(receiver);
            }

            @Override
            public boolean accepts(Object receiver) {
                return dynamicDispatch_.accepts(receiver) && dynamicDispatch_.dispatch(receiver) == dynamicDispatchTarget_;
            }

            @Override
            public boolean isBindable(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.isBindable((dynamicDispatch_.cast(receiver)));
            }

            @Override
            public Object prepareSignature(Object receiver, NativeSignature signature) throws UnsupportedMessageException, UnsupportedTypeException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.prepareSignature((dynamicDispatch_.cast(receiver)), signature);
            }

            @Override
            public Object call(Object receiver, Object signature, Object... args) throws ArityException, UnsupportedMessageException, UnsupportedTypeException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.call((dynamicDispatch_.cast(receiver)), signature, args);
            }

        }
        @GeneratedBy(NativeSymbolLibrary.class)
        private static final class Uncached extends NativeSymbolLibrary {

            @Child private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            Uncached(Object receiver) {
                this.dynamicDispatch_ = DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
                this.dynamicDispatchTarget_ = dynamicDispatch_.dispatch(receiver);
            }

            @TruffleBoundary
            @Override
            public boolean accepts(Object receiver) {
                return dynamicDispatch_.accepts(receiver) && dynamicDispatch_.dispatch(receiver) == dynamicDispatchTarget_;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public boolean isBindable(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.isBindable(receiver);
            }

            @TruffleBoundary
            @Override
            public Object prepareSignature(Object receiver, NativeSignature signature) throws UnsupportedMessageException, UnsupportedTypeException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.prepareSignature(receiver, signature);
            }

            @TruffleBoundary
            @Override
            public Object call(Object receiver, Object signature, Object... args) throws ArityException, UnsupportedMessageException, UnsupportedTypeException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.call(receiver, signature, args);
            }

        }
    }
    @GeneratedBy(NativeSymbolLibrary.class)
    private static class MessageImpl extends Message {

        final int index;

        MessageImpl(String name, int index, Class<?> returnType, Class<?>... parameters) {
            super(NativeSymbolLibraryGen.LIBRARY_CLASS, name, returnType, parameters);
            this.index = index;
        }

    }
    @GeneratedBy(NativeSymbolLibrary.class)
    private static final class Proxy extends NativeSymbolLibrary {

        @Child private ReflectionLibrary lib;

        Proxy(ReflectionLibrary lib) {
            this.lib = lib;
        }

        @Override
        public boolean isBindable(Object receiver_) {
            try {
                return (boolean) lib.send(receiver_, NativeSymbolLibraryGen.IS_BINDABLE);
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public Object prepareSignature(Object receiver_, NativeSignature signature) throws UnsupportedMessageException, UnsupportedTypeException {
            try {
                return lib.send(receiver_, NativeSymbolLibraryGen.PREPARE_SIGNATURE, signature);
            } catch (UnsupportedMessageException | UnsupportedTypeException | RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public Object call(Object receiver_, Object signature, Object... args) throws ArityException, UnsupportedMessageException, UnsupportedTypeException {
            try {
                return lib.send(receiver_, NativeSymbolLibraryGen.CALL, signature, args);
            } catch (ArityException | UnsupportedMessageException | UnsupportedTypeException | RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public boolean accepts(Object receiver_) {
            return lib.accepts(receiver_);
        }

    }
    @GeneratedBy(NativeSymbolLibrary.class)
    private static final class Delegate extends NativeSymbolLibrary {

        @Child private NativeSymbolLibrary delegateLibrary;

        Delegate(NativeSymbolLibrary delegateLibrary) {
            this.delegateLibrary = delegateLibrary;
        }

        @Override
        public boolean isBindable(Object receiver_) {
            if (LibraryFactory.isDelegated(delegateLibrary, 0)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).isBindable(delegate);
            } else {
                return this.delegateLibrary.isBindable(receiver_);
            }
        }

        @Override
        public Object prepareSignature(Object receiver_, NativeSignature signature) throws UnsupportedMessageException, UnsupportedTypeException {
            if (LibraryFactory.isDelegated(delegateLibrary, 1)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).prepareSignature(delegate, signature);
            } else {
                return this.delegateLibrary.prepareSignature(receiver_, signature);
            }
        }

        @Override
        public Object call(Object receiver_, Object signature, Object... args) throws ArityException, UnsupportedMessageException, UnsupportedTypeException {
            if (LibraryFactory.isDelegated(delegateLibrary, 2)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).call(delegate, signature, args);
            } else {
                return this.delegateLibrary.call(receiver_, signature, args);
            }
        }

        @Override
        public boolean accepts(Object receiver_) {
            return delegateLibrary.accepts(receiver_);
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        @Override
        public boolean isAdoptable() {
            return this.delegateLibrary.isAdoptable();
        }

    }
    @GeneratedBy(NativeSymbolLibrary.class)
    private static final class CachedToUncachedDispatch extends NativeSymbolLibrary {

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @TruffleBoundary
        @Override
        public boolean isBindable(Object receiver_) {
            assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).isBindable(receiver_);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public Object prepareSignature(Object receiver_, NativeSignature signature) throws UnsupportedMessageException, UnsupportedTypeException {
            assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).prepareSignature(receiver_, signature);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public Object call(Object receiver_, Object signature, Object... args) throws ArityException, UnsupportedMessageException, UnsupportedTypeException {
            assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).call(receiver_, signature, args);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @Override
        public boolean accepts(Object receiver_) {
            return true;
        }

    }
    @GeneratedBy(NativeSymbolLibrary.class)
    private static final class UncachedDispatch extends NativeSymbolLibrary {

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @TruffleBoundary
        @Override
        public boolean isBindable(Object receiver_) {
            return INSTANCE.getUncached(receiver_).isBindable(receiver_);
        }

        @TruffleBoundary
        @Override
        public Object prepareSignature(Object receiver_, NativeSignature signature) throws UnsupportedMessageException, UnsupportedTypeException {
            return INSTANCE.getUncached(receiver_).prepareSignature(receiver_, signature);
        }

        @TruffleBoundary
        @Override
        public Object call(Object receiver_, Object signature, Object... args) throws ArityException, UnsupportedMessageException, UnsupportedTypeException {
            return INSTANCE.getUncached(receiver_).call(receiver_, signature, args);
        }

        @TruffleBoundary
        @Override
        public boolean accepts(Object receiver_) {
            return true;
        }

        @Override
        public boolean isAdoptable() {
            return false;
        }

    }
    @GeneratedBy(NativeSymbolLibrary.class)
    private static final class CachedDispatchNext extends CachedDispatch {

        CachedDispatchNext(NativeSymbolLibrary library, CachedDispatch next) {
            super(library, next);
        }

        @Override
        int getLimit() {
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
    @GeneratedBy(NativeSymbolLibrary.class)
    private static final class CachedDispatchFirst extends CachedDispatch {

        private final int limit_;

        CachedDispatchFirst(NativeSymbolLibrary library, CachedDispatch next, int limit_) {
            super(library, next);
            this.limit_ = limit_;
        }

        @Override
        int getLimit() {
            return this.limit_;
        }

        @Override
        public NodeCost getCost() {
            if (this.library instanceof CachedToUncachedDispatch) {
                return NodeCost.MEGAMORPHIC;
            }
            CachedDispatch current = this;
            int count = 0;
            do {
                if (current.library != null) {
                    count++;
                }
                current = current.next;
            } while (current != null);
            return NodeCost.fromCount(count);
        }

    }
    @GeneratedBy(NativeSymbolLibrary.class)
    private abstract static class CachedDispatch extends NativeSymbolLibrary {

        @Child NativeSymbolLibrary library;
        @Child CachedDispatch next;

        CachedDispatch(NativeSymbolLibrary library, CachedDispatch next) {
            this.library = library;
            this.next = next;
        }

        abstract int getLimit();

        @ExplodeLoop
        @Override
        public boolean isBindable(Object receiver_) {
            do {
                CachedDispatch current = this;
                do {
                    NativeSymbolLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.isBindable(receiver_);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public Object prepareSignature(Object receiver_, NativeSignature signature) throws UnsupportedMessageException, UnsupportedTypeException {
            do {
                CachedDispatch current = this;
                do {
                    NativeSymbolLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.prepareSignature(receiver_, signature);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public Object call(Object receiver_, Object signature, Object... args) throws ArityException, UnsupportedMessageException, UnsupportedTypeException {
            do {
                CachedDispatch current = this;
                do {
                    NativeSymbolLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.call(receiver_, signature, args);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @Override
        public boolean accepts(Object receiver_) {
            return true;
        }

        private void specialize(Object receiver_) {
            CachedDispatch current = this;
            NativeSymbolLibrary thisLibrary = current.library;
            if (thisLibrary == null) {
                this.library = insert(INSTANCE.create(receiver_));
            } else {
                Lock lock = getLock();
                lock.lock();
                try {
                    int count = 0;
                    do {
                        NativeSymbolLibrary currentLibrary = current.library;
                        if (currentLibrary != null && currentLibrary.accepts(receiver_)) {
                            return;
                        }
                        count++;
                        current = current.next;
                    } while (current != null);
                    if (count >= getLimit()) {
                        this.library = insert(new CachedToUncachedDispatch());
                        this.next = null;
                    } else {
                        this.next = insert(new CachedDispatchNext(INSTANCE.create(receiver_), next));
                    }
                } finally {
                    lock.unlock();
                }
            }
        }

    }
}
