// CheckStyle: start generated
package com.oracle.truffle.nfi.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.nfi.impl.LibFFIClosure;
import com.oracle.truffle.nfi.impl.SerializeArgumentLibrary;
import com.oracle.truffle.nfi.impl.LibFFIClosure.UnboxStringNode;
import java.util.concurrent.locks.Lock;

@GeneratedBy(LibFFIClosure.class)
@SuppressWarnings("unused")
final class LibFFIClosureFactory {

    private static final LibraryFactory<SerializeArgumentLibrary> SERIALIZE_ARGUMENT_LIBRARY_ = LibraryFactory.resolve(SerializeArgumentLibrary.class);

    @GeneratedBy(UnboxStringNode.class)
    static final class UnboxStringNodeGen extends UnboxStringNode {

        @CompilationFinal private volatile int state_;
        @CompilationFinal private volatile int exclude_;
        @Child private NativeString0Data nativeString0_cache;

        private UnboxStringNodeGen() {
        }

        @ExplodeLoop
        @Override
        protected Object execute(Object arg0Value) throws UnsupportedTypeException {
            int state = state_;
            if (state != 0 /* is-active nativeString(Object, SerializeArgumentLibrary) || nativeString(Object, SerializeArgumentLibrary) */) {
                if ((state & 0b1) != 0 /* is-active nativeString(Object, SerializeArgumentLibrary) */) {
                    NativeString0Data s1_ = this.nativeString0_cache;
                    while (s1_ != null) {
                        if ((s1_.serialize_.accepts(arg0Value))) {
                            return nativeString(arg0Value, s1_.serialize_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 0b10) != 0 /* is-active nativeString(Object, SerializeArgumentLibrary) */) {
                    return this.nativeString1Boundary(state, arg0Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value);
        }

        @TruffleBoundary
        private Object nativeString1Boundary(int state, Object arg0Value) throws UnsupportedTypeException {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    SerializeArgumentLibrary nativeString1_serialize__ = (SERIALIZE_ARGUMENT_LIBRARY_.getUncached(arg0Value));
                    return nativeString(arg0Value, nativeString1_serialize__);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        private Object executeAndSpecialize(Object arg0Value) throws UnsupportedTypeException {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            int exclude = exclude_;
            try {
                if ((exclude) == 0 /* is-not-excluded nativeString(Object, SerializeArgumentLibrary) */) {
                    int count1_ = 0;
                    NativeString0Data s1_ = this.nativeString0_cache;
                    if ((state & 0b1) != 0 /* is-active nativeString(Object, SerializeArgumentLibrary) */) {
                        while (s1_ != null) {
                            if ((s1_.serialize_.accepts(arg0Value))) {
                                break;
                            }
                            s1_ = s1_.next_;
                            count1_++;
                        }
                    }
                    if (s1_ == null) {
                        // assert (s1_.serialize_.accepts(arg0Value));
                        if (count1_ < (3)) {
                            s1_ = super.insert(new NativeString0Data(nativeString0_cache));
                            s1_.serialize_ = s1_.insertAccessor((SERIALIZE_ARGUMENT_LIBRARY_.create(arg0Value)));
                            this.nativeString0_cache = s1_;
                            this.state_ = state = state | 0b1 /* add-active nativeString(Object, SerializeArgumentLibrary) */;
                        }
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return nativeString(arg0Value, s1_.serialize_);
                    }
                }
                {
                    SerializeArgumentLibrary nativeString1_serialize__ = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            nativeString1_serialize__ = (SERIALIZE_ARGUMENT_LIBRARY_.getUncached(arg0Value));
                            this.exclude_ = exclude = exclude | 0b1 /* add-excluded nativeString(Object, SerializeArgumentLibrary) */;
                            this.nativeString0_cache = null;
                            state = state & 0xfffffffe /* remove-active nativeString(Object, SerializeArgumentLibrary) */;
                            this.state_ = state = state | 0b10 /* add-active nativeString(Object, SerializeArgumentLibrary) */;
                            lock.unlock();
                            hasLock = false;
                            return nativeString(arg0Value, nativeString1_serialize__);
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                NativeString0Data s1_ = this.nativeString0_cache;
                if ((s1_ == null || s1_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static UnboxStringNode create() {
            return new UnboxStringNodeGen();
        }

        @GeneratedBy(UnboxStringNode.class)
        private static final class NativeString0Data extends Node {

            @Child NativeString0Data next_;
            @Child SerializeArgumentLibrary serialize_;

            NativeString0Data(NativeString0Data next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
    }
}
