/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.spi.types;

import com.oracle.truffle.nfi.spi.types.NativeArrayTypeMirror;
import com.oracle.truffle.nfi.spi.types.NativeEnvTypeMirror;
import com.oracle.truffle.nfi.spi.types.NativeFunctionTypeMirror;
import com.oracle.truffle.nfi.spi.types.NativeLibraryDescriptor;
import com.oracle.truffle.nfi.spi.types.NativeSignature;
import com.oracle.truffle.nfi.spi.types.NativeSimpleType;
import com.oracle.truffle.nfi.spi.types.NativeSimpleTypeMirror;
import com.oracle.truffle.nfi.spi.types.NativeTypeMirror;
import java.util.List;

public abstract class TypeFactory {
    protected TypeFactory() {
        assert (this.checkCaller());
    }

    private boolean checkCaller() {
        String packageName = this.getClass().getPackage().getName();
        assert (packageName.equals("com.oracle.truffle.nfi")) : TypeFactory.class.getName() + " subclass is not in trusted package: " + this.getClass().getName();
        return true;
    }

    protected static NativeLibraryDescriptor createDefaultLibrary() {
        return new NativeLibraryDescriptor(null, null);
    }

    protected static NativeLibraryDescriptor createLibraryDescriptor(String filename, List<String> flags) {
        return new NativeLibraryDescriptor(filename, flags);
    }

    protected static NativeTypeMirror createArrayTypeMirror(NativeTypeMirror elementType) {
        return new NativeArrayTypeMirror(elementType);
    }

    protected static NativeTypeMirror createEnvTypeMirror() {
        return new NativeEnvTypeMirror();
    }

    protected static NativeTypeMirror createFunctionTypeMirror(NativeSignature signature) {
        return new NativeFunctionTypeMirror(signature);
    }

    protected static NativeTypeMirror createSimpleTypeMirror(NativeSimpleType type) {
        return new NativeSimpleTypeMirror(type);
    }

    protected static NativeSignature createSignature(NativeTypeMirror retType, List<NativeTypeMirror> argTypes) {
        return new NativeSignature(retType, -1, argTypes);
    }

    protected static NativeSignature createVarargsSignature(NativeTypeMirror retType, int fixedArgCount, List<NativeTypeMirror> argTypes) {
        assert (0 <= fixedArgCount && fixedArgCount <= argTypes.size());
        return new NativeSignature(retType, fixedArgCount, argTypes);
    }
}

