/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.profiles.BranchProfile;
import java.util.HashMap;
import java.util.Map;

@ExportLibrary(value=InteropLibrary.class)
final class NFILibrary
implements TruffleObject {
    private final Object library;
    private final Map<String, Object> symbols;

    @CompilerDirectives.TruffleBoundary
    NFILibrary(Object library) {
        this.library = library;
        this.symbols = new HashMap<String, Object>();
    }

    Object getLibrary() {
        return this.library;
    }

    @CompilerDirectives.TruffleBoundary
    Object findSymbol(String name) {
        return this.symbols.get(name);
    }

    @CompilerDirectives.TruffleBoundary
    void preBindSymbol(String name, Object symbol) {
        this.symbols.put(name, symbol);
    }

    @ExportMessage
    boolean hasMembers() {
        return true;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Keys getMembers(boolean includeInternal) {
        return new Keys(this.symbols.keySet().toArray());
    }

    @ExportMessage(limit="3")
    boolean isMemberReadable(String symbol, @CachedLibrary(value="this.getLibrary()") InteropLibrary recursive) {
        return recursive.isMemberReadable(this.getLibrary(), symbol);
    }

    @ExportMessage(limit="3")
    Object readMember(String symbol, @CachedLibrary(value="this.getLibrary()") InteropLibrary recursive) throws UnsupportedMessageException, UnknownIdentifierException {
        Object preBound = this.findSymbol(symbol);
        if (preBound != null) {
            return preBound;
        }
        return recursive.readMember(this.getLibrary(), symbol);
    }

    @ExportMessage
    boolean isMemberInvocable(String symbol) {
        return true;
    }

    @ExportMessage
    Object invokeMember(String symbol, Object[] args, @CachedLibrary(limit="3") InteropLibrary executables, @Cached BranchProfile exception) throws UnknownIdentifierException, ArityException, UnsupportedTypeException, UnsupportedMessageException {
        Object preBound = this.findSymbol(symbol);
        if (preBound == null) {
            exception.enter();
            throw UnknownIdentifierException.create((String)symbol);
        }
        return executables.execute(preBound, args);
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class Keys
    implements TruffleObject {
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private final Object[] keys;

        Keys(Object ... keys) {
            this.keys = keys;
        }

        @ExportMessage
        boolean hasArrayElements() {
            return true;
        }

        @ExportMessage
        long getArraySize() {
            return this.keys.length;
        }

        @ExportMessage
        boolean isArrayElementReadable(long index) {
            return 0L <= index && index < (long)this.keys.length;
        }

        @ExportMessage
        Object readArrayElement(long idx, @Cached BranchProfile exception) throws InvalidArrayIndexException {
            if (!this.isArrayElementReadable(idx)) {
                exception.enter();
                throw InvalidArrayIndexException.create((long)idx);
            }
            return this.keys[(int)idx];
        }
    }
}

