// CheckStyle: start generated
package com.oracle.truffle.nfi.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.TruffleLanguage.ContextReference;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.nfi.impl.FunctionExecuteNode;
import com.oracle.truffle.nfi.impl.FunctionExecuteNodeGen;
import com.oracle.truffle.nfi.impl.NFIContext;
import com.oracle.truffle.nfi.impl.NFILanguageImpl;
import com.oracle.truffle.nfi.impl.NativeArgumentBuffer;
import com.oracle.truffle.nfi.impl.NativePointer;
import com.oracle.truffle.nfi.impl.SerializeArgumentLibrary;
import com.oracle.truffle.nfi.spi.NativeSymbolLibrary;
import com.oracle.truffle.nfi.spi.types.NativeSignature;
import java.util.concurrent.locks.Lock;

@GeneratedBy(NativePointer.class)
final class NativePointerGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    static  {
        LibraryExport.register(NativePointer.class, new InteropLibraryExports(), new SerializeArgumentLibraryExports(), new NativeSymbolLibraryExports());
    }

    private NativePointerGen() {
    }

    @GeneratedBy(NativePointer.class)
    private static final class InteropLibraryExports extends LibraryExport<InteropLibrary> {

        private InteropLibraryExports() {
            super(InteropLibrary.class, NativePointer.class, false);
        }

        @Override
        protected InteropLibrary createUncached(Object receiver) {
            assert receiver instanceof NativePointer;
            return new Uncached(receiver);
        }

        @Override
        protected InteropLibrary createCached(Object receiver) {
            assert receiver instanceof NativePointer;
            return new Cached(receiver);
        }

        @GeneratedBy(NativePointer.class)
        private static final class Cached extends InteropLibrary {

            private final Class<? extends NativePointer> receiverClass_;

            Cached(Object receiver) {
                this.receiverClass_ = ((NativePointer) receiver).getClass();
            }

            @Override
            public boolean accepts(Object receiver) {
                assert receiver.getClass() != this.receiverClass_ || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export 'com.oracle.truffle.nfi.impl.NativePointer'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver.getClass() == this.receiverClass_;
            }

            @Override
            public boolean isPointer(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return (CompilerDirectives.castExact(receiver, receiverClass_)).isPointer();
            }

            @Override
            public long asPointer(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return (CompilerDirectives.castExact(receiver, receiverClass_)).asPointer();
            }

            @Override
            public boolean isNull(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return (CompilerDirectives.castExact(receiver, receiverClass_)).isNull();
            }

        }
        @GeneratedBy(NativePointer.class)
        private static final class Uncached extends InteropLibrary {

            private final Class<? extends NativePointer> receiverClass_;

            Uncached(Object receiver) {
                this.receiverClass_ = ((NativePointer) receiver).getClass();
            }

            @TruffleBoundary
            @Override
            public boolean accepts(Object receiver) {
                assert receiver.getClass() != this.receiverClass_ || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export 'com.oracle.truffle.nfi.impl.NativePointer'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver.getClass() == this.receiverClass_;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public boolean isPointer(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((NativePointer) receiver) .isPointer();
            }

            @TruffleBoundary
            @Override
            public long asPointer(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((NativePointer) receiver) .asPointer();
            }

            @TruffleBoundary
            @Override
            public boolean isNull(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((NativePointer) receiver) .isNull();
            }

        }
    }
    @GeneratedBy(NativePointer.class)
    private static final class SerializeArgumentLibraryExports extends LibraryExport<SerializeArgumentLibrary> {

        private SerializeArgumentLibraryExports() {
            super(SerializeArgumentLibrary.class, NativePointer.class, false);
        }

        @Override
        protected SerializeArgumentLibrary createUncached(Object receiver) {
            assert receiver instanceof NativePointer;
            return new Uncached(receiver);
        }

        @Override
        protected SerializeArgumentLibrary createCached(Object receiver) {
            assert receiver instanceof NativePointer;
            return new Cached(receiver);
        }

        @GeneratedBy(NativePointer.class)
        private static final class Cached extends SerializeArgumentLibrary {

            private final Class<? extends NativePointer> receiverClass_;

            Cached(Object receiver) {
                this.receiverClass_ = ((NativePointer) receiver).getClass();
            }

            @Override
            public boolean accepts(Object receiver) {
                assert receiver.getClass() != this.receiverClass_ || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export 'com.oracle.truffle.nfi.impl.NativePointer'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver.getClass() == this.receiverClass_;
            }

            @Override
            public void putPointer(Object receiver, NativeArgumentBuffer buffer, int ptrSize) throws UnsupportedTypeException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                (CompilerDirectives.castExact(receiver, receiverClass_)).putPointer(buffer, ptrSize);
                return;
            }

        }
        @GeneratedBy(NativePointer.class)
        private static final class Uncached extends SerializeArgumentLibrary {

            private final Class<? extends NativePointer> receiverClass_;

            Uncached(Object receiver) {
                this.receiverClass_ = ((NativePointer) receiver).getClass();
            }

            @TruffleBoundary
            @Override
            public boolean accepts(Object receiver) {
                assert receiver.getClass() != this.receiverClass_ || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export 'com.oracle.truffle.nfi.impl.NativePointer'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver.getClass() == this.receiverClass_;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public void putPointer(Object receiver, NativeArgumentBuffer buffer, int ptrSize) throws UnsupportedTypeException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                ((NativePointer) receiver) .putPointer(buffer, ptrSize);
                return;
            }

        }
    }
    @GeneratedBy(NativePointer.class)
    private static final class NativeSymbolLibraryExports extends LibraryExport<NativeSymbolLibrary> {

        private NativeSymbolLibraryExports() {
            super(NativeSymbolLibrary.class, NativePointer.class, false);
        }

        @Override
        protected NativeSymbolLibrary createUncached(Object receiver) {
            assert receiver instanceof NativePointer;
            return new Uncached(receiver);
        }

        @Override
        protected NativeSymbolLibrary createCached(Object receiver) {
            assert receiver instanceof NativePointer;
            return new Cached(receiver);
        }

        @GeneratedBy(NativePointer.class)
        private static final class Cached extends NativeSymbolLibrary {

            private final Class<? extends NativePointer> receiverClass_;
            @CompilationFinal private int state_;
            @CompilationFinal private ContextReference<NFIContext> nFILanguageImplContextReference_;
            @Child private FunctionExecuteNode callNode__execute_;

            Cached(Object receiver) {
                this.receiverClass_ = ((NativePointer) receiver).getClass();
            }

            @Override
            public boolean accepts(Object receiver) {
                assert receiver.getClass() != this.receiverClass_ || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export 'com.oracle.truffle.nfi.impl.NativePointer'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver.getClass() == this.receiverClass_;
            }

            @Override
            public boolean isBindable(Object receiver) {
                assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return (CompilerDirectives.castExact(receiver, receiverClass_)).isBindable();
            }

            @Override
            public Object prepareSignature(Object arg0Value_, NativeSignature arg1Value) throws UnsupportedMessageException, UnsupportedTypeException {
                assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                NativePointer arg0Value = CompilerDirectives.castExact(arg0Value_, receiverClass_);
                int state = state_;
                if ((state & 0b1) != 0 /* is-active prepareSignature(NativePointer, NativeSignature, NFIContext) */) {
                    return arg0Value.prepareSignature(arg1Value, this.nFILanguageImplContextReference_.get());
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return prepareSignatureNode_AndSpecialize(arg0Value, arg1Value);
            }

            private Object prepareSignatureNode_AndSpecialize(NativePointer arg0Value, NativeSignature arg1Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                try {
                    ContextReference<NFIContext> nFILanguageImplContextReference__ = this.nFILanguageImplContextReference_;
                    if (nFILanguageImplContextReference__ == null) {
                        this.nFILanguageImplContextReference_ = nFILanguageImplContextReference__ = super.lookupContextReference(NFILanguageImpl.class);
                    }
                    this.state_ = state = state | 0b1 /* add-active prepareSignature(NativePointer, NativeSignature, NFIContext) */;
                    lock.unlock();
                    hasLock = false;
                    return arg0Value.prepareSignature(arg1Value, nFILanguageImplContextReference__.get());
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                int state = state_;
                if ((state & 0b1) == 0b0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

            @Override
            public Object call(Object arg0Value_, Object arg1Value, Object... arg2Value) throws ArityException, UnsupportedMessageException, UnsupportedTypeException {
                assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                NativePointer arg0Value = CompilerDirectives.castExact(arg0Value_, receiverClass_);
                int state = state_;
                if ((state & 0b10) != 0 /* is-active call(NativePointer, Object, Object[], FunctionExecuteNode) */) {
                    return arg0Value.call(arg1Value, arg2Value, this.callNode__execute_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return callNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private Object callNode_AndSpecialize(NativePointer arg0Value, Object arg1Value, Object[] arg2Value) throws ArityException, UnsupportedTypeException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                try {
                    this.callNode__execute_ = super.insert((FunctionExecuteNodeGen.create()));
                    this.state_ = state = state | 0b10 /* add-active call(NativePointer, Object, Object[], FunctionExecuteNode) */;
                    lock.unlock();
                    hasLock = false;
                    return arg0Value.call(arg1Value, arg2Value, this.callNode__execute_);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

        }
        @GeneratedBy(NativePointer.class)
        private static final class Uncached extends NativeSymbolLibrary {

            private final Class<? extends NativePointer> receiverClass_;
            private final ContextReference<NFIContext> nFILanguageImplContextReference_ = lookupContextReference(NFILanguageImpl.class);

            Uncached(Object receiver) {
                this.receiverClass_ = ((NativePointer) receiver).getClass();
            }

            @TruffleBoundary
            @Override
            public boolean accepts(Object receiver) {
                assert receiver.getClass() != this.receiverClass_ || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export 'com.oracle.truffle.nfi.impl.NativePointer'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver.getClass() == this.receiverClass_;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public boolean isBindable(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((NativePointer) receiver) .isBindable();
            }

            @TruffleBoundary
            @Override
            public Object prepareSignature(Object arg0Value_, NativeSignature arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                NativePointer arg0Value = (NativePointer) arg0Value_;
                return arg0Value.prepareSignature(arg1Value, this.nFILanguageImplContextReference_.get());
            }

            @TruffleBoundary
            @Override
            public Object call(Object arg0Value_, Object arg1Value, Object... arg2Value) throws ArityException, UnsupportedTypeException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                NativePointer arg0Value = (NativePointer) arg0Value_;
                return arg0Value.call(arg1Value, arg2Value, (FunctionExecuteNodeGen.getUncached()));
            }

        }
    }
}
