// CheckStyle: start generated
package com.oracle.truffle.nfi.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.TruffleLanguage.ContextReference;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.ExplodeLoop.LoopExplosionKind;
import com.oracle.truffle.nfi.impl.LibFFIType;
import com.oracle.truffle.nfi.impl.NFIContext;
import com.oracle.truffle.nfi.impl.NFILanguageImpl;
import com.oracle.truffle.nfi.impl.NativeArgumentBuffer;
import com.oracle.truffle.nfi.impl.SerializeArgumentLibrary;
import com.oracle.truffle.nfi.impl.LibFFIType.ArrayType;
import com.oracle.truffle.nfi.impl.LibFFIType.ArrayType.CachedHostObjectHelperNode;
import com.oracle.truffle.nfi.impl.LibFFIType.ArrayType.HostObjectHelperNode;
import com.oracle.truffle.nfi.impl.LibFFIType.ArrayType.SerializeHelperNode;
import com.oracle.truffle.nfi.impl.LibFFIType.ArrayType.HostObjectHelperNode.WrongTypeException;
import com.oracle.truffle.nfi.spi.types.NativeSimpleType;
import java.util.concurrent.locks.Lock;

@GeneratedBy(LibFFIType.class)
@SuppressWarnings("unused")
final class LibFFITypeFactory {

    private static final LibraryFactory<SerializeArgumentLibrary> SERIALIZE_ARGUMENT_LIBRARY_ = LibraryFactory.resolve(SerializeArgumentLibrary.class);

    @GeneratedBy(ArrayType.class)
    static final class ArrayTypeFactory {

        @GeneratedBy(SerializeHelperNode.class)
        static final class SerializeHelperNodeGen extends SerializeHelperNode {

            private static final Uncached UNCACHED = new Uncached();

            @CompilationFinal private int state_;
            @CompilationFinal private int exclude_;
            @CompilationFinal private ContextReference<NFIContext> nFILanguageImplContextReference_;
            @Child private HostObjectHelperNode hostObject_helper_;
            @Child private InteropObject0Data interopObject0_cache;
            @Child private Generic0Data generic0_cache;
            @Child private HostObjectHelperNode generic1_helper_;

            private SerializeHelperNodeGen() {
            }

            @ExplodeLoop(kind = LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
            @Override
            void execute(ArrayType arg0Value, NativeArgumentBuffer arg1Value, Object arg2Value) throws UnsupportedTypeException {
                int state = state_;
                if (state != 0 /* is-active doHostObject(ArrayType, NativeArgumentBuffer, Object, NFIContext, HostObjectHelperNode) || doInteropObject(ArrayType, NativeArgumentBuffer, Object, NFIContext, SerializeArgumentLibrary) || doInteropObject(ArrayType, NativeArgumentBuffer, Object, NFIContext, SerializeArgumentLibrary) || doGeneric(ArrayType, NativeArgumentBuffer, Object, NFIContext, SerializeArgumentLibrary, HostObjectHelperNode) || doGeneric(ArrayType, NativeArgumentBuffer, Object, NFIContext, SerializeArgumentLibrary, HostObjectHelperNode) */) {
                    if ((state & 0b1) != 0 /* is-active doHostObject(ArrayType, NativeArgumentBuffer, Object, NFIContext, HostObjectHelperNode) */) {
                        if ((SerializeHelperNode.isHostObject(this.nFILanguageImplContextReference_.get(), arg2Value))) {
                            try {
                                SerializeHelperNode.doHostObject(arg0Value, arg1Value, arg2Value, this.nFILanguageImplContextReference_.get(), this.hostObject_helper_);
                                return;
                            } catch (WrongTypeException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                Lock lock = getLock();
                                lock.lock();
                                try {
                                    this.exclude_ = this.exclude_ | 0b1 /* add-excluded doHostObject(ArrayType, NativeArgumentBuffer, Object, NFIContext, HostObjectHelperNode) */;
                                    this.state_ = this.state_ & 0xfffffffe /* remove-active doHostObject(ArrayType, NativeArgumentBuffer, Object, NFIContext, HostObjectHelperNode) */;
                                } finally {
                                    lock.unlock();
                                }
                                executeAndSpecialize(arg0Value, arg1Value, arg2Value);
                                return;
                            }
                        }
                    }
                    if ((state & 0b10) != 0 /* is-active doInteropObject(ArrayType, NativeArgumentBuffer, Object, NFIContext, SerializeArgumentLibrary) */) {
                        InteropObject0Data s2_ = this.interopObject0_cache;
                        while (s2_ != null) {
                            if ((s2_.serialize_.accepts(arg2Value)) && (!(SerializeHelperNode.isHostObject(this.nFILanguageImplContextReference_.get(), arg2Value)))) {
                                SerializeHelperNode.doInteropObject(arg0Value, arg1Value, arg2Value, this.nFILanguageImplContextReference_.get(), s2_.serialize_);
                                return;
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state & 0b100) != 0 /* is-active doInteropObject(ArrayType, NativeArgumentBuffer, Object, NFIContext, SerializeArgumentLibrary) */) {
                        if ((!(SerializeHelperNode.isHostObject(this.nFILanguageImplContextReference_.get(), arg2Value)))) {
                            this.interopObject1Boundary(state, arg0Value, arg1Value, arg2Value);
                            return;
                        }
                    }
                    if ((state & 0b1000) != 0 /* is-active doGeneric(ArrayType, NativeArgumentBuffer, Object, NFIContext, SerializeArgumentLibrary, HostObjectHelperNode) */) {
                        Generic0Data s4_ = this.generic0_cache;
                        while (s4_ != null) {
                            if ((s4_.serialize_.accepts(arg2Value))) {
                                SerializeHelperNode.doGeneric(arg0Value, arg1Value, arg2Value, this.nFILanguageImplContextReference_.get(), s4_.serialize_, s4_.helper_);
                                return;
                            }
                            s4_ = s4_.next_;
                        }
                    }
                    if ((state & 0b10000) != 0 /* is-active doGeneric(ArrayType, NativeArgumentBuffer, Object, NFIContext, SerializeArgumentLibrary, HostObjectHelperNode) */) {
                        this.generic1Boundary(state, arg0Value, arg1Value, arg2Value);
                        return;
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                executeAndSpecialize(arg0Value, arg1Value, arg2Value);
                return;
            }

            @TruffleBoundary
            private void interopObject1Boundary(int state, ArrayType arg0Value, NativeArgumentBuffer arg1Value, Object arg2Value) throws UnsupportedTypeException {
                Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                try {
                    SerializeHelperNode.doInteropObject(arg0Value, arg1Value, arg2Value, this.nFILanguageImplContextReference_.get(), (SERIALIZE_ARGUMENT_LIBRARY_.getUncached(arg2Value)));
                    return;
                } finally {
                    NodeUtil.popEncapsulatingNode(prev_);
                }
            }

            @TruffleBoundary
            private void generic1Boundary(int state, ArrayType arg0Value, NativeArgumentBuffer arg1Value, Object arg2Value) throws UnsupportedTypeException {
                Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                try {
                    SerializeHelperNode.doGeneric(arg0Value, arg1Value, arg2Value, this.nFILanguageImplContextReference_.get(), (SERIALIZE_ARGUMENT_LIBRARY_.getUncached(arg2Value)), this.generic1_helper_);
                    return;
                } finally {
                    NodeUtil.popEncapsulatingNode(prev_);
                }
            }

            private void executeAndSpecialize(ArrayType arg0Value, NativeArgumentBuffer arg1Value, Object arg2Value) throws UnsupportedTypeException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                int exclude = exclude_;
                try {
                    if (((exclude & 0b1)) == 0 /* is-not-excluded doHostObject(ArrayType, NativeArgumentBuffer, Object, NFIContext, HostObjectHelperNode) */) {
                        {
                            ContextReference<NFIContext> nFILanguageImplContextReference__ = this.nFILanguageImplContextReference_;
                            if (nFILanguageImplContextReference__ == null) {
                                this.nFILanguageImplContextReference_ = nFILanguageImplContextReference__ = super.lookupContextReference(NFILanguageImpl.class);
                            }
                            NFIContext hostObject_ctx__ = nFILanguageImplContextReference__.get();
                            if ((SerializeHelperNode.isHostObject(hostObject_ctx__, arg2Value))) {
                                this.hostObject_helper_ = super.insert((HostObjectHelperNode.create(arg0Value)));
                                this.state_ = state = state | 0b1 /* add-active doHostObject(ArrayType, NativeArgumentBuffer, Object, NFIContext, HostObjectHelperNode) */;
                                try {
                                    lock.unlock();
                                    hasLock = false;
                                    SerializeHelperNode.doHostObject(arg0Value, arg1Value, arg2Value, hostObject_ctx__, this.hostObject_helper_);
                                    return;
                                } catch (WrongTypeException ex) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    lock.lock();
                                    try {
                                        this.exclude_ = this.exclude_ | 0b1 /* add-excluded doHostObject(ArrayType, NativeArgumentBuffer, Object, NFIContext, HostObjectHelperNode) */;
                                        this.state_ = this.state_ & 0xfffffffe /* remove-active doHostObject(ArrayType, NativeArgumentBuffer, Object, NFIContext, HostObjectHelperNode) */;
                                    } finally {
                                        lock.unlock();
                                    }
                                    executeAndSpecialize(arg0Value, arg1Value, arg2Value);
                                    return;
                                }
                            }
                        }
                    }
                    if (((exclude & 0b10)) == 0 /* is-not-excluded doInteropObject(ArrayType, NativeArgumentBuffer, Object, NFIContext, SerializeArgumentLibrary) */) {
                        int count2_ = 0;
                        InteropObject0Data s2_ = this.interopObject0_cache;
                        if ((state & 0b10) != 0 /* is-active doInteropObject(ArrayType, NativeArgumentBuffer, Object, NFIContext, SerializeArgumentLibrary) */) {
                            while (s2_ != null) {
                                if ((s2_.serialize_.accepts(arg2Value)) && (!(SerializeHelperNode.isHostObject(this.nFILanguageImplContextReference_.get(), arg2Value)))) {
                                    break;
                                }
                                s2_ = s2_.next_;
                                count2_++;
                            }
                        }
                        if (s2_ == null) {
                            {
                                ContextReference<NFIContext> nFILanguageImplContextReference__ = this.nFILanguageImplContextReference_;
                                if (nFILanguageImplContextReference__ == null) {
                                    this.nFILanguageImplContextReference_ = nFILanguageImplContextReference__ = super.lookupContextReference(NFILanguageImpl.class);
                                }
                                NFIContext ctx__ = nFILanguageImplContextReference__.get();
                                // assert (s2_.serialize_.accepts(arg2Value));
                                if ((!(SerializeHelperNode.isHostObject(ctx__, arg2Value))) && count2_ < (3)) {
                                    s2_ = super.insert(new InteropObject0Data(interopObject0_cache));
                                    s2_.serialize_ = s2_.insertAccessor((SERIALIZE_ARGUMENT_LIBRARY_.create(arg2Value)));
                                    this.interopObject0_cache = s2_;
                                    this.state_ = state = state | 0b10 /* add-active doInteropObject(ArrayType, NativeArgumentBuffer, Object, NFIContext, SerializeArgumentLibrary) */;
                                }
                            }
                        }
                        if (s2_ != null) {
                            lock.unlock();
                            hasLock = false;
                            SerializeHelperNode.doInteropObject(arg0Value, arg1Value, arg2Value, this.nFILanguageImplContextReference_.get(), s2_.serialize_);
                            return;
                        }
                    }
                    if (((exclude & 0b100)) == 0 /* is-not-excluded doInteropObject(ArrayType, NativeArgumentBuffer, Object, NFIContext, SerializeArgumentLibrary) */) {
                        {
                            Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                            try {
                                {
                                    ContextReference<NFIContext> nFILanguageImplContextReference__ = this.nFILanguageImplContextReference_;
                                    if (nFILanguageImplContextReference__ == null) {
                                        this.nFILanguageImplContextReference_ = nFILanguageImplContextReference__ = super.lookupContextReference(NFILanguageImpl.class);
                                    }
                                    NFIContext interopObject1_ctx__ = nFILanguageImplContextReference__.get();
                                    if ((!(SerializeHelperNode.isHostObject(interopObject1_ctx__, arg2Value)))) {
                                        this.exclude_ = exclude = exclude | 0b10 /* add-excluded doInteropObject(ArrayType, NativeArgumentBuffer, Object, NFIContext, SerializeArgumentLibrary) */;
                                        this.interopObject0_cache = null;
                                        state = state & 0xfffffffd /* remove-active doInteropObject(ArrayType, NativeArgumentBuffer, Object, NFIContext, SerializeArgumentLibrary) */;
                                        this.state_ = state = state | 0b100 /* add-active doInteropObject(ArrayType, NativeArgumentBuffer, Object, NFIContext, SerializeArgumentLibrary) */;
                                        lock.unlock();
                                        hasLock = false;
                                        SerializeHelperNode.doInteropObject(arg0Value, arg1Value, arg2Value, interopObject1_ctx__, (SERIALIZE_ARGUMENT_LIBRARY_.getUncached(arg2Value)));
                                        return;
                                    }
                                }
                            } finally {
                                NodeUtil.popEncapsulatingNode(prev_);
                            }
                        }
                    }
                    if (((exclude & 0b1000)) == 0 /* is-not-excluded doGeneric(ArrayType, NativeArgumentBuffer, Object, NFIContext, SerializeArgumentLibrary, HostObjectHelperNode) */) {
                        int count4_ = 0;
                        Generic0Data s4_ = this.generic0_cache;
                        if ((state & 0b1000) != 0 /* is-active doGeneric(ArrayType, NativeArgumentBuffer, Object, NFIContext, SerializeArgumentLibrary, HostObjectHelperNode) */) {
                            while (s4_ != null) {
                                if ((s4_.serialize_.accepts(arg2Value))) {
                                    break;
                                }
                                s4_ = s4_.next_;
                                count4_++;
                            }
                        }
                        if (s4_ == null) {
                            // assert (s4_.serialize_.accepts(arg2Value));
                            if (count4_ < (3)) {
                                s4_ = super.insert(new Generic0Data(generic0_cache));
                                ContextReference<NFIContext> nFILanguageImplContextReference__ = this.nFILanguageImplContextReference_;
                                if (nFILanguageImplContextReference__ == null) {
                                    this.nFILanguageImplContextReference_ = nFILanguageImplContextReference__ = super.lookupContextReference(NFILanguageImpl.class);
                                }
                                s4_.serialize_ = s4_.insertAccessor((SERIALIZE_ARGUMENT_LIBRARY_.create(arg2Value)));
                                s4_.helper_ = s4_.insertAccessor((HostObjectHelperNode.create(arg0Value)));
                                this.generic0_cache = s4_;
                                this.exclude_ = exclude = exclude | 0b111 /* add-excluded doHostObject(ArrayType, NativeArgumentBuffer, Object, NFIContext, HostObjectHelperNode), doInteropObject(ArrayType, NativeArgumentBuffer, Object, NFIContext, SerializeArgumentLibrary), doInteropObject(ArrayType, NativeArgumentBuffer, Object, NFIContext, SerializeArgumentLibrary) */;
                                this.interopObject0_cache = null;
                                state = state & 0xfffffff8 /* remove-active doHostObject(ArrayType, NativeArgumentBuffer, Object, NFIContext, HostObjectHelperNode), doInteropObject(ArrayType, NativeArgumentBuffer, Object, NFIContext, SerializeArgumentLibrary), doInteropObject(ArrayType, NativeArgumentBuffer, Object, NFIContext, SerializeArgumentLibrary) */;
                                this.state_ = state = state | 0b1000 /* add-active doGeneric(ArrayType, NativeArgumentBuffer, Object, NFIContext, SerializeArgumentLibrary, HostObjectHelperNode) */;
                            }
                        }
                        if (s4_ != null) {
                            lock.unlock();
                            hasLock = false;
                            SerializeHelperNode.doGeneric(arg0Value, arg1Value, arg2Value, this.nFILanguageImplContextReference_.get(), s4_.serialize_, s4_.helper_);
                            return;
                        }
                    }
                    {
                        Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                        try {
                            ContextReference<NFIContext> nFILanguageImplContextReference__ = this.nFILanguageImplContextReference_;
                            if (nFILanguageImplContextReference__ == null) {
                                this.nFILanguageImplContextReference_ = nFILanguageImplContextReference__ = super.lookupContextReference(NFILanguageImpl.class);
                            }
                            this.generic1_helper_ = super.insert((HostObjectHelperNode.create(arg0Value)));
                            this.exclude_ = exclude = exclude | 0b1111 /* add-excluded doHostObject(ArrayType, NativeArgumentBuffer, Object, NFIContext, HostObjectHelperNode), doInteropObject(ArrayType, NativeArgumentBuffer, Object, NFIContext, SerializeArgumentLibrary), doInteropObject(ArrayType, NativeArgumentBuffer, Object, NFIContext, SerializeArgumentLibrary), doGeneric(ArrayType, NativeArgumentBuffer, Object, NFIContext, SerializeArgumentLibrary, HostObjectHelperNode) */;
                            this.interopObject0_cache = null;
                            this.generic0_cache = null;
                            state = state & 0xfffffff0 /* remove-active doHostObject(ArrayType, NativeArgumentBuffer, Object, NFIContext, HostObjectHelperNode), doInteropObject(ArrayType, NativeArgumentBuffer, Object, NFIContext, SerializeArgumentLibrary), doInteropObject(ArrayType, NativeArgumentBuffer, Object, NFIContext, SerializeArgumentLibrary), doGeneric(ArrayType, NativeArgumentBuffer, Object, NFIContext, SerializeArgumentLibrary, HostObjectHelperNode) */;
                            this.state_ = state = state | 0b10000 /* add-active doGeneric(ArrayType, NativeArgumentBuffer, Object, NFIContext, SerializeArgumentLibrary, HostObjectHelperNode) */;
                            lock.unlock();
                            hasLock = false;
                            SerializeHelperNode.doGeneric(arg0Value, arg1Value, arg2Value, nFILanguageImplContextReference__.get(), (SERIALIZE_ARGUMENT_LIBRARY_.getUncached(arg2Value)), this.generic1_helper_);
                            return;
                        } finally {
                            NodeUtil.popEncapsulatingNode(prev_);
                        }
                    }
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                int state = state_;
                if (state == 0b0) {
                    return NodeCost.UNINITIALIZED;
                } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                    InteropObject0Data s2_ = this.interopObject0_cache;
                    Generic0Data s4_ = this.generic0_cache;
                    if ((s2_ == null || s2_.next_ == null) && (s4_ == null || s4_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

            public static SerializeHelperNode create() {
                return new SerializeHelperNodeGen();
            }

            public static SerializeHelperNode getUncached() {
                return SerializeHelperNodeGen.UNCACHED;
            }

            @GeneratedBy(SerializeHelperNode.class)
            private static final class InteropObject0Data extends Node {

                @Child InteropObject0Data next_;
                @Child SerializeArgumentLibrary serialize_;

                InteropObject0Data(InteropObject0Data next_) {
                    this.next_ = next_;
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                <T extends Node> T insertAccessor(T node) {
                    return super.insert(node);
                }

            }
            @GeneratedBy(SerializeHelperNode.class)
            private static final class Generic0Data extends Node {

                @Child Generic0Data next_;
                @Child SerializeArgumentLibrary serialize_;
                @Child HostObjectHelperNode helper_;

                Generic0Data(Generic0Data next_) {
                    this.next_ = next_;
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                <T extends Node> T insertAccessor(T node) {
                    return super.insert(node);
                }

            }
            @GeneratedBy(SerializeHelperNode.class)
            private static final class Uncached extends SerializeHelperNode {

                private final ContextReference<NFIContext> nFILanguageImplContextReference_ = lookupContextReference(NFILanguageImpl.class);

                @TruffleBoundary
                @Override
                void execute(ArrayType arg0Value, NativeArgumentBuffer arg1Value, Object arg2Value) throws UnsupportedTypeException {
                    SerializeHelperNode.doGeneric(arg0Value, arg1Value, arg2Value, this.nFILanguageImplContextReference_.get(), (SERIALIZE_ARGUMENT_LIBRARY_.getUncached(arg2Value)), (HostObjectHelperNode.getUncached(arg0Value)));
                    return;
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.MEGAMORPHIC;
                }

                @Override
                public boolean isAdoptable() {
                    return false;
                }

            }
        }
        @GeneratedBy(CachedHostObjectHelperNode.class)
        static final class CachedHostObjectHelperNodeGen extends CachedHostObjectHelperNode {

            @CompilationFinal private int state_;
            @CompilationFinal private int exclude_;
            @Child private SerializeArgumentLibrary hostArray10_lib_;
            @Child private SerializeArgumentLibrary hostArray20_lib_;

            private CachedHostObjectHelperNodeGen(int size, NativeSimpleType elementType) {
                super(size, elementType);
            }

            private boolean fallbackGuard_(int state, NativeArgumentBuffer arg0Value, Object arg1Value) {
                if (((state & 0b10)) == 0 /* is-not-active doHostArray1(NativeArgumentBuffer, Object, SerializeArgumentLibrary) */ && (arrayClass1 == arg1Value.getClass())) {
                    return false;
                }
                if (((state & 0b1000)) == 0 /* is-not-active doHostArray2(NativeArgumentBuffer, Object, SerializeArgumentLibrary) */ && (arrayClass2 == arg1Value.getClass())) {
                    return false;
                }
                return true;
            }

            @Override
            void execute(NativeArgumentBuffer arg0Value, Object arg1Value) throws UnsupportedTypeException, WrongTypeException {
                int state = state_;
                if (state != 0 /* is-active doHostArray1(NativeArgumentBuffer, Object, SerializeArgumentLibrary) || doHostArray1(NativeArgumentBuffer, Object, SerializeArgumentLibrary) || doHostArray2(NativeArgumentBuffer, Object, SerializeArgumentLibrary) || doHostArray2(NativeArgumentBuffer, Object, SerializeArgumentLibrary) || doOther(NativeArgumentBuffer, Object) */) {
                    if ((state & 0b1) != 0 /* is-active doHostArray1(NativeArgumentBuffer, Object, SerializeArgumentLibrary) */) {
                        if ((this.hostArray10_lib_.accepts(arg1Value)) && (arrayClass1 == arg1Value.getClass())) {
                            doHostArray1(arg0Value, arg1Value, this.hostArray10_lib_);
                            return;
                        }
                    }
                    if ((state & 0b10) != 0 /* is-active doHostArray1(NativeArgumentBuffer, Object, SerializeArgumentLibrary) */) {
                        if ((arrayClass1 == arg1Value.getClass())) {
                            this.hostArray11Boundary(state, arg0Value, arg1Value);
                            return;
                        }
                    }
                    if ((state & 0b100) != 0 /* is-active doHostArray2(NativeArgumentBuffer, Object, SerializeArgumentLibrary) */) {
                        if ((this.hostArray20_lib_.accepts(arg1Value)) && (arrayClass2 == arg1Value.getClass())) {
                            doHostArray2(arg0Value, arg1Value, this.hostArray20_lib_);
                            return;
                        }
                    }
                    if ((state & 0b1000) != 0 /* is-active doHostArray2(NativeArgumentBuffer, Object, SerializeArgumentLibrary) */) {
                        if ((arrayClass2 == arg1Value.getClass())) {
                            this.hostArray21Boundary(state, arg0Value, arg1Value);
                            return;
                        }
                    }
                    if ((state & 0b10000) != 0 /* is-active doOther(NativeArgumentBuffer, Object) */) {
                        if (fallbackGuard_(state, arg0Value, arg1Value)) {
                            doOther(arg0Value, arg1Value);
                            return;
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                executeAndSpecialize(arg0Value, arg1Value);
                return;
            }

            @TruffleBoundary
            private void hostArray11Boundary(int state, NativeArgumentBuffer arg0Value, Object arg1Value) throws UnsupportedTypeException, WrongTypeException {
                Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                try {
                    doHostArray1(arg0Value, arg1Value, (SERIALIZE_ARGUMENT_LIBRARY_.getUncached(arg1Value)));
                    return;
                } finally {
                    NodeUtil.popEncapsulatingNode(prev_);
                }
            }

            @TruffleBoundary
            private void hostArray21Boundary(int state, NativeArgumentBuffer arg0Value, Object arg1Value) throws UnsupportedTypeException, WrongTypeException {
                Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                try {
                    doHostArray2(arg0Value, arg1Value, (SERIALIZE_ARGUMENT_LIBRARY_.getUncached(arg1Value)));
                    return;
                } finally {
                    NodeUtil.popEncapsulatingNode(prev_);
                }
            }

            private void executeAndSpecialize(NativeArgumentBuffer arg0Value, Object arg1Value) throws UnsupportedTypeException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                int exclude = exclude_;
                try {
                    if (((exclude & 0b1)) == 0 /* is-not-excluded doHostArray1(NativeArgumentBuffer, Object, SerializeArgumentLibrary) */) {
                        boolean HostArray10_duplicateFound_ = false;
                        if ((state & 0b1) != 0 /* is-active doHostArray1(NativeArgumentBuffer, Object, SerializeArgumentLibrary) */) {
                            if ((this.hostArray10_lib_.accepts(arg1Value)) && (arrayClass1 == arg1Value.getClass())) {
                                HostArray10_duplicateFound_ = true;
                            }
                        }
                        if (!HostArray10_duplicateFound_) {
                            if ((arrayClass1 == arg1Value.getClass()) && ((state & 0b1)) == 0 /* is-not-active doHostArray1(NativeArgumentBuffer, Object, SerializeArgumentLibrary) */) {
                                // assert (this.hostArray10_lib_.accepts(arg1Value));
                                this.hostArray10_lib_ = super.insert((SERIALIZE_ARGUMENT_LIBRARY_.create(arg1Value)));
                                this.state_ = state = state | 0b1 /* add-active doHostArray1(NativeArgumentBuffer, Object, SerializeArgumentLibrary) */;
                                HostArray10_duplicateFound_ = true;
                            }
                        }
                        if (HostArray10_duplicateFound_) {
                            lock.unlock();
                            hasLock = false;
                            doHostArray1(arg0Value, arg1Value, this.hostArray10_lib_);
                            return;
                        }
                    }
                    {
                        Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                        try {
                            if ((arrayClass1 == arg1Value.getClass())) {
                                this.exclude_ = exclude = exclude | 0b1 /* add-excluded doHostArray1(NativeArgumentBuffer, Object, SerializeArgumentLibrary) */;
                                state = state & 0xfffffffe /* remove-active doHostArray1(NativeArgumentBuffer, Object, SerializeArgumentLibrary) */;
                                this.state_ = state = state | 0b10 /* add-active doHostArray1(NativeArgumentBuffer, Object, SerializeArgumentLibrary) */;
                                lock.unlock();
                                hasLock = false;
                                doHostArray1(arg0Value, arg1Value, (SERIALIZE_ARGUMENT_LIBRARY_.getUncached(arg1Value)));
                                return;
                            }
                        } finally {
                            NodeUtil.popEncapsulatingNode(prev_);
                        }
                    }
                    if (((exclude & 0b10)) == 0 /* is-not-excluded doHostArray2(NativeArgumentBuffer, Object, SerializeArgumentLibrary) */) {
                        boolean HostArray20_duplicateFound_ = false;
                        if ((state & 0b100) != 0 /* is-active doHostArray2(NativeArgumentBuffer, Object, SerializeArgumentLibrary) */) {
                            if ((this.hostArray20_lib_.accepts(arg1Value)) && (arrayClass2 == arg1Value.getClass())) {
                                HostArray20_duplicateFound_ = true;
                            }
                        }
                        if (!HostArray20_duplicateFound_) {
                            if ((arrayClass2 == arg1Value.getClass()) && ((state & 0b100)) == 0 /* is-not-active doHostArray2(NativeArgumentBuffer, Object, SerializeArgumentLibrary) */) {
                                // assert (this.hostArray20_lib_.accepts(arg1Value));
                                this.hostArray20_lib_ = super.insert((SERIALIZE_ARGUMENT_LIBRARY_.create(arg1Value)));
                                this.state_ = state = state | 0b100 /* add-active doHostArray2(NativeArgumentBuffer, Object, SerializeArgumentLibrary) */;
                                HostArray20_duplicateFound_ = true;
                            }
                        }
                        if (HostArray20_duplicateFound_) {
                            lock.unlock();
                            hasLock = false;
                            doHostArray2(arg0Value, arg1Value, this.hostArray20_lib_);
                            return;
                        }
                    }
                    {
                        Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                        try {
                            if ((arrayClass2 == arg1Value.getClass())) {
                                this.exclude_ = exclude = exclude | 0b10 /* add-excluded doHostArray2(NativeArgumentBuffer, Object, SerializeArgumentLibrary) */;
                                state = state & 0xfffffffb /* remove-active doHostArray2(NativeArgumentBuffer, Object, SerializeArgumentLibrary) */;
                                this.state_ = state = state | 0b1000 /* add-active doHostArray2(NativeArgumentBuffer, Object, SerializeArgumentLibrary) */;
                                lock.unlock();
                                hasLock = false;
                                doHostArray2(arg0Value, arg1Value, (SERIALIZE_ARGUMENT_LIBRARY_.getUncached(arg1Value)));
                                return;
                            }
                        } finally {
                            NodeUtil.popEncapsulatingNode(prev_);
                        }
                    }
                    this.state_ = state = state | 0b10000 /* add-active doOther(NativeArgumentBuffer, Object) */;
                    lock.unlock();
                    hasLock = false;
                    doOther(arg0Value, arg1Value);
                    return;
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                int state = state_;
                if (state == 0b0) {
                    return NodeCost.UNINITIALIZED;
                } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            public static CachedHostObjectHelperNode create(int size, NativeSimpleType elementType) {
                return new CachedHostObjectHelperNodeGen(size, elementType);
            }

        }
    }
}
