// CheckStyle: start generated
package com.oracle.truffle.nfi.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.TruffleLanguage.LanguageReference;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.nfi.impl.LibFFIType;
import com.oracle.truffle.nfi.impl.NFILanguageImpl;
import com.oracle.truffle.nfi.impl.NativeArgumentBuffer;
import com.oracle.truffle.nfi.impl.NativeArgumentLibrary;
import com.oracle.truffle.nfi.impl.SerializeArgumentLibrary;
import com.oracle.truffle.nfi.impl.LibFFIType.BasicType;
import com.oracle.truffle.nfi.spi.types.NativeSimpleType;
import java.util.concurrent.locks.Lock;

@GeneratedBy(BasicType.class)
final class BasicTypeGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<SerializeArgumentLibrary> SERIALIZE_ARGUMENT_LIBRARY_ = LibraryFactory.resolve(SerializeArgumentLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    static  {
        LibraryExport.register(BasicType.class, new NativeArgumentLibraryExports());
    }

    private BasicTypeGen() {
    }

    @GeneratedBy(BasicType.class)
    private static final class NativeArgumentLibraryExports extends LibraryExport<NativeArgumentLibrary> {

        private NativeArgumentLibraryExports() {
            super(NativeArgumentLibrary.class, BasicType.class, false);
        }

        @Override
        protected NativeArgumentLibrary createUncached(Object receiver) {
            assert receiver instanceof BasicType;
            return new Uncached(receiver);
        }

        @Override
        protected NativeArgumentLibrary createCached(Object receiver) {
            assert receiver instanceof BasicType;
            return new Cached(receiver);
        }

        @GeneratedBy(BasicType.class)
        private static final class Cached extends NativeArgumentLibrary {

            private final Class<? extends BasicType> receiverClass_;
            @CompilationFinal private int state_;
            @CompilationFinal private NativeSimpleType cachedType;
            @CompilationFinal private LanguageReference<NFILanguageImpl> nFILanguageImplReference_;
            @Child private SerializeArgumentLibrary serializeNode__serialize_;
            @Child private InteropLibrary serializeNode__interop_;

            Cached(Object receiver) {
                this.receiverClass_ = ((BasicType) receiver).getClass();
            }

            @Override
            public boolean accepts(Object receiver) {
                assert receiver.getClass() != this.receiverClass_ || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export 'com.oracle.truffle.nfi.impl.LibFFIType.BasicType'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver.getClass() == this.receiverClass_ && accepts_(receiver);
            }

            private boolean accepts_(Object arg0Value_) {
                BasicType arg0Value = CompilerDirectives.castExact(arg0Value_, receiverClass_);
                int state = state_;
                if ((state & 0b1) != 0 /* is-active accepts(BasicType, NativeSimpleType) */) {
                    return arg0Value.accepts(this.cachedType);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return acceptsNode_AndSpecialize(arg0Value);
            }

            private boolean acceptsNode_AndSpecialize(BasicType arg0Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                try {
                    if (this.cachedType == null) {
                        this.cachedType = (arg0Value.simpleType);
                    }
                    this.state_ = state = state | 0b1 /* add-active accepts(BasicType, NativeSimpleType) */;
                    lock.unlock();
                    hasLock = false;
                    return arg0Value.accepts(this.cachedType);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                int state = state_;
                if ((state & 0b1) == 0b0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

            @Override
            public void serialize(LibFFIType arg0Value_, NativeArgumentBuffer arg1Value, Object arg2Value) throws UnsupportedTypeException {
                assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                BasicType arg0Value = CompilerDirectives.castExact(arg0Value_, receiverClass_);
                int state = state_;
                if ((state & 0b10) != 0 /* is-active serialize(BasicType, NativeArgumentBuffer, Object, NativeSimpleType, SerializeArgumentLibrary, InteropLibrary) */) {
                    arg0Value.serialize(arg1Value, arg2Value, this.cachedType, this.serializeNode__serialize_, this.serializeNode__interop_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                serializeNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
                return;
            }

            private void serializeNode_AndSpecialize(BasicType arg0Value, NativeArgumentBuffer arg1Value, Object arg2Value) throws UnsupportedTypeException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                try {
                    if (this.cachedType == null) {
                        this.cachedType = (arg0Value.simpleType);
                    }
                    this.serializeNode__serialize_ = super.insert((SERIALIZE_ARGUMENT_LIBRARY_.createDispatched(3)));
                    this.serializeNode__interop_ = super.insert((INTEROP_LIBRARY_.createDispatched(1)));
                    this.state_ = state = state | 0b10 /* add-active serialize(BasicType, NativeArgumentBuffer, Object, NativeSimpleType, SerializeArgumentLibrary, InteropLibrary) */;
                    lock.unlock();
                    hasLock = false;
                    arg0Value.serialize(arg1Value, arg2Value, this.cachedType, this.serializeNode__serialize_, this.serializeNode__interop_);
                    return;
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public Object deserialize(LibFFIType arg0Value_, NativeArgumentBuffer arg1Value) {
                assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                BasicType arg0Value = CompilerDirectives.castExact(arg0Value_, receiverClass_);
                int state = state_;
                if ((state & 0b100) != 0 /* is-active deserialize(BasicType, NativeArgumentBuffer, NativeSimpleType, NFILanguageImpl) */) {
                    return arg0Value.deserialize(arg1Value, this.cachedType, this.nFILanguageImplReference_.get());
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return deserializeNode_AndSpecialize(arg0Value, arg1Value);
            }

            private Object deserializeNode_AndSpecialize(BasicType arg0Value, NativeArgumentBuffer arg1Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                try {
                    if (this.cachedType == null) {
                        this.cachedType = (arg0Value.simpleType);
                    }
                    LanguageReference<NFILanguageImpl> nFILanguageImplReference__ = this.nFILanguageImplReference_;
                    if (nFILanguageImplReference__ == null) {
                        this.nFILanguageImplReference_ = nFILanguageImplReference__ = super.lookupLanguageReference(NFILanguageImpl.class);
                    }
                    this.state_ = state = state | 0b100 /* add-active deserialize(BasicType, NativeArgumentBuffer, NativeSimpleType, NFILanguageImpl) */;
                    lock.unlock();
                    hasLock = false;
                    return arg0Value.deserialize(arg1Value, this.cachedType, nFILanguageImplReference__.get());
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

        }
        @GeneratedBy(BasicType.class)
        private static final class Uncached extends NativeArgumentLibrary {

            private final Class<? extends BasicType> receiverClass_;
            private final LanguageReference<NFILanguageImpl> nFILanguageImplReference_ = lookupLanguageReference(NFILanguageImpl.class);

            Uncached(Object receiver) {
                this.receiverClass_ = ((BasicType) receiver).getClass();
            }

            @TruffleBoundary
            @Override
            public boolean accepts(Object receiver) {
                assert receiver.getClass() != this.receiverClass_ || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export 'com.oracle.truffle.nfi.impl.LibFFIType.BasicType'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver.getClass() == this.receiverClass_ && accepts_(receiver);
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public void serialize(LibFFIType arg0Value_, NativeArgumentBuffer arg1Value, Object arg2Value) throws UnsupportedTypeException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                BasicType arg0Value = (BasicType) arg0Value_;
                arg0Value.serialize(arg1Value, arg2Value, (arg0Value.simpleType), (SERIALIZE_ARGUMENT_LIBRARY_.getUncached()), (INTEROP_LIBRARY_.getUncached()));
                return;
            }

            @TruffleBoundary
            @Override
            public Object deserialize(LibFFIType arg0Value_, NativeArgumentBuffer arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                BasicType arg0Value = (BasicType) arg0Value_;
                return arg0Value.deserialize(arg1Value, (arg0Value.simpleType), this.nFILanguageImplReference_.get());
            }

            @TruffleBoundary
            private static boolean accepts_(Object arg0Value_) {
                BasicType arg0Value = (BasicType) arg0Value_;
                return arg0Value.accepts((arg0Value.simpleType));
            }

        }
    }
}
