// CheckStyle: start generated
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.nfi.BindSignatureNode;
import com.oracle.truffle.nfi.BindSignatureNodeGen;
import com.oracle.truffle.nfi.NFISymbol;
import com.oracle.truffle.nfi.spi.NativeSymbolLibrary;
import java.util.concurrent.locks.Lock;

@GeneratedBy(NFISymbol.class)
final class NFISymbolGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<NativeSymbolLibrary> NATIVE_SYMBOL_LIBRARY_ = LibraryFactory.resolve(NativeSymbolLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    static  {
        LibraryExport.register(NFISymbol.class, new InteropLibraryExports());
    }

    private NFISymbolGen() {
    }

    @GeneratedBy(NFISymbol.class)
    private static final class InteropLibraryExports extends LibraryExport<InteropLibrary> {

        private InteropLibraryExports() {
            super(InteropLibrary.class, NFISymbol.class, false);
        }

        @Override
        protected InteropLibrary createUncached(Object receiver) {
            assert receiver instanceof NFISymbol;
            return new Uncached();
        }

        @Override
        protected InteropLibrary createCached(Object receiver) {
            assert receiver instanceof NFISymbol;
            return new Cached(receiver);
        }

        @GeneratedBy(NFISymbol.class)
        private static final class Cached extends InteropLibrary {

            @Child private NativeSymbolLibrary receivernativeSymbolNativeSymbolLibrary;
            @Child private InteropLibrary receivernativeSymbolInteropLibrary;
            @CompilationFinal private int state_;
            @CompilationFinal private BranchProfile executeNode__exception_;
            @Child private BindSignatureNode invokeMemberNode__bind_;
            @CompilationFinal private ConditionProfile invokeMemberNode__isCallable_;
            @CompilationFinal private BranchProfile invokeMemberNode__exception_;

            Cached(Object receiver) {
                this.receivernativeSymbolNativeSymbolLibrary = insert(NATIVE_SYMBOL_LIBRARY_.create((((NFISymbol) receiver).nativeSymbol)));
                this.receivernativeSymbolInteropLibrary = insert(INTEROP_LIBRARY_.create((((NFISymbol) receiver).nativeSymbol)));
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof NFISymbol) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export 'com.oracle.truffle.nfi.NFISymbol'. Exported receiver with dynamic dispatch found but not expected.";
                if (!(receiver instanceof NFISymbol)) {
                    return false;
                } else if (!this.receivernativeSymbolNativeSymbolLibrary.accepts((((NFISymbol) receiver).nativeSymbol))) {
                    return false;
                } else if (!this.receivernativeSymbolInteropLibrary.accepts((((NFISymbol) receiver).nativeSymbol))) {
                    return false;
                } else {
                    return true;
                }
            }

            @Override
            public boolean isExecutable(Object receiver) {
                assert assertAdopted();
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((NFISymbol) receiver).isExecutable();
            }

            @Override
            public Object execute(Object arg0Value_, Object... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                NFISymbol arg0Value = (NFISymbol) arg0Value_;
                int state = state_;
                if ((state & 0b1) != 0 /* is-active execute(NFISymbol, Object[], NativeSymbolLibrary, BranchProfile) */) {
                    return arg0Value.execute(arg1Value, this.receivernativeSymbolNativeSymbolLibrary, this.executeNode__exception_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeNode_AndSpecialize(arg0Value, arg1Value);
            }

            private Object executeNode_AndSpecialize(NFISymbol arg0Value, Object[] arg1Value) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                try {
                    this.executeNode__exception_ = (BranchProfile.create());
                    this.state_ = state = state | 0b1 /* add-active execute(NFISymbol, Object[], NativeSymbolLibrary, BranchProfile) */;
                    lock.unlock();
                    hasLock = false;
                    return arg0Value.execute(arg1Value, this.receivernativeSymbolNativeSymbolLibrary, this.executeNode__exception_);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                int state = state_;
                if ((state & 0b1) == 0b0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

            @Override
            public boolean hasMembers(Object receiver) {
                assert assertAdopted();
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((NFISymbol) receiver).hasMembers();
            }

            @Override
            public Object getMembers(Object receiver, boolean includeInternal) throws UnsupportedMessageException {
                assert assertAdopted();
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((NFISymbol) receiver).getMembers(includeInternal);
            }

            @Override
            public boolean isMemberInvocable(Object receiver, String member) {
                assert assertAdopted();
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((NFISymbol) receiver).isMemberInvocable(member);
            }

            @Override
            public Object invokeMember(Object arg0Value_, String arg1Value, Object... arg2Value) throws UnsupportedMessageException, ArityException, UnknownIdentifierException, UnsupportedTypeException {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                NFISymbol arg0Value = (NFISymbol) arg0Value_;
                int state = state_;
                if ((state & 0b10) != 0 /* is-active invokeMember(NFISymbol, String, Object[], BindSignatureNode, NativeSymbolLibrary, ConditionProfile, BranchProfile) */) {
                    return arg0Value.invokeMember(arg1Value, arg2Value, this.invokeMemberNode__bind_, this.receivernativeSymbolNativeSymbolLibrary, this.invokeMemberNode__isCallable_, this.invokeMemberNode__exception_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return invokeMemberNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private Object invokeMemberNode_AndSpecialize(NFISymbol arg0Value, String arg1Value, Object[] arg2Value) throws ArityException, UnknownIdentifierException, UnsupportedTypeException, UnsupportedMessageException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                try {
                    this.invokeMemberNode__bind_ = super.insert((BindSignatureNodeGen.create()));
                    this.invokeMemberNode__isCallable_ = (ConditionProfile.createBinaryProfile());
                    this.invokeMemberNode__exception_ = (BranchProfile.create());
                    this.state_ = state = state | 0b10 /* add-active invokeMember(NFISymbol, String, Object[], BindSignatureNode, NativeSymbolLibrary, ConditionProfile, BranchProfile) */;
                    lock.unlock();
                    hasLock = false;
                    return arg0Value.invokeMember(arg1Value, arg2Value, this.invokeMemberNode__bind_, this.receivernativeSymbolNativeSymbolLibrary, this.invokeMemberNode__isCallable_, this.invokeMemberNode__exception_);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isNull(Object arg0Value_) {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                NFISymbol arg0Value = (NFISymbol) arg0Value_;
                return arg0Value.isNull(this.receivernativeSymbolInteropLibrary);
            }

            @Override
            public boolean isPointer(Object arg0Value_) {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                NFISymbol arg0Value = (NFISymbol) arg0Value_;
                return arg0Value.isPointer(this.receivernativeSymbolInteropLibrary);
            }

            @Override
            public long asPointer(Object arg0Value_) throws UnsupportedMessageException {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                NFISymbol arg0Value = (NFISymbol) arg0Value_;
                return arg0Value.asPointer(this.receivernativeSymbolInteropLibrary);
            }

            @Override
            public void toNative(Object arg0Value_) {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                NFISymbol arg0Value = (NFISymbol) arg0Value_;
                arg0Value.toNative(this.receivernativeSymbolInteropLibrary);
                return;
            }

        }
        @GeneratedBy(NFISymbol.class)
        private static final class Uncached extends InteropLibrary {

            Uncached() {
            }

            @TruffleBoundary
            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof NFISymbol) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export 'com.oracle.truffle.nfi.NFISymbol'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof NFISymbol;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public boolean isExecutable(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((NFISymbol) receiver) .isExecutable();
            }

            @TruffleBoundary
            @Override
            public Object execute(Object arg0Value_, Object... arg1Value) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                NFISymbol arg0Value = (NFISymbol) arg0Value_;
                return arg0Value.execute(arg1Value, NATIVE_SYMBOL_LIBRARY_.getUncached((arg0Value.nativeSymbol)), (BranchProfile.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean hasMembers(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((NFISymbol) receiver) .hasMembers();
            }

            @TruffleBoundary
            @Override
            public Object getMembers(Object receiver, boolean includeInternal) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((NFISymbol) receiver) .getMembers(includeInternal);
            }

            @TruffleBoundary
            @Override
            public boolean isMemberInvocable(Object receiver, String member) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((NFISymbol) receiver) .isMemberInvocable(member);
            }

            @TruffleBoundary
            @Override
            public Object invokeMember(Object arg0Value_, String arg1Value, Object... arg2Value) throws ArityException, UnknownIdentifierException, UnsupportedTypeException, UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                NFISymbol arg0Value = (NFISymbol) arg0Value_;
                return arg0Value.invokeMember(arg1Value, arg2Value, (BindSignatureNodeGen.getUncached()), NATIVE_SYMBOL_LIBRARY_.getUncached((arg0Value.nativeSymbol)), (ConditionProfile.getUncached()), (BranchProfile.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean isNull(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                NFISymbol arg0Value = (NFISymbol) arg0Value_;
                return arg0Value.isNull(INTEROP_LIBRARY_.getUncached((arg0Value.nativeSymbol)));
            }

            @TruffleBoundary
            @Override
            public boolean isPointer(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                NFISymbol arg0Value = (NFISymbol) arg0Value_;
                return arg0Value.isPointer(INTEROP_LIBRARY_.getUncached((arg0Value.nativeSymbol)));
            }

            @TruffleBoundary
            @Override
            public long asPointer(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                NFISymbol arg0Value = (NFISymbol) arg0Value_;
                return arg0Value.asPointer(INTEROP_LIBRARY_.getUncached((arg0Value.nativeSymbol)));
            }

            @TruffleBoundary
            @Override
            public void toNative(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                NFISymbol arg0Value = (NFISymbol) arg0Value_;
                arg0Value.toNative(INTEROP_LIBRARY_.getUncached((arg0Value.nativeSymbol)));
                return;
            }

        }
    }
}
