/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.nfi.impl.LibFFIClosure;
import com.oracle.truffle.nfi.impl.SerializeArgumentLibrary;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LibFFIClosure.class)
final class LibFFIClosureFactory {
    private static final LibraryFactory<SerializeArgumentLibrary> SERIALIZE_ARGUMENT_LIBRARY_ = LibraryFactory.resolve(SerializeArgumentLibrary.class);

    LibFFIClosureFactory() {
    }

    @GeneratedBy(value=LibFFIClosure.UnboxStringNode.class)
    static final class UnboxStringNodeGen
    extends LibFFIClosure.UnboxStringNode {
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;
        @Node.Child
        private NativeString0Data nativeString0_cache;

        private UnboxStringNodeGen() {
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        protected Object execute(Object arg0Value) throws UnsupportedTypeException {
            int state = this.state_;
            if (state != 0) {
                if ((state & 1) != 0) {
                    NativeString0Data s1_ = this.nativeString0_cache;
                    while (s1_ != null) {
                        if (s1_.serialize_.accepts(arg0Value)) {
                            return this.nativeString(arg0Value, s1_.serialize_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 2) != 0) {
                    return this.nativeString1Boundary(state, arg0Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object nativeString1Boundary(int state, Object arg0Value) throws UnsupportedTypeException {
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                Object object = this.nativeString(arg0Value, (SerializeArgumentLibrary)SERIALIZE_ARGUMENT_LIBRARY_.getUncached(arg0Value));
                return object;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object executeAndSpecialize(Object arg0Value) throws UnsupportedTypeException {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                Object object;
                if (exclude == 0) {
                    int count1_ = 0;
                    NativeString0Data s1_ = this.nativeString0_cache;
                    if ((state & 1) != 0) {
                        while (s1_ != null && !s1_.serialize_.accepts(arg0Value)) {
                            s1_ = s1_.next_;
                            ++count1_;
                        }
                    }
                    if (s1_ == null && count1_ < 3) {
                        s1_ = (NativeString0Data)super.insert((Node)new NativeString0Data(this.nativeString0_cache));
                        s1_.serialize_ = (SerializeArgumentLibrary)s1_.insertAccessor(SERIALIZE_ARGUMENT_LIBRARY_.create(arg0Value));
                        this.nativeString0_cache = s1_;
                        this.state_ = state |= 1;
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        Object object2 = this.nativeString(arg0Value, s1_.serialize_);
                        return object2;
                    }
                }
                Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                try {
                    this.exclude_ = exclude |= 1;
                    this.nativeString0_cache = null;
                    state &= 0xFFFFFFFE;
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    object = this.nativeString(arg0Value, (SerializeArgumentLibrary)SERIALIZE_ARGUMENT_LIBRARY_.getUncached(arg0Value));
                }
                catch (Throwable throwable) {
                    NodeUtil.popEncapsulatingNode((Node)prev_);
                    throw throwable;
                }
                NodeUtil.popEncapsulatingNode((Node)prev_);
                return object;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            NativeString0Data s1_;
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0 && ((s1_ = this.nativeString0_cache) == null || s1_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static LibFFIClosure.UnboxStringNode create() {
            return new UnboxStringNodeGen();
        }

        @GeneratedBy(value=LibFFIClosure.UnboxStringNode.class)
        private static final class NativeString0Data
        extends Node {
            @Node.Child
            NativeString0Data next_;
            @Node.Child
            SerializeArgumentLibrary serialize_;

            NativeString0Data(NativeString0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }
}

