// CheckStyle: start generated
package com.oracle.truffle.nfi.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.TruffleLanguage.ContextReference;
import com.oracle.truffle.api.TruffleLanguage.LanguageReference;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.ExplodeLoop.LoopExplosionKind;
import com.oracle.truffle.nfi.impl.LibFFIClosure;
import com.oracle.truffle.nfi.impl.LibFFIType;
import com.oracle.truffle.nfi.impl.NFIContext;
import com.oracle.truffle.nfi.impl.NFILanguageImpl;
import com.oracle.truffle.nfi.impl.NativeArgumentBuffer;
import com.oracle.truffle.nfi.impl.NativeArgumentLibrary;
import com.oracle.truffle.nfi.impl.SerializeArgumentLibrary;
import com.oracle.truffle.nfi.impl.LibFFIType.ClosureType;
import com.oracle.truffle.nfi.impl.LibFFIType.ClosureType.Serialize;
import java.util.concurrent.locks.Lock;

@GeneratedBy(ClosureType.class)
final class ClosureTypeGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    private static final LibraryFactory<SerializeArgumentLibrary> SERIALIZE_ARGUMENT_LIBRARY_ = LibraryFactory.resolve(SerializeArgumentLibrary.class);

    static  {
        LibraryExport.register(ClosureType.class, new NativeArgumentLibraryExports());
    }

    private ClosureTypeGen() {
    }

    @GeneratedBy(ClosureType.class)
    private static final class NativeArgumentLibraryExports extends LibraryExport<NativeArgumentLibrary> {

        private NativeArgumentLibraryExports() {
            super(NativeArgumentLibrary.class, ClosureType.class, false);
        }

        @Override
        protected NativeArgumentLibrary createUncached(Object receiver) {
            assert receiver instanceof ClosureType;
            return new Uncached();
        }

        @Override
        protected NativeArgumentLibrary createCached(Object receiver) {
            assert receiver instanceof ClosureType;
            return new Cached();
        }

        @GeneratedBy(ClosureType.class)
        private static final class Cached extends NativeArgumentLibrary {

            @CompilationFinal private int state_;
            @CompilationFinal private int exclude_;
            @CompilationFinal private ContextReference<NFIContext> nFILanguageImplContextReference_;
            @CompilationFinal private LanguageReference<NFILanguageImpl> nFILanguageImplReference_;
            @Child private SerializeExecutableCachedData serialize_executableCached_cache;
            @Child private InteropLibrary serialize_executableSlowPath0_interop_;
            @Child private SerializePointer0Data serialize_pointer0_cache;

            Cached() {
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof ClosureType) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export 'com.oracle.truffle.nfi.impl.LibFFIType.ClosureType'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof ClosureType;
            }

            @ExplodeLoop(kind = LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
            @Override
            public void serialize(LibFFIType arg0Value_, NativeArgumentBuffer arg1Value, Object arg2Value) throws UnsupportedTypeException {
                assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                ClosureType arg0Value = (ClosureType) arg0Value_;
                int state = state_;
                if ((state & 0b111111) != 0 /* is-active doClosure(ClosureType, NativeArgumentBuffer, LibFFIClosure) || doExecutableCached(ClosureType, NativeArgumentBuffer, Object, Object, InteropLibrary, ContextReference<NFIContext>, LibFFIClosure) || doExecutableSlowPath(ClosureType, NativeArgumentBuffer, Object, ContextReference<NFIContext>, InteropLibrary) || doExecutableSlowPath(ClosureType, NativeArgumentBuffer, Object, ContextReference<NFIContext>, InteropLibrary) || doPointer(ClosureType, NativeArgumentBuffer, Object, InteropLibrary, SerializeArgumentLibrary) || doPointer(ClosureType, NativeArgumentBuffer, Object, InteropLibrary, SerializeArgumentLibrary) */) {
                    if ((state & 0b1) != 0 /* is-active doClosure(ClosureType, NativeArgumentBuffer, LibFFIClosure) */ && arg2Value instanceof LibFFIClosure) {
                        LibFFIClosure arg2Value_ = (LibFFIClosure) arg2Value;
                        Serialize.doClosure(arg0Value, arg1Value, arg2Value_);
                        return;
                    }
                    if ((state & 0b111110) != 0 /* is-active doExecutableCached(ClosureType, NativeArgumentBuffer, Object, Object, InteropLibrary, ContextReference<NFIContext>, LibFFIClosure) || doExecutableSlowPath(ClosureType, NativeArgumentBuffer, Object, ContextReference<NFIContext>, InteropLibrary) || doExecutableSlowPath(ClosureType, NativeArgumentBuffer, Object, ContextReference<NFIContext>, InteropLibrary) || doPointer(ClosureType, NativeArgumentBuffer, Object, InteropLibrary, SerializeArgumentLibrary) || doPointer(ClosureType, NativeArgumentBuffer, Object, InteropLibrary, SerializeArgumentLibrary) */) {
                        if ((state & 0b10) != 0 /* is-active doExecutableCached(ClosureType, NativeArgumentBuffer, Object, Object, InteropLibrary, ContextReference<NFIContext>, LibFFIClosure) */) {
                            SerializeExecutableCachedData s2_ = this.serialize_executableCached_cache;
                            while (s2_ != null) {
                                assert (s2_.interop_.accepts(s2_.cachedValue_));
                                if ((arg2Value == s2_.cachedValue_)) {
                                    assert (Serialize.isOther(s2_.cachedValue_));
                                    assert (s2_.interop_.isExecutable(s2_.cachedValue_));
                                    Serialize.doExecutableCached(arg0Value, arg1Value, arg2Value, s2_.cachedValue_, s2_.interop_, this.nFILanguageImplContextReference_, s2_.cachedClosure_);
                                    return;
                                }
                                s2_ = s2_.next_;
                            }
                        }
                        if ((state & 0b100) != 0 /* is-active doExecutableSlowPath(ClosureType, NativeArgumentBuffer, Object, ContextReference<NFIContext>, InteropLibrary) */) {
                            if ((this.serialize_executableSlowPath0_interop_.accepts(arg2Value)) && (Serialize.isOther(arg2Value)) && (this.serialize_executableSlowPath0_interop_.isExecutable(arg2Value))) {
                                Serialize.doExecutableSlowPath(arg0Value, arg1Value, arg2Value, this.nFILanguageImplContextReference_, this.serialize_executableSlowPath0_interop_);
                                return;
                            }
                        }
                        if ((state & 0b1000) != 0 /* is-active doExecutableSlowPath(ClosureType, NativeArgumentBuffer, Object, ContextReference<NFIContext>, InteropLibrary) */) {
                            if ((Serialize.isOther(arg2Value))) {
                                Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                                try {
                                    if (((INTEROP_LIBRARY_.getUncached(arg2Value)).isExecutable(arg2Value))) {
                                        Serialize.doExecutableSlowPath(arg0Value, arg1Value, arg2Value, this.nFILanguageImplContextReference_, (INTEROP_LIBRARY_.getUncached(arg2Value)));
                                        return;
                                    }
                                } finally {
                                    NodeUtil.popEncapsulatingNode(prev_);
                                }
                            }
                        }
                        if ((state & 0b10000) != 0 /* is-active doPointer(ClosureType, NativeArgumentBuffer, Object, InteropLibrary, SerializeArgumentLibrary) */) {
                            SerializePointer0Data s5_ = this.serialize_pointer0_cache;
                            while (s5_ != null) {
                                if ((s5_.interop_.accepts(arg2Value)) && (s5_.serialize_.accepts(arg2Value)) && (Serialize.isOther(arg2Value)) && (!(s5_.interop_.isExecutable(arg2Value)))) {
                                    Serialize.doPointer(arg0Value, arg1Value, arg2Value, s5_.interop_, s5_.serialize_);
                                    return;
                                }
                                s5_ = s5_.next_;
                            }
                        }
                        if ((state & 0b100000) != 0 /* is-active doPointer(ClosureType, NativeArgumentBuffer, Object, InteropLibrary, SerializeArgumentLibrary) */) {
                            if ((Serialize.isOther(arg2Value))) {
                                Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                                try {
                                    if ((!((INTEROP_LIBRARY_.getUncached(arg2Value)).isExecutable(arg2Value)))) {
                                        Serialize.doPointer(arg0Value, arg1Value, arg2Value, (INTEROP_LIBRARY_.getUncached(arg2Value)), (SERIALIZE_ARGUMENT_LIBRARY_.getUncached(arg2Value)));
                                        return;
                                    }
                                } finally {
                                    NodeUtil.popEncapsulatingNode(prev_);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                serializeAndSpecialize(arg0Value, arg1Value, arg2Value);
                return;
            }

            private void serializeAndSpecialize(ClosureType arg0Value, NativeArgumentBuffer arg1Value, Object arg2Value) throws UnsupportedTypeException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                int exclude = exclude_;
                try {
                    if (arg2Value instanceof LibFFIClosure) {
                        LibFFIClosure arg2Value_ = (LibFFIClosure) arg2Value;
                        this.state_ = state = state | 0b1 /* add-active doClosure(ClosureType, NativeArgumentBuffer, LibFFIClosure) */;
                        lock.unlock();
                        hasLock = false;
                        Serialize.doClosure(arg0Value, arg1Value, arg2Value_);
                        return;
                    }
                    if (((exclude & 0b1)) == 0 /* is-not-excluded doExecutableCached(ClosureType, NativeArgumentBuffer, Object, Object, InteropLibrary, ContextReference<NFIContext>, LibFFIClosure) */) {
                        int count2_ = 0;
                        SerializeExecutableCachedData s2_ = this.serialize_executableCached_cache;
                        if ((state & 0b10) != 0 /* is-active doExecutableCached(ClosureType, NativeArgumentBuffer, Object, Object, InteropLibrary, ContextReference<NFIContext>, LibFFIClosure) */) {
                            while (s2_ != null) {
                                assert (s2_.interop_.accepts(s2_.cachedValue_));
                                if ((arg2Value == s2_.cachedValue_)) {
                                    assert (Serialize.isOther(s2_.cachedValue_));
                                    assert (s2_.interop_.isExecutable(s2_.cachedValue_));
                                    break;
                                }
                                s2_ = s2_.next_;
                                count2_++;
                            }
                        }
                        if (s2_ == null) {
                            {
                                Object cachedValue__ = (arg2Value);
                                // assert (s2_.interop_.accepts(s2_.cachedValue_));
                                // assert (arg2Value == s2_.cachedValue_);
                                if ((Serialize.isOther(cachedValue__))) {
                                    InteropLibrary interop__ = super.insert((INTEROP_LIBRARY_.create(cachedValue__)));
                                    if ((interop__.isExecutable(cachedValue__)) && count2_ < (3)) {
                                        s2_ = super.insert(new SerializeExecutableCachedData(serialize_executableCached_cache));
                                        s2_.cachedValue_ = cachedValue__;
                                        s2_.interop_ = s2_.insertAccessor(interop__);
                                        ContextReference<NFIContext> nFILanguageImplContextReference__ = this.nFILanguageImplContextReference_;
                                        if (nFILanguageImplContextReference__ == null) {
                                            this.nFILanguageImplContextReference_ = nFILanguageImplContextReference__ = super.lookupContextReference(NFILanguageImpl.class);
                                        }
                                        s2_.cachedClosure_ = (LibFFIClosure.create(arg0Value.signature, arg2Value, nFILanguageImplContextReference__));
                                        this.serialize_executableCached_cache = s2_;
                                        this.state_ = state = state | 0b10 /* add-active doExecutableCached(ClosureType, NativeArgumentBuffer, Object, Object, InteropLibrary, ContextReference<NFIContext>, LibFFIClosure) */;
                                    }
                                }
                            }
                        }
                        if (s2_ != null) {
                            lock.unlock();
                            hasLock = false;
                            Serialize.doExecutableCached(arg0Value, arg1Value, arg2Value, s2_.cachedValue_, s2_.interop_, this.nFILanguageImplContextReference_, s2_.cachedClosure_);
                            return;
                        }
                    }
                    if (((exclude & 0b10)) == 0 /* is-not-excluded doExecutableSlowPath(ClosureType, NativeArgumentBuffer, Object, ContextReference<NFIContext>, InteropLibrary) */) {
                        boolean ExecutableSlowPath0_duplicateFound_ = false;
                        if ((state & 0b100) != 0 /* is-active doExecutableSlowPath(ClosureType, NativeArgumentBuffer, Object, ContextReference<NFIContext>, InteropLibrary) */) {
                            if ((this.serialize_executableSlowPath0_interop_.accepts(arg2Value)) && (Serialize.isOther(arg2Value)) && (this.serialize_executableSlowPath0_interop_.isExecutable(arg2Value))) {
                                ExecutableSlowPath0_duplicateFound_ = true;
                            }
                        }
                        if (!ExecutableSlowPath0_duplicateFound_) {
                            if ((Serialize.isOther(arg2Value))) {
                                // assert (this.serialize_executableSlowPath0_interop_.accepts(arg2Value));
                                InteropLibrary serialize_executableSlowPath0_interop__ = super.insert((INTEROP_LIBRARY_.create(arg2Value)));
                                if ((serialize_executableSlowPath0_interop__.isExecutable(arg2Value)) && ((state & 0b100)) == 0 /* is-not-active doExecutableSlowPath(ClosureType, NativeArgumentBuffer, Object, ContextReference<NFIContext>, InteropLibrary) */) {
                                    ContextReference<NFIContext> nFILanguageImplContextReference__ = this.nFILanguageImplContextReference_;
                                    if (nFILanguageImplContextReference__ == null) {
                                        this.nFILanguageImplContextReference_ = nFILanguageImplContextReference__ = super.lookupContextReference(NFILanguageImpl.class);
                                    }
                                    this.serialize_executableSlowPath0_interop_ = super.insert(serialize_executableSlowPath0_interop__);
                                    this.exclude_ = exclude = exclude | 0b1 /* add-excluded doExecutableCached(ClosureType, NativeArgumentBuffer, Object, Object, InteropLibrary, ContextReference<NFIContext>, LibFFIClosure) */;
                                    this.serialize_executableCached_cache = null;
                                    state = state & 0xfffffffd /* remove-active doExecutableCached(ClosureType, NativeArgumentBuffer, Object, Object, InteropLibrary, ContextReference<NFIContext>, LibFFIClosure) */;
                                    this.state_ = state = state | 0b100 /* add-active doExecutableSlowPath(ClosureType, NativeArgumentBuffer, Object, ContextReference<NFIContext>, InteropLibrary) */;
                                    ExecutableSlowPath0_duplicateFound_ = true;
                                }
                            }
                        }
                        if (ExecutableSlowPath0_duplicateFound_) {
                            lock.unlock();
                            hasLock = false;
                            Serialize.doExecutableSlowPath(arg0Value, arg1Value, arg2Value, this.nFILanguageImplContextReference_, this.serialize_executableSlowPath0_interop_);
                            return;
                        }
                    }
                    {
                        Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                        try {
                            if ((Serialize.isOther(arg2Value))) {
                                InteropLibrary serialize_executableSlowPath1_interop__ = (INTEROP_LIBRARY_.getUncached(arg2Value));
                                if ((serialize_executableSlowPath1_interop__.isExecutable(arg2Value))) {
                                    ContextReference<NFIContext> nFILanguageImplContextReference__ = this.nFILanguageImplContextReference_;
                                    if (nFILanguageImplContextReference__ == null) {
                                        this.nFILanguageImplContextReference_ = nFILanguageImplContextReference__ = super.lookupContextReference(NFILanguageImpl.class);
                                    }
                                    this.exclude_ = exclude = exclude | 0b11 /* add-excluded doExecutableCached(ClosureType, NativeArgumentBuffer, Object, Object, InteropLibrary, ContextReference<NFIContext>, LibFFIClosure), doExecutableSlowPath(ClosureType, NativeArgumentBuffer, Object, ContextReference<NFIContext>, InteropLibrary) */;
                                    this.serialize_executableCached_cache = null;
                                    state = state & 0xfffffff9 /* remove-active doExecutableCached(ClosureType, NativeArgumentBuffer, Object, Object, InteropLibrary, ContextReference<NFIContext>, LibFFIClosure), doExecutableSlowPath(ClosureType, NativeArgumentBuffer, Object, ContextReference<NFIContext>, InteropLibrary) */;
                                    this.state_ = state = state | 0b1000 /* add-active doExecutableSlowPath(ClosureType, NativeArgumentBuffer, Object, ContextReference<NFIContext>, InteropLibrary) */;
                                    lock.unlock();
                                    hasLock = false;
                                    Serialize.doExecutableSlowPath(arg0Value, arg1Value, arg2Value, nFILanguageImplContextReference__, serialize_executableSlowPath1_interop__);
                                    return;
                                }
                            }
                        } finally {
                            NodeUtil.popEncapsulatingNode(prev_);
                        }
                    }
                    if (((exclude & 0b100)) == 0 /* is-not-excluded doPointer(ClosureType, NativeArgumentBuffer, Object, InteropLibrary, SerializeArgumentLibrary) */) {
                        int count5_ = 0;
                        SerializePointer0Data s5_ = this.serialize_pointer0_cache;
                        if ((state & 0b10000) != 0 /* is-active doPointer(ClosureType, NativeArgumentBuffer, Object, InteropLibrary, SerializeArgumentLibrary) */) {
                            while (s5_ != null) {
                                if ((s5_.interop_.accepts(arg2Value)) && (s5_.serialize_.accepts(arg2Value)) && (Serialize.isOther(arg2Value)) && (!(s5_.interop_.isExecutable(arg2Value)))) {
                                    break;
                                }
                                s5_ = s5_.next_;
                                count5_++;
                            }
                        }
                        if (s5_ == null) {
                            if ((Serialize.isOther(arg2Value))) {
                                // assert (s5_.interop_.accepts(arg2Value));
                                // assert (s5_.serialize_.accepts(arg2Value));
                                InteropLibrary interop__ = super.insert((INTEROP_LIBRARY_.create(arg2Value)));
                                if ((!(interop__.isExecutable(arg2Value))) && count5_ < (3)) {
                                    s5_ = super.insert(new SerializePointer0Data(serialize_pointer0_cache));
                                    s5_.interop_ = s5_.insertAccessor(interop__);
                                    s5_.serialize_ = s5_.insertAccessor((SERIALIZE_ARGUMENT_LIBRARY_.create(arg2Value)));
                                    this.serialize_pointer0_cache = s5_;
                                    this.state_ = state = state | 0b10000 /* add-active doPointer(ClosureType, NativeArgumentBuffer, Object, InteropLibrary, SerializeArgumentLibrary) */;
                                }
                            }
                        }
                        if (s5_ != null) {
                            lock.unlock();
                            hasLock = false;
                            Serialize.doPointer(arg0Value, arg1Value, arg2Value, s5_.interop_, s5_.serialize_);
                            return;
                        }
                    }
                    {
                        Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                        try {
                            if ((Serialize.isOther(arg2Value))) {
                                InteropLibrary serialize_pointer1_interop__ = (INTEROP_LIBRARY_.getUncached(arg2Value));
                                if ((!(serialize_pointer1_interop__.isExecutable(arg2Value)))) {
                                    this.exclude_ = exclude = exclude | 0b100 /* add-excluded doPointer(ClosureType, NativeArgumentBuffer, Object, InteropLibrary, SerializeArgumentLibrary) */;
                                    this.serialize_pointer0_cache = null;
                                    state = state & 0xffffffef /* remove-active doPointer(ClosureType, NativeArgumentBuffer, Object, InteropLibrary, SerializeArgumentLibrary) */;
                                    this.state_ = state = state | 0b100000 /* add-active doPointer(ClosureType, NativeArgumentBuffer, Object, InteropLibrary, SerializeArgumentLibrary) */;
                                    lock.unlock();
                                    hasLock = false;
                                    Serialize.doPointer(arg0Value, arg1Value, arg2Value, serialize_pointer1_interop__, (SERIALIZE_ARGUMENT_LIBRARY_.getUncached(arg2Value)));
                                    return;
                                }
                            }
                        } finally {
                            NodeUtil.popEncapsulatingNode(prev_);
                        }
                    }
                    throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                int state = state_;
                if ((state & 0b111111) == 0b0) {
                    return NodeCost.UNINITIALIZED;
                } else if (((state & 0b111111) & ((state & 0b111111) - 1)) == 0 /* is-single-active  */) {
                    SerializeExecutableCachedData s2_ = this.serialize_executableCached_cache;
                    SerializePointer0Data s5_ = this.serialize_pointer0_cache;
                    if ((s2_ == null || s2_.next_ == null) && (s5_ == null || s5_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

            @Override
            public Object deserialize(LibFFIType arg0Value_, NativeArgumentBuffer arg1Value) {
                assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                ClosureType arg0Value = (ClosureType) arg0Value_;
                int state = state_;
                if ((state & 0b1000000) != 0 /* is-active deserializeRet(ClosureType, NativeArgumentBuffer, NFILanguageImpl) */) {
                    return arg0Value.deserializeRet(arg1Value, this.nFILanguageImplReference_.get());
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return deserializeRetNode_AndSpecialize(arg0Value, arg1Value);
            }

            private Object deserializeRetNode_AndSpecialize(ClosureType arg0Value, NativeArgumentBuffer arg1Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                try {
                    LanguageReference<NFILanguageImpl> nFILanguageImplReference__ = this.nFILanguageImplReference_;
                    if (nFILanguageImplReference__ == null) {
                        this.nFILanguageImplReference_ = nFILanguageImplReference__ = super.lookupLanguageReference(NFILanguageImpl.class);
                    }
                    this.state_ = state = state | 0b1000000 /* add-active deserializeRet(ClosureType, NativeArgumentBuffer, NFILanguageImpl) */;
                    lock.unlock();
                    hasLock = false;
                    return arg0Value.deserializeRet(arg1Value, nFILanguageImplReference__.get());
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @GeneratedBy(ClosureType.class)
            private static final class SerializeExecutableCachedData extends Node {

                @Child SerializeExecutableCachedData next_;
                @CompilationFinal Object cachedValue_;
                @Child InteropLibrary interop_;
                @CompilationFinal LibFFIClosure cachedClosure_;

                SerializeExecutableCachedData(SerializeExecutableCachedData next_) {
                    this.next_ = next_;
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                <T extends Node> T insertAccessor(T node) {
                    return super.insert(node);
                }

            }
            @GeneratedBy(ClosureType.class)
            private static final class SerializePointer0Data extends Node {

                @Child SerializePointer0Data next_;
                @Child InteropLibrary interop_;
                @Child SerializeArgumentLibrary serialize_;

                SerializePointer0Data(SerializePointer0Data next_) {
                    this.next_ = next_;
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                <T extends Node> T insertAccessor(T node) {
                    return super.insert(node);
                }

            }
        }
        @GeneratedBy(ClosureType.class)
        private static final class Uncached extends NativeArgumentLibrary {

            private final ContextReference<NFIContext> nFILanguageImplContextReference_ = lookupContextReference(NFILanguageImpl.class);
            private final LanguageReference<NFILanguageImpl> nFILanguageImplReference_ = lookupLanguageReference(NFILanguageImpl.class);

            Uncached() {
            }

            @TruffleBoundary
            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof ClosureType) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export 'com.oracle.truffle.nfi.impl.LibFFIType.ClosureType'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof ClosureType;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public void serialize(LibFFIType arg0Value_, NativeArgumentBuffer arg1Value, Object arg2Value) throws UnsupportedTypeException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                ClosureType arg0Value = (ClosureType) arg0Value_;
                if (arg2Value instanceof LibFFIClosure) {
                    LibFFIClosure arg2Value_ = (LibFFIClosure) arg2Value;
                    Serialize.doClosure(arg0Value, arg1Value, arg2Value_);
                    return;
                }
                if ((Serialize.isOther(arg2Value)) && ((INTEROP_LIBRARY_.getUncached(arg2Value)).isExecutable(arg2Value))) {
                    Serialize.doExecutableSlowPath(arg0Value, arg1Value, arg2Value, this.nFILanguageImplContextReference_, (INTEROP_LIBRARY_.getUncached(arg2Value)));
                    return;
                }
                if ((Serialize.isOther(arg2Value)) && (!((INTEROP_LIBRARY_.getUncached(arg2Value)).isExecutable(arg2Value)))) {
                    Serialize.doPointer(arg0Value, arg1Value, arg2Value, (INTEROP_LIBRARY_.getUncached(arg2Value)), (SERIALIZE_ARGUMENT_LIBRARY_.getUncached(arg2Value)));
                    return;
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
            }

            @TruffleBoundary
            @Override
            public Object deserialize(LibFFIType arg0Value_, NativeArgumentBuffer arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                ClosureType arg0Value = (ClosureType) arg0Value_;
                return arg0Value.deserializeRet(arg1Value, this.nFILanguageImplReference_.get());
            }

        }
    }
}
