// CheckStyle: start generated
package com.oracle.truffle.nfi.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.nfi.impl.NativeArgumentBuffer;
import com.oracle.truffle.nfi.impl.SerializeArgumentLibrary;
import com.oracle.truffle.nfi.impl.SerializeArgumentLibrary.CharConversion;
import java.util.concurrent.locks.Lock;

@GeneratedBy(CharConversion.class)
final class CharConversionGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<SerializeArgumentLibrary> SERIALIZE_ARGUMENT_LIBRARY_ = LibraryFactory.resolve(SerializeArgumentLibrary.class);

    static  {
        LibraryExport.register(CharConversion.class, new SerializeArgumentLibraryExports());
    }

    private CharConversionGen() {
    }

    @GeneratedBy(CharConversion.class)
    private static final class SerializeArgumentLibraryExports extends LibraryExport<SerializeArgumentLibrary> {

        private SerializeArgumentLibraryExports() {
            super(SerializeArgumentLibrary.class, Character.class, true);
        }

        @Override
        protected SerializeArgumentLibrary createUncached(Object receiver) {
            assert receiver instanceof Character;
            return new Uncached();
        }

        @Override
        protected SerializeArgumentLibrary createCached(Object receiver) {
            assert receiver instanceof Character;
            return new Cached();
        }

        @GeneratedBy(CharConversion.class)
        private static final class Cached extends SerializeArgumentLibrary {

            @CompilationFinal private int state_;
            @Child private SerializeArgumentLibrary putByteNode__serialize_;
            @Child private SerializeArgumentLibrary putUByteNode__serialize_;
            @Child private SerializeArgumentLibrary putShortNode__serialize_;
            @Child private SerializeArgumentLibrary putUShortNode__serialize_;
            @Child private SerializeArgumentLibrary putIntNode__serialize_;
            @Child private SerializeArgumentLibrary putUIntNode__serialize_;
            @Child private SerializeArgumentLibrary putLongNode__serialize_;
            @Child private SerializeArgumentLibrary putULongNode__serialize_;
            @Child private SerializeArgumentLibrary putFloatNode__serialize_;
            @Child private SerializeArgumentLibrary putDoubleNode__serialize_;

            Cached() {
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof Character) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export 'com.oracle.truffle.nfi.impl.SerializeArgumentLibrary.CharConversion'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof Character;
            }

            @Override
            public void putByte(Object arg0Value_, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                Character arg0Value = (Character) arg0Value_;
                int state = state_;
                if ((state & 0b1) != 0 /* is-active putByte(Character, NativeArgumentBuffer, SerializeArgumentLibrary) */) {
                    assert (this.putByteNode__serialize_.accepts(CharConversion.zero()));
                    CharConversion.putByte(arg0Value, arg1Value, this.putByteNode__serialize_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                putByteNode_AndSpecialize(arg0Value, arg1Value);
                return;
            }

            private void putByteNode_AndSpecialize(Character arg0Value, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                try {
                    // assert (this.putByteNode__serialize_.accepts(CharConversion.zero()));
                    this.putByteNode__serialize_ = super.insert((SERIALIZE_ARGUMENT_LIBRARY_.create(CharConversion.zero())));
                    this.state_ = state = state | 0b1 /* add-active putByte(Character, NativeArgumentBuffer, SerializeArgumentLibrary) */;
                    lock.unlock();
                    hasLock = false;
                    CharConversion.putByte(arg0Value, arg1Value, this.putByteNode__serialize_);
                    return;
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                int state = state_;
                if ((state & 0b1) == 0b0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

            @Override
            public void putUByte(Object arg0Value_, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                Character arg0Value = (Character) arg0Value_;
                int state = state_;
                if ((state & 0b10) != 0 /* is-active putUByte(Character, NativeArgumentBuffer, SerializeArgumentLibrary) */) {
                    assert (this.putUByteNode__serialize_.accepts(CharConversion.zero()));
                    CharConversion.putUByte(arg0Value, arg1Value, this.putUByteNode__serialize_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                putUByteNode_AndSpecialize(arg0Value, arg1Value);
                return;
            }

            private void putUByteNode_AndSpecialize(Character arg0Value, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                try {
                    // assert (this.putUByteNode__serialize_.accepts(CharConversion.zero()));
                    this.putUByteNode__serialize_ = super.insert((SERIALIZE_ARGUMENT_LIBRARY_.create(CharConversion.zero())));
                    this.state_ = state = state | 0b10 /* add-active putUByte(Character, NativeArgumentBuffer, SerializeArgumentLibrary) */;
                    lock.unlock();
                    hasLock = false;
                    CharConversion.putUByte(arg0Value, arg1Value, this.putUByteNode__serialize_);
                    return;
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void putShort(Object arg0Value_, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                Character arg0Value = (Character) arg0Value_;
                int state = state_;
                if ((state & 0b100) != 0 /* is-active putShort(Character, NativeArgumentBuffer, SerializeArgumentLibrary) */) {
                    assert (this.putShortNode__serialize_.accepts(CharConversion.zero()));
                    CharConversion.putShort(arg0Value, arg1Value, this.putShortNode__serialize_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                putShortNode_AndSpecialize(arg0Value, arg1Value);
                return;
            }

            private void putShortNode_AndSpecialize(Character arg0Value, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                try {
                    // assert (this.putShortNode__serialize_.accepts(CharConversion.zero()));
                    this.putShortNode__serialize_ = super.insert((SERIALIZE_ARGUMENT_LIBRARY_.create(CharConversion.zero())));
                    this.state_ = state = state | 0b100 /* add-active putShort(Character, NativeArgumentBuffer, SerializeArgumentLibrary) */;
                    lock.unlock();
                    hasLock = false;
                    CharConversion.putShort(arg0Value, arg1Value, this.putShortNode__serialize_);
                    return;
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void putUShort(Object arg0Value_, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                Character arg0Value = (Character) arg0Value_;
                int state = state_;
                if ((state & 0b1000) != 0 /* is-active putUShort(Character, NativeArgumentBuffer, SerializeArgumentLibrary) */) {
                    assert (this.putUShortNode__serialize_.accepts(CharConversion.zero()));
                    CharConversion.putUShort(arg0Value, arg1Value, this.putUShortNode__serialize_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                putUShortNode_AndSpecialize(arg0Value, arg1Value);
                return;
            }

            private void putUShortNode_AndSpecialize(Character arg0Value, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                try {
                    // assert (this.putUShortNode__serialize_.accepts(CharConversion.zero()));
                    this.putUShortNode__serialize_ = super.insert((SERIALIZE_ARGUMENT_LIBRARY_.create(CharConversion.zero())));
                    this.state_ = state = state | 0b1000 /* add-active putUShort(Character, NativeArgumentBuffer, SerializeArgumentLibrary) */;
                    lock.unlock();
                    hasLock = false;
                    CharConversion.putUShort(arg0Value, arg1Value, this.putUShortNode__serialize_);
                    return;
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void putInt(Object arg0Value_, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                Character arg0Value = (Character) arg0Value_;
                int state = state_;
                if ((state & 0b10000) != 0 /* is-active putInt(Character, NativeArgumentBuffer, SerializeArgumentLibrary) */) {
                    assert (this.putIntNode__serialize_.accepts(CharConversion.zero()));
                    CharConversion.putInt(arg0Value, arg1Value, this.putIntNode__serialize_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                putIntNode_AndSpecialize(arg0Value, arg1Value);
                return;
            }

            private void putIntNode_AndSpecialize(Character arg0Value, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                try {
                    // assert (this.putIntNode__serialize_.accepts(CharConversion.zero()));
                    this.putIntNode__serialize_ = super.insert((SERIALIZE_ARGUMENT_LIBRARY_.create(CharConversion.zero())));
                    this.state_ = state = state | 0b10000 /* add-active putInt(Character, NativeArgumentBuffer, SerializeArgumentLibrary) */;
                    lock.unlock();
                    hasLock = false;
                    CharConversion.putInt(arg0Value, arg1Value, this.putIntNode__serialize_);
                    return;
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void putUInt(Object arg0Value_, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                Character arg0Value = (Character) arg0Value_;
                int state = state_;
                if ((state & 0b100000) != 0 /* is-active putUInt(Character, NativeArgumentBuffer, SerializeArgumentLibrary) */) {
                    assert (this.putUIntNode__serialize_.accepts(CharConversion.zero()));
                    CharConversion.putUInt(arg0Value, arg1Value, this.putUIntNode__serialize_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                putUIntNode_AndSpecialize(arg0Value, arg1Value);
                return;
            }

            private void putUIntNode_AndSpecialize(Character arg0Value, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                try {
                    // assert (this.putUIntNode__serialize_.accepts(CharConversion.zero()));
                    this.putUIntNode__serialize_ = super.insert((SERIALIZE_ARGUMENT_LIBRARY_.create(CharConversion.zero())));
                    this.state_ = state = state | 0b100000 /* add-active putUInt(Character, NativeArgumentBuffer, SerializeArgumentLibrary) */;
                    lock.unlock();
                    hasLock = false;
                    CharConversion.putUInt(arg0Value, arg1Value, this.putUIntNode__serialize_);
                    return;
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void putLong(Object arg0Value_, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                Character arg0Value = (Character) arg0Value_;
                int state = state_;
                if ((state & 0b1000000) != 0 /* is-active putLong(Character, NativeArgumentBuffer, SerializeArgumentLibrary) */) {
                    assert (this.putLongNode__serialize_.accepts(CharConversion.zero()));
                    CharConversion.putLong(arg0Value, arg1Value, this.putLongNode__serialize_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                putLongNode_AndSpecialize(arg0Value, arg1Value);
                return;
            }

            private void putLongNode_AndSpecialize(Character arg0Value, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                try {
                    // assert (this.putLongNode__serialize_.accepts(CharConversion.zero()));
                    this.putLongNode__serialize_ = super.insert((SERIALIZE_ARGUMENT_LIBRARY_.create(CharConversion.zero())));
                    this.state_ = state = state | 0b1000000 /* add-active putLong(Character, NativeArgumentBuffer, SerializeArgumentLibrary) */;
                    lock.unlock();
                    hasLock = false;
                    CharConversion.putLong(arg0Value, arg1Value, this.putLongNode__serialize_);
                    return;
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void putULong(Object arg0Value_, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                Character arg0Value = (Character) arg0Value_;
                int state = state_;
                if ((state & 0b10000000) != 0 /* is-active putULong(Character, NativeArgumentBuffer, SerializeArgumentLibrary) */) {
                    assert (this.putULongNode__serialize_.accepts(CharConversion.zero()));
                    CharConversion.putULong(arg0Value, arg1Value, this.putULongNode__serialize_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                putULongNode_AndSpecialize(arg0Value, arg1Value);
                return;
            }

            private void putULongNode_AndSpecialize(Character arg0Value, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                try {
                    // assert (this.putULongNode__serialize_.accepts(CharConversion.zero()));
                    this.putULongNode__serialize_ = super.insert((SERIALIZE_ARGUMENT_LIBRARY_.create(CharConversion.zero())));
                    this.state_ = state = state | 0b10000000 /* add-active putULong(Character, NativeArgumentBuffer, SerializeArgumentLibrary) */;
                    lock.unlock();
                    hasLock = false;
                    CharConversion.putULong(arg0Value, arg1Value, this.putULongNode__serialize_);
                    return;
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void putFloat(Object arg0Value_, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                Character arg0Value = (Character) arg0Value_;
                int state = state_;
                if ((state & 0b100000000) != 0 /* is-active putFloat(Character, NativeArgumentBuffer, SerializeArgumentLibrary) */) {
                    assert (this.putFloatNode__serialize_.accepts(CharConversion.zero()));
                    CharConversion.putFloat(arg0Value, arg1Value, this.putFloatNode__serialize_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                putFloatNode_AndSpecialize(arg0Value, arg1Value);
                return;
            }

            private void putFloatNode_AndSpecialize(Character arg0Value, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                try {
                    // assert (this.putFloatNode__serialize_.accepts(CharConversion.zero()));
                    this.putFloatNode__serialize_ = super.insert((SERIALIZE_ARGUMENT_LIBRARY_.create(CharConversion.zero())));
                    this.state_ = state = state | 0b100000000 /* add-active putFloat(Character, NativeArgumentBuffer, SerializeArgumentLibrary) */;
                    lock.unlock();
                    hasLock = false;
                    CharConversion.putFloat(arg0Value, arg1Value, this.putFloatNode__serialize_);
                    return;
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void putDouble(Object arg0Value_, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                Character arg0Value = (Character) arg0Value_;
                int state = state_;
                if ((state & 0b1000000000) != 0 /* is-active putDouble(Character, NativeArgumentBuffer, SerializeArgumentLibrary) */) {
                    assert (this.putDoubleNode__serialize_.accepts(CharConversion.zero()));
                    CharConversion.putDouble(arg0Value, arg1Value, this.putDoubleNode__serialize_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                putDoubleNode_AndSpecialize(arg0Value, arg1Value);
                return;
            }

            private void putDoubleNode_AndSpecialize(Character arg0Value, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                try {
                    // assert (this.putDoubleNode__serialize_.accepts(CharConversion.zero()));
                    this.putDoubleNode__serialize_ = super.insert((SERIALIZE_ARGUMENT_LIBRARY_.create(CharConversion.zero())));
                    this.state_ = state = state | 0b1000000000 /* add-active putDouble(Character, NativeArgumentBuffer, SerializeArgumentLibrary) */;
                    lock.unlock();
                    hasLock = false;
                    CharConversion.putDouble(arg0Value, arg1Value, this.putDoubleNode__serialize_);
                    return;
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

        }
        @GeneratedBy(CharConversion.class)
        private static final class Uncached extends SerializeArgumentLibrary {

            Uncached() {
            }

            @TruffleBoundary
            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof Character) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export 'com.oracle.truffle.nfi.impl.SerializeArgumentLibrary.CharConversion'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof Character;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public void putByte(Object arg0Value_, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                Character arg0Value = (Character) arg0Value_;
                // assert ((SERIALIZE_ARGUMENT_LIBRARY_.getUncached(CharConversion.zero())).accepts(CharConversion.zero()));
                CharConversion.putByte(arg0Value, arg1Value, (SERIALIZE_ARGUMENT_LIBRARY_.getUncached(CharConversion.zero())));
                return;
            }

            @TruffleBoundary
            @Override
            public void putUByte(Object arg0Value_, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                Character arg0Value = (Character) arg0Value_;
                // assert ((SERIALIZE_ARGUMENT_LIBRARY_.getUncached(CharConversion.zero())).accepts(CharConversion.zero()));
                CharConversion.putUByte(arg0Value, arg1Value, (SERIALIZE_ARGUMENT_LIBRARY_.getUncached(CharConversion.zero())));
                return;
            }

            @TruffleBoundary
            @Override
            public void putShort(Object arg0Value_, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                Character arg0Value = (Character) arg0Value_;
                // assert ((SERIALIZE_ARGUMENT_LIBRARY_.getUncached(CharConversion.zero())).accepts(CharConversion.zero()));
                CharConversion.putShort(arg0Value, arg1Value, (SERIALIZE_ARGUMENT_LIBRARY_.getUncached(CharConversion.zero())));
                return;
            }

            @TruffleBoundary
            @Override
            public void putUShort(Object arg0Value_, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                Character arg0Value = (Character) arg0Value_;
                // assert ((SERIALIZE_ARGUMENT_LIBRARY_.getUncached(CharConversion.zero())).accepts(CharConversion.zero()));
                CharConversion.putUShort(arg0Value, arg1Value, (SERIALIZE_ARGUMENT_LIBRARY_.getUncached(CharConversion.zero())));
                return;
            }

            @TruffleBoundary
            @Override
            public void putInt(Object arg0Value_, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                Character arg0Value = (Character) arg0Value_;
                // assert ((SERIALIZE_ARGUMENT_LIBRARY_.getUncached(CharConversion.zero())).accepts(CharConversion.zero()));
                CharConversion.putInt(arg0Value, arg1Value, (SERIALIZE_ARGUMENT_LIBRARY_.getUncached(CharConversion.zero())));
                return;
            }

            @TruffleBoundary
            @Override
            public void putUInt(Object arg0Value_, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                Character arg0Value = (Character) arg0Value_;
                // assert ((SERIALIZE_ARGUMENT_LIBRARY_.getUncached(CharConversion.zero())).accepts(CharConversion.zero()));
                CharConversion.putUInt(arg0Value, arg1Value, (SERIALIZE_ARGUMENT_LIBRARY_.getUncached(CharConversion.zero())));
                return;
            }

            @TruffleBoundary
            @Override
            public void putLong(Object arg0Value_, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                Character arg0Value = (Character) arg0Value_;
                // assert ((SERIALIZE_ARGUMENT_LIBRARY_.getUncached(CharConversion.zero())).accepts(CharConversion.zero()));
                CharConversion.putLong(arg0Value, arg1Value, (SERIALIZE_ARGUMENT_LIBRARY_.getUncached(CharConversion.zero())));
                return;
            }

            @TruffleBoundary
            @Override
            public void putULong(Object arg0Value_, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                Character arg0Value = (Character) arg0Value_;
                // assert ((SERIALIZE_ARGUMENT_LIBRARY_.getUncached(CharConversion.zero())).accepts(CharConversion.zero()));
                CharConversion.putULong(arg0Value, arg1Value, (SERIALIZE_ARGUMENT_LIBRARY_.getUncached(CharConversion.zero())));
                return;
            }

            @TruffleBoundary
            @Override
            public void putFloat(Object arg0Value_, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                Character arg0Value = (Character) arg0Value_;
                // assert ((SERIALIZE_ARGUMENT_LIBRARY_.getUncached(CharConversion.zero())).accepts(CharConversion.zero()));
                CharConversion.putFloat(arg0Value, arg1Value, (SERIALIZE_ARGUMENT_LIBRARY_.getUncached(CharConversion.zero())));
                return;
            }

            @TruffleBoundary
            @Override
            public void putDouble(Object arg0Value_, NativeArgumentBuffer arg1Value) throws UnsupportedTypeException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                Character arg0Value = (Character) arg0Value_;
                // assert ((SERIALIZE_ARGUMENT_LIBRARY_.getUncached(CharConversion.zero())).accepts(CharConversion.zero()));
                CharConversion.putDouble(arg0Value, arg1Value, (SERIALIZE_ARGUMENT_LIBRARY_.getUncached(CharConversion.zero())));
                return;
            }

        }
    }
}
