// CheckStyle: start generated
package com.oracle.truffle.nfi.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.ExplodeLoop.LoopExplosionKind;
import com.oracle.truffle.nfi.impl.TypeConversion.AsPointerNode;
import com.oracle.truffle.nfi.impl.TypeConversion.AsStringNode;
import java.util.concurrent.locks.Lock;

@GeneratedBy(TypeConversion.class)
final class TypeConversionFactory {

    @GeneratedBy(AsPointerNode.class)
    static final class AsPointerNodeGen extends AsPointerNode {

        @CompilationFinal private int state_;
        @CompilationFinal private int exclude_;
        @Child private SerializePointerData serializePointer_cache;
        @Child private NullAsPointerData nullAsPointer_cache;
        @Child private TransitionToNativeData transitionToNative_cache;

        private AsPointerNodeGen() {
        }

        @ExplodeLoop(kind = LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        @Override
        NativePointer execute(TruffleObject arg0Value) {
            int state = state_;
            if (state != 0 /* is-active serializePointer(TruffleObject, Node, Node) || nullAsPointer(TruffleObject, Node) || transitionToNative(TruffleObject, Node, Node, Node) */) {
                if ((state & 0b1) != 0 /* is-active serializePointer(TruffleObject, Node, Node) */) {
                    SerializePointerData s1_ = this.serializePointer_cache;
                    while (s1_ != null) {
                        if ((AsPointerNode.checkIsPointer(s1_.isPointer_, arg0Value))) {
                            return serializePointer(arg0Value, s1_.isPointer_, s1_.asPointer_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 0b10) != 0 /* is-active nullAsPointer(TruffleObject, Node) */) {
                    NullAsPointerData s2_ = this.nullAsPointer_cache;
                    while (s2_ != null) {
                        if ((TypeConversion.checkNull(s2_.isNull_, arg0Value))) {
                            return nullAsPointer(arg0Value, s2_.isNull_);
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state & 0b100) != 0 /* is-active transitionToNative(TruffleObject, Node, Node, Node) */) {
                    TransitionToNativeData s3_ = this.transitionToNative_cache;
                    while (s3_ != null) {
                        if ((!(TypeConversion.checkNull(s3_.isNull_, arg0Value)))) {
                            return transitionToNative(arg0Value, s3_.isNull_, s3_.toNative_, s3_.asPointer_);
                        }
                        s3_ = s3_.next_;
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value);
        }

        private NativePointer executeAndSpecialize(TruffleObject arg0Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            int exclude = exclude_;
            try {
                if ((exclude) == 0 /* is-not-excluded serializePointer(TruffleObject, Node, Node) */) {
                    int count1_ = 0;
                    SerializePointerData s1_ = this.serializePointer_cache;
                    if ((state & 0b1) != 0 /* is-active serializePointer(TruffleObject, Node, Node) */) {
                        while (s1_ != null) {
                            if ((AsPointerNode.checkIsPointer(s1_.isPointer_, arg0Value))) {
                                break;
                            }
                            s1_ = s1_.next_;
                            count1_++;
                        }
                    }
                    if (s1_ == null) {
                        {
                            Node isPointer__ = (AsPointerNode.createIsPointer());
                            if ((AsPointerNode.checkIsPointer(isPointer__, arg0Value)) && count1_ < (3)) {
                                s1_ = new SerializePointerData(serializePointer_cache);
                                s1_.isPointer_ = isPointer__;
                                s1_.asPointer_ = (AsPointerNode.createAsPointer());
                                this.serializePointer_cache = super.insert(s1_);
                                this.state_ = state = state | 0b1 /* add-active serializePointer(TruffleObject, Node, Node) */;
                            }
                        }
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return serializePointer(arg0Value, s1_.isPointer_, s1_.asPointer_);
                    }
                }
                int count2_ = 0;
                NullAsPointerData s2_ = this.nullAsPointer_cache;
                if ((state & 0b10) != 0 /* is-active nullAsPointer(TruffleObject, Node) */) {
                    while (s2_ != null) {
                        if ((TypeConversion.checkNull(s2_.isNull_, arg0Value))) {
                            break;
                        }
                        s2_ = s2_.next_;
                        count2_++;
                    }
                }
                if (s2_ == null) {
                    {
                        Node isNull__ = (TypeConversion.createIsNull());
                        if ((TypeConversion.checkNull(isNull__, arg0Value)) && count2_ < (3)) {
                            s2_ = new NullAsPointerData(nullAsPointer_cache);
                            s2_.isNull_ = isNull__;
                            this.nullAsPointer_cache = super.insert(s2_);
                            this.state_ = state = state | 0b10 /* add-active nullAsPointer(TruffleObject, Node) */;
                        }
                    }
                }
                if (s2_ != null) {
                    lock.unlock();
                    hasLock = false;
                    return nullAsPointer(arg0Value, s2_.isNull_);
                }
                int count3_ = 0;
                TransitionToNativeData s3_ = this.transitionToNative_cache;
                if ((state & 0b100) != 0 /* is-active transitionToNative(TruffleObject, Node, Node, Node) */) {
                    while (s3_ != null) {
                        if ((!(TypeConversion.checkNull(s3_.isNull_, arg0Value)))) {
                            break;
                        }
                        s3_ = s3_.next_;
                        count3_++;
                    }
                }
                if (s3_ == null) {
                    {
                        Node isNull__ = (TypeConversion.createIsNull());
                        if ((!(TypeConversion.checkNull(isNull__, arg0Value))) && count3_ < (3)) {
                            s3_ = new TransitionToNativeData(transitionToNative_cache);
                            s3_.isNull_ = isNull__;
                            s3_.toNative_ = (AsPointerNode.createToNative());
                            s3_.asPointer_ = (AsPointerNode.createAsPointer());
                            this.transitionToNative_cache = super.insert(s3_);
                            this.exclude_ = exclude = exclude | 0b1 /* add-excluded serializePointer(TruffleObject, Node, Node) */;
                            this.serializePointer_cache = null;
                            state = state & 0xfffffffe /* remove-active serializePointer(TruffleObject, Node, Node) */;
                            this.state_ = state = state | 0b100 /* add-active transitionToNative(TruffleObject, Node, Node, Node) */;
                        }
                    }
                }
                if (s3_ != null) {
                    lock.unlock();
                    hasLock = false;
                    return transitionToNative(arg0Value, s3_.isNull_, s3_.toNative_, s3_.asPointer_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                SerializePointerData s1_ = this.serializePointer_cache;
                NullAsPointerData s2_ = this.nullAsPointer_cache;
                TransitionToNativeData s3_ = this.transitionToNative_cache;
                if ((s1_ == null || s1_.next_ == null) && (s2_ == null || s2_.next_ == null) && (s3_ == null || s3_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static AsPointerNode create() {
            return new AsPointerNodeGen();
        }

        @GeneratedBy(AsPointerNode.class)
        private static final class SerializePointerData extends Node {

            @Child SerializePointerData next_;
            @Child Node isPointer_;
            @Child Node asPointer_;

            SerializePointerData(SerializePointerData next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(AsPointerNode.class)
        private static final class NullAsPointerData extends Node {

            @Child NullAsPointerData next_;
            @Child Node isNull_;

            NullAsPointerData(NullAsPointerData next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(AsPointerNode.class)
        private static final class TransitionToNativeData extends Node {

            @Child TransitionToNativeData next_;
            @Child Node isNull_;
            @Child Node toNative_;
            @Child Node asPointer_;

            TransitionToNativeData(TransitionToNativeData next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
    }
    @GeneratedBy(AsStringNode.class)
    static final class AsStringNodeGen extends AsStringNode {

        @CompilationFinal private int state_;
        @Child private NullAsStringData nullAsString_cache;
        @Child private BoxedAsStringData boxedAsString_cache;

        private AsStringNodeGen(boolean acceptAnything) {
            super(acceptAnything);
        }

        @ExplodeLoop(kind = LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        @Override
        String execute(Object arg0Value) {
            int state = state_;
            if ((state & 0b1) != 0 /* is-active stringAsString(String) */ && arg0Value instanceof String) {
                String arg0Value_ = (String) arg0Value;
                return stringAsString(arg0Value_);
            }
            if ((state & 0b110) != 0 /* is-active nullAsString(TruffleObject, Node) || boxedAsString(TruffleObject, Node, Node, AsStringNode) */ && arg0Value instanceof TruffleObject) {
                TruffleObject arg0Value_ = (TruffleObject) arg0Value;
                if ((state & 0b10) != 0 /* is-active nullAsString(TruffleObject, Node) */) {
                    NullAsStringData s2_ = this.nullAsString_cache;
                    while (s2_ != null) {
                        if ((TypeConversion.checkNull(s2_.isNull_, arg0Value_))) {
                            return nullAsString(arg0Value_, s2_.isNull_);
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state & 0b100) != 0 /* is-active boxedAsString(TruffleObject, Node, Node, AsStringNode) */) {
                    BoxedAsStringData s3_ = this.boxedAsString_cache;
                    while (s3_ != null) {
                        if ((AsStringNode.checkIsBoxed(s3_.isBoxed_, arg0Value_))) {
                            return boxedAsString(arg0Value_, s3_.isBoxed_, s3_.unbox_, s3_.asString_);
                        }
                        s3_ = s3_.next_;
                    }
                }
            }
            if ((state & 0b1000) != 0 /* is-active otherAsString(Object) */) {
                assert (acceptAnything);
                if ((AsStringNode.isOther(arg0Value))) {
                    return otherAsString(arg0Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value);
        }

        private String executeAndSpecialize(Object arg0Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            try {
                if (arg0Value instanceof String) {
                    String arg0Value_ = (String) arg0Value;
                    this.state_ = state = state | 0b1 /* add-active stringAsString(String) */;
                    lock.unlock();
                    hasLock = false;
                    return stringAsString(arg0Value_);
                }
                if (arg0Value instanceof TruffleObject) {
                    TruffleObject arg0Value_ = (TruffleObject) arg0Value;
                    int count2_ = 0;
                    NullAsStringData s2_ = this.nullAsString_cache;
                    if ((state & 0b10) != 0 /* is-active nullAsString(TruffleObject, Node) */) {
                        while (s2_ != null) {
                            if ((TypeConversion.checkNull(s2_.isNull_, arg0Value_))) {
                                break;
                            }
                            s2_ = s2_.next_;
                            count2_++;
                        }
                    }
                    if (s2_ == null) {
                        {
                            Node isNull__ = (TypeConversion.createIsNull());
                            if ((TypeConversion.checkNull(isNull__, arg0Value_)) && count2_ < (3)) {
                                s2_ = new NullAsStringData(nullAsString_cache);
                                s2_.isNull_ = isNull__;
                                this.nullAsString_cache = super.insert(s2_);
                                this.state_ = state = state | 0b10 /* add-active nullAsString(TruffleObject, Node) */;
                            }
                        }
                    }
                    if (s2_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return nullAsString(arg0Value_, s2_.isNull_);
                    }
                    int count3_ = 0;
                    BoxedAsStringData s3_ = this.boxedAsString_cache;
                    if ((state & 0b100) != 0 /* is-active boxedAsString(TruffleObject, Node, Node, AsStringNode) */) {
                        while (s3_ != null) {
                            if ((AsStringNode.checkIsBoxed(s3_.isBoxed_, arg0Value_))) {
                                break;
                            }
                            s3_ = s3_.next_;
                            count3_++;
                        }
                    }
                    if (s3_ == null) {
                        {
                            Node isBoxed__ = (AsStringNode.createIsBoxed());
                            if ((AsStringNode.checkIsBoxed(isBoxed__, arg0Value_)) && count3_ < (3)) {
                                s3_ = new BoxedAsStringData(boxedAsString_cache);
                                s3_.isBoxed_ = isBoxed__;
                                s3_.unbox_ = (AsStringNode.createUnbox());
                                s3_.asString_ = (createRecursive());
                                this.boxedAsString_cache = super.insert(s3_);
                                this.state_ = state = state | 0b100 /* add-active boxedAsString(TruffleObject, Node, Node, AsStringNode) */;
                            }
                        }
                    }
                    if (s3_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return boxedAsString(arg0Value_, s3_.isBoxed_, s3_.unbox_, s3_.asString_);
                    }
                }
                if ((acceptAnything) && (AsStringNode.isOther(arg0Value))) {
                    this.state_ = state = state | 0b1000 /* add-active otherAsString(Object) */;
                    lock.unlock();
                    hasLock = false;
                    return otherAsString(arg0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                NullAsStringData s2_ = this.nullAsString_cache;
                BoxedAsStringData s3_ = this.boxedAsString_cache;
                if ((s2_ == null || s2_.next_ == null) && (s3_ == null || s3_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static AsStringNode create(boolean acceptAnything) {
            return new AsStringNodeGen(acceptAnything);
        }

        @GeneratedBy(AsStringNode.class)
        private static final class NullAsStringData extends Node {

            @Child NullAsStringData next_;
            @Child Node isNull_;

            NullAsStringData(NullAsStringData next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(AsStringNode.class)
        private static final class BoxedAsStringData extends Node {

            @Child BoxedAsStringData next_;
            @Child Node isBoxed_;
            @Child Node unbox_;
            @Child AsStringNode asString_;

            BoxedAsStringData(BoxedAsStringData next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
    }
}
