// CheckStyle: start generated
package com.oracle.truffle.nfi.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.nfi.impl.NativePointerMessageResolutionForeign.AsNativePointerSubNode;
import com.oracle.truffle.nfi.impl.NativePointerMessageResolutionForeign.BindSubNode;
import com.oracle.truffle.nfi.impl.NativePointerMessageResolutionForeign.CanResolveNativePointerSubNode;
import com.oracle.truffle.nfi.impl.NativePointerMessageResolutionForeign.IsBoxedNativePointerSubNode;
import com.oracle.truffle.nfi.impl.NativePointerMessageResolutionForeign.IsNativePointerSubNode;
import com.oracle.truffle.nfi.impl.NativePointerMessageResolutionForeign.IsNullNativePointerSubNode;
import com.oracle.truffle.nfi.impl.NativePointerMessageResolutionForeign.NativePointerKeyInfoSubNode;
import com.oracle.truffle.nfi.impl.NativePointerMessageResolutionForeign.NativePointerKeysSubNode;
import com.oracle.truffle.nfi.impl.NativePointerMessageResolutionForeign.ToNativePointerSubNode;
import com.oracle.truffle.nfi.impl.NativePointerMessageResolutionForeign.UnboxNativePointerSubNode;
import java.util.concurrent.locks.Lock;

@GeneratedBy(NativePointerMessageResolutionForeign.class)
final class NativePointerMessageResolutionForeignFactory {

    @GeneratedBy(BindSubNode.class)
    static final class BindSubNodeGen extends BindSubNode {

        @CompilationFinal private int state_;

        private BindSubNodeGen() {
        }

        @Override
        public Object executeWithTarget(VirtualFrame frameValue, Object arg0Value, Object arg1Value, Object arg2Value) {
            int state = state_;
            if (state != 0 /* is-active accessWithTarget(NativePointer, String, Object[]) */ && arg0Value instanceof NativePointer) {
                NativePointer arg0Value_ = (NativePointer) arg0Value;
                if (arg1Value instanceof String) {
                    String arg1Value_ = (String) arg1Value;
                    if (arg2Value instanceof Object[]) {
                        Object[] arg2Value_ = (Object[]) arg2Value;
                        return accessWithTarget(arg0Value_, arg1Value_, arg2Value_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }

        private Object executeAndSpecialize(Object arg0Value, Object arg1Value, Object arg2Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            try {
                if (arg0Value instanceof NativePointer) {
                    NativePointer arg0Value_ = (NativePointer) arg0Value;
                    if (arg1Value instanceof String) {
                        String arg1Value_ = (String) arg1Value;
                        if (arg2Value instanceof Object[]) {
                            Object[] arg2Value_ = (Object[]) arg2Value;
                            this.state_ = state = state | 0b1 /* add-active accessWithTarget(NativePointer, String, Object[]) */;
                            lock.unlock();
                            hasLock = false;
                            return accessWithTarget(arg0Value_, arg1Value_, arg2Value_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static BindSubNode create() {
            return new BindSubNodeGen();
        }

    }
    @GeneratedBy(NativePointerKeyInfoSubNode.class)
    static final class NativePointerKeyInfoSubNodeGen extends NativePointerKeyInfoSubNode {

        @CompilationFinal private int state_;

        private NativePointerKeyInfoSubNodeGen() {
        }

        @Override
        public Object executeWithTarget(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
            int state = state_;
            if (state != 0 /* is-active accessWithTarget(NativePointer, Object) */ && arg0Value instanceof NativePointer) {
                NativePointer arg0Value_ = (NativePointer) arg0Value;
                return accessWithTarget(arg0Value_, arg1Value);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        private Object executeAndSpecialize(Object arg0Value, Object arg1Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            try {
                if (arg0Value instanceof NativePointer) {
                    NativePointer arg0Value_ = (NativePointer) arg0Value;
                    this.state_ = state = state | 0b1 /* add-active accessWithTarget(NativePointer, Object) */;
                    lock.unlock();
                    hasLock = false;
                    return accessWithTarget(arg0Value_, arg1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static NativePointerKeyInfoSubNode create() {
            return new NativePointerKeyInfoSubNodeGen();
        }

    }
    @GeneratedBy(NativePointerKeysSubNode.class)
    static final class NativePointerKeysSubNodeGen extends NativePointerKeysSubNode {

        @CompilationFinal private int state_;

        private NativePointerKeysSubNodeGen() {
        }

        @Override
        public Object executeWithTarget(VirtualFrame frameValue, Object arg0Value) {
            int state = state_;
            if (state != 0 /* is-active accessWithTarget(NativePointer) */ && arg0Value instanceof NativePointer) {
                NativePointer arg0Value_ = (NativePointer) arg0Value;
                return accessWithTarget(arg0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value);
        }

        private Object executeAndSpecialize(Object arg0Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            try {
                if (arg0Value instanceof NativePointer) {
                    NativePointer arg0Value_ = (NativePointer) arg0Value;
                    this.state_ = state = state | 0b1 /* add-active accessWithTarget(NativePointer) */;
                    lock.unlock();
                    hasLock = false;
                    return accessWithTarget(arg0Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static NativePointerKeysSubNode create() {
            return new NativePointerKeysSubNodeGen();
        }

    }
    @GeneratedBy(AsNativePointerSubNode.class)
    static final class AsNativePointerSubNodeGen extends AsNativePointerSubNode {

        @CompilationFinal private int state_;

        private AsNativePointerSubNodeGen() {
        }

        @Override
        public Object executeWithTarget(VirtualFrame frameValue, Object arg0Value) {
            int state = state_;
            if (state != 0 /* is-active accessWithTarget(NativePointer) */ && arg0Value instanceof NativePointer) {
                NativePointer arg0Value_ = (NativePointer) arg0Value;
                return accessWithTarget(arg0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value);
        }

        private Object executeAndSpecialize(Object arg0Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            try {
                if (arg0Value instanceof NativePointer) {
                    NativePointer arg0Value_ = (NativePointer) arg0Value;
                    this.state_ = state = state | 0b1 /* add-active accessWithTarget(NativePointer) */;
                    lock.unlock();
                    hasLock = false;
                    return accessWithTarget(arg0Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static AsNativePointerSubNode create() {
            return new AsNativePointerSubNodeGen();
        }

    }
    @GeneratedBy(IsNullNativePointerSubNode.class)
    static final class IsNullNativePointerSubNodeGen extends IsNullNativePointerSubNode {

        @CompilationFinal private int state_;

        private IsNullNativePointerSubNodeGen() {
        }

        @Override
        public Object executeWithTarget(VirtualFrame frameValue, Object arg0Value) {
            int state = state_;
            if (state != 0 /* is-active accessWithTarget(NativePointer) */ && arg0Value instanceof NativePointer) {
                NativePointer arg0Value_ = (NativePointer) arg0Value;
                return accessWithTarget(arg0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value);
        }

        private Object executeAndSpecialize(Object arg0Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            try {
                if (arg0Value instanceof NativePointer) {
                    NativePointer arg0Value_ = (NativePointer) arg0Value;
                    this.state_ = state = state | 0b1 /* add-active accessWithTarget(NativePointer) */;
                    lock.unlock();
                    hasLock = false;
                    return accessWithTarget(arg0Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static IsNullNativePointerSubNode create() {
            return new IsNullNativePointerSubNodeGen();
        }

    }
    @GeneratedBy(ToNativePointerSubNode.class)
    static final class ToNativePointerSubNodeGen extends ToNativePointerSubNode {

        @CompilationFinal private int state_;

        private ToNativePointerSubNodeGen() {
        }

        @Override
        public Object executeWithTarget(VirtualFrame frameValue, Object arg0Value) {
            int state = state_;
            if (state != 0 /* is-active accessWithTarget(NativePointer) */ && arg0Value instanceof NativePointer) {
                NativePointer arg0Value_ = (NativePointer) arg0Value;
                return accessWithTarget(arg0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value);
        }

        private Object executeAndSpecialize(Object arg0Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            try {
                if (arg0Value instanceof NativePointer) {
                    NativePointer arg0Value_ = (NativePointer) arg0Value;
                    this.state_ = state = state | 0b1 /* add-active accessWithTarget(NativePointer) */;
                    lock.unlock();
                    hasLock = false;
                    return accessWithTarget(arg0Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static ToNativePointerSubNode create() {
            return new ToNativePointerSubNodeGen();
        }

    }
    @GeneratedBy(UnboxNativePointerSubNode.class)
    static final class UnboxNativePointerSubNodeGen extends UnboxNativePointerSubNode {

        @CompilationFinal private int state_;

        private UnboxNativePointerSubNodeGen() {
        }

        @Override
        public Object executeWithTarget(VirtualFrame frameValue, Object arg0Value) {
            int state = state_;
            if (state != 0 /* is-active accessWithTarget(NativePointer) */ && arg0Value instanceof NativePointer) {
                NativePointer arg0Value_ = (NativePointer) arg0Value;
                return accessWithTarget(arg0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value);
        }

        private Object executeAndSpecialize(Object arg0Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            try {
                if (arg0Value instanceof NativePointer) {
                    NativePointer arg0Value_ = (NativePointer) arg0Value;
                    this.state_ = state = state | 0b1 /* add-active accessWithTarget(NativePointer) */;
                    lock.unlock();
                    hasLock = false;
                    return accessWithTarget(arg0Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static UnboxNativePointerSubNode create() {
            return new UnboxNativePointerSubNodeGen();
        }

    }
    @GeneratedBy(IsBoxedNativePointerSubNode.class)
    static final class IsBoxedNativePointerSubNodeGen extends IsBoxedNativePointerSubNode {

        @CompilationFinal private int state_;

        private IsBoxedNativePointerSubNodeGen() {
        }

        @Override
        public Object executeWithTarget(VirtualFrame frameValue, Object arg0Value) {
            int state = state_;
            if (state != 0 /* is-active accessWithTarget(NativePointer) */ && arg0Value instanceof NativePointer) {
                NativePointer arg0Value_ = (NativePointer) arg0Value;
                return accessWithTarget(arg0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value);
        }

        private Object executeAndSpecialize(Object arg0Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            try {
                if (arg0Value instanceof NativePointer) {
                    NativePointer arg0Value_ = (NativePointer) arg0Value;
                    this.state_ = state = state | 0b1 /* add-active accessWithTarget(NativePointer) */;
                    lock.unlock();
                    hasLock = false;
                    return accessWithTarget(arg0Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static IsBoxedNativePointerSubNode create() {
            return new IsBoxedNativePointerSubNodeGen();
        }

    }
    @GeneratedBy(IsNativePointerSubNode.class)
    static final class IsNativePointerSubNodeGen extends IsNativePointerSubNode {

        @CompilationFinal private int state_;

        private IsNativePointerSubNodeGen() {
        }

        @Override
        public Object executeWithTarget(VirtualFrame frameValue, Object arg0Value) {
            int state = state_;
            if (state != 0 /* is-active accessWithTarget(NativePointer) */ && arg0Value instanceof NativePointer) {
                NativePointer arg0Value_ = (NativePointer) arg0Value;
                return accessWithTarget(arg0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value);
        }

        private Object executeAndSpecialize(Object arg0Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            try {
                if (arg0Value instanceof NativePointer) {
                    NativePointer arg0Value_ = (NativePointer) arg0Value;
                    this.state_ = state = state | 0b1 /* add-active accessWithTarget(NativePointer) */;
                    lock.unlock();
                    hasLock = false;
                    return accessWithTarget(arg0Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static IsNativePointerSubNode create() {
            return new IsNativePointerSubNodeGen();
        }

    }
    @GeneratedBy(CanResolveNativePointerSubNode.class)
    static final class CanResolveNativePointerSubNodeGen extends CanResolveNativePointerSubNode {

        @CompilationFinal private int state_;

        private CanResolveNativePointerSubNodeGen() {
        }

        @Override
        public Object executeWithTarget(VirtualFrame frameValue, Object arg0Value) {
            int state = state_;
            if (state != 0 /* is-active testWithTarget(TruffleObject) */ && arg0Value instanceof TruffleObject) {
                TruffleObject arg0Value_ = (TruffleObject) arg0Value;
                return testWithTarget(arg0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value);
        }

        private Object executeAndSpecialize(Object arg0Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            try {
                if (arg0Value instanceof TruffleObject) {
                    TruffleObject arg0Value_ = (TruffleObject) arg0Value;
                    this.state_ = state = state | 0b1 /* add-active testWithTarget(TruffleObject) */;
                    lock.unlock();
                    hasLock = false;
                    return testWithTarget(arg0Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static CanResolveNativePointerSubNode create() {
            return new CanResolveNativePointerSubNodeGen();
        }

    }
}
