package com.oracle.truffle.nfi.impl;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.ForeignAccess.Factory;
import com.oracle.truffle.api.interop.ForeignAccess.StandardFactory;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.RootNode;
import java.util.List;

/**
 * This foreign access factory is generated by {@link com.oracle.truffle.nfi.impl.NativePointerMessageResolution}.
 * You are supposed to use it for the receiver object {@link com.oracle.truffle.nfi.impl.NativePointer}.
 */
final class NativePointerMessageResolutionForeign implements StandardFactory, Factory {
    public static final ForeignAccess ACCESS = ForeignAccess.create(new NativePointerMessageResolutionForeign(), CanResolveNativePointerSubNode.createRoot());
    @Deprecated public static ForeignAccess createAccess() { return ForeignAccess.create(new NativePointerMessageResolutionForeign(), CanResolveNativePointerSubNode.createRoot()); }

    private NativePointerMessageResolutionForeign() { }

    @Override
    @TruffleBoundary
    public boolean canHandle(TruffleObject obj) {
        return (boolean) Truffle.getRuntime().createCallTarget(CanResolveNativePointerSubNode.createRoot()).call(obj);
    }

    @Override
    public CallTarget accessIsNull() {
      return Truffle.getRuntime().createCallTarget(IsNullNativePointerSubNode.createRoot());
    }
    @Override
    public CallTarget accessIsExecutable() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessIsInstantiable() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessIsBoxed() {
      return Truffle.getRuntime().createCallTarget(IsBoxedNativePointerSubNode.createRoot());
    }
    @Override
    public CallTarget accessHasKeys() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(true));
    }
    @Override
    public CallTarget accessHasSize() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessGetSize() {
      return null;
    }
    @Override
    public CallTarget accessUnbox() {
      return com.oracle.truffle.api.Truffle.getRuntime().createCallTarget(UnboxNativePointerSubNode.createRoot());
    }
    @Override
    public CallTarget accessRead() {
      return null;
    }
    @Override
    public CallTarget accessWrite() {
      return null;
    }
    @Override
    public CallTarget accessRemove() {
      return null;
    }
    @Override
    public CallTarget accessExecute(int argumentsLength) {
      return null;
    }
    @Override
    public CallTarget accessInvoke(int argumentsLength) {
      return com.oracle.truffle.api.Truffle.getRuntime().createCallTarget(BindSubNode.createRoot());
    }
    @Override
    public CallTarget accessNew(int argumentsLength) {
      return null;
    }
    @Override
    public CallTarget accessKeyInfo() {
      return com.oracle.truffle.api.Truffle.getRuntime().createCallTarget(NativePointerKeyInfoSubNode.createRoot());
    }
    @Override
    public CallTarget accessKeys() {
      return com.oracle.truffle.api.Truffle.getRuntime().createCallTarget(NativePointerKeysSubNode.createRoot());
    }
    @Override
    public CallTarget accessIsPointer() {
      return Truffle.getRuntime().createCallTarget(IsNativePointerSubNode.createRoot());
    }
    @Override
    public CallTarget accessAsPointer() {
      return com.oracle.truffle.api.Truffle.getRuntime().createCallTarget(AsNativePointerSubNode.createRoot());
    }
    @Override
    public CallTarget accessToNative() {
      return com.oracle.truffle.api.Truffle.getRuntime().createCallTarget(ToNativePointerSubNode.createRoot());
    }
    @Override
    public CallTarget accessMessage(Message unknown) {
      return null;
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.nfi.impl.NativePointerMessageResolution.BindNode}.
     */
    abstract static class BindSubNode extends com.oracle.truffle.nfi.impl.NativePointerMessageResolution.BindNode {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o0, Object o1, Object o2);
        @Specialization
        protected Object accessWithTarget(com.oracle.truffle.nfi.impl.NativePointer receiver, java.lang.String method, java.lang.Object[] args) {
            return access(receiver, method, args);
        }
        private static final class INVOKERootNode extends RootNode {
            protected INVOKERootNode() {
                super(null);
            }

            @Child private BindSubNode node = com.oracle.truffle.nfi.impl.NativePointerMessageResolutionForeignFactory.BindSubNodeGen.create();
            @Override
            public String getName() {
                return "Interop::INVOKE::" + com.oracle.truffle.nfi.impl.NativePointer.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                try {
                  Object receiver = ForeignAccess.getReceiver(frame);
                  List<Object> arguments = ForeignAccess.getArguments(frame);
                  Object identifier = arguments.get(0);
                  Object[] args = new Object[arguments.size() - 1];
                  for (int i = 0; i < arguments.size() - 1; i++) {
                    args[i] = arguments.get(i + 1);
                  }
                  return node.executeWithTarget(frame, receiver, identifier, args);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof BindSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }
        }

        public static RootNode createRoot() {
            return new INVOKERootNode();
        }
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.nfi.impl.NativePointerMessageResolution.NativePointerKeyInfoNode}.
     */
    abstract static class NativePointerKeyInfoSubNode extends com.oracle.truffle.nfi.impl.NativePointerMessageResolution.NativePointerKeyInfoNode {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o0, Object o1);
        @Specialization
        protected Object accessWithTarget(com.oracle.truffle.nfi.impl.NativePointer receiver, java.lang.Object arg) {
            return access(receiver, arg);
        }
        private static final class KEY_INFORootNode extends RootNode {
            protected KEY_INFORootNode() {
                super(null);
            }

            @Child private NativePointerKeyInfoSubNode node = com.oracle.truffle.nfi.impl.NativePointerMessageResolutionForeignFactory.NativePointerKeyInfoSubNodeGen.create();
            @Override
            public String getName() {
                return "Interop::KEY_INFO::" + com.oracle.truffle.nfi.impl.NativePointer.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object receiver = ForeignAccess.getReceiver(frame);
                Object identifier = ForeignAccess.getArguments(frame).get(0);
                try {
                    return node.executeWithTarget(frame, receiver, identifier);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof NativePointerKeyInfoSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }

        }
        public static RootNode createRoot() {
            return new KEY_INFORootNode();
        }
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.nfi.impl.NativePointerMessageResolution.NativePointerKeysNode}.
     */
    abstract static class NativePointerKeysSubNode extends com.oracle.truffle.nfi.impl.NativePointerMessageResolution.NativePointerKeysNode {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o0);
        @Specialization
        protected Object accessWithTarget(com.oracle.truffle.nfi.impl.NativePointer receiver) {
            return access(receiver);
        }
        private static final class KEYSRootNode extends RootNode {
            protected KEYSRootNode() {
                super(null);
            }

            @Child private NativePointerKeysSubNode node = com.oracle.truffle.nfi.impl.NativePointerMessageResolutionForeignFactory.NativePointerKeysSubNodeGen.create();
            @Override
            public String getName() {
                return "Interop::KEYS::" + com.oracle.truffle.nfi.impl.NativePointer.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object receiver = ForeignAccess.getReceiver(frame);
                try {
                    return node.executeWithTarget(frame, receiver);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof NativePointerKeysSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }

        }
        public static RootNode createRoot() {
            return new KEYSRootNode();
        }
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.nfi.impl.NativePointerMessageResolution.AsNativePointerNode}.
     */
    abstract static class AsNativePointerSubNode extends com.oracle.truffle.nfi.impl.NativePointerMessageResolution.AsNativePointerNode {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o0);
        @Specialization
        protected Object accessWithTarget(com.oracle.truffle.nfi.impl.NativePointer receiver) {
            return access(receiver);
        }
        private static final class AS_POINTERRootNode extends RootNode {
            protected AS_POINTERRootNode() {
                super(null);
            }

            @Child private AsNativePointerSubNode node = com.oracle.truffle.nfi.impl.NativePointerMessageResolutionForeignFactory.AsNativePointerSubNodeGen.create();
            @Override
            public String getName() {
                return "Interop::AS_POINTER::" + com.oracle.truffle.nfi.impl.NativePointer.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object receiver = ForeignAccess.getReceiver(frame);
                try {
                    return node.executeWithTarget(frame, receiver);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof AsNativePointerSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }

        }
        public static RootNode createRoot() {
            return new AS_POINTERRootNode();
        }
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.nfi.impl.NativePointerMessageResolution.IsNullNativePointerNode}.
     */
    abstract static class IsNullNativePointerSubNode extends com.oracle.truffle.nfi.impl.NativePointerMessageResolution.IsNullNativePointerNode {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o0);
        @Specialization
        protected Object accessWithTarget(com.oracle.truffle.nfi.impl.NativePointer receiver) {
            return access(receiver);
        }
        private static final class IS_NULLRootNode extends RootNode {
            protected IS_NULLRootNode() {
                super(null);
            }

            @Child private IsNullNativePointerSubNode node = com.oracle.truffle.nfi.impl.NativePointerMessageResolutionForeignFactory.IsNullNativePointerSubNodeGen.create();
            @Override
            public String getName() {
                return "Interop::IS_NULL::" + com.oracle.truffle.nfi.impl.NativePointer.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object receiver = ForeignAccess.getReceiver(frame);
                try {
                    return node.executeWithTarget(frame, receiver);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof IsNullNativePointerSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }

        }
        public static RootNode createRoot() {
            return new IS_NULLRootNode();
        }
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.nfi.impl.NativePointerMessageResolution.ToNativePointerNode}.
     */
    abstract static class ToNativePointerSubNode extends com.oracle.truffle.nfi.impl.NativePointerMessageResolution.ToNativePointerNode {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o0);
        @Specialization
        protected Object accessWithTarget(com.oracle.truffle.nfi.impl.NativePointer receiver) {
            return access(receiver);
        }
        private static final class TO_NATIVERootNode extends RootNode {
            protected TO_NATIVERootNode() {
                super(null);
            }

            @Child private ToNativePointerSubNode node = com.oracle.truffle.nfi.impl.NativePointerMessageResolutionForeignFactory.ToNativePointerSubNodeGen.create();
            @Override
            public String getName() {
                return "Interop::TO_NATIVE::" + com.oracle.truffle.nfi.impl.NativePointer.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object receiver = ForeignAccess.getReceiver(frame);
                try {
                    return node.executeWithTarget(frame, receiver);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof ToNativePointerSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }

        }
        public static RootNode createRoot() {
            return new TO_NATIVERootNode();
        }
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.nfi.impl.NativePointerMessageResolution.UnboxNativePointerNode}.
     */
    abstract static class UnboxNativePointerSubNode extends com.oracle.truffle.nfi.impl.NativePointerMessageResolution.UnboxNativePointerNode {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o0);
        @Specialization
        protected Object accessWithTarget(com.oracle.truffle.nfi.impl.NativePointer receiver) {
            return access(receiver);
        }
        private static final class UNBOXRootNode extends RootNode {
            protected UNBOXRootNode() {
                super(null);
            }

            @Child private UnboxNativePointerSubNode node = com.oracle.truffle.nfi.impl.NativePointerMessageResolutionForeignFactory.UnboxNativePointerSubNodeGen.create();
            @Override
            public String getName() {
                return "Interop::UNBOX::" + com.oracle.truffle.nfi.impl.NativePointer.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object receiver = ForeignAccess.getReceiver(frame);
                try {
                    return node.executeWithTarget(frame, receiver);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof UnboxNativePointerSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }

        }
        public static RootNode createRoot() {
            return new UNBOXRootNode();
        }
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.nfi.impl.NativePointerMessageResolution.IsBoxedNativePointerNode}.
     */
    abstract static class IsBoxedNativePointerSubNode extends com.oracle.truffle.nfi.impl.NativePointerMessageResolution.IsBoxedNativePointerNode {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o0);
        @Specialization
        protected Object accessWithTarget(com.oracle.truffle.nfi.impl.NativePointer receiver) {
            return access(receiver);
        }
        private static final class IS_BOXEDRootNode extends RootNode {
            protected IS_BOXEDRootNode() {
                super(null);
            }

            @Child private IsBoxedNativePointerSubNode node = com.oracle.truffle.nfi.impl.NativePointerMessageResolutionForeignFactory.IsBoxedNativePointerSubNodeGen.create();
            @Override
            public String getName() {
                return "Interop::IS_BOXED::" + com.oracle.truffle.nfi.impl.NativePointer.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object receiver = ForeignAccess.getReceiver(frame);
                try {
                    return node.executeWithTarget(frame, receiver);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof IsBoxedNativePointerSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }

        }
        public static RootNode createRoot() {
            return new IS_BOXEDRootNode();
        }
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.nfi.impl.NativePointerMessageResolution.IsNativePointerNode}.
     */
    abstract static class IsNativePointerSubNode extends com.oracle.truffle.nfi.impl.NativePointerMessageResolution.IsNativePointerNode {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o0);
        @Specialization
        protected Object accessWithTarget(com.oracle.truffle.nfi.impl.NativePointer receiver) {
            return access(receiver);
        }
        private static final class IS_POINTERRootNode extends RootNode {
            protected IS_POINTERRootNode() {
                super(null);
            }

            @Child private IsNativePointerSubNode node = com.oracle.truffle.nfi.impl.NativePointerMessageResolutionForeignFactory.IsNativePointerSubNodeGen.create();
            @Override
            public String getName() {
                return "Interop::IS_POINTER::" + com.oracle.truffle.nfi.impl.NativePointer.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object receiver = ForeignAccess.getReceiver(frame);
                try {
                    return node.executeWithTarget(frame, receiver);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof IsNativePointerSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }

        }
        public static RootNode createRoot() {
            return new IS_POINTERRootNode();
        }
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.nfi.impl.NativePointerMessageResolution.CanResolveNativePointerNode}.
     * Generated for {@link com.oracle.truffle.nfi.impl.NativePointer}.
     */
    abstract static class CanResolveNativePointerSubNode extends com.oracle.truffle.nfi.impl.NativePointerMessageResolution.CanResolveNativePointerNode {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o);
        @Specialization
        protected Object testWithTarget(com.oracle.truffle.api.interop.TruffleObject receiver) {
            return test(receiver);
        }
        private static final class LanguageCheckRootNode extends RootNode {
            protected LanguageCheckRootNode() {
                super(null);
            }

            @Child private CanResolveNativePointerSubNode node = com.oracle.truffle.nfi.impl.NativePointerMessageResolutionForeignFactory.CanResolveNativePointerSubNodeGen.create();
            @Override
            public Object execute(VirtualFrame frame) {
                try {
                  Object receiver = ForeignAccess.getReceiver(frame);
                  return node.executeWithTarget(frame, receiver);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof CanResolveNativePointerSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }

        }
        public static RootNode createRoot() {
            return new LanguageCheckRootNode();
        }
    }
}
