package com.oracle.truffle.nfi.impl;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.ForeignAccess.Factory;
import com.oracle.truffle.api.interop.ForeignAccess.StandardFactory;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.RootNode;

/**
 * This foreign access factory is generated by {@link com.oracle.truffle.nfi.impl.LibFFILibraryMessageResolution}.
 * You are supposed to use it for the receiver object {@link com.oracle.truffle.nfi.impl.LibFFILibrary}.
 */
final class LibFFILibraryMessageResolutionForeign implements StandardFactory, Factory {
    public static final ForeignAccess ACCESS = ForeignAccess.create(new LibFFILibraryMessageResolutionForeign(), CanResolveLibFFILibrarySubNode.createRoot());
    @Deprecated public static ForeignAccess createAccess() { return ForeignAccess.create(new LibFFILibraryMessageResolutionForeign(), CanResolveLibFFILibrarySubNode.createRoot()); }

    private LibFFILibraryMessageResolutionForeign() { }

    @Override
    @TruffleBoundary
    public boolean canHandle(TruffleObject obj) {
        return (boolean) Truffle.getRuntime().createCallTarget(CanResolveLibFFILibrarySubNode.createRoot()).call(obj);
    }

    @Override
    public CallTarget accessIsNull() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessIsExecutable() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessIsInstantiable() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessIsBoxed() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessHasKeys() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessHasSize() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessGetSize() {
      return null;
    }
    @Override
    public CallTarget accessUnbox() {
      return null;
    }
    @Override
    public CallTarget accessRead() {
      return com.oracle.truffle.api.Truffle.getRuntime().createCallTarget(LookupSymbolSubNode.createRoot());
    }
    @Override
    public CallTarget accessWrite() {
      return null;
    }
    @Override
    public CallTarget accessRemove() {
      return null;
    }
    @Override
    public CallTarget accessExecute(int argumentsLength) {
      return null;
    }
    @Override
    public CallTarget accessInvoke(int argumentsLength) {
      return null;
    }
    @Override
    public CallTarget accessNew(int argumentsLength) {
      return null;
    }
    @Override
    public CallTarget accessKeyInfo() {
      return com.oracle.truffle.api.Truffle.getRuntime().createCallTarget(KeyInfoSubNode.createRoot());
    }
    @Override
    public CallTarget accessKeys() {
      return null;
    }
    @Override
    public CallTarget accessIsPointer() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessAsPointer() {
      return null;
    }
    @Override
    public CallTarget accessToNative() {
      return null;
    }
    @Override
    public CallTarget accessMessage(Message unknown) {
      return null;
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.nfi.impl.LibFFILibraryMessageResolution.KeyInfoNode}.
     */
    abstract static class KeyInfoSubNode extends com.oracle.truffle.nfi.impl.LibFFILibraryMessageResolution.KeyInfoNode {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o0, Object o1);
        @Specialization
        protected Object accessWithTarget(com.oracle.truffle.nfi.impl.LibFFILibrary receiver, java.lang.Object arg) {
            return access(receiver, arg);
        }
        private static final class KEY_INFORootNode extends RootNode {
            protected KEY_INFORootNode() {
                super(null);
            }

            @Child private KeyInfoSubNode node = com.oracle.truffle.nfi.impl.LibFFILibraryMessageResolutionForeignFactory.KeyInfoSubNodeGen.create();
            @Override
            public String getName() {
                return "Interop::KEY_INFO::" + com.oracle.truffle.nfi.impl.LibFFILibrary.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object receiver = ForeignAccess.getReceiver(frame);
                Object identifier = ForeignAccess.getArguments(frame).get(0);
                try {
                    return node.executeWithTarget(frame, receiver, identifier);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof KeyInfoSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }

        }
        public static RootNode createRoot() {
            return new KEY_INFORootNode();
        }
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.nfi.impl.LibFFILibraryMessageResolution.LookupSymbolNode}.
     */
    abstract static class LookupSymbolSubNode extends com.oracle.truffle.nfi.impl.LibFFILibraryMessageResolution.LookupSymbolNode {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o0, Object o1);
        @Specialization
        protected Object accessWithTarget(com.oracle.truffle.nfi.impl.LibFFILibrary receiver, java.lang.Object symbol) {
            return access(receiver, symbol);
        }
        private static final class READRootNode extends RootNode {
            protected READRootNode() {
                super(null);
            }

            @Child private LookupSymbolSubNode node = com.oracle.truffle.nfi.impl.LibFFILibraryMessageResolutionForeignFactory.LookupSymbolSubNodeGen.create();
            @Override
            public String getName() {
                return "Interop::READ::" + com.oracle.truffle.nfi.impl.LibFFILibrary.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object receiver = ForeignAccess.getReceiver(frame);
                Object identifier = ForeignAccess.getArguments(frame).get(0);
                try {
                    return node.executeWithTarget(frame, receiver, identifier);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof LookupSymbolSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }

        }
        public static RootNode createRoot() {
            return new READRootNode();
        }
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.nfi.impl.LibFFILibraryMessageResolution.CanResolveLibFFILibraryNode}.
     * Generated for {@link com.oracle.truffle.nfi.impl.LibFFILibrary}.
     */
    abstract static class CanResolveLibFFILibrarySubNode extends com.oracle.truffle.nfi.impl.LibFFILibraryMessageResolution.CanResolveLibFFILibraryNode {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o);
        @Specialization
        protected Object testWithTarget(com.oracle.truffle.api.interop.TruffleObject receiver) {
            return test(receiver);
        }
        private static final class LanguageCheckRootNode extends RootNode {
            protected LanguageCheckRootNode() {
                super(null);
            }

            @Child private CanResolveLibFFILibrarySubNode node = com.oracle.truffle.nfi.impl.LibFFILibraryMessageResolutionForeignFactory.CanResolveLibFFILibrarySubNodeGen.create();
            @Override
            public Object execute(VirtualFrame frame) {
                try {
                  Object receiver = ForeignAccess.getReceiver(frame);
                  return node.executeWithTarget(frame, receiver);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof CanResolveLibFFILibrarySubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }

        }
        public static RootNode createRoot() {
            return new LanguageCheckRootNode();
        }
    }
}
