package com.oracle.truffle.nfi.impl;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.ForeignAccess.Factory;
import com.oracle.truffle.api.interop.ForeignAccess.StandardFactory;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.RootNode;
import java.util.List;

/**
 * This foreign access factory is generated by {@link com.oracle.truffle.nfi.impl.LibFFIFunctionMessageResolution}.
 * You are supposed to use it for the receiver object {@link com.oracle.truffle.nfi.impl.LibFFIFunction}.
 */
final class LibFFIFunctionMessageResolutionForeign implements StandardFactory, Factory {
    public static final ForeignAccess ACCESS = ForeignAccess.create(new LibFFIFunctionMessageResolutionForeign(), CanResolveLibFFIFunctionSubNode.createRoot());
    @Deprecated public static ForeignAccess createAccess() { return ForeignAccess.create(new LibFFIFunctionMessageResolutionForeign(), CanResolveLibFFIFunctionSubNode.createRoot()); }

    private LibFFIFunctionMessageResolutionForeign() { }

    @Override
    @TruffleBoundary
    public boolean canHandle(TruffleObject obj) {
        return (boolean) Truffle.getRuntime().createCallTarget(CanResolveLibFFIFunctionSubNode.createRoot()).call(obj);
    }

    @Override
    public CallTarget accessIsNull() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessIsExecutable() {
      return Truffle.getRuntime().createCallTarget(IsExecutableLibFFIFunctionSubNode.createRoot());
    }
    @Override
    public CallTarget accessIsInstantiable() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessIsBoxed() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessHasKeys() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(true));
    }
    @Override
    public CallTarget accessHasSize() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessGetSize() {
      return null;
    }
    @Override
    public CallTarget accessUnbox() {
      return null;
    }
    @Override
    public CallTarget accessRead() {
      return null;
    }
    @Override
    public CallTarget accessWrite() {
      return null;
    }
    @Override
    public CallTarget accessRemove() {
      return null;
    }
    @Override
    public CallTarget accessExecute(int argumentsLength) {
      return com.oracle.truffle.api.Truffle.getRuntime().createCallTarget(ExecuteLibFFIFunctionSubNode.createRoot());
    }
    @Override
    public CallTarget accessInvoke(int argumentsLength) {
      return com.oracle.truffle.api.Truffle.getRuntime().createCallTarget(ReBindSubNode.createRoot());
    }
    @Override
    public CallTarget accessNew(int argumentsLength) {
      return null;
    }
    @Override
    public CallTarget accessKeyInfo() {
      return com.oracle.truffle.api.Truffle.getRuntime().createCallTarget(LibFFIFunctionKeyInfoSubNode.createRoot());
    }
    @Override
    public CallTarget accessKeys() {
      return com.oracle.truffle.api.Truffle.getRuntime().createCallTarget(LibFFIFunctionKeysSubNode.createRoot());
    }
    @Override
    public CallTarget accessIsPointer() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessAsPointer() {
      return null;
    }
    @Override
    public CallTarget accessToNative() {
      return com.oracle.truffle.api.Truffle.getRuntime().createCallTarget(ToNativeSubNode.createRoot());
    }
    @Override
    public CallTarget accessMessage(Message unknown) {
      return null;
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.nfi.impl.LibFFIFunctionMessageResolution.ExecuteLibFFIFunctionNode}.
     */
    abstract static class ExecuteLibFFIFunctionSubNode extends com.oracle.truffle.nfi.impl.LibFFIFunctionMessageResolution.ExecuteLibFFIFunctionNode {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o0, Object o1);
        @Specialization
        protected Object accessWithTarget(com.oracle.truffle.nfi.impl.LibFFIFunction receiver, java.lang.Object[] args) {
            return access(receiver, args);
        }
        private static final class EXECUTERootNode extends RootNode {
            protected EXECUTERootNode() {
                super(null);
            }

            @Child private ExecuteLibFFIFunctionSubNode node = com.oracle.truffle.nfi.impl.LibFFIFunctionMessageResolutionForeignFactory.ExecuteLibFFIFunctionSubNodeGen.create();
            @Override
            public String getName() {
                return "Interop::EXECUTE::" + com.oracle.truffle.nfi.impl.LibFFIFunction.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                try {
                  Object receiver = ForeignAccess.getReceiver(frame);
                  List<Object> arguments = ForeignAccess.getArguments(frame);
                  Object[] args = new Object[arguments.size()];
                  for (int i = 0; i < arguments.size(); i++) {
                    args[i] = arguments.get(i);
                  }
                  return node.executeWithTarget(frame, receiver, args);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof ExecuteLibFFIFunctionSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }
        }

        public static RootNode createRoot() {
            return new EXECUTERootNode();
        }
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.nfi.impl.LibFFIFunctionMessageResolution.ReBindNode}.
     */
    abstract static class ReBindSubNode extends com.oracle.truffle.nfi.impl.LibFFIFunctionMessageResolution.ReBindNode {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o0, Object o1, Object o2);
        @Specialization
        protected Object accessWithTarget(com.oracle.truffle.nfi.impl.LibFFIFunction receiver, java.lang.String identifier, java.lang.Object[] args) {
            return access(receiver, identifier, args);
        }
        private static final class INVOKERootNode extends RootNode {
            protected INVOKERootNode() {
                super(null);
            }

            @Child private ReBindSubNode node = com.oracle.truffle.nfi.impl.LibFFIFunctionMessageResolutionForeignFactory.ReBindSubNodeGen.create();
            @Override
            public String getName() {
                return "Interop::INVOKE::" + com.oracle.truffle.nfi.impl.LibFFIFunction.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                try {
                  Object receiver = ForeignAccess.getReceiver(frame);
                  List<Object> arguments = ForeignAccess.getArguments(frame);
                  Object identifier = arguments.get(0);
                  Object[] args = new Object[arguments.size() - 1];
                  for (int i = 0; i < arguments.size() - 1; i++) {
                    args[i] = arguments.get(i + 1);
                  }
                  return node.executeWithTarget(frame, receiver, identifier, args);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof ReBindSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }
        }

        public static RootNode createRoot() {
            return new INVOKERootNode();
        }
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.nfi.impl.LibFFIFunctionMessageResolution.LibFFIFunctionKeyInfoNode}.
     */
    abstract static class LibFFIFunctionKeyInfoSubNode extends com.oracle.truffle.nfi.impl.LibFFIFunctionMessageResolution.LibFFIFunctionKeyInfoNode {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o0, Object o1);
        @Specialization
        protected Object accessWithTarget(com.oracle.truffle.nfi.impl.LibFFIFunction receiver, java.lang.Object identifier) {
            return access(receiver, identifier);
        }
        private static final class KEY_INFORootNode extends RootNode {
            protected KEY_INFORootNode() {
                super(null);
            }

            @Child private LibFFIFunctionKeyInfoSubNode node = com.oracle.truffle.nfi.impl.LibFFIFunctionMessageResolutionForeignFactory.LibFFIFunctionKeyInfoSubNodeGen.create();
            @Override
            public String getName() {
                return "Interop::KEY_INFO::" + com.oracle.truffle.nfi.impl.LibFFIFunction.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object receiver = ForeignAccess.getReceiver(frame);
                Object identifier = ForeignAccess.getArguments(frame).get(0);
                try {
                    return node.executeWithTarget(frame, receiver, identifier);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof LibFFIFunctionKeyInfoSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }

        }
        public static RootNode createRoot() {
            return new KEY_INFORootNode();
        }
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.nfi.impl.LibFFIFunctionMessageResolution.LibFFIFunctionKeysNode}.
     */
    abstract static class LibFFIFunctionKeysSubNode extends com.oracle.truffle.nfi.impl.LibFFIFunctionMessageResolution.LibFFIFunctionKeysNode {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o0);
        @Specialization
        protected Object accessWithTarget(com.oracle.truffle.nfi.impl.LibFFIFunction receiver) {
            return access(receiver);
        }
        private static final class KEYSRootNode extends RootNode {
            protected KEYSRootNode() {
                super(null);
            }

            @Child private LibFFIFunctionKeysSubNode node = com.oracle.truffle.nfi.impl.LibFFIFunctionMessageResolutionForeignFactory.LibFFIFunctionKeysSubNodeGen.create();
            @Override
            public String getName() {
                return "Interop::KEYS::" + com.oracle.truffle.nfi.impl.LibFFIFunction.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object receiver = ForeignAccess.getReceiver(frame);
                try {
                    return node.executeWithTarget(frame, receiver);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof LibFFIFunctionKeysSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }

        }
        public static RootNode createRoot() {
            return new KEYSRootNode();
        }
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.nfi.impl.LibFFIFunctionMessageResolution.ToNativeNode}.
     */
    abstract static class ToNativeSubNode extends com.oracle.truffle.nfi.impl.LibFFIFunctionMessageResolution.ToNativeNode {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o0);
        @Specialization
        protected Object accessWithTarget(com.oracle.truffle.nfi.impl.LibFFIFunction receiver) {
            return access(receiver);
        }
        private static final class TO_NATIVERootNode extends RootNode {
            protected TO_NATIVERootNode() {
                super(null);
            }

            @Child private ToNativeSubNode node = com.oracle.truffle.nfi.impl.LibFFIFunctionMessageResolutionForeignFactory.ToNativeSubNodeGen.create();
            @Override
            public String getName() {
                return "Interop::TO_NATIVE::" + com.oracle.truffle.nfi.impl.LibFFIFunction.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object receiver = ForeignAccess.getReceiver(frame);
                try {
                    return node.executeWithTarget(frame, receiver);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof ToNativeSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }

        }
        public static RootNode createRoot() {
            return new TO_NATIVERootNode();
        }
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.nfi.impl.LibFFIFunctionMessageResolution.IsExecutableLibFFIFunctionNode}.
     */
    abstract static class IsExecutableLibFFIFunctionSubNode extends com.oracle.truffle.nfi.impl.LibFFIFunctionMessageResolution.IsExecutableLibFFIFunctionNode {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o0);
        @Specialization
        protected Object accessWithTarget(com.oracle.truffle.nfi.impl.LibFFIFunction receiver) {
            return access(receiver);
        }
        private static final class IS_EXECUTABLERootNode extends RootNode {
            protected IS_EXECUTABLERootNode() {
                super(null);
            }

            @Child private IsExecutableLibFFIFunctionSubNode node = com.oracle.truffle.nfi.impl.LibFFIFunctionMessageResolutionForeignFactory.IsExecutableLibFFIFunctionSubNodeGen.create();
            @Override
            public String getName() {
                return "Interop::IS_EXECUTABLE::" + com.oracle.truffle.nfi.impl.LibFFIFunction.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object receiver = ForeignAccess.getReceiver(frame);
                try {
                    return node.executeWithTarget(frame, receiver);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof IsExecutableLibFFIFunctionSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }

        }
        public static RootNode createRoot() {
            return new IS_EXECUTABLERootNode();
        }
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.nfi.impl.LibFFIFunctionMessageResolution.CanResolveLibFFIFunctionNode}.
     * Generated for {@link com.oracle.truffle.nfi.impl.LibFFIFunction}.
     */
    abstract static class CanResolveLibFFIFunctionSubNode extends com.oracle.truffle.nfi.impl.LibFFIFunctionMessageResolution.CanResolveLibFFIFunctionNode {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o);
        @Specialization
        protected Object testWithTarget(com.oracle.truffle.api.interop.TruffleObject receiver) {
            return test(receiver);
        }
        private static final class LanguageCheckRootNode extends RootNode {
            protected LanguageCheckRootNode() {
                super(null);
            }

            @Child private CanResolveLibFFIFunctionSubNode node = com.oracle.truffle.nfi.impl.LibFFIFunctionMessageResolutionForeignFactory.CanResolveLibFFIFunctionSubNodeGen.create();
            @Override
            public Object execute(VirtualFrame frame) {
                try {
                  Object receiver = ForeignAccess.getReceiver(frame);
                  return node.executeWithTarget(frame, receiver);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof CanResolveLibFFIFunctionSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }

        }
        public static RootNode createRoot() {
            return new LanguageCheckRootNode();
        }
    }
}
