// CheckStyle: start generated
package com.oracle.truffle.nfi.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.ExplodeLoop.LoopExplosionKind;
import com.oracle.truffle.nfi.impl.LibFFIClosure.UnboxStringNode;
import java.util.concurrent.locks.Lock;

@GeneratedBy(LibFFIClosure.class)
final class LibFFIClosureFactory {

    @GeneratedBy(UnboxStringNode.class)
    static final class UnboxStringNodeGen extends UnboxStringNode {

        @CompilationFinal private int state_;
        @Child private UnboxNullData unboxNull_cache;
        @Child private Node unboxBoxed_unbox_;
        @Child private UnboxStringNode unboxBoxed_recursive_;

        private UnboxStringNodeGen() {
        }

        @ExplodeLoop(kind = LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        @Override
        protected Object execute(Object arg0Value) {
            int state = state_;
            if ((state & 0b1) != 0 /* is-active nativeString(NativeString) */ && arg0Value instanceof NativeString) {
                NativeString arg0Value_ = (NativeString) arg0Value;
                return nativeString(arg0Value_);
            }
            if ((state & 0b10) != 0 /* is-active unboxNull(TruffleObject, Node) */ && arg0Value instanceof TruffleObject) {
                TruffleObject arg0Value_ = (TruffleObject) arg0Value;
                UnboxNullData s2_ = this.unboxNull_cache;
                while (s2_ != null) {
                    if ((UnboxStringNode.checkIsNull(s2_.isNull_, arg0Value_))) {
                        return unboxNull(arg0Value_, s2_.isNull_);
                    }
                    s2_ = s2_.next_;
                }
            }
            if ((state & 0b100) != 0 /* is-active javaString(String) */ && arg0Value instanceof String) {
                String arg0Value_ = (String) arg0Value;
                return javaString(arg0Value_);
            }
            if ((state & 0b1000) != 0 /* is-active unboxBoxed(TruffleObject, Node, UnboxStringNode) */ && arg0Value instanceof TruffleObject) {
                TruffleObject arg0Value_ = (TruffleObject) arg0Value;
                if ((UnboxStringNode.checkNeedUnbox(arg0Value_))) {
                    return unboxBoxed(arg0Value_, this.unboxBoxed_unbox_, this.unboxBoxed_recursive_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value);
        }

        private Object executeAndSpecialize(Object arg0Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            try {
                if (arg0Value instanceof NativeString) {
                    NativeString arg0Value_ = (NativeString) arg0Value;
                    this.state_ = state = state | 0b1 /* add-active nativeString(NativeString) */;
                    lock.unlock();
                    hasLock = false;
                    return nativeString(arg0Value_);
                }
                if (arg0Value instanceof TruffleObject) {
                    TruffleObject arg0Value_ = (TruffleObject) arg0Value;
                    int count2_ = 0;
                    UnboxNullData s2_ = this.unboxNull_cache;
                    if ((state & 0b10) != 0 /* is-active unboxNull(TruffleObject, Node) */) {
                        while (s2_ != null) {
                            if ((UnboxStringNode.checkIsNull(s2_.isNull_, arg0Value_))) {
                                break;
                            }
                            s2_ = s2_.next_;
                            count2_++;
                        }
                    }
                    if (s2_ == null) {
                        {
                            Node isNull__ = (UnboxStringNode.createIsNull());
                            if ((UnboxStringNode.checkIsNull(isNull__, arg0Value_)) && count2_ < (3)) {
                                s2_ = new UnboxNullData(unboxNull_cache);
                                s2_.isNull_ = isNull__;
                                this.unboxNull_cache = super.insert(s2_);
                                this.state_ = state = state | 0b10 /* add-active unboxNull(TruffleObject, Node) */;
                            }
                        }
                    }
                    if (s2_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return unboxNull(arg0Value_, s2_.isNull_);
                    }
                }
                if (arg0Value instanceof String) {
                    String arg0Value_ = (String) arg0Value;
                    this.state_ = state = state | 0b100 /* add-active javaString(String) */;
                    lock.unlock();
                    hasLock = false;
                    return javaString(arg0Value_);
                }
                if (arg0Value instanceof TruffleObject) {
                    TruffleObject arg0Value_ = (TruffleObject) arg0Value;
                    if ((UnboxStringNode.checkNeedUnbox(arg0Value_))) {
                        this.unboxBoxed_unbox_ = super.insert((UnboxStringNode.createUnbox()));
                        this.unboxBoxed_recursive_ = super.insert((UnboxStringNode.createRecursive()));
                        this.state_ = state = state | 0b1000 /* add-active unboxBoxed(TruffleObject, Node, UnboxStringNode) */;
                        lock.unlock();
                        hasLock = false;
                        return unboxBoxed(arg0Value_, this.unboxBoxed_unbox_, this.unboxBoxed_recursive_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                UnboxNullData s2_ = this.unboxNull_cache;
                if ((s2_ == null || s2_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static UnboxStringNode create() {
            return new UnboxStringNodeGen();
        }

        @GeneratedBy(UnboxStringNode.class)
        private static final class UnboxNullData extends Node {

            @Child UnboxNullData next_;
            @Child Node isNull_;

            UnboxNullData(UnboxNullData next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
    }
}
