// CheckStyle: start generated
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.nfi.NFILibraryMessageResolutionForeign.CanResolveNFILibrarySubNode;
import com.oracle.truffle.nfi.NFILibraryMessageResolutionForeign.InvokeSymbolSubNode;
import com.oracle.truffle.nfi.NFILibraryMessageResolutionForeign.KeyInfoSubNode;
import com.oracle.truffle.nfi.NFILibraryMessageResolutionForeign.KeysSubNode;
import com.oracle.truffle.nfi.NFILibraryMessageResolutionForeign.LookupSymbolSubNode;
import java.util.concurrent.locks.Lock;

@GeneratedBy(NFILibraryMessageResolutionForeign.class)
final class NFILibraryMessageResolutionForeignFactory {

    @GeneratedBy(InvokeSymbolSubNode.class)
    static final class InvokeSymbolSubNodeGen extends InvokeSymbolSubNode {

        @CompilationFinal private int state_;

        private InvokeSymbolSubNodeGen() {
        }

        @Override
        public Object executeWithTarget(VirtualFrame frameValue, Object arg0Value, Object arg1Value, Object arg2Value) {
            int state = state_;
            if (state != 0 /* is-active accessWithTarget(NFILibrary, String, Object[]) */ && arg0Value instanceof NFILibrary) {
                NFILibrary arg0Value_ = (NFILibrary) arg0Value;
                if (arg1Value instanceof String) {
                    String arg1Value_ = (String) arg1Value;
                    if (arg2Value instanceof Object[]) {
                        Object[] arg2Value_ = (Object[]) arg2Value;
                        return accessWithTarget(arg0Value_, arg1Value_, arg2Value_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }

        private Object executeAndSpecialize(Object arg0Value, Object arg1Value, Object arg2Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            try {
                if (arg0Value instanceof NFILibrary) {
                    NFILibrary arg0Value_ = (NFILibrary) arg0Value;
                    if (arg1Value instanceof String) {
                        String arg1Value_ = (String) arg1Value;
                        if (arg2Value instanceof Object[]) {
                            Object[] arg2Value_ = (Object[]) arg2Value;
                            this.state_ = state = state | 0b1 /* add-active accessWithTarget(NFILibrary, String, Object[]) */;
                            lock.unlock();
                            hasLock = false;
                            return accessWithTarget(arg0Value_, arg1Value_, arg2Value_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static InvokeSymbolSubNode create() {
            return new InvokeSymbolSubNodeGen();
        }

    }
    @GeneratedBy(KeyInfoSubNode.class)
    static final class KeyInfoSubNodeGen extends KeyInfoSubNode {

        @CompilationFinal private int state_;

        private KeyInfoSubNodeGen() {
        }

        @Override
        public Object executeWithTarget(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
            int state = state_;
            if (state != 0 /* is-active accessWithTarget(NFILibrary, Object) */ && arg0Value instanceof NFILibrary) {
                NFILibrary arg0Value_ = (NFILibrary) arg0Value;
                return accessWithTarget(arg0Value_, arg1Value);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        private Object executeAndSpecialize(Object arg0Value, Object arg1Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            try {
                if (arg0Value instanceof NFILibrary) {
                    NFILibrary arg0Value_ = (NFILibrary) arg0Value;
                    this.state_ = state = state | 0b1 /* add-active accessWithTarget(NFILibrary, Object) */;
                    lock.unlock();
                    hasLock = false;
                    return accessWithTarget(arg0Value_, arg1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static KeyInfoSubNode create() {
            return new KeyInfoSubNodeGen();
        }

    }
    @GeneratedBy(LookupSymbolSubNode.class)
    static final class LookupSymbolSubNodeGen extends LookupSymbolSubNode {

        @CompilationFinal private int state_;

        private LookupSymbolSubNodeGen() {
        }

        @Override
        public Object executeWithTarget(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
            int state = state_;
            if (state != 0 /* is-active accessWithTarget(NFILibrary, Object) */ && arg0Value instanceof NFILibrary) {
                NFILibrary arg0Value_ = (NFILibrary) arg0Value;
                return accessWithTarget(arg0Value_, arg1Value);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        private Object executeAndSpecialize(Object arg0Value, Object arg1Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            try {
                if (arg0Value instanceof NFILibrary) {
                    NFILibrary arg0Value_ = (NFILibrary) arg0Value;
                    this.state_ = state = state | 0b1 /* add-active accessWithTarget(NFILibrary, Object) */;
                    lock.unlock();
                    hasLock = false;
                    return accessWithTarget(arg0Value_, arg1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static LookupSymbolSubNode create() {
            return new LookupSymbolSubNodeGen();
        }

    }
    @GeneratedBy(KeysSubNode.class)
    static final class KeysSubNodeGen extends KeysSubNode {

        @CompilationFinal private int state_;

        private KeysSubNodeGen() {
        }

        @Override
        public Object executeWithTarget(VirtualFrame frameValue, Object arg0Value) {
            int state = state_;
            if (state != 0 /* is-active accessWithTarget(NFILibrary) */ && arg0Value instanceof NFILibrary) {
                NFILibrary arg0Value_ = (NFILibrary) arg0Value;
                return accessWithTarget(arg0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value);
        }

        private Object executeAndSpecialize(Object arg0Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            try {
                if (arg0Value instanceof NFILibrary) {
                    NFILibrary arg0Value_ = (NFILibrary) arg0Value;
                    this.state_ = state = state | 0b1 /* add-active accessWithTarget(NFILibrary) */;
                    lock.unlock();
                    hasLock = false;
                    return accessWithTarget(arg0Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static KeysSubNode create() {
            return new KeysSubNodeGen();
        }

    }
    @GeneratedBy(CanResolveNFILibrarySubNode.class)
    static final class CanResolveNFILibrarySubNodeGen extends CanResolveNFILibrarySubNode {

        @CompilationFinal private int state_;

        private CanResolveNFILibrarySubNodeGen() {
        }

        @Override
        public Object executeWithTarget(VirtualFrame frameValue, Object arg0Value) {
            int state = state_;
            if (state != 0 /* is-active testWithTarget(TruffleObject) */ && arg0Value instanceof TruffleObject) {
                TruffleObject arg0Value_ = (TruffleObject) arg0Value;
                return testWithTarget(arg0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value);
        }

        private Object executeAndSpecialize(Object arg0Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            try {
                if (arg0Value instanceof TruffleObject) {
                    TruffleObject arg0Value_ = (TruffleObject) arg0Value;
                    this.state_ = state = state | 0b1 /* add-active testWithTarget(TruffleObject) */;
                    lock.unlock();
                    hasLock = false;
                    return testWithTarget(arg0Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static CanResolveNFILibrarySubNode create() {
            return new CanResolveNFILibrarySubNodeGen();
        }

    }
}
