// CheckStyle: start generated
package com.oracle.truffle.nfi.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.TruffleLanguage.LanguageReference;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.ExplodeLoop.LoopExplosionKind;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.nfi.impl.FunctionExecuteNode;
import com.oracle.truffle.nfi.impl.LibFFISignature;
import com.oracle.truffle.nfi.impl.NFILanguageImpl;
import com.oracle.truffle.nfi.impl.NativeArgumentLibrary;
import com.oracle.truffle.nfi.impl.NativePointer;
import java.util.concurrent.locks.Lock;

@GeneratedBy(FunctionExecuteNode.class)
final class FunctionExecuteNodeGen extends FunctionExecuteNode {

    private static final Uncached UNCACHED = new Uncached();
    private static final LibraryFactory<NativeArgumentLibrary> NATIVE_ARGUMENT_LIBRARY_ = LibraryFactory.resolve(NativeArgumentLibrary.class);

    @CompilationFinal private int state_;
    @CompilationFinal private int exclude_;
    @CompilationFinal private LanguageReference<NFILanguageImpl> nFILanguageImplReference_;
    @Child private CachedSignatureData cachedSignature_cache;
    @Child private CachedArgCountData cachedArgCount_cache;
    @Child private NativeArgumentLibrary genericExecute_nativeArguments_;

    private FunctionExecuteNodeGen() {
    }

    @ExplodeLoop(kind = LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
    @Override
    public Object execute(NativePointer arg0Value, LibFFISignature arg1Value, Object[] arg2Value) throws ArityException, UnsupportedTypeException {
        int state = state_;
        if (state != 0 /* is-active cachedSignature(NativePointer, LibFFISignature, Object[], LibFFISignature, DirectCallNode) || cachedArgCount(NativePointer, LibFFISignature, Object[], NativeArgumentLibrary[], DirectCallNode, BranchProfile) || genericExecute(NativePointer, LibFFISignature, Object[], NativeArgumentLibrary, NFILanguageImpl) */) {
            if ((state & 0b1) != 0 /* is-active cachedSignature(NativePointer, LibFFISignature, Object[], LibFFISignature, DirectCallNode) */) {
                CachedSignatureData s1_ = this.cachedSignature_cache;
                while (s1_ != null) {
                    if ((arg1Value == s1_.cachedSignature_)) {
                        return cachedSignature(arg0Value, arg1Value, arg2Value, s1_.cachedSignature_, s1_.execute_);
                    }
                    s1_ = s1_.next_;
                }
            }
            if ((state & 0b10) != 0 /* is-active cachedArgCount(NativePointer, LibFFISignature, Object[], NativeArgumentLibrary[], DirectCallNode, BranchProfile) */) {
                CachedArgCountData s2_ = this.cachedArgCount_cache;
                while (s2_ != null) {
                    if ((arg1Value.getArgTypes().length == s2_.libs_.length)) {
                        return cachedArgCount(arg0Value, arg1Value, arg2Value, s2_.libs_, s2_.slowPathCall_, s2_.exception_);
                    }
                    s2_ = s2_.next_;
                }
            }
            if ((state & 0b100) != 0 /* is-active genericExecute(NativePointer, LibFFISignature, Object[], NativeArgumentLibrary, NFILanguageImpl) */) {
                return FunctionExecuteNode.genericExecute(arg0Value, arg1Value, arg2Value, this.genericExecute_nativeArguments_, this.nFILanguageImplReference_.get());
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
    }

    private Object executeAndSpecialize(NativePointer arg0Value, LibFFISignature arg1Value, Object[] arg2Value) throws ArityException, UnsupportedTypeException {
        Lock lock = getLock();
        boolean hasLock = true;
        lock.lock();
        int state = state_;
        int exclude = exclude_;
        try {
            if (((exclude & 0b1)) == 0 /* is-not-excluded cachedSignature(NativePointer, LibFFISignature, Object[], LibFFISignature, DirectCallNode) */) {
                int count1_ = 0;
                CachedSignatureData s1_ = this.cachedSignature_cache;
                if ((state & 0b1) != 0 /* is-active cachedSignature(NativePointer, LibFFISignature, Object[], LibFFISignature, DirectCallNode) */) {
                    while (s1_ != null) {
                        if ((arg1Value == s1_.cachedSignature_)) {
                            break;
                        }
                        s1_ = s1_.next_;
                        count1_++;
                    }
                }
                if (s1_ == null) {
                    // assert (arg1Value == s1_.cachedSignature_);
                    if (count1_ < (3)) {
                        s1_ = super.insert(new CachedSignatureData(cachedSignature_cache));
                        s1_.cachedSignature_ = (arg1Value);
                        s1_.execute_ = s1_.insertAccessor((createCachedSignatureCall(s1_.cachedSignature_)));
                        this.cachedSignature_cache = s1_;
                        this.state_ = state = state | 0b1 /* add-active cachedSignature(NativePointer, LibFFISignature, Object[], LibFFISignature, DirectCallNode) */;
                    }
                }
                if (s1_ != null) {
                    lock.unlock();
                    hasLock = false;
                    return cachedSignature(arg0Value, arg1Value, arg2Value, s1_.cachedSignature_, s1_.execute_);
                }
            }
            if (((exclude & 0b10)) == 0 /* is-not-excluded cachedArgCount(NativePointer, LibFFISignature, Object[], NativeArgumentLibrary[], DirectCallNode, BranchProfile) */) {
                int count2_ = 0;
                CachedArgCountData s2_ = this.cachedArgCount_cache;
                if ((state & 0b10) != 0 /* is-active cachedArgCount(NativePointer, LibFFISignature, Object[], NativeArgumentLibrary[], DirectCallNode, BranchProfile) */) {
                    while (s2_ != null) {
                        if ((arg1Value.getArgTypes().length == s2_.libs_.length)) {
                            break;
                        }
                        s2_ = s2_.next_;
                        count2_++;
                    }
                }
                if (s2_ == null) {
                    {
                        NativeArgumentLibrary[] libs__ = super.insert((FunctionExecuteNode.getGenericNativeArgumentLibraries(arg1Value.getArgTypes().length)));
                        if ((arg1Value.getArgTypes().length == libs__.length) && count2_ < (3)) {
                            s2_ = super.insert(new CachedArgCountData(cachedArgCount_cache));
                            s2_.libs_ = s2_.insertAccessor(libs__);
                            s2_.slowPathCall_ = s2_.insertAccessor((createSlowPathCall()));
                            s2_.exception_ = (BranchProfile.create());
                            this.cachedArgCount_cache = s2_;
                            this.exclude_ = exclude = exclude | 0b1 /* add-excluded cachedSignature(NativePointer, LibFFISignature, Object[], LibFFISignature, DirectCallNode) */;
                            this.cachedSignature_cache = null;
                            state = state & 0xfffffffe /* remove-active cachedSignature(NativePointer, LibFFISignature, Object[], LibFFISignature, DirectCallNode) */;
                            this.state_ = state = state | 0b10 /* add-active cachedArgCount(NativePointer, LibFFISignature, Object[], NativeArgumentLibrary[], DirectCallNode, BranchProfile) */;
                        }
                    }
                }
                if (s2_ != null) {
                    lock.unlock();
                    hasLock = false;
                    return cachedArgCount(arg0Value, arg1Value, arg2Value, s2_.libs_, s2_.slowPathCall_, s2_.exception_);
                }
            }
            this.genericExecute_nativeArguments_ = super.insert((NATIVE_ARGUMENT_LIBRARY_.createDispatched(FunctionExecuteNode.ARG_DISPATCH_LIMIT)));
            LanguageReference<NFILanguageImpl> nFILanguageImplReference__ = this.nFILanguageImplReference_;
            if (nFILanguageImplReference__ == null) {
                this.nFILanguageImplReference_ = nFILanguageImplReference__ = super.lookupLanguageReference(NFILanguageImpl.class);
            }
            this.exclude_ = exclude = exclude | 0b11 /* add-excluded cachedSignature(NativePointer, LibFFISignature, Object[], LibFFISignature, DirectCallNode), cachedArgCount(NativePointer, LibFFISignature, Object[], NativeArgumentLibrary[], DirectCallNode, BranchProfile) */;
            this.cachedSignature_cache = null;
            this.cachedArgCount_cache = null;
            state = state & 0xfffffffc /* remove-active cachedSignature(NativePointer, LibFFISignature, Object[], LibFFISignature, DirectCallNode), cachedArgCount(NativePointer, LibFFISignature, Object[], NativeArgumentLibrary[], DirectCallNode, BranchProfile) */;
            this.state_ = state = state | 0b100 /* add-active genericExecute(NativePointer, LibFFISignature, Object[], NativeArgumentLibrary, NFILanguageImpl) */;
            lock.unlock();
            hasLock = false;
            return FunctionExecuteNode.genericExecute(arg0Value, arg1Value, arg2Value, this.genericExecute_nativeArguments_, nFILanguageImplReference__.get());
        } finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        int state = state_;
        if (state == 0b0) {
            return NodeCost.UNINITIALIZED;
        } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
            CachedSignatureData s1_ = this.cachedSignature_cache;
            CachedArgCountData s2_ = this.cachedArgCount_cache;
            if ((s1_ == null || s1_.next_ == null) && (s2_ == null || s2_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    public static FunctionExecuteNode create() {
        return new FunctionExecuteNodeGen();
    }

    public static FunctionExecuteNode getUncached() {
        return UNCACHED;
    }

    @GeneratedBy(FunctionExecuteNode.class)
    private static final class CachedSignatureData extends Node {

        @Child CachedSignatureData next_;
        @CompilationFinal LibFFISignature cachedSignature_;
        @Child DirectCallNode execute_;

        CachedSignatureData(CachedSignatureData next_) {
            this.next_ = next_;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return super.insert(node);
        }

    }
    @GeneratedBy(FunctionExecuteNode.class)
    private static final class CachedArgCountData extends Node {

        @Child CachedArgCountData next_;
        @Children NativeArgumentLibrary[] libs_;
        @Child DirectCallNode slowPathCall_;
        @CompilationFinal BranchProfile exception_;

        CachedArgCountData(CachedArgCountData next_) {
            this.next_ = next_;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T[] insertAccessor(T[] node) {
            return super.insert(node);
        }

        <T extends Node> T insertAccessor(T node) {
            return super.insert(node);
        }

    }
    @GeneratedBy(FunctionExecuteNode.class)
    private static final class Uncached extends FunctionExecuteNode {

        private final LanguageReference<NFILanguageImpl> nFILanguageImplReference_ = lookupLanguageReference(NFILanguageImpl.class);

        @TruffleBoundary
        @Override
        public Object execute(NativePointer arg0Value, LibFFISignature arg1Value, Object[] arg2Value) throws ArityException, UnsupportedTypeException {
            return FunctionExecuteNode.genericExecute(arg0Value, arg1Value, arg2Value, (NATIVE_ARGUMENT_LIBRARY_.getUncached()), this.nFILanguageImplReference_.get());
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @Override
        public boolean isAdoptable() {
            return false;
        }

    }
}
