// CheckStyle: start generated
package com.oracle.truffle.nfi.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.TruffleLanguage.LanguageReference;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.nfi.impl.LibFFIType;
import com.oracle.truffle.nfi.impl.NFILanguageImpl;
import com.oracle.truffle.nfi.impl.NativeArgumentBuffer;
import com.oracle.truffle.nfi.impl.NativeArgumentLibrary;
import com.oracle.truffle.nfi.impl.LibFFIType.ArrayType;
import com.oracle.truffle.nfi.impl.LibFFIType.ArrayType.SerializeHelperNode;
import com.oracle.truffle.nfi.impl.LibFFITypeFactory.ArrayTypeFactory.SerializeHelperNodeGen;
import com.oracle.truffle.nfi.spi.types.NativeSimpleType;
import java.util.concurrent.locks.Lock;

@GeneratedBy(ArrayType.class)
final class ArrayTypeGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    static  {
        LibraryExport.register(ArrayType.class, new NativeArgumentLibraryExports());
    }

    private ArrayTypeGen() {
    }

    @GeneratedBy(ArrayType.class)
    private static final class NativeArgumentLibraryExports extends LibraryExport<NativeArgumentLibrary> {

        private NativeArgumentLibraryExports() {
            super(NativeArgumentLibrary.class, ArrayType.class, false);
        }

        @Override
        protected NativeArgumentLibrary createUncached(Object receiver) {
            assert receiver instanceof ArrayType;
            return new Uncached();
        }

        @Override
        protected NativeArgumentLibrary createCached(Object receiver) {
            assert receiver instanceof ArrayType;
            return new Cached();
        }

        @GeneratedBy(ArrayType.class)
        private static final class Cached extends NativeArgumentLibrary {

            @CompilationFinal private int state_;
            @CompilationFinal private LanguageReference<NFILanguageImpl> nFILanguageImplReference_;
            @CompilationFinal private NativeSimpleType acceptsNode__cachedType_;
            @Child private SerializeHelperNode serializeNode__serializeHelper_;

            Cached() {
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof ArrayType) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export 'com.oracle.truffle.nfi.impl.LibFFIType.ArrayType'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof ArrayType && accepts_(receiver);
            }

            private boolean accepts_(Object arg0Value_) {
                ArrayType arg0Value = (ArrayType) arg0Value_;
                int state = state_;
                if ((state & 0b1) != 0 /* is-active accepts(ArrayType, NativeSimpleType) */) {
                    return arg0Value.accepts(this.acceptsNode__cachedType_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return acceptsNode_AndSpecialize(arg0Value);
            }

            private boolean acceptsNode_AndSpecialize(ArrayType arg0Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                try {
                    this.acceptsNode__cachedType_ = (arg0Value.elementType);
                    this.state_ = state = state | 0b1 /* add-active accepts(ArrayType, NativeSimpleType) */;
                    lock.unlock();
                    hasLock = false;
                    return arg0Value.accepts(this.acceptsNode__cachedType_);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                int state = state_;
                if ((state & 0b1) == 0b0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

            @Override
            public void serialize(LibFFIType arg0Value_, NativeArgumentBuffer arg1Value, Object arg2Value) throws UnsupportedTypeException {
                assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                ArrayType arg0Value = (ArrayType) arg0Value_;
                int state = state_;
                if ((state & 0b10) != 0 /* is-active serialize(ArrayType, NativeArgumentBuffer, Object, SerializeHelperNode) */) {
                    arg0Value.serialize(arg1Value, arg2Value, this.serializeNode__serializeHelper_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                serializeNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
                return;
            }

            private void serializeNode_AndSpecialize(ArrayType arg0Value, NativeArgumentBuffer arg1Value, Object arg2Value) throws UnsupportedTypeException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                try {
                    this.serializeNode__serializeHelper_ = super.insert((SerializeHelperNodeGen.create()));
                    this.state_ = state = state | 0b10 /* add-active serialize(ArrayType, NativeArgumentBuffer, Object, SerializeHelperNode) */;
                    lock.unlock();
                    hasLock = false;
                    arg0Value.serialize(arg1Value, arg2Value, this.serializeNode__serializeHelper_);
                    return;
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public Object deserialize(LibFFIType arg0Value_, NativeArgumentBuffer arg1Value) {
                assert getRootNode() != null : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                ArrayType arg0Value = (ArrayType) arg0Value_;
                int state = state_;
                if ((state & 0b100) != 0 /* is-active deserializeRet(ArrayType, NativeArgumentBuffer, NFILanguageImpl) */) {
                    return arg0Value.deserializeRet(arg1Value, this.nFILanguageImplReference_.get());
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return deserializeRetNode_AndSpecialize(arg0Value, arg1Value);
            }

            private Object deserializeRetNode_AndSpecialize(ArrayType arg0Value, NativeArgumentBuffer arg1Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                try {
                    LanguageReference<NFILanguageImpl> nFILanguageImplReference__ = this.nFILanguageImplReference_;
                    if (nFILanguageImplReference__ == null) {
                        this.nFILanguageImplReference_ = nFILanguageImplReference__ = super.lookupLanguageReference(NFILanguageImpl.class);
                    }
                    this.state_ = state = state | 0b100 /* add-active deserializeRet(ArrayType, NativeArgumentBuffer, NFILanguageImpl) */;
                    lock.unlock();
                    hasLock = false;
                    return arg0Value.deserializeRet(arg1Value, nFILanguageImplReference__.get());
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

        }
        @GeneratedBy(ArrayType.class)
        private static final class Uncached extends NativeArgumentLibrary {

            private final LanguageReference<NFILanguageImpl> nFILanguageImplReference_ = lookupLanguageReference(NFILanguageImpl.class);

            Uncached() {
            }

            @TruffleBoundary
            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof ArrayType) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export 'com.oracle.truffle.nfi.impl.LibFFIType.ArrayType'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof ArrayType && accepts_(receiver);
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public void serialize(LibFFIType arg0Value_, NativeArgumentBuffer arg1Value, Object arg2Value) throws UnsupportedTypeException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                ArrayType arg0Value = (ArrayType) arg0Value_;
                arg0Value.serialize(arg1Value, arg2Value, (SerializeHelperNodeGen.getUncached()));
                return;
            }

            @TruffleBoundary
            @Override
            public Object deserialize(LibFFIType arg0Value_, NativeArgumentBuffer arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                ArrayType arg0Value = (ArrayType) arg0Value_;
                return arg0Value.deserializeRet(arg1Value, this.nFILanguageImplReference_.get());
            }

            @TruffleBoundary
            private static boolean accepts_(Object arg0Value_) {
                ArrayType arg0Value = (ArrayType) arg0Value_;
                return arg0Value.accepts((arg0Value.elementType));
            }

        }
    }
}
