// CheckStyle: start generated
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.ExplodeLoop.LoopExplosionKind;
import com.oracle.truffle.nfi.BindSignatureNode;
import com.oracle.truffle.nfi.spi.NativeSymbolLibrary;
import java.util.concurrent.locks.Lock;

@GeneratedBy(BindSignatureNode.class)
@SuppressWarnings("unused")
final class BindSignatureNodeGen extends BindSignatureNode {

    private static final Uncached UNCACHED = new Uncached();
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    private static final LibraryFactory<NativeSymbolLibrary> NATIVE_SYMBOL_LIBRARY_ = LibraryFactory.resolve(NativeSymbolLibrary.class);

    @CompilationFinal private int state_;
    @CompilationFinal private int exclude_;
    @Child private CachedSignature0Data cachedSignature0_cache;
    @Child private CachedSignature1Data cachedSignature1_cache;
    @Child private CachedSignatureString0Data cachedSignatureString0_cache;
    @Child private CachedSignatureString1Data cachedSignatureString1_cache;
    @Child private Generic0Data generic0_cache;

    private BindSignatureNodeGen() {
    }

    @ExplodeLoop(kind = LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
    @Override
    Object execute(Object arg0Value, Object arg1Value) throws UnsupportedMessageException, UnsupportedTypeException {
        int state = state_;
        if (state != 0 /* is-active doCachedSignature(Object, Object, Object, InteropLibrary, NativeSymbolLibrary, Object) || doCachedSignature(Object, Object, Object, InteropLibrary, NativeSymbolLibrary, Object) || doCachedSignatureString(Object, Object, InteropLibrary, String, NativeSymbolLibrary, Object) || doCachedSignatureString(Object, Object, InteropLibrary, String, NativeSymbolLibrary, Object) || doGeneric(Object, Object, InteropLibrary, NativeSymbolLibrary) || doGeneric(Object, Object, InteropLibrary, NativeSymbolLibrary) */) {
            if ((state & 0b1) != 0 /* is-active doCachedSignature(Object, Object, Object, InteropLibrary, NativeSymbolLibrary, Object) */) {
                CachedSignature0Data s1_ = this.cachedSignature0_cache;
                while (s1_ != null) {
                    assert (s1_.interop_.accepts(s1_.cachedSignature_));
                    if ((s1_.symbolLibrary_.accepts(arg0Value)) && (arg1Value == s1_.cachedSignature_)) {
                        return BindSignatureNode.doCachedSignature(arg0Value, arg1Value, s1_.cachedSignature_, s1_.interop_, s1_.symbolLibrary_, s1_.parsedSignature_);
                    }
                    s1_ = s1_.next_;
                }
            }
            if ((state & 0b10) != 0 /* is-active doCachedSignature(Object, Object, Object, InteropLibrary, NativeSymbolLibrary, Object) */) {
                CachedSignature1Data s2_ = this.cachedSignature1_cache;
                while (s2_ != null) {
                    if ((arg1Value == s2_.cachedSignature_)) {
                        return this.cachedSignature1Boundary(state, s2_, arg0Value, arg1Value);
                    }
                    s2_ = s2_.next_;
                }
            }
            if ((state & 0b100) != 0 /* is-active doCachedSignatureString(Object, Object, InteropLibrary, String, NativeSymbolLibrary, Object) */) {
                CachedSignatureString0Data s3_ = this.cachedSignatureString0_cache;
                while (s3_ != null) {
                    if ((s3_.interop_.accepts(arg1Value)) && (s3_.symbolLibrary_.accepts(arg0Value)) && (s3_.cachedSignature_.equals(BindSignatureNode.asString(s3_.interop_, arg1Value)))) {
                        return BindSignatureNode.doCachedSignatureString(arg0Value, arg1Value, s3_.interop_, s3_.cachedSignature_, s3_.symbolLibrary_, s3_.parsedSignature_);
                    }
                    s3_ = s3_.next_;
                }
            }
            if ((state & 0b1000) != 0 /* is-active doCachedSignatureString(Object, Object, InteropLibrary, String, NativeSymbolLibrary, Object) */) {
                CachedSignatureString1Data s4_ = this.cachedSignatureString1_cache;
                while (s4_ != null) {
                    Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                    try {
                        if ((s4_.cachedSignature_.equals(BindSignatureNode.asString((INTEROP_LIBRARY_.getUncached(arg1Value)), arg1Value)))) {
                            return BindSignatureNode.doCachedSignatureString(arg0Value, arg1Value, (INTEROP_LIBRARY_.getUncached(arg1Value)), s4_.cachedSignature_, (NATIVE_SYMBOL_LIBRARY_.getUncached(arg0Value)), s4_.parsedSignature_);
                        }
                    } finally {
                        NodeUtil.popEncapsulatingNode(prev_);
                    }
                    s4_ = s4_.next_;
                }
            }
            if ((state & 0b10000) != 0 /* is-active doGeneric(Object, Object, InteropLibrary, NativeSymbolLibrary) */) {
                Generic0Data s5_ = this.generic0_cache;
                while (s5_ != null) {
                    if ((s5_.interop_.accepts(arg1Value)) && (s5_.symbolLibrary_.accepts(arg0Value))) {
                        return BindSignatureNode.doGeneric(arg0Value, arg1Value, s5_.interop_, s5_.symbolLibrary_);
                    }
                    s5_ = s5_.next_;
                }
            }
            if ((state & 0b100000) != 0 /* is-active doGeneric(Object, Object, InteropLibrary, NativeSymbolLibrary) */) {
                return this.generic1Boundary(state, arg0Value, arg1Value);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value, arg1Value);
    }

    @TruffleBoundary
    private Object cachedSignature1Boundary(int state, CachedSignature1Data s2_, Object arg0Value, Object arg1Value) throws UnsupportedMessageException, UnsupportedTypeException {
        Node prev_ = NodeUtil.pushEncapsulatingNode(this);
        try {
            return BindSignatureNode.doCachedSignature(arg0Value, arg1Value, s2_.cachedSignature_, (INTEROP_LIBRARY_.getUncached(s2_.cachedSignature_)), (NATIVE_SYMBOL_LIBRARY_.getUncached(arg0Value)), s2_.parsedSignature_);
        } finally {
            NodeUtil.popEncapsulatingNode(prev_);
        }
    }

    @TruffleBoundary
    private Object generic1Boundary(int state, Object arg0Value, Object arg1Value) throws UnsupportedMessageException, UnsupportedTypeException {
        Node prev_ = NodeUtil.pushEncapsulatingNode(this);
        try {
            return BindSignatureNode.doGeneric(arg0Value, arg1Value, (INTEROP_LIBRARY_.getUncached(arg1Value)), (NATIVE_SYMBOL_LIBRARY_.getUncached(arg0Value)));
        } finally {
            NodeUtil.popEncapsulatingNode(prev_);
        }
    }

    private Object executeAndSpecialize(Object arg0Value, Object arg1Value) throws UnsupportedMessageException, UnsupportedTypeException {
        Lock lock = getLock();
        boolean hasLock = true;
        lock.lock();
        int state = state_;
        int exclude = exclude_;
        try {
            if (((exclude & 0b1)) == 0 /* is-not-excluded doCachedSignature(Object, Object, Object, InteropLibrary, NativeSymbolLibrary, Object) */) {
                int count1_ = 0;
                CachedSignature0Data s1_ = this.cachedSignature0_cache;
                if ((state & 0b1) != 0 /* is-active doCachedSignature(Object, Object, Object, InteropLibrary, NativeSymbolLibrary, Object) */) {
                    while (s1_ != null) {
                        assert (s1_.interop_.accepts(s1_.cachedSignature_));
                        if ((s1_.symbolLibrary_.accepts(arg0Value)) && (arg1Value == s1_.cachedSignature_)) {
                            break;
                        }
                        s1_ = s1_.next_;
                        count1_++;
                    }
                }
                if (s1_ == null) {
                    // assert (s1_.interop_.accepts(s1_.cachedSignature_));
                    // assert (s1_.symbolLibrary_.accepts(arg0Value));
                    // assert (arg1Value == s1_.cachedSignature_);
                    if (count1_ < (5)) {
                        s1_ = super.insert(new CachedSignature0Data(cachedSignature0_cache));
                        s1_.cachedSignature_ = (arg1Value);
                        s1_.interop_ = s1_.insertAccessor((INTEROP_LIBRARY_.create(s1_.cachedSignature_)));
                        s1_.symbolLibrary_ = s1_.insertAccessor((NATIVE_SYMBOL_LIBRARY_.create(arg0Value)));
                        s1_.parsedSignature_ = (BindSignatureNode.parseSignature(arg0Value, s1_.cachedSignature_, s1_.interop_, s1_.symbolLibrary_));
                        this.cachedSignature0_cache = s1_;
                        this.state_ = state = state | 0b1 /* add-active doCachedSignature(Object, Object, Object, InteropLibrary, NativeSymbolLibrary, Object) */;
                    }
                }
                if (s1_ != null) {
                    lock.unlock();
                    hasLock = false;
                    return BindSignatureNode.doCachedSignature(arg0Value, arg1Value, s1_.cachedSignature_, s1_.interop_, s1_.symbolLibrary_, s1_.parsedSignature_);
                }
            }
            if (((exclude & 0b10)) == 0 /* is-not-excluded doCachedSignature(Object, Object, Object, InteropLibrary, NativeSymbolLibrary, Object) */) {
                {
                    Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                    try {
                        int count2_ = 0;
                        CachedSignature1Data s2_ = this.cachedSignature1_cache;
                        if ((state & 0b10) != 0 /* is-active doCachedSignature(Object, Object, Object, InteropLibrary, NativeSymbolLibrary, Object) */) {
                            while (s2_ != null) {
                                if ((arg1Value == s2_.cachedSignature_)) {
                                    break;
                                }
                                s2_ = s2_.next_;
                                count2_++;
                            }
                        }
                        if (s2_ == null) {
                            // assert (arg1Value == s2_.cachedSignature_);
                            if (count2_ < (5)) {
                                s2_ = super.insert(new CachedSignature1Data(cachedSignature1_cache));
                                s2_.cachedSignature_ = (arg1Value);
                                s2_.parsedSignature_ = (BindSignatureNode.parseSignature(arg0Value, s2_.cachedSignature_, (INTEROP_LIBRARY_.getUncached(s2_.cachedSignature_)), (NATIVE_SYMBOL_LIBRARY_.getUncached(arg0Value))));
                                this.cachedSignature1_cache = s2_;
                                this.exclude_ = exclude = exclude | 0b1 /* add-excluded doCachedSignature(Object, Object, Object, InteropLibrary, NativeSymbolLibrary, Object) */;
                                this.cachedSignature0_cache = null;
                                state = state & 0xfffffffe /* remove-active doCachedSignature(Object, Object, Object, InteropLibrary, NativeSymbolLibrary, Object) */;
                                this.state_ = state = state | 0b10 /* add-active doCachedSignature(Object, Object, Object, InteropLibrary, NativeSymbolLibrary, Object) */;
                            }
                        }
                        if (s2_ != null) {
                            lock.unlock();
                            hasLock = false;
                            return BindSignatureNode.doCachedSignature(arg0Value, arg1Value, s2_.cachedSignature_, (INTEROP_LIBRARY_.getUncached(s2_.cachedSignature_)), (NATIVE_SYMBOL_LIBRARY_.getUncached(arg0Value)), s2_.parsedSignature_);
                        }
                    } finally {
                        NodeUtil.popEncapsulatingNode(prev_);
                    }
                }
            }
            if (((exclude & 0b100)) == 0 /* is-not-excluded doCachedSignatureString(Object, Object, InteropLibrary, String, NativeSymbolLibrary, Object) */) {
                int count3_ = 0;
                CachedSignatureString0Data s3_ = this.cachedSignatureString0_cache;
                if ((state & 0b100) != 0 /* is-active doCachedSignatureString(Object, Object, InteropLibrary, String, NativeSymbolLibrary, Object) */) {
                    while (s3_ != null) {
                        if ((s3_.interop_.accepts(arg1Value)) && (s3_.symbolLibrary_.accepts(arg0Value)) && (s3_.cachedSignature_.equals(BindSignatureNode.asString(s3_.interop_, arg1Value)))) {
                            break;
                        }
                        s3_ = s3_.next_;
                        count3_++;
                    }
                }
                if (s3_ == null) {
                    {
                        InteropLibrary interop__ = super.insert((INTEROP_LIBRARY_.create(arg1Value)));
                        String cachedSignature__ = (BindSignatureNode.asString(interop__, arg1Value));
                        // assert (s3_.interop_.accepts(arg1Value));
                        // assert (s3_.symbolLibrary_.accepts(arg0Value));
                        if ((cachedSignature__.equals(BindSignatureNode.asString(interop__, arg1Value))) && count3_ < (5)) {
                            s3_ = super.insert(new CachedSignatureString0Data(cachedSignatureString0_cache));
                            s3_.interop_ = s3_.insertAccessor(interop__);
                            s3_.cachedSignature_ = cachedSignature__;
                            s3_.symbolLibrary_ = s3_.insertAccessor((NATIVE_SYMBOL_LIBRARY_.create(arg0Value)));
                            s3_.parsedSignature_ = (BindSignatureNode.parseSignature(arg0Value, arg1Value, interop__, s3_.symbolLibrary_));
                            this.cachedSignatureString0_cache = s3_;
                            this.exclude_ = exclude = exclude | 0b11 /* add-excluded doCachedSignature(Object, Object, Object, InteropLibrary, NativeSymbolLibrary, Object), doCachedSignature(Object, Object, Object, InteropLibrary, NativeSymbolLibrary, Object) */;
                            this.cachedSignature0_cache = null;
                            this.cachedSignature1_cache = null;
                            state = state & 0xfffffffc /* remove-active doCachedSignature(Object, Object, Object, InteropLibrary, NativeSymbolLibrary, Object), doCachedSignature(Object, Object, Object, InteropLibrary, NativeSymbolLibrary, Object) */;
                            this.state_ = state = state | 0b100 /* add-active doCachedSignatureString(Object, Object, InteropLibrary, String, NativeSymbolLibrary, Object) */;
                        }
                    }
                }
                if (s3_ != null) {
                    lock.unlock();
                    hasLock = false;
                    return BindSignatureNode.doCachedSignatureString(arg0Value, arg1Value, s3_.interop_, s3_.cachedSignature_, s3_.symbolLibrary_, s3_.parsedSignature_);
                }
            }
            if (((exclude & 0b1000)) == 0 /* is-not-excluded doCachedSignatureString(Object, Object, InteropLibrary, String, NativeSymbolLibrary, Object) */) {
                {
                    Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                    try {
                        int count4_ = 0;
                        CachedSignatureString1Data s4_ = this.cachedSignatureString1_cache;
                        if ((state & 0b1000) != 0 /* is-active doCachedSignatureString(Object, Object, InteropLibrary, String, NativeSymbolLibrary, Object) */) {
                            while (s4_ != null) {
                                if ((s4_.cachedSignature_.equals(BindSignatureNode.asString((INTEROP_LIBRARY_.getUncached(arg1Value)), arg1Value)))) {
                                    break;
                                }
                                s4_ = s4_.next_;
                                count4_++;
                            }
                        }
                        if (s4_ == null) {
                            {
                                InteropLibrary interop__ = (INTEROP_LIBRARY_.getUncached(arg1Value));
                                String cachedSignature__ = (BindSignatureNode.asString(interop__, arg1Value));
                                if ((cachedSignature__.equals(BindSignatureNode.asString(interop__, arg1Value))) && count4_ < (5)) {
                                    s4_ = super.insert(new CachedSignatureString1Data(cachedSignatureString1_cache));
                                    s4_.cachedSignature_ = cachedSignature__;
                                    s4_.parsedSignature_ = (BindSignatureNode.parseSignature(arg0Value, arg1Value, interop__, (NATIVE_SYMBOL_LIBRARY_.getUncached(arg0Value))));
                                    this.cachedSignatureString1_cache = s4_;
                                    this.exclude_ = exclude = exclude | 0b111 /* add-excluded doCachedSignature(Object, Object, Object, InteropLibrary, NativeSymbolLibrary, Object), doCachedSignature(Object, Object, Object, InteropLibrary, NativeSymbolLibrary, Object), doCachedSignatureString(Object, Object, InteropLibrary, String, NativeSymbolLibrary, Object) */;
                                    this.cachedSignature0_cache = null;
                                    this.cachedSignature1_cache = null;
                                    this.cachedSignatureString0_cache = null;
                                    state = state & 0xfffffff8 /* remove-active doCachedSignature(Object, Object, Object, InteropLibrary, NativeSymbolLibrary, Object), doCachedSignature(Object, Object, Object, InteropLibrary, NativeSymbolLibrary, Object), doCachedSignatureString(Object, Object, InteropLibrary, String, NativeSymbolLibrary, Object) */;
                                    this.state_ = state = state | 0b1000 /* add-active doCachedSignatureString(Object, Object, InteropLibrary, String, NativeSymbolLibrary, Object) */;
                                }
                            }
                        }
                        if (s4_ != null) {
                            lock.unlock();
                            hasLock = false;
                            return BindSignatureNode.doCachedSignatureString(arg0Value, arg1Value, (INTEROP_LIBRARY_.getUncached(arg1Value)), s4_.cachedSignature_, (NATIVE_SYMBOL_LIBRARY_.getUncached(arg0Value)), s4_.parsedSignature_);
                        }
                    } finally {
                        NodeUtil.popEncapsulatingNode(prev_);
                    }
                }
            }
            if (((exclude & 0b10000)) == 0 /* is-not-excluded doGeneric(Object, Object, InteropLibrary, NativeSymbolLibrary) */) {
                int count5_ = 0;
                Generic0Data s5_ = this.generic0_cache;
                if ((state & 0b10000) != 0 /* is-active doGeneric(Object, Object, InteropLibrary, NativeSymbolLibrary) */) {
                    while (s5_ != null) {
                        if ((s5_.interop_.accepts(arg1Value)) && (s5_.symbolLibrary_.accepts(arg0Value))) {
                            break;
                        }
                        s5_ = s5_.next_;
                        count5_++;
                    }
                }
                if (s5_ == null) {
                    // assert (s5_.interop_.accepts(arg1Value));
                    // assert (s5_.symbolLibrary_.accepts(arg0Value));
                    if (count5_ < (3)) {
                        s5_ = super.insert(new Generic0Data(generic0_cache));
                        s5_.interop_ = s5_.insertAccessor((INTEROP_LIBRARY_.create(arg1Value)));
                        s5_.symbolLibrary_ = s5_.insertAccessor((NATIVE_SYMBOL_LIBRARY_.create(arg0Value)));
                        this.generic0_cache = s5_;
                        this.exclude_ = exclude = exclude | 0b1111 /* add-excluded doCachedSignature(Object, Object, Object, InteropLibrary, NativeSymbolLibrary, Object), doCachedSignature(Object, Object, Object, InteropLibrary, NativeSymbolLibrary, Object), doCachedSignatureString(Object, Object, InteropLibrary, String, NativeSymbolLibrary, Object), doCachedSignatureString(Object, Object, InteropLibrary, String, NativeSymbolLibrary, Object) */;
                        this.cachedSignature0_cache = null;
                        this.cachedSignature1_cache = null;
                        this.cachedSignatureString0_cache = null;
                        this.cachedSignatureString1_cache = null;
                        state = state & 0xfffffff0 /* remove-active doCachedSignature(Object, Object, Object, InteropLibrary, NativeSymbolLibrary, Object), doCachedSignature(Object, Object, Object, InteropLibrary, NativeSymbolLibrary, Object), doCachedSignatureString(Object, Object, InteropLibrary, String, NativeSymbolLibrary, Object), doCachedSignatureString(Object, Object, InteropLibrary, String, NativeSymbolLibrary, Object) */;
                        this.state_ = state = state | 0b10000 /* add-active doGeneric(Object, Object, InteropLibrary, NativeSymbolLibrary) */;
                    }
                }
                if (s5_ != null) {
                    lock.unlock();
                    hasLock = false;
                    return BindSignatureNode.doGeneric(arg0Value, arg1Value, s5_.interop_, s5_.symbolLibrary_);
                }
            }
            {
                Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                try {
                    this.exclude_ = exclude = exclude | 0b11111 /* add-excluded doCachedSignature(Object, Object, Object, InteropLibrary, NativeSymbolLibrary, Object), doCachedSignature(Object, Object, Object, InteropLibrary, NativeSymbolLibrary, Object), doCachedSignatureString(Object, Object, InteropLibrary, String, NativeSymbolLibrary, Object), doCachedSignatureString(Object, Object, InteropLibrary, String, NativeSymbolLibrary, Object), doGeneric(Object, Object, InteropLibrary, NativeSymbolLibrary) */;
                    this.cachedSignature0_cache = null;
                    this.cachedSignature1_cache = null;
                    this.cachedSignatureString0_cache = null;
                    this.cachedSignatureString1_cache = null;
                    this.generic0_cache = null;
                    state = state & 0xffffffe0 /* remove-active doCachedSignature(Object, Object, Object, InteropLibrary, NativeSymbolLibrary, Object), doCachedSignature(Object, Object, Object, InteropLibrary, NativeSymbolLibrary, Object), doCachedSignatureString(Object, Object, InteropLibrary, String, NativeSymbolLibrary, Object), doCachedSignatureString(Object, Object, InteropLibrary, String, NativeSymbolLibrary, Object), doGeneric(Object, Object, InteropLibrary, NativeSymbolLibrary) */;
                    this.state_ = state = state | 0b100000 /* add-active doGeneric(Object, Object, InteropLibrary, NativeSymbolLibrary) */;
                    lock.unlock();
                    hasLock = false;
                    return BindSignatureNode.doGeneric(arg0Value, arg1Value, (INTEROP_LIBRARY_.getUncached(arg1Value)), (NATIVE_SYMBOL_LIBRARY_.getUncached(arg0Value)));
                } finally {
                    NodeUtil.popEncapsulatingNode(prev_);
                }
            }
        } finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        int state = state_;
        if (state == 0b0) {
            return NodeCost.UNINITIALIZED;
        } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
            CachedSignature0Data s1_ = this.cachedSignature0_cache;
            CachedSignature1Data s2_ = this.cachedSignature1_cache;
            CachedSignatureString0Data s3_ = this.cachedSignatureString0_cache;
            CachedSignatureString1Data s4_ = this.cachedSignatureString1_cache;
            Generic0Data s5_ = this.generic0_cache;
            if ((s1_ == null || s1_.next_ == null) && (s2_ == null || s2_.next_ == null) && (s3_ == null || s3_.next_ == null) && (s4_ == null || s4_.next_ == null) && (s5_ == null || s5_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    public static BindSignatureNode create() {
        return new BindSignatureNodeGen();
    }

    public static BindSignatureNode getUncached() {
        return UNCACHED;
    }

    @GeneratedBy(BindSignatureNode.class)
    private static final class CachedSignature0Data extends Node {

        @Child CachedSignature0Data next_;
        @CompilationFinal Object cachedSignature_;
        @Child InteropLibrary interop_;
        @Child NativeSymbolLibrary symbolLibrary_;
        @CompilationFinal Object parsedSignature_;

        CachedSignature0Data(CachedSignature0Data next_) {
            this.next_ = next_;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return super.insert(node);
        }

    }
    @GeneratedBy(BindSignatureNode.class)
    private static final class CachedSignature1Data extends Node {

        @Child CachedSignature1Data next_;
        @CompilationFinal Object cachedSignature_;
        @CompilationFinal Object parsedSignature_;

        CachedSignature1Data(CachedSignature1Data next_) {
            this.next_ = next_;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
    @GeneratedBy(BindSignatureNode.class)
    private static final class CachedSignatureString0Data extends Node {

        @Child CachedSignatureString0Data next_;
        @Child InteropLibrary interop_;
        @CompilationFinal String cachedSignature_;
        @Child NativeSymbolLibrary symbolLibrary_;
        @CompilationFinal Object parsedSignature_;

        CachedSignatureString0Data(CachedSignatureString0Data next_) {
            this.next_ = next_;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return super.insert(node);
        }

    }
    @GeneratedBy(BindSignatureNode.class)
    private static final class CachedSignatureString1Data extends Node {

        @Child CachedSignatureString1Data next_;
        @CompilationFinal String cachedSignature_;
        @CompilationFinal Object parsedSignature_;

        CachedSignatureString1Data(CachedSignatureString1Data next_) {
            this.next_ = next_;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
    @GeneratedBy(BindSignatureNode.class)
    private static final class Generic0Data extends Node {

        @Child Generic0Data next_;
        @Child InteropLibrary interop_;
        @Child NativeSymbolLibrary symbolLibrary_;

        Generic0Data(Generic0Data next_) {
            this.next_ = next_;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return super.insert(node);
        }

    }
    @GeneratedBy(BindSignatureNode.class)
    private static final class Uncached extends BindSignatureNode {

        @TruffleBoundary
        @Override
        Object execute(Object arg0Value, Object arg1Value) throws UnsupportedMessageException, UnsupportedTypeException {
            return BindSignatureNode.doGeneric(arg0Value, arg1Value, (INTEROP_LIBRARY_.getUncached(arg1Value)), (NATIVE_SYMBOL_LIBRARY_.getUncached(arg0Value)));
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @Override
        public boolean isAdoptable() {
            return false;
        }

    }
}
