// CheckStyle: start generated
package com.oracle.truffle.nfi.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.ExplodeLoop.LoopExplosionKind;
import com.oracle.truffle.nfi.impl.TypeConversion.AsPointerNode;
import java.util.concurrent.locks.Lock;

@GeneratedBy(SlowPathSerializeArgumentNode.class)
final class SlowPathSerializeArgumentNodeGen extends SlowPathSerializeArgumentNode {

    @CompilationFinal private int state_;
    @CompilationFinal private int exclude_;
    @Child private CacheTypeData cacheType_cache;
    @Child private GenericWithPrepareData genericWithPrepare_cache;

    private SlowPathSerializeArgumentNodeGen() {
    }

    @ExplodeLoop(kind = LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
    @Override
    public Object execute(NativeArgumentBuffer arg0Value, LibFFIType arg1Value, Object arg2Value) {
        int state = state_;
        if (state != 0 /* is-active cacheType(NativeArgumentBuffer, LibFFIType, Object, LibFFIType, SerializeArgumentNode) || genericWithoutPrepare(NativeArgumentBuffer, LibFFIType, Object) || genericWithPrepare(NativeArgumentBuffer, LibFFIType, TruffleObject, Node, Node, AsPointerNode, SlowPathSerializeArgumentNode) */) {
            if ((state & 0b11) != 0 /* is-active cacheType(NativeArgumentBuffer, LibFFIType, Object, LibFFIType, SerializeArgumentNode) || genericWithoutPrepare(NativeArgumentBuffer, LibFFIType, Object) */) {
                if ((state & 0b1) != 0 /* is-active cacheType(NativeArgumentBuffer, LibFFIType, Object, LibFFIType, SerializeArgumentNode) */) {
                    CacheTypeData s1_ = this.cacheType_cache;
                    while (s1_ != null) {
                        if ((arg1Value == s1_.cachedType_)) {
                            return cacheType(arg0Value, arg1Value, arg2Value, s1_.cachedType_, s1_.serialize_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 0b10) != 0 /* is-active genericWithoutPrepare(NativeArgumentBuffer, LibFFIType, Object) */) {
                    if ((SlowPathSerializeArgumentNode.needNoPrepare(arg2Value))) {
                        return genericWithoutPrepare(arg0Value, arg1Value, arg2Value);
                    }
                }
            }
            if ((state & 0b100) != 0 /* is-active genericWithPrepare(NativeArgumentBuffer, LibFFIType, TruffleObject, Node, Node, AsPointerNode, SlowPathSerializeArgumentNode) */ && arg2Value instanceof TruffleObject) {
                TruffleObject arg2Value_ = (TruffleObject) arg2Value;
                GenericWithPrepareData s3_ = this.genericWithPrepare_cache;
                if (s3_ != null) {
                    if ((arg2Value_ != null)) {
                        return genericWithPrepare(arg0Value, arg1Value, arg2Value_, s3_.unbox_, s3_.isExecutable_, s3_.asPointer_, s3_.recursive_);
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
    }

    private Object executeAndSpecialize(NativeArgumentBuffer arg0Value, LibFFIType arg1Value, Object arg2Value) {
        Lock lock = getLock();
        boolean hasLock = true;
        lock.lock();
        int state = state_;
        int exclude = exclude_;
        try {
            if ((exclude) == 0 /* is-not-excluded cacheType(NativeArgumentBuffer, LibFFIType, Object, LibFFIType, SerializeArgumentNode) */) {
                int count1_ = 0;
                CacheTypeData s1_ = this.cacheType_cache;
                if ((state & 0b1) != 0 /* is-active cacheType(NativeArgumentBuffer, LibFFIType, Object, LibFFIType, SerializeArgumentNode) */) {
                    while (s1_ != null) {
                        if ((arg1Value == s1_.cachedType_)) {
                            break;
                        }
                        s1_ = s1_.next_;
                        count1_++;
                    }
                }
                if (s1_ == null) {
                    // assert (arg1Value == s1_.cachedType_);
                    if (count1_ < (3)) {
                        s1_ = new CacheTypeData(cacheType_cache);
                        s1_.cachedType_ = (arg1Value);
                        s1_.serialize_ = (s1_.cachedType_.createSerializeArgumentNode());
                        this.cacheType_cache = super.insert(s1_);
                        this.state_ = state = state | 0b1 /* add-active cacheType(NativeArgumentBuffer, LibFFIType, Object, LibFFIType, SerializeArgumentNode) */;
                    }
                }
                if (s1_ != null) {
                    lock.unlock();
                    hasLock = false;
                    return cacheType(arg0Value, arg1Value, arg2Value, s1_.cachedType_, s1_.serialize_);
                }
            }
            if ((SlowPathSerializeArgumentNode.needNoPrepare(arg2Value))) {
                this.exclude_ = exclude = exclude | 0b1 /* add-excluded cacheType(NativeArgumentBuffer, LibFFIType, Object, LibFFIType, SerializeArgumentNode) */;
                this.cacheType_cache = null;
                state = state & 0xfffffffe /* remove-active cacheType(NativeArgumentBuffer, LibFFIType, Object, LibFFIType, SerializeArgumentNode) */;
                this.state_ = state = state | 0b10 /* add-active genericWithoutPrepare(NativeArgumentBuffer, LibFFIType, Object) */;
                lock.unlock();
                hasLock = false;
                return genericWithoutPrepare(arg0Value, arg1Value, arg2Value);
            }
            if (arg2Value instanceof TruffleObject) {
                TruffleObject arg2Value_ = (TruffleObject) arg2Value;
                if ((arg2Value_ != null)) {
                    GenericWithPrepareData s3_ = new GenericWithPrepareData();
                    s3_.unbox_ = (SlowPathSerializeArgumentNode.createUnbox());
                    s3_.isExecutable_ = (SlowPathSerializeArgumentNode.createIsExecutable());
                    s3_.asPointer_ = (SlowPathSerializeArgumentNode.createAsPointer());
                    s3_.recursive_ = (SlowPathSerializeArgumentNode.createRecursive());
                    this.genericWithPrepare_cache = super.insert(s3_);
                    this.exclude_ = exclude = exclude | 0b1 /* add-excluded cacheType(NativeArgumentBuffer, LibFFIType, Object, LibFFIType, SerializeArgumentNode) */;
                    this.cacheType_cache = null;
                    state = state & 0xfffffffe /* remove-active cacheType(NativeArgumentBuffer, LibFFIType, Object, LibFFIType, SerializeArgumentNode) */;
                    this.state_ = state = state | 0b100 /* add-active genericWithPrepare(NativeArgumentBuffer, LibFFIType, TruffleObject, Node, Node, AsPointerNode, SlowPathSerializeArgumentNode) */;
                    lock.unlock();
                    hasLock = false;
                    return genericWithPrepare(arg0Value, arg1Value, arg2Value_, s3_.unbox_, s3_.isExecutable_, s3_.asPointer_, s3_.recursive_);
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
        } finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        int state = state_;
        if (state == 0b0) {
            return NodeCost.UNINITIALIZED;
        } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
            CacheTypeData s1_ = this.cacheType_cache;
            if ((s1_ == null || s1_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    public static SlowPathSerializeArgumentNode create() {
        return new SlowPathSerializeArgumentNodeGen();
    }

    @GeneratedBy(SlowPathSerializeArgumentNode.class)
    private static final class CacheTypeData extends Node {

        @Child CacheTypeData next_;
        @CompilationFinal LibFFIType cachedType_;
        @Child SerializeArgumentNode serialize_;

        CacheTypeData(CacheTypeData next_) {
            this.next_ = next_;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
    @GeneratedBy(SlowPathSerializeArgumentNode.class)
    private static final class GenericWithPrepareData extends Node {

        @Child Node unbox_;
        @Child Node isExecutable_;
        @Child AsPointerNode asPointer_;
        @Child SlowPathSerializeArgumentNode recursive_;

        GenericWithPrepareData() {
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
}
