// CheckStyle: start generated
package com.oracle.truffle.nfi.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.ExplodeLoop.LoopExplosionKind;
import com.oracle.truffle.nfi.impl.LibFFIType.ArrayType;
import com.oracle.truffle.nfi.impl.SerializeArgumentNode.SerializeArrayArgumentNode;
import com.oracle.truffle.nfi.impl.SerializeArgumentNode.SerializeClosureArgumentNode;
import com.oracle.truffle.nfi.impl.SerializeArgumentNode.SerializePointerArgumentNode;
import com.oracle.truffle.nfi.impl.SerializeArgumentNode.SerializeSimpleArgumentNode;
import com.oracle.truffle.nfi.impl.SerializeArgumentNode.SerializeStringArgumentNode;
import com.oracle.truffle.nfi.impl.TypeConversion.AsPointerNode;
import com.oracle.truffle.nfi.impl.TypeConversion.AsStringNode;
import java.util.concurrent.locks.Lock;

@GeneratedBy(SerializeArgumentNode.class)
final class SerializeArgumentNodeFactory {

    @GeneratedBy(SerializeSimpleArgumentNode.class)
    static final class SerializeSimpleArgumentNodeGen extends SerializeSimpleArgumentNode {

        @CompilationFinal private int state_;
        @Child private SerializeUnboxData serializeUnbox_cache;

        private SerializeSimpleArgumentNodeGen(LibFFIType argType) {
            super(argType);
        }

        @ExplodeLoop(kind = LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        @Override
        boolean execute(NativeArgumentBuffer arg0Value, Object arg1Value) {
            int state = state_;
            if (state != 0 /* is-active serializeByte(NativeArgumentBuffer, byte) || serializeBoolean(NativeArgumentBuffer, boolean) || serializeShort(NativeArgumentBuffer, short) || serializeChar(NativeArgumentBuffer, char) || serializeInt(NativeArgumentBuffer, int) || serializeLong(NativeArgumentBuffer, long) || serializeFloat(NativeArgumentBuffer, float) || serializeDouble(NativeArgumentBuffer, double) || serializeUnbox(NativeArgumentBuffer, TruffleObject, Node, Node, SerializeArgumentNode) */) {
                if ((state & 0b1) != 0 /* is-active serializeByte(NativeArgumentBuffer, byte) */ && arg1Value instanceof Byte) {
                    byte arg1Value_ = (byte) arg1Value;
                    return serializeByte(arg0Value, arg1Value_);
                }
                if ((state & 0b10) != 0 /* is-active serializeBoolean(NativeArgumentBuffer, boolean) */ && arg1Value instanceof Boolean) {
                    boolean arg1Value_ = (boolean) arg1Value;
                    return serializeBoolean(arg0Value, arg1Value_);
                }
                if ((state & 0b100) != 0 /* is-active serializeShort(NativeArgumentBuffer, short) */ && arg1Value instanceof Short) {
                    short arg1Value_ = (short) arg1Value;
                    return serializeShort(arg0Value, arg1Value_);
                }
                if ((state & 0b1000) != 0 /* is-active serializeChar(NativeArgumentBuffer, char) */ && arg1Value instanceof Character) {
                    char arg1Value_ = (char) arg1Value;
                    return serializeChar(arg0Value, arg1Value_);
                }
                if ((state & 0b10000) != 0 /* is-active serializeInt(NativeArgumentBuffer, int) */ && arg1Value instanceof Integer) {
                    int arg1Value_ = (int) arg1Value;
                    return serializeInt(arg0Value, arg1Value_);
                }
                if ((state & 0b100000) != 0 /* is-active serializeLong(NativeArgumentBuffer, long) */ && arg1Value instanceof Long) {
                    long arg1Value_ = (long) arg1Value;
                    return serializeLong(arg0Value, arg1Value_);
                }
                if ((state & 0b1000000) != 0 /* is-active serializeFloat(NativeArgumentBuffer, float) */ && arg1Value instanceof Float) {
                    float arg1Value_ = (float) arg1Value;
                    return serializeFloat(arg0Value, arg1Value_);
                }
                if ((state & 0b10000000) != 0 /* is-active serializeDouble(NativeArgumentBuffer, double) */ && arg1Value instanceof Double) {
                    double arg1Value_ = (double) arg1Value;
                    return serializeDouble(arg0Value, arg1Value_);
                }
                if ((state & 0b100000000) != 0 /* is-active serializeUnbox(NativeArgumentBuffer, TruffleObject, Node, Node, SerializeArgumentNode) */ && arg1Value instanceof TruffleObject) {
                    TruffleObject arg1Value_ = (TruffleObject) arg1Value;
                    SerializeUnboxData s9_ = this.serializeUnbox_cache;
                    while (s9_ != null) {
                        if ((SerializeSimpleArgumentNode.checkIsBoxed(s9_.isBoxed_, arg1Value_))) {
                            return serializeUnbox(arg0Value, arg1Value_, s9_.isBoxed_, s9_.unbox_, s9_.serialize_);
                        }
                        s9_ = s9_.next_;
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        private boolean executeAndSpecialize(NativeArgumentBuffer arg0Value, Object arg1Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            try {
                if (arg1Value instanceof Byte) {
                    byte arg1Value_ = (byte) arg1Value;
                    this.state_ = state = state | 0b1 /* add-active serializeByte(NativeArgumentBuffer, byte) */;
                    lock.unlock();
                    hasLock = false;
                    return serializeByte(arg0Value, arg1Value_);
                }
                if (arg1Value instanceof Boolean) {
                    boolean arg1Value_ = (boolean) arg1Value;
                    this.state_ = state = state | 0b10 /* add-active serializeBoolean(NativeArgumentBuffer, boolean) */;
                    lock.unlock();
                    hasLock = false;
                    return serializeBoolean(arg0Value, arg1Value_);
                }
                if (arg1Value instanceof Short) {
                    short arg1Value_ = (short) arg1Value;
                    this.state_ = state = state | 0b100 /* add-active serializeShort(NativeArgumentBuffer, short) */;
                    lock.unlock();
                    hasLock = false;
                    return serializeShort(arg0Value, arg1Value_);
                }
                if (arg1Value instanceof Character) {
                    char arg1Value_ = (char) arg1Value;
                    this.state_ = state = state | 0b1000 /* add-active serializeChar(NativeArgumentBuffer, char) */;
                    lock.unlock();
                    hasLock = false;
                    return serializeChar(arg0Value, arg1Value_);
                }
                if (arg1Value instanceof Integer) {
                    int arg1Value_ = (int) arg1Value;
                    this.state_ = state = state | 0b10000 /* add-active serializeInt(NativeArgumentBuffer, int) */;
                    lock.unlock();
                    hasLock = false;
                    return serializeInt(arg0Value, arg1Value_);
                }
                if (arg1Value instanceof Long) {
                    long arg1Value_ = (long) arg1Value;
                    this.state_ = state = state | 0b100000 /* add-active serializeLong(NativeArgumentBuffer, long) */;
                    lock.unlock();
                    hasLock = false;
                    return serializeLong(arg0Value, arg1Value_);
                }
                if (arg1Value instanceof Float) {
                    float arg1Value_ = (float) arg1Value;
                    this.state_ = state = state | 0b1000000 /* add-active serializeFloat(NativeArgumentBuffer, float) */;
                    lock.unlock();
                    hasLock = false;
                    return serializeFloat(arg0Value, arg1Value_);
                }
                if (arg1Value instanceof Double) {
                    double arg1Value_ = (double) arg1Value;
                    this.state_ = state = state | 0b10000000 /* add-active serializeDouble(NativeArgumentBuffer, double) */;
                    lock.unlock();
                    hasLock = false;
                    return serializeDouble(arg0Value, arg1Value_);
                }
                if (arg1Value instanceof TruffleObject) {
                    TruffleObject arg1Value_ = (TruffleObject) arg1Value;
                    int count9_ = 0;
                    SerializeUnboxData s9_ = this.serializeUnbox_cache;
                    if ((state & 0b100000000) != 0 /* is-active serializeUnbox(NativeArgumentBuffer, TruffleObject, Node, Node, SerializeArgumentNode) */) {
                        while (s9_ != null) {
                            if ((SerializeSimpleArgumentNode.checkIsBoxed(s9_.isBoxed_, arg1Value_))) {
                                break;
                            }
                            s9_ = s9_.next_;
                            count9_++;
                        }
                    }
                    if (s9_ == null) {
                        {
                            Node isBoxed__ = (SerializeArgumentNode.createIsBoxed());
                            if ((SerializeSimpleArgumentNode.checkIsBoxed(isBoxed__, arg1Value_)) && count9_ < (3)) {
                                s9_ = new SerializeUnboxData(serializeUnbox_cache);
                                s9_.isBoxed_ = isBoxed__;
                                s9_.unbox_ = (SerializeArgumentNode.createUnbox());
                                s9_.serialize_ = (argType.createSerializeArgumentNode());
                                this.serializeUnbox_cache = super.insert(s9_);
                                this.state_ = state = state | 0b100000000 /* add-active serializeUnbox(NativeArgumentBuffer, TruffleObject, Node, Node, SerializeArgumentNode) */;
                            }
                        }
                    }
                    if (s9_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return serializeUnbox(arg0Value, arg1Value_, s9_.isBoxed_, s9_.unbox_, s9_.serialize_);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                SerializeUnboxData s9_ = this.serializeUnbox_cache;
                if ((s9_ == null || s9_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static SerializeSimpleArgumentNode create(LibFFIType argType) {
            return new SerializeSimpleArgumentNodeGen(argType);
        }

        @GeneratedBy(SerializeSimpleArgumentNode.class)
        private static final class SerializeUnboxData extends Node {

            @Child SerializeUnboxData next_;
            @Child Node isBoxed_;
            @Child Node unbox_;
            @Child SerializeArgumentNode serialize_;

            SerializeUnboxData(SerializeUnboxData next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
    }
    @GeneratedBy(SerializePointerArgumentNode.class)
    static final class SerializePointerArgumentNodeGen extends SerializePointerArgumentNode {

        @CompilationFinal private int state_;
        @CompilationFinal private int exclude_;
        @Child private AsPointerNode serializeTruffleObject_asPointer_;

        private SerializePointerArgumentNodeGen(LibFFIType type) {
            super(type);
        }

        @Override
        boolean execute(NativeArgumentBuffer arg0Value, Object arg1Value) {
            int state = state_;
            if (state != 0 /* is-active serializeLong(NativeArgumentBuffer, long) || serializeNativeString(NativeArgumentBuffer, NativeString) || serializeNativePointer(NativeArgumentBuffer, NativePointer) || serializeTruffleObject(NativeArgumentBuffer, TruffleObject, AsPointerNode) */) {
                if ((state & 0b1) != 0 /* is-active serializeLong(NativeArgumentBuffer, long) */ && arg1Value instanceof Long) {
                    long arg1Value_ = (long) arg1Value;
                    return serializeLong(arg0Value, arg1Value_);
                }
                if ((state & 0b10) != 0 /* is-active serializeNativeString(NativeArgumentBuffer, NativeString) */ && arg1Value instanceof NativeString) {
                    NativeString arg1Value_ = (NativeString) arg1Value;
                    return serializeNativeString(arg0Value, arg1Value_);
                }
                if ((state & 0b100) != 0 /* is-active serializeNativePointer(NativeArgumentBuffer, NativePointer) */ && arg1Value instanceof NativePointer) {
                    NativePointer arg1Value_ = (NativePointer) arg1Value;
                    return serializeNativePointer(arg0Value, arg1Value_);
                }
                if ((state & 0b1000) != 0 /* is-active serializeTruffleObject(NativeArgumentBuffer, TruffleObject, AsPointerNode) */ && arg1Value instanceof TruffleObject) {
                    TruffleObject arg1Value_ = (TruffleObject) arg1Value;
                    return serializeTruffleObject(arg0Value, arg1Value_, this.serializeTruffleObject_asPointer_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        private boolean executeAndSpecialize(NativeArgumentBuffer arg0Value, Object arg1Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            int exclude = exclude_;
            try {
                if (arg1Value instanceof Long) {
                    long arg1Value_ = (long) arg1Value;
                    this.state_ = state = state | 0b1 /* add-active serializeLong(NativeArgumentBuffer, long) */;
                    lock.unlock();
                    hasLock = false;
                    return serializeLong(arg0Value, arg1Value_);
                }
                if (((exclude & 0b1)) == 0 /* is-not-excluded serializeNativeString(NativeArgumentBuffer, NativeString) */ && arg1Value instanceof NativeString) {
                    NativeString arg1Value_ = (NativeString) arg1Value;
                    this.state_ = state = state | 0b10 /* add-active serializeNativeString(NativeArgumentBuffer, NativeString) */;
                    lock.unlock();
                    hasLock = false;
                    return serializeNativeString(arg0Value, arg1Value_);
                }
                if (((exclude & 0b10)) == 0 /* is-not-excluded serializeNativePointer(NativeArgumentBuffer, NativePointer) */ && arg1Value instanceof NativePointer) {
                    NativePointer arg1Value_ = (NativePointer) arg1Value;
                    this.state_ = state = state | 0b100 /* add-active serializeNativePointer(NativeArgumentBuffer, NativePointer) */;
                    lock.unlock();
                    hasLock = false;
                    return serializeNativePointer(arg0Value, arg1Value_);
                }
                if (arg1Value instanceof TruffleObject) {
                    TruffleObject arg1Value_ = (TruffleObject) arg1Value;
                    this.serializeTruffleObject_asPointer_ = super.insert((SerializePointerArgumentNode.createAsPointer()));
                    this.exclude_ = exclude = exclude | 0b11 /* add-excluded serializeNativeString(NativeArgumentBuffer, NativeString), serializeNativePointer(NativeArgumentBuffer, NativePointer) */;
                    state = state & 0xfffffff9 /* remove-active serializeNativeString(NativeArgumentBuffer, NativeString), serializeNativePointer(NativeArgumentBuffer, NativePointer) */;
                    this.state_ = state = state | 0b1000 /* add-active serializeTruffleObject(NativeArgumentBuffer, TruffleObject, AsPointerNode) */;
                    lock.unlock();
                    hasLock = false;
                    return serializeTruffleObject(arg0Value, arg1Value_, this.serializeTruffleObject_asPointer_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static SerializePointerArgumentNode create(LibFFIType type) {
            return new SerializePointerArgumentNodeGen(type);
        }

    }
    @GeneratedBy(SerializeStringArgumentNode.class)
    static final class SerializeStringArgumentNodeGen extends SerializeStringArgumentNode {

        @CompilationFinal private int state_;
        @Child private AsStringNode serializeOther_asString_;

        private SerializeStringArgumentNodeGen(LibFFIType type) {
            super(type);
        }

        @Override
        boolean execute(NativeArgumentBuffer arg0Value, Object arg1Value) {
            int state = state_;
            if (state != 0 /* is-active serializeNativeString(NativeArgumentBuffer, NativeString) || serializeOther(NativeArgumentBuffer, Object, AsStringNode) */) {
                if ((state & 0b1) != 0 /* is-active serializeNativeString(NativeArgumentBuffer, NativeString) */ && arg1Value instanceof NativeString) {
                    NativeString arg1Value_ = (NativeString) arg1Value;
                    return serializeNativeString(arg0Value, arg1Value_);
                }
                if ((state & 0b10) != 0 /* is-active serializeOther(NativeArgumentBuffer, Object, AsStringNode) */) {
                    if ((SerializeStringArgumentNode.notNativeString(arg1Value))) {
                        return serializeOther(arg0Value, arg1Value, this.serializeOther_asString_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        private boolean executeAndSpecialize(NativeArgumentBuffer arg0Value, Object arg1Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            try {
                if (arg1Value instanceof NativeString) {
                    NativeString arg1Value_ = (NativeString) arg1Value;
                    this.state_ = state = state | 0b1 /* add-active serializeNativeString(NativeArgumentBuffer, NativeString) */;
                    lock.unlock();
                    hasLock = false;
                    return serializeNativeString(arg0Value, arg1Value_);
                }
                if ((SerializeStringArgumentNode.notNativeString(arg1Value))) {
                    this.serializeOther_asString_ = super.insert((SerializeStringArgumentNode.createAsString()));
                    this.state_ = state = state | 0b10 /* add-active serializeOther(NativeArgumentBuffer, Object, AsStringNode) */;
                    lock.unlock();
                    hasLock = false;
                    return serializeOther(arg0Value, arg1Value, this.serializeOther_asString_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static SerializeStringArgumentNode create(LibFFIType type) {
            return new SerializeStringArgumentNodeGen(type);
        }

    }
    @GeneratedBy(SerializeArrayArgumentNode.class)
    static final class SerializeArrayArgumentNodeGen extends SerializeArrayArgumentNode {

        @CompilationFinal private int state_;
        @Child private Node serializeNull_isNull_;
        @CompilationFinal private Class<?> serializeArray1_arrayType_;
        @CompilationFinal private Class<?> serializeArray2_arrayType_;

        private SerializeArrayArgumentNodeGen(ArrayType argType) {
            super(argType);
        }

        @SuppressWarnings("unused")
        private boolean fallbackGuard_(int state, NativeArgumentBuffer arg0Value, Object arg1Value, Object arg2Value) {
            if (arg1Value instanceof TruffleObject) {
                {
                    TruffleObject arg1Value_ = (TruffleObject) arg1Value;
                    if ((((state & 0b10)) == 0 /* is-not-active Guard[(SerializeArgumentNode.checkNull(isNull, arg))] */ || (SerializeArgumentNode.checkNull(this.serializeNull_isNull_, arg1Value_)))) {
                        return false;
                    }
                }
                if (((state & 0b100)) == 0 /* is-not-active serializeArray1(NativeArgumentBuffer, TruffleObject, Object, Class<>) */ && (((state & 0b1000)) == 0 /* is-not-active Guard[(SerializeArrayArgumentNode.isInstanceOf(arrayType, hostObject))] */ || (SerializeArrayArgumentNode.isInstanceOf(this.serializeArray1_arrayType_, arg2Value)))) {
                    return false;
                }
                if (((state & 0b10000)) == 0 /* is-not-active serializeArray2(NativeArgumentBuffer, TruffleObject, Object, Class<>) */ && (((state & 0b100000)) == 0 /* is-not-active Guard[(SerializeArrayArgumentNode.isInstanceOf(arrayType, hostObject))] */ || (SerializeArrayArgumentNode.isInstanceOf(this.serializeArray2_arrayType_, arg2Value)))) {
                    return false;
                }
            }
            return true;
        }

        @Override
        boolean execute(NativeArgumentBuffer arg0Value, Object arg1Value, Object arg2Value) {
            int state = state_;
            if ((state & 0b1010101) != 0 /* is-active serializeNull(NativeArgumentBuffer, TruffleObject, Object, Node) || serializeArray1(NativeArgumentBuffer, TruffleObject, Object, Class<>) || serializeArray2(NativeArgumentBuffer, TruffleObject, Object, Class<>) || error(NativeArgumentBuffer, Object, Object) */) {
                if ((state & 0b10101) != 0 /* is-active serializeNull(NativeArgumentBuffer, TruffleObject, Object, Node) || serializeArray1(NativeArgumentBuffer, TruffleObject, Object, Class<>) || serializeArray2(NativeArgumentBuffer, TruffleObject, Object, Class<>) */ && arg1Value instanceof TruffleObject) {
                    TruffleObject arg1Value_ = (TruffleObject) arg1Value;
                    if ((state & 0b1) != 0 /* is-active serializeNull(NativeArgumentBuffer, TruffleObject, Object, Node) */) {
                        if ((SerializeArgumentNode.checkNull(this.serializeNull_isNull_, arg1Value_))) {
                            return serializeNull(arg0Value, arg1Value_, arg2Value, this.serializeNull_isNull_);
                        }
                    }
                    if ((state & 0b100) != 0 /* is-active serializeArray1(NativeArgumentBuffer, TruffleObject, Object, Class<>) */) {
                        if ((SerializeArrayArgumentNode.isInstanceOf(this.serializeArray1_arrayType_, arg2Value))) {
                            return serializeArray1(arg0Value, arg1Value_, arg2Value, this.serializeArray1_arrayType_);
                        }
                    }
                    if ((state & 0b10000) != 0 /* is-active serializeArray2(NativeArgumentBuffer, TruffleObject, Object, Class<>) */) {
                        if ((SerializeArrayArgumentNode.isInstanceOf(this.serializeArray2_arrayType_, arg2Value))) {
                            return serializeArray2(arg0Value, arg1Value_, arg2Value, this.serializeArray2_arrayType_);
                        }
                    }
                }
                if ((state & 0b1000000) != 0 /* is-active error(NativeArgumentBuffer, Object, Object) */) {
                    if (fallbackGuard_(state, arg0Value, arg1Value, arg2Value)) {
                        return error(arg0Value, arg1Value, arg2Value);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }

        private boolean executeAndSpecialize(NativeArgumentBuffer arg0Value, Object arg1Value, Object arg2Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            try {
                if (arg1Value instanceof TruffleObject) {
                    TruffleObject arg1Value_ = (TruffleObject) arg1Value;
                    boolean SerializeNull_duplicateFound_ = false;
                    if ((state & 0b1) != 0 /* is-active serializeNull(NativeArgumentBuffer, TruffleObject, Object, Node) */) {
                        if ((SerializeArgumentNode.checkNull(this.serializeNull_isNull_, arg1Value_))) {
                            SerializeNull_duplicateFound_ = true;
                        }
                    }
                    if (!SerializeNull_duplicateFound_) {
                        {
                            if (((state & 0b10)) == 0 /* is-not-active Guard[(SerializeArgumentNode.checkNull(isNull, arg))] */) {
                                this.serializeNull_isNull_ = super.insert((SerializeArgumentNode.createIsNull()));
                                this.state_ = state = state | 0b10 /* add-active Guard[(SerializeArgumentNode.checkNull(isNull, arg))] */;
                            }
                            if ((SerializeArgumentNode.checkNull(this.serializeNull_isNull_, arg1Value_)) && ((state & 0b1)) == 0 /* is-not-active serializeNull(NativeArgumentBuffer, TruffleObject, Object, Node) */) {
                                this.state_ = state = state | 0b1 /* add-active serializeNull(NativeArgumentBuffer, TruffleObject, Object, Node) */;
                                SerializeNull_duplicateFound_ = true;
                            }
                        }
                    }
                    if (SerializeNull_duplicateFound_) {
                        lock.unlock();
                        hasLock = false;
                        return serializeNull(arg0Value, arg1Value_, arg2Value, this.serializeNull_isNull_);
                    }
                    boolean SerializeArray1_duplicateFound_ = false;
                    if ((state & 0b100) != 0 /* is-active serializeArray1(NativeArgumentBuffer, TruffleObject, Object, Class<>) */) {
                        if ((SerializeArrayArgumentNode.isInstanceOf(this.serializeArray1_arrayType_, arg2Value))) {
                            SerializeArray1_duplicateFound_ = true;
                        }
                    }
                    if (!SerializeArray1_duplicateFound_) {
                        {
                            if (((state & 0b1000)) == 0 /* is-not-active Guard[(SerializeArrayArgumentNode.isInstanceOf(arrayType, hostObject))] */) {
                                this.serializeArray1_arrayType_ = (argType.getArrayType(arg2Value));
                                this.state_ = state = state | 0b1000 /* add-active Guard[(SerializeArrayArgumentNode.isInstanceOf(arrayType, hostObject))] */;
                            }
                            if ((SerializeArrayArgumentNode.isInstanceOf(this.serializeArray1_arrayType_, arg2Value)) && ((state & 0b100)) == 0 /* is-not-active serializeArray1(NativeArgumentBuffer, TruffleObject, Object, Class<>) */) {
                                this.state_ = state = state | 0b100 /* add-active serializeArray1(NativeArgumentBuffer, TruffleObject, Object, Class<>) */;
                                SerializeArray1_duplicateFound_ = true;
                            }
                        }
                    }
                    if (SerializeArray1_duplicateFound_) {
                        lock.unlock();
                        hasLock = false;
                        return serializeArray1(arg0Value, arg1Value_, arg2Value, this.serializeArray1_arrayType_);
                    }
                    boolean SerializeArray2_duplicateFound_ = false;
                    if ((state & 0b10000) != 0 /* is-active serializeArray2(NativeArgumentBuffer, TruffleObject, Object, Class<>) */) {
                        if ((SerializeArrayArgumentNode.isInstanceOf(this.serializeArray2_arrayType_, arg2Value))) {
                            SerializeArray2_duplicateFound_ = true;
                        }
                    }
                    if (!SerializeArray2_duplicateFound_) {
                        {
                            if (((state & 0b100000)) == 0 /* is-not-active Guard[(SerializeArrayArgumentNode.isInstanceOf(arrayType, hostObject))] */) {
                                this.serializeArray2_arrayType_ = (argType.getArrayType(arg2Value));
                                this.state_ = state = state | 0b100000 /* add-active Guard[(SerializeArrayArgumentNode.isInstanceOf(arrayType, hostObject))] */;
                            }
                            if ((SerializeArrayArgumentNode.isInstanceOf(this.serializeArray2_arrayType_, arg2Value)) && ((state & 0b10000)) == 0 /* is-not-active serializeArray2(NativeArgumentBuffer, TruffleObject, Object, Class<>) */) {
                                this.state_ = state = state | 0b10000 /* add-active serializeArray2(NativeArgumentBuffer, TruffleObject, Object, Class<>) */;
                                SerializeArray2_duplicateFound_ = true;
                            }
                        }
                    }
                    if (SerializeArray2_duplicateFound_) {
                        lock.unlock();
                        hasLock = false;
                        return serializeArray2(arg0Value, arg1Value_, arg2Value, this.serializeArray2_arrayType_);
                    }
                }
                this.state_ = state = state | 0b1000000 /* add-active error(NativeArgumentBuffer, Object, Object) */;
                lock.unlock();
                hasLock = false;
                return error(arg0Value, arg1Value, arg2Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if ((state & 0b1010101) == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else if (((state & 0b1010101) & ((state & 0b1010101) - 1)) == 0 /* is-single-active  */) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static SerializeArrayArgumentNode create(ArrayType argType) {
            return new SerializeArrayArgumentNodeGen(argType);
        }

    }
    @GeneratedBy(SerializeClosureArgumentNode.class)
    static final class SerializeClosureArgumentNodeGen extends SerializeClosureArgumentNode {

        @CompilationFinal private int state_;
        @CompilationFinal private int exclude_;
        @Child private SerializeCachedData serializeCached_cache;
        @Child private SerializeExecutableData serializeExecutable_cache;
        @Child private SerializePointerData serializePointer_cache;

        private SerializeClosureArgumentNodeGen(LibFFIType argType, LibFFISignature signature) {
            super(argType, signature);
        }

        @ExplodeLoop(kind = LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        @Override
        boolean execute(NativeArgumentBuffer arg0Value, Object arg1Value) {
            int state = state_;
            if (state != 0 /* is-active serializeNativePointer(NativeArgumentBuffer, NativePointer) || serializeCached(NativeArgumentBuffer, TruffleObject, TruffleObject, Node, LibFFIClosure) || serializeExecutable(NativeArgumentBuffer, TruffleObject, Node) || serializePointer(NativeArgumentBuffer, TruffleObject, Node, AsPointerNode) */) {
                if ((state & 0b1) != 0 /* is-active serializeNativePointer(NativeArgumentBuffer, NativePointer) */ && arg1Value instanceof NativePointer) {
                    NativePointer arg1Value_ = (NativePointer) arg1Value;
                    return serializeNativePointer(arg0Value, arg1Value_);
                }
                if ((state & 0b1110) != 0 /* is-active serializeCached(NativeArgumentBuffer, TruffleObject, TruffleObject, Node, LibFFIClosure) || serializeExecutable(NativeArgumentBuffer, TruffleObject, Node) || serializePointer(NativeArgumentBuffer, TruffleObject, Node, AsPointerNode) */ && arg1Value instanceof TruffleObject) {
                    TruffleObject arg1Value_ = (TruffleObject) arg1Value;
                    if ((state & 0b10) != 0 /* is-active serializeCached(NativeArgumentBuffer, TruffleObject, TruffleObject, Node, LibFFIClosure) */) {
                        SerializeCachedData s2_ = this.serializeCached_cache;
                        while (s2_ != null) {
                            assert (SerializeClosureArgumentNode.checkExecutable(s2_.isExecutable_, s2_.cachedObject_));
                            if ((arg1Value_ == s2_.cachedObject_)) {
                                return serializeCached(arg0Value, arg1Value_, s2_.cachedObject_, s2_.isExecutable_, s2_.closure_);
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state & 0b100) != 0 /* is-active serializeExecutable(NativeArgumentBuffer, TruffleObject, Node) */) {
                        SerializeExecutableData s3_ = this.serializeExecutable_cache;
                        while (s3_ != null) {
                            if ((SerializeClosureArgumentNode.checkExecutable(s3_.isExecutable_, arg1Value_))) {
                                return serializeExecutable(arg0Value, arg1Value_, s3_.isExecutable_);
                            }
                            s3_ = s3_.next_;
                        }
                    }
                    if ((state & 0b1000) != 0 /* is-active serializePointer(NativeArgumentBuffer, TruffleObject, Node, AsPointerNode) */) {
                        SerializePointerData s4_ = this.serializePointer_cache;
                        while (s4_ != null) {
                            if ((!(SerializeClosureArgumentNode.checkExecutable(s4_.isExecutable_, arg1Value_)))) {
                                return serializePointer(arg0Value, arg1Value_, s4_.isExecutable_, s4_.asPointer_);
                            }
                            s4_ = s4_.next_;
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        private boolean executeAndSpecialize(NativeArgumentBuffer arg0Value, Object arg1Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            int exclude = exclude_;
            try {
                if ((exclude) == 0 /* is-not-excluded serializeNativePointer(NativeArgumentBuffer, NativePointer) */ && arg1Value instanceof NativePointer) {
                    NativePointer arg1Value_ = (NativePointer) arg1Value;
                    this.state_ = state = state | 0b1 /* add-active serializeNativePointer(NativeArgumentBuffer, NativePointer) */;
                    lock.unlock();
                    hasLock = false;
                    return serializeNativePointer(arg0Value, arg1Value_);
                }
                if (arg1Value instanceof TruffleObject) {
                    TruffleObject arg1Value_ = (TruffleObject) arg1Value;
                    int count2_ = 0;
                    SerializeCachedData s2_ = this.serializeCached_cache;
                    if ((state & 0b10) != 0 /* is-active serializeCached(NativeArgumentBuffer, TruffleObject, TruffleObject, Node, LibFFIClosure) */) {
                        while (s2_ != null) {
                            assert (SerializeClosureArgumentNode.checkExecutable(s2_.isExecutable_, s2_.cachedObject_));
                            if ((arg1Value_ == s2_.cachedObject_)) {
                                break;
                            }
                            s2_ = s2_.next_;
                            count2_++;
                        }
                    }
                    if (s2_ == null) {
                        {
                            TruffleObject cachedObject__ = (arg1Value_);
                            Node isExecutable__ = (SerializeClosureArgumentNode.createIsExecutable());
                            if ((SerializeClosureArgumentNode.checkExecutable(isExecutable__, cachedObject__))) {
                                // assert (arg1Value_ == cachedObject__);
                                if (count2_ < (5)) {
                                    s2_ = new SerializeCachedData(serializeCached_cache);
                                    s2_.cachedObject_ = cachedObject__;
                                    s2_.isExecutable_ = isExecutable__;
                                    s2_.closure_ = (createClosure(arg1Value_));
                                    this.serializeCached_cache = super.insert(s2_);
                                    this.state_ = state = state | 0b10 /* add-active serializeCached(NativeArgumentBuffer, TruffleObject, TruffleObject, Node, LibFFIClosure) */;
                                }
                            }
                        }
                    }
                    if (s2_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return serializeCached(arg0Value, arg1Value_, s2_.cachedObject_, s2_.isExecutable_, s2_.closure_);
                    }
                    int count3_ = 0;
                    SerializeExecutableData s3_ = this.serializeExecutable_cache;
                    if ((state & 0b100) != 0 /* is-active serializeExecutable(NativeArgumentBuffer, TruffleObject, Node) */) {
                        while (s3_ != null) {
                            if ((SerializeClosureArgumentNode.checkExecutable(s3_.isExecutable_, arg1Value_))) {
                                break;
                            }
                            s3_ = s3_.next_;
                            count3_++;
                        }
                    }
                    if (s3_ == null) {
                        {
                            Node isExecutable__ = (SerializeClosureArgumentNode.createIsExecutable());
                            if ((SerializeClosureArgumentNode.checkExecutable(isExecutable__, arg1Value_)) && count3_ < (3)) {
                                s3_ = new SerializeExecutableData(serializeExecutable_cache);
                                s3_.isExecutable_ = isExecutable__;
                                this.serializeExecutable_cache = super.insert(s3_);
                                this.state_ = state = state | 0b100 /* add-active serializeExecutable(NativeArgumentBuffer, TruffleObject, Node) */;
                            }
                        }
                    }
                    if (s3_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return serializeExecutable(arg0Value, arg1Value_, s3_.isExecutable_);
                    }
                    int count4_ = 0;
                    SerializePointerData s4_ = this.serializePointer_cache;
                    if ((state & 0b1000) != 0 /* is-active serializePointer(NativeArgumentBuffer, TruffleObject, Node, AsPointerNode) */) {
                        while (s4_ != null) {
                            if ((!(SerializeClosureArgumentNode.checkExecutable(s4_.isExecutable_, arg1Value_)))) {
                                break;
                            }
                            s4_ = s4_.next_;
                            count4_++;
                        }
                    }
                    if (s4_ == null) {
                        {
                            Node isExecutable__ = (SerializeClosureArgumentNode.createIsExecutable());
                            if ((!(SerializeClosureArgumentNode.checkExecutable(isExecutable__, arg1Value_))) && count4_ < (3)) {
                                s4_ = new SerializePointerData(serializePointer_cache);
                                s4_.isExecutable_ = isExecutable__;
                                s4_.asPointer_ = (SerializeClosureArgumentNode.createAsPointer());
                                this.serializePointer_cache = super.insert(s4_);
                                this.exclude_ = exclude = exclude | 0b1 /* add-excluded serializeNativePointer(NativeArgumentBuffer, NativePointer) */;
                                state = state & 0xfffffffe /* remove-active serializeNativePointer(NativeArgumentBuffer, NativePointer) */;
                                this.state_ = state = state | 0b1000 /* add-active serializePointer(NativeArgumentBuffer, TruffleObject, Node, AsPointerNode) */;
                            }
                        }
                    }
                    if (s4_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return serializePointer(arg0Value, arg1Value_, s4_.isExecutable_, s4_.asPointer_);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                SerializeCachedData s2_ = this.serializeCached_cache;
                SerializeExecutableData s3_ = this.serializeExecutable_cache;
                SerializePointerData s4_ = this.serializePointer_cache;
                if ((s2_ == null || s2_.next_ == null) && (s3_ == null || s3_.next_ == null) && (s4_ == null || s4_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static SerializeClosureArgumentNode create(LibFFIType argType, LibFFISignature signature) {
            return new SerializeClosureArgumentNodeGen(argType, signature);
        }

        @GeneratedBy(SerializeClosureArgumentNode.class)
        private static final class SerializeCachedData extends Node {

            @Child SerializeCachedData next_;
            @CompilationFinal TruffleObject cachedObject_;
            @Child Node isExecutable_;
            @CompilationFinal LibFFIClosure closure_;

            SerializeCachedData(SerializeCachedData next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(SerializeClosureArgumentNode.class)
        private static final class SerializeExecutableData extends Node {

            @Child SerializeExecutableData next_;
            @Child Node isExecutable_;

            SerializeExecutableData(SerializeExecutableData next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(SerializeClosureArgumentNode.class)
        private static final class SerializePointerData extends Node {

            @Child SerializePointerData next_;
            @Child Node isExecutable_;
            @Child AsPointerNode asPointer_;

            SerializePointerData(SerializePointerData next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
    }
}
