package com.oracle.truffle.nfi.impl;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.ForeignAccess.Factory;
import com.oracle.truffle.api.interop.ForeignAccess.StandardFactory;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.RootNode;
import java.util.function.Supplier;

/**
 * This foreign access factory is generated by {@link com.oracle.truffle.nfi.impl.NativeStringMessageResolution}.
 * You are supposed to use it for the receiver object {@link com.oracle.truffle.nfi.impl.NativeString}.
 */
@GeneratedBy(com.oracle.truffle.nfi.impl.NativeStringMessageResolution.class)
final class NativeStringMessageResolutionForeign implements StandardFactory, Factory {
    public static final ForeignAccess ACCESS = ForeignAccess.createAccess(new NativeStringMessageResolutionForeign(), new Supplier<RootNode>() { @Override public RootNode get() { return CanResolveNativeStringSubNode.createRoot(); }});
    @Deprecated public static ForeignAccess createAccess() { return ForeignAccess.createAccess(new NativeStringMessageResolutionForeign(), new Supplier<RootNode>() { @Override public RootNode get() { return CanResolveNativeStringSubNode.createRoot(); }}); }

    private NativeStringMessageResolutionForeign() { }

    @Override
    @TruffleBoundary
    public boolean canHandle(TruffleObject obj) {
        return (boolean) Truffle.getRuntime().createCallTarget(CanResolveNativeStringSubNode.createRoot()).call(obj);
    }

    @Override
    public CallTarget accessIsNull() {
      return Truffle.getRuntime().createCallTarget(IsNullNativeStringSubNode.createRoot());
    }
    @Override
    public CallTarget accessIsExecutable() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessIsInstantiable() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessIsBoxed() {
      return Truffle.getRuntime().createCallTarget(IsBoxedNativeStringSubNode.createRoot());
    }
    @Override
    public CallTarget accessHasKeys() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessHasSize() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessGetSize() {
      return null;
    }
    @Override
    public CallTarget accessUnbox() {
      return com.oracle.truffle.api.Truffle.getRuntime().createCallTarget(UnboxNativeStringSubNode.createRoot());
    }
    @Override
    public CallTarget accessRead() {
      return null;
    }
    @Override
    public CallTarget accessWrite() {
      return null;
    }
    @Override
    public CallTarget accessRemove() {
      return null;
    }
    @Override
    public CallTarget accessExecute(int argumentsLength) {
      return null;
    }
    @Override
    public CallTarget accessInvoke(int argumentsLength) {
      return null;
    }
    @Override
    public CallTarget accessNew(int argumentsLength) {
      return null;
    }
    @Override
    public CallTarget accessKeyInfo() {
      return null;
    }
    @Override
    public CallTarget accessKeys() {
      return null;
    }
    @Override
    public CallTarget accessIsPointer() {
      return Truffle.getRuntime().createCallTarget(IsPointerNativeStringSubNode.createRoot());
    }
    @Override
    public CallTarget accessAsPointer() {
      return com.oracle.truffle.api.Truffle.getRuntime().createCallTarget(AsPointerNativeStringSubNode.createRoot());
    }
    @Override
    public CallTarget accessToNative() {
      return null;
    }
    @Override
    public CallTarget accessMessage(Message unknown) {
      return null;
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.nfi.impl.NativeStringMessageResolution.AsPointerNativeStringNode}.
     */
    abstract static class AsPointerNativeStringSubNode extends com.oracle.truffle.nfi.impl.NativeStringMessageResolution.AsPointerNativeStringNode {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o0);
        @Specialization
        protected Object accessWithTarget(com.oracle.truffle.nfi.impl.NativeString receiver) {
            return access(receiver);
        }
        private static final class AS_POINTERRootNode extends RootNode {
            protected AS_POINTERRootNode() {
                super(null);
            }

            @Child private AsPointerNativeStringSubNode node = com.oracle.truffle.nfi.impl.NativeStringMessageResolutionForeignFactory.AsPointerNativeStringSubNodeGen.create();
            @Override
            public String getName() {
                return "Interop::AS_POINTER::" + com.oracle.truffle.nfi.impl.NativeString.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object receiver = ForeignAccess.getReceiver(frame);
                try {
                    return node.executeWithTarget(frame, receiver);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof AsPointerNativeStringSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }

        }
        public static RootNode createRoot() {
            return new AS_POINTERRootNode();
        }
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.nfi.impl.NativeStringMessageResolution.IsNullNativeStringNode}.
     */
    abstract static class IsNullNativeStringSubNode extends com.oracle.truffle.nfi.impl.NativeStringMessageResolution.IsNullNativeStringNode {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o0);
        @Specialization
        protected Object accessWithTarget(com.oracle.truffle.nfi.impl.NativeString receiver) {
            return access(receiver);
        }
        private static final class IS_NULLRootNode extends RootNode {
            protected IS_NULLRootNode() {
                super(null);
            }

            @Child private IsNullNativeStringSubNode node = com.oracle.truffle.nfi.impl.NativeStringMessageResolutionForeignFactory.IsNullNativeStringSubNodeGen.create();
            @Override
            public String getName() {
                return "Interop::IS_NULL::" + com.oracle.truffle.nfi.impl.NativeString.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object receiver = ForeignAccess.getReceiver(frame);
                try {
                    return node.executeWithTarget(frame, receiver);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof IsNullNativeStringSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }

        }
        public static RootNode createRoot() {
            return new IS_NULLRootNode();
        }
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.nfi.impl.NativeStringMessageResolution.UnboxNativeStringNode}.
     */
    abstract static class UnboxNativeStringSubNode extends com.oracle.truffle.nfi.impl.NativeStringMessageResolution.UnboxNativeStringNode {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o0);
        @Specialization
        protected Object accessWithTarget(com.oracle.truffle.nfi.impl.NativeString receiver) {
            return access(receiver);
        }
        private static final class UNBOXRootNode extends RootNode {
            protected UNBOXRootNode() {
                super(null);
            }

            @Child private UnboxNativeStringSubNode node = com.oracle.truffle.nfi.impl.NativeStringMessageResolutionForeignFactory.UnboxNativeStringSubNodeGen.create();
            @Override
            public String getName() {
                return "Interop::UNBOX::" + com.oracle.truffle.nfi.impl.NativeString.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object receiver = ForeignAccess.getReceiver(frame);
                try {
                    return node.executeWithTarget(frame, receiver);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof UnboxNativeStringSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }

        }
        public static RootNode createRoot() {
            return new UNBOXRootNode();
        }
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.nfi.impl.NativeStringMessageResolution.IsBoxedNativeStringNode}.
     */
    abstract static class IsBoxedNativeStringSubNode extends com.oracle.truffle.nfi.impl.NativeStringMessageResolution.IsBoxedNativeStringNode {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o0);
        @Specialization
        protected Object accessWithTarget(com.oracle.truffle.nfi.impl.NativeString receiver) {
            return access(receiver);
        }
        private static final class IS_BOXEDRootNode extends RootNode {
            protected IS_BOXEDRootNode() {
                super(null);
            }

            @Child private IsBoxedNativeStringSubNode node = com.oracle.truffle.nfi.impl.NativeStringMessageResolutionForeignFactory.IsBoxedNativeStringSubNodeGen.create();
            @Override
            public String getName() {
                return "Interop::IS_BOXED::" + com.oracle.truffle.nfi.impl.NativeString.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object receiver = ForeignAccess.getReceiver(frame);
                try {
                    return node.executeWithTarget(frame, receiver);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof IsBoxedNativeStringSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }

        }
        public static RootNode createRoot() {
            return new IS_BOXEDRootNode();
        }
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.nfi.impl.NativeStringMessageResolution.IsPointerNativeStringNode}.
     */
    abstract static class IsPointerNativeStringSubNode extends com.oracle.truffle.nfi.impl.NativeStringMessageResolution.IsPointerNativeStringNode {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o0);
        @Specialization
        protected Object accessWithTarget(com.oracle.truffle.nfi.impl.NativeString receiver) {
            return access(receiver);
        }
        private static final class IS_POINTERRootNode extends RootNode {
            protected IS_POINTERRootNode() {
                super(null);
            }

            @Child private IsPointerNativeStringSubNode node = com.oracle.truffle.nfi.impl.NativeStringMessageResolutionForeignFactory.IsPointerNativeStringSubNodeGen.create();
            @Override
            public String getName() {
                return "Interop::IS_POINTER::" + com.oracle.truffle.nfi.impl.NativeString.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object receiver = ForeignAccess.getReceiver(frame);
                try {
                    return node.executeWithTarget(frame, receiver);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof IsPointerNativeStringSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }

        }
        public static RootNode createRoot() {
            return new IS_POINTERRootNode();
        }
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.nfi.impl.NativeStringMessageResolution.CanResolveNativeStringNode}.
     * Generated for {@link com.oracle.truffle.nfi.impl.NativeString}.
     */
    abstract static class CanResolveNativeStringSubNode extends com.oracle.truffle.nfi.impl.NativeStringMessageResolution.CanResolveNativeStringNode {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o);
        @Specialization
        protected Object testWithTarget(com.oracle.truffle.api.interop.TruffleObject receiver) {
            return test(receiver);
        }
        private static final class LanguageCheckRootNode extends RootNode {
            protected LanguageCheckRootNode() {
                super(null);
            }

            @Child private CanResolveNativeStringSubNode node = com.oracle.truffle.nfi.impl.NativeStringMessageResolutionForeignFactory.CanResolveNativeStringSubNodeGen.create();
            @Override
            public Object execute(VirtualFrame frame) {
                Object receiver = ForeignAccess.getReceiver(frame);
                try {
                    return node.executeWithTarget(frame, receiver);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof CanResolveNativeStringSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }

        }
        public static RootNode createRoot() {
            return new LanguageCheckRootNode();
        }
    }
}
