// CheckStyle: start generated
package com.oracle.truffle.nfi.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.ExplodeLoop.LoopExplosionKind;
import com.oracle.truffle.nfi.impl.LibFFILibraryMessageResolution.CachedLookupSymbolNode;
import java.util.concurrent.locks.Lock;

@GeneratedBy(LibFFILibraryMessageResolution.class)
final class LibFFILibraryMessageResolutionFactory {

    @GeneratedBy(CachedLookupSymbolNode.class)
    static final class CachedLookupSymbolNodeGen extends CachedLookupSymbolNode {

        @CompilationFinal private int state_;
        @CompilationFinal private int exclude_;
        @CompilationFinal private LookupCachedData lookupCached_cache;

        private CachedLookupSymbolNodeGen() {
        }

        @ExplodeLoop(kind = LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        @Override
        protected TruffleObject executeLookup(LibFFILibrary arg0Value, String arg1Value) {
            int state = state_;
            if (state != 0 /* is-active lookupCached(LibFFILibrary, String, LibFFILibrary, String, TruffleObject) || lookup(LibFFILibrary, String) */) {
                if ((state & 0b1) != 0 /* is-active lookupCached(LibFFILibrary, String, LibFFILibrary, String, TruffleObject) */) {
                    LookupCachedData s1_ = this.lookupCached_cache;
                    while (s1_ != null) {
                        if ((arg0Value == s1_.cachedReceiver_) && (arg1Value.equals(s1_.cachedSymbol_))) {
                            return lookupCached(arg0Value, arg1Value, s1_.cachedReceiver_, s1_.cachedSymbol_, s1_.cachedRet_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 0b10) != 0 /* is-active lookup(LibFFILibrary, String) */) {
                    return lookup(arg0Value, arg1Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        private TruffleObject executeAndSpecialize(LibFFILibrary arg0Value, String arg1Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            int exclude = exclude_;
            try {
                if ((exclude) == 0 /* is-not-excluded lookupCached(LibFFILibrary, String, LibFFILibrary, String, TruffleObject) */) {
                    int count1_ = 0;
                    LookupCachedData s1_ = this.lookupCached_cache;
                    if ((state & 0b1) != 0 /* is-active lookupCached(LibFFILibrary, String, LibFFILibrary, String, TruffleObject) */) {
                        while (s1_ != null) {
                            if ((arg0Value == s1_.cachedReceiver_) && (arg1Value.equals(s1_.cachedSymbol_))) {
                                break;
                            }
                            s1_ = s1_.next_;
                            count1_++;
                        }
                    }
                    if (s1_ == null) {
                        // assert (arg0Value == s1_.cachedReceiver_);
                        // assert (arg1Value.equals(s1_.cachedSymbol_));
                        if (count1_ < (3)) {
                            s1_ = new LookupCachedData(lookupCached_cache);
                            s1_.cachedReceiver_ = (arg0Value);
                            s1_.cachedSymbol_ = (arg1Value);
                            s1_.cachedRet_ = (lookup(s1_.cachedReceiver_, s1_.cachedSymbol_));
                            this.lookupCached_cache = s1_;
                            this.state_ = state = state | 0b1 /* add-active lookupCached(LibFFILibrary, String, LibFFILibrary, String, TruffleObject) */;
                        }
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return lookupCached(arg0Value, arg1Value, s1_.cachedReceiver_, s1_.cachedSymbol_, s1_.cachedRet_);
                    }
                }
                this.exclude_ = exclude = exclude | 0b1 /* add-excluded lookupCached(LibFFILibrary, String, LibFFILibrary, String, TruffleObject) */;
                this.lookupCached_cache = null;
                state = state & 0xfffffffe /* remove-active lookupCached(LibFFILibrary, String, LibFFILibrary, String, TruffleObject) */;
                this.state_ = state = state | 0b10 /* add-active lookup(LibFFILibrary, String) */;
                lock.unlock();
                hasLock = false;
                return lookup(arg0Value, arg1Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                LookupCachedData s1_ = this.lookupCached_cache;
                if ((s1_ == null || s1_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static CachedLookupSymbolNode create() {
            return new CachedLookupSymbolNodeGen();
        }

        @GeneratedBy(CachedLookupSymbolNode.class)
        private static final class LookupCachedData {

            @CompilationFinal LookupCachedData next_;
            @CompilationFinal LibFFILibrary cachedReceiver_;
            @CompilationFinal String cachedSymbol_;
            @CompilationFinal TruffleObject cachedRet_;

            LookupCachedData(LookupCachedData next_) {
                this.next_ = next_;
            }

        }
    }
}
