// CheckStyle: start generated
package com.oracle.truffle.nfi.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.ExplodeLoop.LoopExplosionKind;
import com.oracle.truffle.nfi.impl.LibFFIFunctionMessageResolution.CachedExecuteNode;
import java.util.concurrent.locks.Lock;

@GeneratedBy(LibFFIFunctionMessageResolution.class)
final class LibFFIFunctionMessageResolutionFactory {

    @GeneratedBy(CachedExecuteNode.class)
    static final class CachedExecuteNodeGen extends CachedExecuteNode {

        @CompilationFinal private int state_;
        @CompilationFinal private int exclude_;
        @Child private CachedSignatureData cachedSignature_cache;
        @Child private CachedArgCountData cachedArgCount_cache;
        @Child private SlowPathSerializeArgumentNode genericExecute_serializeArgs_;

        private CachedExecuteNodeGen() {
        }

        @ExplodeLoop(kind = LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        @Override
        public Object execute(LibFFIFunction arg0Value, Object[] arg1Value) {
            int state = state_;
            if (state != 0 /* is-active cachedSignature(LibFFIFunction, Object[], LibFFISignature, SerializeArgumentNode[]) || cachedArgCount(LibFFIFunction, Object[], SlowPathSerializeArgumentNode[]) || genericExecute(LibFFIFunction, Object[], SlowPathSerializeArgumentNode) */) {
                if ((state & 0b1) != 0 /* is-active cachedSignature(LibFFIFunction, Object[], LibFFISignature, SerializeArgumentNode[]) */) {
                    CachedSignatureData s1_ = this.cachedSignature_cache;
                    while (s1_ != null) {
                        if ((CachedExecuteNode.checkSignature(arg0Value, s1_.signature_))) {
                            return cachedSignature(arg0Value, arg1Value, s1_.signature_, s1_.serializeArgs_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 0b10) != 0 /* is-active cachedArgCount(LibFFIFunction, Object[], SlowPathSerializeArgumentNode[]) */) {
                    CachedArgCountData s2_ = this.cachedArgCount_cache;
                    while (s2_ != null) {
                        if ((arg0Value.getSignature().getArgTypes().length == s2_.serializeArgs_.length)) {
                            return cachedArgCount(arg0Value, arg1Value, s2_.serializeArgs_);
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state & 0b100) != 0 /* is-active genericExecute(LibFFIFunction, Object[], SlowPathSerializeArgumentNode) */) {
                    return genericExecute(arg0Value, arg1Value, this.genericExecute_serializeArgs_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        private Object executeAndSpecialize(LibFFIFunction arg0Value, Object[] arg1Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            int exclude = exclude_;
            try {
                if (((exclude & 0b1)) == 0 /* is-not-excluded cachedSignature(LibFFIFunction, Object[], LibFFISignature, SerializeArgumentNode[]) */) {
                    int count1_ = 0;
                    CachedSignatureData s1_ = this.cachedSignature_cache;
                    if ((state & 0b1) != 0 /* is-active cachedSignature(LibFFIFunction, Object[], LibFFISignature, SerializeArgumentNode[]) */) {
                        while (s1_ != null) {
                            if ((CachedExecuteNode.checkSignature(arg0Value, s1_.signature_))) {
                                break;
                            }
                            s1_ = s1_.next_;
                            count1_++;
                        }
                    }
                    if (s1_ == null) {
                        {
                            LibFFISignature signature__ = (arg0Value.getSignature());
                            if ((CachedExecuteNode.checkSignature(arg0Value, signature__)) && count1_ < (3)) {
                                s1_ = new CachedSignatureData(cachedSignature_cache);
                                s1_.signature_ = signature__;
                                s1_.serializeArgs_ = (CachedExecuteNode.getSerializeArgumentNodes(signature__));
                                this.cachedSignature_cache = super.insert(s1_);
                                this.state_ = state = state | 0b1 /* add-active cachedSignature(LibFFIFunction, Object[], LibFFISignature, SerializeArgumentNode[]) */;
                            }
                        }
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return cachedSignature(arg0Value, arg1Value, s1_.signature_, s1_.serializeArgs_);
                    }
                }
                if (((exclude & 0b10)) == 0 /* is-not-excluded cachedArgCount(LibFFIFunction, Object[], SlowPathSerializeArgumentNode[]) */) {
                    int count2_ = 0;
                    CachedArgCountData s2_ = this.cachedArgCount_cache;
                    if ((state & 0b10) != 0 /* is-active cachedArgCount(LibFFIFunction, Object[], SlowPathSerializeArgumentNode[]) */) {
                        while (s2_ != null) {
                            if ((arg0Value.getSignature().getArgTypes().length == s2_.serializeArgs_.length)) {
                                break;
                            }
                            s2_ = s2_.next_;
                            count2_++;
                        }
                    }
                    if (s2_ == null) {
                        {
                            SlowPathSerializeArgumentNode[] serializeArgs__ = (CachedExecuteNode.getSlowPathSerializeArgumentNodes(arg0Value));
                            if ((arg0Value.getSignature().getArgTypes().length == serializeArgs__.length) && count2_ < (3)) {
                                s2_ = new CachedArgCountData(cachedArgCount_cache);
                                s2_.serializeArgs_ = serializeArgs__;
                                this.cachedArgCount_cache = super.insert(s2_);
                                this.exclude_ = exclude = exclude | 0b1 /* add-excluded cachedSignature(LibFFIFunction, Object[], LibFFISignature, SerializeArgumentNode[]) */;
                                this.cachedSignature_cache = null;
                                state = state & 0xfffffffe /* remove-active cachedSignature(LibFFIFunction, Object[], LibFFISignature, SerializeArgumentNode[]) */;
                                this.state_ = state = state | 0b10 /* add-active cachedArgCount(LibFFIFunction, Object[], SlowPathSerializeArgumentNode[]) */;
                            }
                        }
                    }
                    if (s2_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return cachedArgCount(arg0Value, arg1Value, s2_.serializeArgs_);
                    }
                }
                this.genericExecute_serializeArgs_ = super.insert((CachedExecuteNode.createSlowPathSerializeArgumentNode()));
                this.exclude_ = exclude = exclude | 0b11 /* add-excluded cachedSignature(LibFFIFunction, Object[], LibFFISignature, SerializeArgumentNode[]), cachedArgCount(LibFFIFunction, Object[], SlowPathSerializeArgumentNode[]) */;
                this.cachedSignature_cache = null;
                this.cachedArgCount_cache = null;
                state = state & 0xfffffffc /* remove-active cachedSignature(LibFFIFunction, Object[], LibFFISignature, SerializeArgumentNode[]), cachedArgCount(LibFFIFunction, Object[], SlowPathSerializeArgumentNode[]) */;
                this.state_ = state = state | 0b100 /* add-active genericExecute(LibFFIFunction, Object[], SlowPathSerializeArgumentNode) */;
                lock.unlock();
                hasLock = false;
                return genericExecute(arg0Value, arg1Value, this.genericExecute_serializeArgs_);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                CachedSignatureData s1_ = this.cachedSignature_cache;
                CachedArgCountData s2_ = this.cachedArgCount_cache;
                if ((s1_ == null || s1_.next_ == null) && (s2_ == null || s2_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static CachedExecuteNode create() {
            return new CachedExecuteNodeGen();
        }

        @GeneratedBy(CachedExecuteNode.class)
        private static final class CachedSignatureData extends Node {

            @Child CachedSignatureData next_;
            @CompilationFinal LibFFISignature signature_;
            @Children SerializeArgumentNode[] serializeArgs_;

            CachedSignatureData(CachedSignatureData next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(CachedExecuteNode.class)
        private static final class CachedArgCountData extends Node {

            @Child CachedArgCountData next_;
            @Children SlowPathSerializeArgumentNode[] serializeArgs_;

            CachedArgCountData(CachedArgCountData next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
    }
}
