// CheckStyle: start generated
package com.oracle.truffle.nfi.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.ExplodeLoop.LoopExplosionKind;
import com.oracle.truffle.nfi.impl.BindSignatureNode.PointerBindSignatureNode;
import com.oracle.truffle.nfi.impl.BindSignatureNode.ReBindSignatureNode;
import com.oracle.truffle.nfi.impl.BindSignatureNode.SignatureCacheNode;
import java.util.concurrent.locks.Lock;

@GeneratedBy(BindSignatureNode.class)
final class BindSignatureNodeFactory {

    @GeneratedBy(SignatureCacheNode.class)
    static final class SignatureCacheNodeGen extends SignatureCacheNode {

        @CompilationFinal private int state_;
        @CompilationFinal private int exclude_;
        @CompilationFinal private CachedData cached_cache;

        private SignatureCacheNodeGen() {
        }

        @ExplodeLoop(kind = LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        @Override
        protected LibFFISignature execute(String arg0Value) {
            int state = state_;
            if (state != 0 /* is-active cached(String, String, LibFFISignature) || parse(String) */) {
                if ((state & 0b1) != 0 /* is-active cached(String, String, LibFFISignature) */) {
                    CachedData s1_ = this.cached_cache;
                    while (s1_ != null) {
                        if ((SignatureCacheNode.checkSignature(arg0Value, s1_.cachedSignature_))) {
                            return cached(arg0Value, s1_.cachedSignature_, s1_.ret_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 0b10) != 0 /* is-active parse(String) */) {
                    return parse(arg0Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value);
        }

        private LibFFISignature executeAndSpecialize(String arg0Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            int exclude = exclude_;
            try {
                if ((exclude) == 0 /* is-not-excluded cached(String, String, LibFFISignature) */) {
                    int count1_ = 0;
                    CachedData s1_ = this.cached_cache;
                    if ((state & 0b1) != 0 /* is-active cached(String, String, LibFFISignature) */) {
                        while (s1_ != null) {
                            if ((SignatureCacheNode.checkSignature(arg0Value, s1_.cachedSignature_))) {
                                break;
                            }
                            s1_ = s1_.next_;
                            count1_++;
                        }
                    }
                    if (s1_ == null) {
                        {
                            String cachedSignature__ = (arg0Value);
                            if ((SignatureCacheNode.checkSignature(arg0Value, cachedSignature__)) && count1_ < (3)) {
                                s1_ = new CachedData(cached_cache);
                                s1_.cachedSignature_ = cachedSignature__;
                                s1_.ret_ = (parse(arg0Value));
                                this.cached_cache = s1_;
                                this.state_ = state = state | 0b1 /* add-active cached(String, String, LibFFISignature) */;
                            }
                        }
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return cached(arg0Value, s1_.cachedSignature_, s1_.ret_);
                    }
                }
                this.exclude_ = exclude = exclude | 0b1 /* add-excluded cached(String, String, LibFFISignature) */;
                this.cached_cache = null;
                state = state & 0xfffffffe /* remove-active cached(String, String, LibFFISignature) */;
                this.state_ = state = state | 0b10 /* add-active parse(String) */;
                lock.unlock();
                hasLock = false;
                return parse(arg0Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                CachedData s1_ = this.cached_cache;
                if ((s1_ == null || s1_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static SignatureCacheNode create() {
            return new SignatureCacheNodeGen();
        }

        @GeneratedBy(SignatureCacheNode.class)
        private static final class CachedData {

            @CompilationFinal CachedData next_;
            @CompilationFinal String cachedSignature_;
            @CompilationFinal LibFFISignature ret_;

            CachedData(CachedData next_) {
                this.next_ = next_;
            }

        }
    }
    @GeneratedBy(PointerBindSignatureNode.class)
    static final class PointerBindSignatureNodeGen extends PointerBindSignatureNode {

        @CompilationFinal private int state_;

        private PointerBindSignatureNodeGen() {
        }

        @Override
        TruffleObject execute(TruffleObject arg0Value, Object arg1Value) {
            int state = state_;
            if (state != 0 /* is-active doNull(NativePointer, Object) || doFunction(NativePointer, Object) */ && arg0Value instanceof NativePointer) {
                NativePointer arg0Value_ = (NativePointer) arg0Value;
                if ((state & 0b1) != 0 /* is-active doNull(NativePointer, Object) */) {
                    if ((PointerBindSignatureNode.checkNull(arg0Value_))) {
                        return doNull(arg0Value_, arg1Value);
                    }
                }
                if ((state & 0b10) != 0 /* is-active doFunction(NativePointer, Object) */) {
                    if ((!(PointerBindSignatureNode.checkNull(arg0Value_)))) {
                        return doFunction(arg0Value_, arg1Value);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        private TruffleObject executeAndSpecialize(TruffleObject arg0Value, Object arg1Value) {
            int state = state_;
            if (arg0Value instanceof NativePointer) {
                NativePointer arg0Value_ = (NativePointer) arg0Value;
                if ((PointerBindSignatureNode.checkNull(arg0Value_))) {
                    this.state_ = state = state | 0b1 /* add-active doNull(NativePointer, Object) */;
                    return doNull(arg0Value_, arg1Value);
                }
                if ((!(PointerBindSignatureNode.checkNull(arg0Value_)))) {
                    this.state_ = state = state | 0b10 /* add-active doFunction(NativePointer, Object) */;
                    return doFunction(arg0Value_, arg1Value);
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static PointerBindSignatureNode create() {
            return new PointerBindSignatureNodeGen();
        }

    }
    @GeneratedBy(ReBindSignatureNode.class)
    static final class ReBindSignatureNodeGen extends ReBindSignatureNode {

        @CompilationFinal private int state_;

        private ReBindSignatureNodeGen() {
        }

        @Override
        TruffleObject execute(TruffleObject arg0Value, Object arg1Value) {
            int state = state_;
            if (state != 0 /* is-active rebind(LibFFIFunction, Object) */ && arg0Value instanceof LibFFIFunction) {
                LibFFIFunction arg0Value_ = (LibFFIFunction) arg0Value;
                return rebind(arg0Value_, arg1Value);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        private TruffleObject executeAndSpecialize(TruffleObject arg0Value, Object arg1Value) {
            int state = state_;
            if (arg0Value instanceof LibFFIFunction) {
                LibFFIFunction arg0Value_ = (LibFFIFunction) arg0Value;
                this.state_ = state = state | 0b1 /* add-active rebind(LibFFIFunction, Object) */;
                return rebind(arg0Value_, arg1Value);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static ReBindSignatureNode create() {
            return new ReBindSignatureNodeGen();
        }

    }
}
