// CheckStyle: start generated
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.ExplodeLoop.LoopExplosionKind;
import com.oracle.truffle.nfi.NFILibraryMessageResolution.CachedLookupSymbolNode;
import com.oracle.truffle.nfi.NFILibraryMessageResolution.IdentToStringNode;
import java.util.concurrent.locks.Lock;

@GeneratedBy(NFILibraryMessageResolution.class)
final class NFILibraryMessageResolutionFactory {

    @GeneratedBy(CachedLookupSymbolNode.class)
    static final class CachedLookupSymbolNodeGen extends CachedLookupSymbolNode {

        @CompilationFinal private int state_;
        @CompilationFinal private int exclude_;
        @CompilationFinal private LookupCachedData lookupCached_cache;
        @Child private Node lookup_read_;

        private CachedLookupSymbolNodeGen() {
        }

        @ExplodeLoop(kind = LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        @Override
        protected TruffleObject executeLookup(NFILibrary arg0Value, String arg1Value) {
            int state = state_;
            if (state != 0 /* is-active lookupCached(NFILibrary, String, NFILibrary, String, TruffleObject) || lookup(NFILibrary, String, Node) */) {
                if ((state & 0b1) != 0 /* is-active lookupCached(NFILibrary, String, NFILibrary, String, TruffleObject) */) {
                    LookupCachedData s1_ = this.lookupCached_cache;
                    while (s1_ != null) {
                        if ((arg0Value == s1_.cachedReceiver_) && (arg1Value.equals(s1_.cachedSymbol_))) {
                            return lookupCached(arg0Value, arg1Value, s1_.cachedReceiver_, s1_.cachedSymbol_, s1_.cachedRet_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 0b10) != 0 /* is-active lookup(NFILibrary, String, Node) */) {
                    return lookup(arg0Value, arg1Value, this.lookup_read_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        private TruffleObject executeAndSpecialize(NFILibrary arg0Value, String arg1Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            int exclude = exclude_;
            try {
                if ((exclude) == 0 /* is-not-excluded lookupCached(NFILibrary, String, NFILibrary, String, TruffleObject) */) {
                    int count1_ = 0;
                    LookupCachedData s1_ = this.lookupCached_cache;
                    if ((state & 0b1) != 0 /* is-active lookupCached(NFILibrary, String, NFILibrary, String, TruffleObject) */) {
                        while (s1_ != null) {
                            if ((arg0Value == s1_.cachedReceiver_) && (arg1Value.equals(s1_.cachedSymbol_))) {
                                break;
                            }
                            s1_ = s1_.next_;
                            count1_++;
                        }
                    }
                    if (s1_ == null) {
                        // assert (arg0Value == s1_.cachedReceiver_);
                        // assert (arg1Value.equals(s1_.cachedSymbol_));
                        if (count1_ < (3)) {
                            s1_ = new LookupCachedData(lookupCached_cache);
                            s1_.cachedReceiver_ = (arg0Value);
                            s1_.cachedSymbol_ = (arg1Value);
                            s1_.cachedRet_ = (lookup(s1_.cachedReceiver_, s1_.cachedSymbol_, createRead()));
                            this.lookupCached_cache = s1_;
                            this.state_ = state = state | 0b1 /* add-active lookupCached(NFILibrary, String, NFILibrary, String, TruffleObject) */;
                        }
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return lookupCached(arg0Value, arg1Value, s1_.cachedReceiver_, s1_.cachedSymbol_, s1_.cachedRet_);
                    }
                }
                this.lookup_read_ = super.insert((createRead()));
                this.exclude_ = exclude = exclude | 0b1 /* add-excluded lookupCached(NFILibrary, String, NFILibrary, String, TruffleObject) */;
                this.lookupCached_cache = null;
                state = state & 0xfffffffe /* remove-active lookupCached(NFILibrary, String, NFILibrary, String, TruffleObject) */;
                this.state_ = state = state | 0b10 /* add-active lookup(NFILibrary, String, Node) */;
                lock.unlock();
                hasLock = false;
                return lookup(arg0Value, arg1Value, this.lookup_read_);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                LookupCachedData s1_ = this.lookupCached_cache;
                if ((s1_ == null || s1_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static CachedLookupSymbolNode create() {
            return new CachedLookupSymbolNodeGen();
        }

        @GeneratedBy(CachedLookupSymbolNode.class)
        private static final class LookupCachedData {

            @CompilationFinal LookupCachedData next_;
            @CompilationFinal NFILibrary cachedReceiver_;
            @CompilationFinal String cachedSymbol_;
            @CompilationFinal TruffleObject cachedRet_;

            LookupCachedData(LookupCachedData next_) {
                this.next_ = next_;
            }

        }
    }
    @GeneratedBy(IdentToStringNode.class)
    static final class IdentToStringNodeGen extends IdentToStringNode {

        @CompilationFinal private int state_;
        @Child private BoxedData boxed_cache;

        private IdentToStringNodeGen() {
        }

        @ExplodeLoop(kind = LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        @Override
        String execute(Object arg0Value) {
            int state = state_;
            if ((state & 0b1) != 0 /* is-active doString(String) */ && arg0Value instanceof String) {
                String arg0Value_ = (String) arg0Value;
                return doString(arg0Value_);
            }
            if ((state & 0b10) != 0 /* is-active doBoxed(TruffleObject, Node, Node, IdentToStringNode) */ && arg0Value instanceof TruffleObject) {
                TruffleObject arg0Value_ = (TruffleObject) arg0Value;
                BoxedData s2_ = this.boxed_cache;
                while (s2_ != null) {
                    if ((IdentToStringNode.checkIsBoxed(s2_.isBoxed_, arg0Value_))) {
                        return doBoxed(arg0Value_, s2_.isBoxed_, s2_.unbox_, s2_.toString_);
                    }
                    s2_ = s2_.next_;
                }
            }
            if ((state & 0b100) != 0 /* is-active doOther(Object) */) {
                if ((IdentToStringNode.isOther(arg0Value))) {
                    return doOther(arg0Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value);
        }

        private String executeAndSpecialize(Object arg0Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            try {
                if (arg0Value instanceof String) {
                    String arg0Value_ = (String) arg0Value;
                    this.state_ = state = state | 0b1 /* add-active doString(String) */;
                    lock.unlock();
                    hasLock = false;
                    return doString(arg0Value_);
                }
                if (arg0Value instanceof TruffleObject) {
                    TruffleObject arg0Value_ = (TruffleObject) arg0Value;
                    int count2_ = 0;
                    BoxedData s2_ = this.boxed_cache;
                    if ((state & 0b10) != 0 /* is-active doBoxed(TruffleObject, Node, Node, IdentToStringNode) */) {
                        while (s2_ != null) {
                            if ((IdentToStringNode.checkIsBoxed(s2_.isBoxed_, arg0Value_))) {
                                break;
                            }
                            s2_ = s2_.next_;
                            count2_++;
                        }
                    }
                    if (s2_ == null) {
                        {
                            Node isBoxed__ = (IdentToStringNode.createIsBoxed());
                            if ((IdentToStringNode.checkIsBoxed(isBoxed__, arg0Value_)) && count2_ < (3)) {
                                s2_ = new BoxedData(boxed_cache);
                                s2_.isBoxed_ = isBoxed__;
                                s2_.unbox_ = (IdentToStringNode.createUnbox());
                                s2_.toString_ = (IdentToStringNode.create());
                                this.boxed_cache = super.insert(s2_);
                                this.state_ = state = state | 0b10 /* add-active doBoxed(TruffleObject, Node, Node, IdentToStringNode) */;
                            }
                        }
                    }
                    if (s2_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return doBoxed(arg0Value_, s2_.isBoxed_, s2_.unbox_, s2_.toString_);
                    }
                }
                if ((IdentToStringNode.isOther(arg0Value))) {
                    this.state_ = state = state | 0b100 /* add-active doOther(Object) */;
                    lock.unlock();
                    hasLock = false;
                    return doOther(arg0Value);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                BoxedData s2_ = this.boxed_cache;
                if ((s2_ == null || s2_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static IdentToStringNode create() {
            return new IdentToStringNodeGen();
        }

        @GeneratedBy(IdentToStringNode.class)
        private static final class BoxedData extends Node {

            @Child BoxedData next_;
            @Child Node isBoxed_;
            @Child Node unbox_;
            @Child IdentToStringNode toString_;

            BoxedData(BoxedData next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
    }
}
