/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.backend.panama;

import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.nfi.backend.panama.NativePointer;
import com.oracle.truffle.nfi.backend.panama.NativeString;
import com.oracle.truffle.nfi.backend.panama.PanamaType;
import java.lang.foreign.MemorySegment;

abstract class ClosureArgumentNode
extends Node {
    ClosureArgumentNode() {
    }

    public abstract Object execute(VirtualFrame var1);

    @NodeChild(value="argument", type=ClosureArgumentNode.class)
    static abstract class StringClosureArgumentNode
    extends ClosureArgumentNode {
        final PanamaType type;

        StringClosureArgumentNode(PanamaType type) {
            this.type = type;
        }

        @Specialization(guards={"arg == null"})
        Object doNull(Object arg) {
            return new NativeString(0L);
        }

        @Fallback
        Object doString(Object arg) {
            return ((MemorySegment)arg).getString(0L);
        }
    }

    @NodeChild(value="argument", type=ClosureArgumentNode.class)
    static abstract class GenericClosureArgumentNode
    extends ClosureArgumentNode {
        final PanamaType type;

        GenericClosureArgumentNode(PanamaType type) {
            this.type = type;
        }

        @Specialization(guards={"arg == null"})
        Object doNull(Object arg) {
            return NativePointer.NULL;
        }

        @Fallback
        Object doGeneric(Object arg) {
            return arg;
        }
    }

    static final class GetArgumentNode
    extends ClosureArgumentNode {
        private final int index;

        GetArgumentNode(int index) {
            this.index = index;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            Object[] args = (Object[])frame.getArguments()[1];
            if (this.index == args.length) {
                return frame.getArguments()[0];
            }
            return args[this.index];
        }
    }

    static final class ConstArgumentNode
    extends ClosureArgumentNode {
        private final Object value;

        ConstArgumentNode(Object value) {
            this.value = value;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return this.value;
        }
    }
}

