/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.backend.panama;

import com.oracle.truffle.api.InternalResource;
import com.oracle.truffle.nfi.backend.panama.NFIError;
import com.oracle.truffle.nfi.backend.panama.PanamaNFIContext;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;

public class ErrorContext {
    private static final String ERRNO_LOCATION = switch (InternalResource.OS.getCurrent()) {
        default -> throw new MatchException(null, null);
        case InternalResource.OS.DARWIN -> "__error";
        case InternalResource.OS.LINUX -> "__errno_location";
        case InternalResource.OS.WINDOWS -> "_errno";
    };
    private MemorySegment errnoLocation;
    final PanamaNFIContext ctx;

    MemorySegment lookupErrnoLocation() {
        try {
            Linker linker = Linker.nativeLinker();
            FunctionDescriptor desc = FunctionDescriptor.of(ValueLayout.JAVA_LONG, new MemoryLayout[0]);
            MemorySegment sym = linker.defaultLookup().find(ERRNO_LOCATION).orElseThrow();
            MethodHandle handle = linker.downcallHandle(desc, new Linker.Option[0]);
            try {
                return MemorySegment.ofAddress(handle.invokeExact(sym)).reinterpret(4L);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        catch (IllegalCallerException ic) {
            throw NFIError.illegalNativeAccess(null);
        }
    }

    void initialize() {
        if (this.errnoLocation == null) {
            this.errnoLocation = this.lookupErrnoLocation();
        }
    }

    private MemorySegment getErrnoLocation() {
        assert (this.errnoLocation != null);
        return this.errnoLocation;
    }

    int getNativeErrno() {
        return this.getErrnoLocation().get(ValueLayout.JAVA_INT, 0L);
    }

    void setNativeErrno(int newErrno) {
        this.getErrnoLocation().set(ValueLayout.JAVA_INT, 0L, newErrno);
    }

    ErrorContext(PanamaNFIContext ctx, Thread thread) {
        this.ctx = ctx;
    }
}

