/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.backend.panama;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.nfi.backend.panama.PanamaNFILanguage;
import com.oracle.truffle.nfi.backend.panama.PanamaType;
import java.lang.foreign.Arena;

class PanamaNFIContext {
    final PanamaNFILanguage language;
    Arena arena;
    @CompilerDirectives.CompilationFinal
    TruffleLanguage.Env env;
    private static final TruffleLanguage.ContextReference<PanamaNFIContext> REFERENCE = TruffleLanguage.ContextReference.create(PanamaNFILanguage.class);

    PanamaNFIContext(PanamaNFILanguage language, TruffleLanguage.Env env) {
        this.language = language;
        this.env = env;
    }

    void initialize() {
        this.arena = Arena.ofShared();
    }

    void patchEnv(TruffleLanguage.Env env) {
        this.env = env;
    }

    void dispose() {
        if (this.arena != null) {
            this.arena.close();
        }
    }

    Arena getContextArena() {
        return this.arena;
    }

    @CompilerDirectives.TruffleBoundary
    PanamaType lookupEnvType() {
        return null;
    }

    static PanamaNFIContext get(Node node) {
        return (PanamaNFIContext)REFERENCE.get(node);
    }
}

