/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.backend.panama;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.nfi.backend.panama.NFIError;
import com.oracle.truffle.nfi.backend.panama.PanamaLibrary;
import com.oracle.truffle.nfi.backend.panama.PanamaNFIBackendFactory;
import com.oracle.truffle.nfi.backend.panama.PanamaNFIContext;
import com.oracle.truffle.nfi.backend.panama.PanamaNFILanguage;
import com.oracle.truffle.nfi.backend.panama.PanamaSignature;
import com.oracle.truffle.nfi.backend.panama.PanamaType;
import com.oracle.truffle.nfi.backend.spi.NFIBackend;
import com.oracle.truffle.nfi.backend.spi.NFIBackendLibrary;
import com.oracle.truffle.nfi.backend.spi.types.NativeLibraryDescriptor;
import com.oracle.truffle.nfi.backend.spi.types.NativeSimpleType;
import com.oracle.truffle.nfi.backend.spi.util.ProfiledArrayBuilder;
import java.lang.foreign.SymbolLookup;
import java.util.EnumMap;
import java.util.Map;

@ExportLibrary(value=NFIBackendLibrary.class)
final class PanamaNFIBackend
implements NFIBackend {
    private final PanamaNFILanguage language;
    private Map<NativeSimpleType, PanamaType> simpleTypes;

    PanamaNFIBackend(PanamaNFILanguage language) {
        this.language = language;
        this.initializeTypes();
    }

    private void initializeTypes() {
        this.simpleTypes = new EnumMap<NativeSimpleType, PanamaType>(NativeSimpleType.class);
        block3: for (NativeSimpleType type : NativeSimpleType.values()) {
            switch (type) {
                case VOID: 
                case UINT8: 
                case SINT8: 
                case UINT16: 
                case SINT16: 
                case UINT32: 
                case SINT32: 
                case UINT64: 
                case SINT64: 
                case POINTER: 
                case FLOAT: 
                case DOUBLE: {
                    this.simpleTypes.put(type, new PanamaType(type));
                    continue block3;
                }
                default: {
                    this.simpleTypes.put(type, null);
                }
            }
        }
    }

    public CallTarget parse(NativeLibraryDescriptor descriptor) {
        RootNode ret = descriptor.isDefaultLibrary() ? PanamaNFIBackendFactory.LoadDefaultNodeGen.create(this.language) : PanamaNFIBackendFactory.LoadLibraryNodeGen.create(this.language, descriptor.getFilename());
        return ret.getCallTarget();
    }

    @ExportMessage
    Object getSimpleType(NativeSimpleType type) {
        return this.simpleTypes.get(type);
    }

    @ExportMessage
    Object getArrayType(NativeSimpleType type) {
        return null;
    }

    @ExportMessage
    Object getEnvType(@CachedLibrary(value="this") InteropLibrary self) {
        return PanamaNFIContext.get((Node)self).lookupEnvType();
    }

    @ExportMessage
    Object createSignatureBuilder(@CachedLibrary(value="this") NFIBackendLibrary self, @Bind(value="$node") Node node, @Cached InlinedBranchProfile error, @Cached ProfiledArrayBuilder.ArrayBuilderFactory builderFactory) {
        if (!PanamaNFIContext.get((Node)self).env.isNativeAccessAllowed()) {
            error.enter(node);
            throw new NFIError("Access to native code is not allowed by the host environment.", (Node)self);
        }
        return new PanamaSignature.PanamaSignatureBuilder(builderFactory);
    }

    static abstract class LoadDefaultNode
    extends RootNode {
        protected LoadDefaultNode(PanamaNFILanguage language) {
            super((TruffleLanguage)language);
        }

        public abstract Object execute(VirtualFrame var1);

        @Specialization
        public Object loadDefault(VirtualFrame frame, @CachedLibrary(value="this") NFIBackendLibrary self, @Cached InlinedBranchProfile error) {
            if (!PanamaNFIContext.get((Node)self).env.isNativeAccessAllowed()) {
                error.enter((Node)this);
                throw new NFIError("Access to native code is not allowed by the host environment.", (Node)self);
            }
            return PanamaLibrary.createDefault();
        }
    }

    static abstract class LoadLibraryNode
    extends RootNode {
        private final String name;

        protected LoadLibraryNode(PanamaNFILanguage language, String name) {
            super((TruffleLanguage)language);
            this.name = name;
        }

        @CompilerDirectives.TruffleBoundary
        private SymbolLookup doLoad() {
            PanamaNFIContext ctx = PanamaNFIContext.get((Node)this);
            try {
                return SymbolLookup.libraryLookup(this.name, ctx.getContextArena());
            }
            catch (IllegalArgumentException ex) {
                throw new NFIError("Library lookup returned null. Library likely does not exist on the provided location.", (Node)this);
            }
        }

        public abstract Object execute(VirtualFrame var1);

        @Specialization
        public Object loadLibrary(VirtualFrame frame, @CachedLibrary(value="this") NFIBackendLibrary self, @Cached InlinedBranchProfile error) {
            if (!PanamaNFIContext.get((Node)self).env.isNativeAccessAllowed()) {
                error.enter((Node)this);
                throw new NFIError("Access to native code is not allowed by the host environment.", (Node)self);
            }
            return PanamaLibrary.create(this.doLoad());
        }
    }
}

