/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot.enterprise;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.polyglot.enterprise.EnterprisePolyglotImpl;
import com.oracle.truffle.polyglot.enterprise.IsolateSourceCache;
import com.oracle.truffle.polyglot.enterprise.NativeContext;
import com.oracle.truffle.polyglot.enterprise.NativePolyglotIsolateServices;
import java.lang.ref.Reference;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;
import org.graalvm.collections.Pair;
import org.graalvm.nativebridge.NativeIsolate;
import org.graalvm.nativebridge.NativeObject;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;

final class NativeEngine
extends NativeObject {
    private final EnterprisePolyglotImpl polyglot;
    private final Engine localEngine;
    private final boolean bound;
    private final long hostStackHeadRoom;
    private final NativePolyglotIsolateServices isolateServices;
    private final Set<Object> contexts;
    private boolean closed;
    private volatile Reference<Engine> weakAPI;

    NativeEngine(EnterprisePolyglotImpl enterprisePolyglotImpl, NativeIsolate nativeIsolate, long l2, Engine engine, boolean bl, long l3, NativePolyglotIsolateServices nativePolyglotIsolateServices) {
        super(nativeIsolate, l2);
        this.polyglot = enterprisePolyglotImpl;
        this.localEngine = engine;
        this.bound = bl;
        this.hostStackHeadRoom = l3;
        this.isolateServices = nativePolyglotIsolateServices;
        this.contexts = Collections.newSetFromMap(new WeakHashMap());
    }

    Engine getLocalEngine() {
        return this.localEngine;
    }

    void setEngineAPIReference(Reference<Engine> reference) {
        this.weakAPI = reference;
    }

    Reference<Engine> getEngineAPIReference() {
        return this.weakAPI;
    }

    Engine getEngineAPI() {
        Engine engine = this.weakAPI.get();
        if (engine == null) {
            throw CompilerDirectives.shouldNotReachHere((String)"API object must not be garbage collected when engine implementation is in use.");
        }
        return engine;
    }

    boolean isBound() {
        return this.bound;
    }

    long getHostStackHeadRoom() {
        return this.hostStackHeadRoom;
    }

    IsolateSourceCache getSourceCache() {
        return this.getPolyglotIsolateServices().getSourceCache();
    }

    NativePolyglotIsolateServices getPolyglotIsolateServices() {
        return this.isolateServices;
    }

    Pair<Long, Long> getKey() {
        return Pair.create((Object)this.getIsolate().getIsolateId(), (Object)this.getHandle());
    }

    synchronized void onContextCreated(Object object) {
        if (this.closed) {
            throw new IllegalStateException("Engine is already closed.");
        }
        NativeContext nativeContext = (NativeContext)((Object)this.polyglot.getAPIAccess().getContextReceiver(object));
        this.polyglot.registerContext(nativeContext);
        this.contexts.add(object);
    }

    synchronized void close() {
        this.closed = true;
        if (!this.contexts.isEmpty()) {
            AbstractPolyglotImpl.APIAccess aPIAccess = this.polyglot.getAPIAccess();
            Iterator<Object> iterator = this.contexts.iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                iterator.remove();
                NativeContext nativeContext = (NativeContext)((Object)aPIAccess.getContextReceiver(object));
                if (!this.polyglot.requireContextRegistered(nativeContext)) continue;
                this.polyglot.releaseContextRegisteredRequirement(nativeContext, true);
            }
        }
    }
}

