/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.java.model;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.type.WildcardType;

public class CodeTypeMirror
implements TypeMirror {
    private final TypeKind kind;

    public CodeTypeMirror(TypeKind kind) {
        this.kind = kind;
    }

    @Override
    public TypeKind getKind() {
        return this.kind;
    }

    @Override
    public <R, P> R accept(TypeVisitor<R, P> v, P p) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<? extends AnnotationMirror> getAnnotationMirrors() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <A extends Annotation> A[] getAnnotationsByType(Class<A> annotationType) {
        throw new UnsupportedOperationException();
    }

    public static class DeclaredCodeTypeMirror
    extends CodeTypeMirror
    implements DeclaredType {
        private final TypeElement clazz;
        private final List<TypeMirror> typeArguments;

        public DeclaredCodeTypeMirror(TypeElement clazz) {
            this(clazz, Collections.emptyList());
        }

        public DeclaredCodeTypeMirror(TypeElement clazz, List<TypeMirror> typeArguments) {
            super(TypeKind.DECLARED);
            this.clazz = clazz;
            this.typeArguments = typeArguments;
        }

        @Override
        public Element asElement() {
            return this.clazz;
        }

        @Override
        public TypeMirror getEnclosingType() {
            return this.clazz.getEnclosingElement().asType();
        }

        public List<TypeMirror> getTypeArguments() {
            return this.typeArguments;
        }

        @Override
        public String toString() {
            return this.clazz.getQualifiedName().toString();
        }
    }

    public static class ArrayCodeTypeMirror
    extends CodeTypeMirror
    implements ArrayType {
        private final TypeMirror component;

        public ArrayCodeTypeMirror(TypeMirror component) {
            super(TypeKind.ARRAY);
            this.component = component;
        }

        @Override
        public TypeMirror getComponentType() {
            return this.component;
        }
    }

    public static class WildcardTypeMirror
    extends CodeTypeMirror
    implements WildcardType {
        private final TypeMirror extendsBounds;
        private final TypeMirror superBounds;

        public WildcardTypeMirror(TypeMirror extendsBounds, TypeMirror superBounds) {
            super(TypeKind.WILDCARD);
            this.extendsBounds = extendsBounds;
            this.superBounds = superBounds;
        }

        @Override
        public TypeMirror getExtendsBound() {
            return this.extendsBounds;
        }

        @Override
        public TypeMirror getSuperBound() {
            return this.superBounds;
        }
    }
}

