/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.bytecode.parser;

import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.SuppressFBWarnings;
import com.oracle.truffle.dsl.processor.TruffleTypes;
import com.oracle.truffle.dsl.processor.bytecode.model.ConstantOperandModel;
import com.oracle.truffle.dsl.processor.bytecode.model.OperationModel;
import com.oracle.truffle.dsl.processor.bytecode.model.Signature;
import com.oracle.truffle.dsl.processor.bytecode.parser.CustomOperationParser;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.java.model.CodeTypeMirror;
import com.oracle.truffle.dsl.processor.model.MessageContainer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

public class SpecializationSignatureParser {
    final ProcessorContext context;
    final TruffleTypes types;

    public SpecializationSignatureParser(ProcessorContext context) {
        this.context = context;
        this.types = context.getTypes();
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED"}, justification="Calls to params poll() as expected. FindBugs false positive.")
    public SpecializationSignature parse(ExecutableElement specialization, MessageContainer errorTarget, OperationModel.ConstantOperandsModel constantOperands) {
        boolean isValid = true;
        boolean isFallback = ElementUtils.findAnnotationMirror((Element)specialization, (TypeMirror)this.types.Fallback) != null;
        ArrayDeque<? extends VariableElement> params = new ArrayDeque<VariableElement>(specialization.getParameters());
        if (!params.isEmpty() && ElementUtils.isAssignable(SpecializationSignatureParser.peekType(params), this.types.Frame) && !ElementUtils.isAssignable(((VariableElement)params.poll()).asType(), this.types.VirtualFrame)) {
            errorTarget.addError(specialization, "Frame parameter must have type VirtualFrame.", new Object[0]);
            isValid = false;
        }
        SpecializationSignatureParser.skipDSLParameters(params);
        ArrayList<VariableElement> operands = new ArrayList<VariableElement>();
        boolean hasVariadic = false;
        while (!params.isEmpty()) {
            operands.add((VariableElement)params.poll());
            SpecializationSignatureParser.skipDSLParameters(params);
        }
        ArrayList<String> operandNames = new ArrayList<String>(operands.size());
        int numConstantOperands = constantOperands.before().size() + constantOperands.after().size();
        if (operands.size() < numConstantOperands) {
            errorTarget.addError(specialization, "Specialization should declare at least %d operand%s (one for each %s).", numConstantOperands, numConstantOperands == 1 ? "" : "s", ElementUtils.getSimpleName(this.types.ConstantOperand));
            isValid = false;
        } else {
            int numDynamicOperands = operands.size() - numConstantOperands;
            for (int i = 0; i < constantOperands.before().size(); ++i) {
                ConstantOperandModel constantOperand;
                VariableElement operand = (VariableElement)operands.get(i);
                isValid = this.checkConstantOperandParam(operand, constantOperand = constantOperands.before().get(i), errorTarget) && isValid;
                operandNames.add(constantOperand.getNameOrDefault(operand.getSimpleName().toString()));
            }
            int dynamicOffset = constantOperands.before().size();
            for (int i = 0; i < numDynamicOperands; ++i) {
                VariableElement dynamicOperand = (VariableElement)operands.get(dynamicOffset + i);
                if (hasVariadic) {
                    if (this.isVariadic(dynamicOperand)) {
                        errorTarget.addError(dynamicOperand, "Multiple variadic operands not allowed to an operation. Split up the operation if such behaviour is required.", new Object[0]);
                    } else {
                        errorTarget.addError(dynamicOperand, "Non-variadic operands must precede variadic operands.", new Object[0]);
                    }
                    isValid = false;
                } else if (this.isVariadic(dynamicOperand)) {
                    hasVariadic = true;
                    if (!ElementUtils.typeEquals(dynamicOperand.asType(), new CodeTypeMirror.ArrayCodeTypeMirror(this.context.getDeclaredType(Object.class)))) {
                        errorTarget.addError(dynamicOperand, "Variadic operand must have type Object[].", new Object[0]);
                        isValid = false;
                    }
                }
                if (isFallback && !ElementUtils.isObject(dynamicOperand.asType())) {
                    if (errorTarget != null) {
                        errorTarget.addError(dynamicOperand, "Operands to @%s specializations of Operation nodes must have type %s.", ElementUtils.getSimpleName(this.types.Fallback), ElementUtils.getSimpleName(this.context.getDeclaredType(Object.class)));
                    }
                    isValid = false;
                }
                operandNames.add(dynamicOperand.getSimpleName().toString());
            }
            int constantAfterOffset = dynamicOffset + numDynamicOperands;
            for (int i = 0; i < constantOperands.after().size(); ++i) {
                ConstantOperandModel constantOperand;
                VariableElement operand = (VariableElement)operands.get(constantAfterOffset + i);
                isValid = this.checkConstantOperandParam(operand, constantOperand = constantOperands.after().get(i), errorTarget) && isValid;
                operandNames.add(constantOperand.getNameOrDefault(operand.getSimpleName().toString()));
            }
        }
        if (!isValid) {
            return null;
        }
        List<TypeMirror> operandTypes = operands.stream().map(v -> v.asType()).toList();
        TypeMirror returnType = specialization.getReturnType();
        if (ElementUtils.canThrowTypeExact(specialization.getThrownTypes(), CustomOperationParser.types().UnexpectedResultException)) {
            returnType = this.context.getDeclaredType(Object.class);
        }
        Signature signature = new Signature(returnType, operandTypes, hasVariadic, constantOperands.before().size(), constantOperands.after().size());
        return new SpecializationSignature(signature, operandNames);
    }

    private boolean isVariadic(VariableElement param) {
        return ElementUtils.findAnnotationMirror((Element)param, (TypeMirror)this.types.Variadic) != null;
    }

    private static TypeMirror peekType(Queue<? extends VariableElement> queue) {
        return queue.peek().asType();
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED"}, justification="Calls to params poll() as expected. FindBugs false positive.")
    private static void skipDSLParameters(Queue<? extends VariableElement> queue) {
        while (!queue.isEmpty() && SpecializationSignatureParser.isDSLParameter(queue.peek())) {
            queue.poll();
        }
    }

    private static boolean isDSLParameter(VariableElement param) {
        for (AnnotationMirror annotationMirror : param.getAnnotationMirrors()) {
            if (!ElementUtils.typeEqualsAny((TypeMirror)annotationMirror.getAnnotationType(), CustomOperationParser.types().Cached, CustomOperationParser.types().CachedLibrary, CustomOperationParser.types().Bind)) continue;
            return true;
        }
        return false;
    }

    private boolean checkConstantOperandParam(VariableElement constantOperandParam, ConstantOperandModel constantOperand, MessageContainer errorTarget) {
        TypeMirror constantType;
        if (this.isVariadic(constantOperandParam)) {
            errorTarget.addError(constantOperandParam, "Constant operand parameter cannot be variadic.", new Object[0]);
            return false;
        }
        TypeMirror parameterType = constantOperandParam.asType();
        if (!ElementUtils.typeEquals(parameterType, constantType = constantOperand.type())) {
            errorTarget.addError(constantOperandParam, "Constant operand parameter must have type %s.", ElementUtils.getSimpleName(constantType));
            return false;
        }
        return true;
    }

    public static Signature createPolymorphicSignature(List<SpecializationSignature> signatures, List<ExecutableElement> specializations, MessageContainer customOperation) {
        assert (!signatures.isEmpty());
        assert (signatures.size() == specializations.size());
        Signature polymorphicSignature = signatures.get(0).signature();
        for (int i = 1; i < signatures.size() && (polymorphicSignature = SpecializationSignatureParser.mergeSignatures(signatures.get(i).signature(), polymorphicSignature, specializations.get(i), customOperation)) != null; ++i) {
        }
        return polymorphicSignature;
    }

    private static Signature mergeSignatures(Signature a, Signature b, Element el, MessageContainer errorTarget) {
        if (a.isVariadic != b.isVariadic) {
            if (errorTarget != null) {
                errorTarget.addError(el, "Error calculating operation signature: either all or none of the specializations must be variadic (i.e., have a @%s annotated parameter)", ElementUtils.getSimpleName(CustomOperationParser.types().Variadic));
            }
            return null;
        }
        if (a.isVoid != b.isVoid) {
            if (errorTarget != null) {
                errorTarget.addError(el, "Error calculating operation signature: either all or none of the specializations must be declared void.", new Object[0]);
            }
            return null;
        }
        assert (a.constantOperandsBeforeCount == b.constantOperandsBeforeCount);
        assert (a.constantOperandsAfterCount == b.constantOperandsAfterCount);
        if (a.dynamicOperandCount != b.dynamicOperandCount) {
            if (errorTarget != null) {
                errorTarget.addError(el, "Error calculating operation signature: all specializations must have the same number of operands.", new Object[0]);
            }
            return null;
        }
        TypeMirror newReturnType = SpecializationSignatureParser.mergeIfPrimitiveType(a.context, a.returnType, b.returnType);
        ArrayList<TypeMirror> mergedTypes = new ArrayList<TypeMirror>(a.operandTypes.size());
        for (int i = 0; i < a.operandTypes.size(); ++i) {
            mergedTypes.add(SpecializationSignatureParser.mergeIfPrimitiveType(a.context, a.operandTypes.get(i), b.operandTypes.get(i)));
        }
        return new Signature(newReturnType, mergedTypes, a.isVariadic, a.constantOperandsBeforeCount, a.constantOperandsAfterCount);
    }

    private static TypeMirror mergeIfPrimitiveType(ProcessorContext context, TypeMirror a, TypeMirror b) {
        if (ElementUtils.typeEquals(ElementUtils.boxType(context, a), ElementUtils.boxType(context, b))) {
            return a;
        }
        return context.getType(Object.class);
    }

    public record SpecializationSignature(Signature signature, List<String> operandNames) {
    }
}

